/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.AbstractRedisReactiveCommands;
import io.lettuce.core.FlushMode;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import io.lettuce.core.api.reactive.RedisServerReactiveCommands;
import io.lettuce.core.cluster.AsyncClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterDistributionChannelWriter;
import io.lettuce.core.cluster.ClusterScanSupport;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.cluster.StatefulRedisClusterConnectionImpl;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.reactive.RedisAdvancedClusterReactiveCommands;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.protocol.ConnectionIntent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisAdvancedClusterReactiveCommandsImpl<K, V>
extends AbstractRedisReactiveCommands<K, V>
implements RedisAdvancedClusterReactiveCommands<K, V> {
    private static final Predicate<RedisClusterNode> ALL_NODES = node -> true;
    private final RedisCodec<K, V> codec;

    @Deprecated
    public RedisAdvancedClusterReactiveCommandsImpl(StatefulRedisClusterConnectionImpl<K, V> connection, RedisCodec<K, V> codec, Supplier<JsonParser> parser) {
        super(connection, codec, parser);
        this.codec = codec;
    }

    @Deprecated
    public RedisAdvancedClusterReactiveCommandsImpl(StatefulRedisClusterConnectionImpl<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.codec = codec;
    }

    public RedisAdvancedClusterReactiveCommandsImpl(StatefulRedisClusterConnection<K, V> connection, RedisCodec<K, V> codec, Supplier<JsonParser> parser) {
        super(connection, codec, parser);
        this.codec = codec;
    }

    public RedisAdvancedClusterReactiveCommandsImpl(StatefulRedisClusterConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.codec = codec;
    }

    @Override
    public Mono<String> clientSetname(K name) {
        ArrayList<Object> publishers = new ArrayList<Object>();
        publishers.add(super.clientSetname(name));
        for (RedisClusterNode redisClusterNode : this.getStatefulConnection().getPartitions()) {
            Mono<RedisClusterReactiveCommands<K, V>> byNodeId = this.getConnectionReactive(redisClusterNode.getNodeId());
            publishers.add(byNodeId.flatMap(conn -> {
                if (conn.isOpen()) {
                    return conn.clientSetname(name);
                }
                return Mono.empty();
            }));
            Mono<RedisClusterReactiveCommands<K, V>> byHost = this.getConnectionReactive(redisClusterNode.getUri().getHost(), redisClusterNode.getUri().getPort());
            publishers.add(byHost.flatMap(conn -> {
                if (conn.isOpen()) {
                    return conn.clientSetname(name);
                }
                return Mono.empty();
            }));
        }
        return Flux.merge(publishers).last();
    }

    @Override
    public Mono<Long> clusterCountKeysInSlot(int slot) {
        Mono<RedisClusterReactiveCommands<K, V>> connectionBySlot = this.findConnectionBySlotReactive(slot);
        return connectionBySlot.flatMap(cmd -> cmd.clusterCountKeysInSlot(slot));
    }

    @Override
    public Flux<K> clusterGetKeysInSlot(int slot, int count) {
        Mono<RedisClusterReactiveCommands<K, V>> connectionBySlot = this.findConnectionBySlotReactive(slot);
        return connectionBySlot.flatMapMany(conn -> conn.clusterGetKeysInSlot(slot, count));
    }

    @Override
    public Mono<Long> dbsize() {
        Map publishers = this.executeOnUpstream(RedisServerReactiveCommands::dbsize);
        return Flux.merge(publishers.values()).reduce((accu, next) -> accu + next);
    }

    @Override
    public Mono<Long> del(K ... keys) {
        return this.del((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Mono<Long> del(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.del(keys);
        }
        ArrayList<Mono<Long>> publishers = new ArrayList<Mono<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            publishers.add(super.del((Iterable)entry.getValue()));
        }
        return Flux.merge(publishers).reduce((accu, next) -> accu + next);
    }

    @Override
    public Mono<Long> exists(K ... keys) {
        return this.exists((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Mono<Long> exists(Iterable<K> keys) {
        List<K> keyList = LettuceLists.newList(keys);
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keyList);
        if (partitioned.size() < 2) {
            return super.exists(keyList);
        }
        ArrayList<Mono<Long>> publishers = new ArrayList<Mono<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            publishers.add(super.exists((Iterable)entry.getValue()));
        }
        return Flux.merge(publishers).reduce((accu, next) -> accu + next);
    }

    @Override
    public Mono<String> flushall() {
        Map publishers = this.executeOnUpstream(RedisServerReactiveCommands::flushall);
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> flushall(FlushMode flushMode) {
        Map publishers = this.executeOnUpstream(it -> it.flushall(flushMode));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> flushallAsync() {
        Map publishers = this.executeOnUpstream(RedisServerReactiveCommands::flushallAsync);
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> flushdb() {
        Map publishers = this.executeOnUpstream(RedisServerReactiveCommands::flushdb);
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> flushdb(FlushMode flushMode) {
        Map publishers = this.executeOnUpstream(it -> it.flushdb(flushMode));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Flux<K> keys(K pattern) {
        Map publishers = this.executeOnUpstream(commands -> commands.keys(pattern));
        return Flux.merge(publishers.values());
    }

    @Override
    public Mono<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        Map publishers = this.executeOnUpstream(commands -> commands.keys(channel, pattern));
        return Flux.merge(publishers.values()).reduce((accu, next) -> accu + next);
    }

    @Override
    public Flux<KeyValue<K, V>> mget(K ... keys) {
        return this.mget((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Flux<KeyValue<K, V>> mget(Iterable<K> keys) {
        List keyList = LettuceLists.newList(keys);
        Map partitioned = SlotHash.partition(this.codec, keyList);
        if (partitioned.size() < 2) {
            return super.mget(keyList);
        }
        ArrayList publishers = new ArrayList();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            publishers.add(super.mget((Iterable)entry.getValue()));
        }
        Flux fluxes = Flux.mergeSequential(publishers);
        Mono map = fluxes.collectList().map(vs -> {
            KeyValue[] values = new KeyValue[vs.size()];
            int offset = 0;
            for (Map.Entry entry : partitioned.entrySet()) {
                for (int i = 0; i < keyList.size(); ++i) {
                    int index = ((List)entry.getValue()).indexOf(keyList.get(i));
                    if (index == -1) continue;
                    values[i] = (KeyValue)vs.get(offset + index);
                }
                offset += ((List)entry.getValue()).size();
            }
            return Arrays.asList(values);
        });
        return map.flatMapIterable(keyValues -> keyValues);
    }

    @Override
    public Mono<Long> mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        return this.mget(channel, (Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Mono<Long> mget(KeyValueStreamingChannel<K, V> channel, Iterable<K> keys) {
        List<K> keyList = LettuceLists.newList(keys);
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keyList);
        if (partitioned.size() < 2) {
            return super.mget(channel, keyList);
        }
        ArrayList<Mono<Long>> publishers = new ArrayList<Mono<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            publishers.add(super.mget(channel, (Iterable)entry.getValue()));
        }
        return Flux.merge(publishers).reduce(Long::sum);
    }

    @Override
    public Mono<Boolean> msetnx(Map<K, V> map) {
        return this.pipeliningWithMap(map, kvMap -> RedisAdvancedClusterReactiveCommandsImpl.super.msetnx(kvMap).flux(), booleanFlux -> booleanFlux).reduce((accu, next) -> accu != false && next != false);
    }

    @Override
    public Mono<String> mset(Map<K, V> map) {
        return this.pipeliningWithMap(map, kvMap -> RedisAdvancedClusterReactiveCommandsImpl.super.mset(kvMap).flux(), booleanFlux -> booleanFlux).last();
    }

    @Override
    public Mono<K> randomkey() {
        Partitions partitions = this.getStatefulConnection().getPartitions();
        if (partitions.isEmpty()) {
            return super.randomkey();
        }
        int index = ThreadLocalRandom.current().nextInt(partitions.size());
        Mono<RedisClusterReactiveCommands<K, V>> connection = this.getConnectionReactive(partitions.getPartition(index).getNodeId());
        return connection.flatMap(RedisKeyReactiveCommands::randomkey);
    }

    @Override
    public Mono<String> scriptFlush() {
        Map publishers = this.executeOnNodes(RedisScriptingReactiveCommands::scriptFlush, ALL_NODES);
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> scriptKill() {
        Map publishers = this.executeOnNodes(RedisScriptingReactiveCommands::scriptKill, ALL_NODES);
        return Flux.merge(publishers.values()).onErrorReturn((Object)"OK").last();
    }

    @Override
    public Mono<String> scriptLoad(byte[] script) {
        Map publishers = this.executeOnNodes(commands -> commands.scriptLoad(script), ALL_NODES);
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<Void> shutdown(boolean save) {
        Map publishers = this.executeOnNodes(commands -> commands.shutdown(save), ALL_NODES);
        return Flux.merge(publishers.values()).then();
    }

    @Override
    public Mono<Long> touch(K ... keys) {
        return this.touch((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Mono<Long> touch(Iterable<K> keys) {
        List<K> keyList = LettuceLists.newList(keys);
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keyList);
        if (partitioned.size() < 2) {
            return super.touch(keyList);
        }
        ArrayList<Mono<Long>> publishers = new ArrayList<Mono<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            publishers.add(super.touch((Iterable)entry.getValue()));
        }
        return Flux.merge(publishers).reduce((accu, next) -> accu + next);
    }

    @Override
    public Mono<Long> unlink(K ... keys) {
        return this.unlink((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Mono<Long> unlink(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.unlink(keys);
        }
        ArrayList<Mono<Long>> publishers = new ArrayList<Mono<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            publishers.add(super.unlink((Iterable)entry.getValue()));
        }
        return Flux.merge(publishers).reduce((accu, next) -> accu + next);
    }

    @Override
    public RedisClusterReactiveCommands<K, V> getConnection(String nodeId) {
        return this.getStatefulConnection().getConnection(nodeId).reactive();
    }

    private Mono<RedisClusterReactiveCommands<K, V>> getConnectionReactive(String nodeId) {
        return RedisAdvancedClusterReactiveCommandsImpl.getMono(this.getConnectionProvider().getConnectionAsync(ConnectionIntent.WRITE, nodeId)).map(StatefulRedisConnection::reactive);
    }

    @Override
    public RedisClusterReactiveCommands<K, V> getConnection(String host, int port) {
        return this.getStatefulConnection().getConnection(host, port).reactive();
    }

    private Mono<RedisClusterReactiveCommands<K, V>> getConnectionReactive(String host, int port) {
        return RedisAdvancedClusterReactiveCommandsImpl.getMono(this.getConnectionProvider().getConnectionAsync(ConnectionIntent.WRITE, host, port)).map(StatefulRedisConnection::reactive);
    }

    @Override
    public StatefulRedisClusterConnection<K, V> getStatefulConnection() {
        return (StatefulRedisClusterConnection)super.getConnection();
    }

    @Override
    public Mono<KeyScanCursor<K>> scan() {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(), ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(scanArgs), ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan((ScanCursor)cursor, scanArgs), ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.clusterScan(scanCursor, RedisKeyReactiveCommands::scan, ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(channel), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(channel, scanArgs), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan(channel, (ScanCursor)cursor, scanArgs), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan(channel, (ScanCursor)cursor), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    private <T extends ScanCursor> Mono<T> clusterScan(ScanCursor cursor, BiFunction<RedisKeyReactiveCommands<K, V>, ScanCursor, Mono<T>> scanFunction, ClusterScanSupport.ScanCursorMapper<Mono<T>> resultMapper) {
        return RedisAdvancedClusterReactiveCommandsImpl.clusterScan(this.getStatefulConnection(), this.getConnectionProvider(), cursor, scanFunction, resultMapper);
    }

    private <T> Flux<T> pipeliningWithMap(Map<K, V> map, Function<Map<K, V>, Flux<T>> function, Function<Flux<T>, Flux<T>> resultFunction) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, map.keySet());
        if (partitioned.size() < 2) {
            return function.apply(map);
        }
        List publishers = partitioned.values().stream().map(ks -> {
            HashMap op = new HashMap();
            ks.forEach(k -> op.put(k, map.get(k)));
            return (Flux)function.apply(op);
        }).collect(Collectors.toList());
        return resultFunction.apply(Flux.merge(publishers));
    }

    protected <T> Map<String, Publisher<T>> executeOnUpstream(Function<RedisClusterReactiveCommands<K, V>, ? extends Publisher<T>> function) {
        return this.executeOnNodes(function, redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.UPSTREAM));
    }

    protected <T> Map<String, Publisher<T>> executeOnNodes(Function<RedisClusterReactiveCommands<K, V>, ? extends Publisher<T>> function, Predicate<RedisClusterNode> filter) {
        HashMap<String, Publisher<T>> executions = new HashMap<String, Publisher<T>>();
        for (RedisClusterNode redisClusterNode : this.getStatefulConnection().getPartitions()) {
            if (!filter.test(redisClusterNode)) continue;
            RedisURI uri = redisClusterNode.getUri();
            Mono<RedisClusterReactiveCommands<K, V>> connection = this.getConnectionReactive(uri.getHost(), uri.getPort());
            executions.put(redisClusterNode.getNodeId(), (Publisher<T>)connection.flatMapMany(function::apply));
        }
        return executions;
    }

    private Mono<RedisClusterReactiveCommands<K, V>> findConnectionBySlotReactive(int slot) {
        RedisClusterNode node = this.getStatefulConnection().getPartitions().getPartitionBySlot(slot);
        if (node != null) {
            return this.getConnectionReactive(node.getUri().getHost(), node.getUri().getPort());
        }
        return Mono.error((Throwable)new RedisException("No partition for slot " + slot));
    }

    private AsyncClusterConnectionProvider getConnectionProvider() {
        ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)this.getStatefulConnection().getChannelWriter();
        return (AsyncClusterConnectionProvider)((Object)writer.getClusterConnectionProvider());
    }

    static <T extends ScanCursor, K, V> Mono<T> clusterScan(StatefulRedisClusterConnection<K, V> connection, AsyncClusterConnectionProvider connectionProvider, ScanCursor cursor, BiFunction<RedisKeyReactiveCommands<K, V>, ScanCursor, Mono<T>> scanFunction, ClusterScanSupport.ScanCursorMapper<Mono<T>> mapper) {
        List<String> nodeIds = ClusterScanSupport.getNodeIds(connection, cursor);
        String currentNodeId = ClusterScanSupport.getCurrentNodeId(cursor, nodeIds);
        ScanCursor continuationCursor = ClusterScanSupport.getContinuationCursor(cursor);
        Mono scanCursor = RedisAdvancedClusterReactiveCommandsImpl.getMono(connectionProvider.getConnectionAsync(ConnectionIntent.WRITE, currentNodeId)).flatMap(conn -> (Mono)scanFunction.apply(conn.reactive(), continuationCursor));
        return mapper.map(nodeIds, currentNodeId, scanCursor);
    }

    private static <T> Mono<T> getMono(CompletableFuture<T> future) {
        return Mono.fromCompletionStage(future);
    }
}

