/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.StateChangedListener;
import net.osmand.plus.OsmandSettings;
import net.sourceforge.offroad.OsmWindow;

public class ApplicationMode {
    private static Map<String, Set<ApplicationMode>> widgets = new LinkedHashMap<String, Set<ApplicationMode>>();
    private static List<ApplicationMode> values = new ArrayList<ApplicationMode>();
    private static List<ApplicationMode> cachedFilteredValues = new ArrayList<ApplicationMode>();
    public static final ApplicationMode DEFAULT = ApplicationMode.create(848, "default").speed(1.5f, 5).arrivalDistance(90).defLocation().icon(0, 0).reg();
    public static final ApplicationMode CAR = ApplicationMode.create(849, "car").speed(15.3f, 35).arrivalDistance(90).carLocation().icon(0, 0).reg();
    public static final ApplicationMode BICYCLE = ApplicationMode.create(850, "bicycle").speed(5.5f, 15).arrivalDistance(60).bicycleLocation().icon(0, 0).reg();
    public static final ApplicationMode PEDESTRIAN = ApplicationMode.create(851, "pedestrian").speed(1.5f, 5).arrivalDistance(45).icon(0, 0).reg();
    public static final ApplicationMode AIRCRAFT = ApplicationMode.create(1244, "aircraft").speed(40.0f, 100).carLocation().icon(0, 0).reg();
    public static final ApplicationMode BOAT = ApplicationMode.create(1243, "boat").speed(5.5f, 20).carLocation().icon(0, 0).reg();
    public static final ApplicationMode HIKING = ApplicationMode.create(1241, "hiking").speed(1.5f, 5).parent(PEDESTRIAN).icon(0, 0).reg();
    public static final ApplicationMode MOTORCYCLE = ApplicationMode.create(1242, "motorcycle").speed(15.3f, 40).carLocation().parent(CAR).icon(0, 0).reg();
    public static final ApplicationMode TRUCK = ApplicationMode.create(1273, "truck").speed(15.3f, 40).carLocation().parent(CAR).icon(0, 0).reg();
    private final int key;
    private final String stringKey;
    private ApplicationMode parent;
    private int iconId = 0;
    private int smallIconDark = 0;
    private float defaultSpeed = 10.0f;
    private int minDistanceForTurn = 50;
    private int arrivalDistance = 90;
    private int bearingIconDay = 0;
    private int bearingIconNight = 0;
    private int locationIconDay = 0;
    private int locationIconNight = 0;
    private static StateChangedListener<String> listener;

    private static ApplicationModeBuilder create(int key, String stringKey) {
        ApplicationModeBuilder builder = new ApplicationModeBuilder();
        builder.applicationMode = new ApplicationMode(key, stringKey);
        return builder;
    }

    private ApplicationMode(int key, String stringKey) {
        this.key = key;
        this.stringKey = stringKey;
    }

    public static List<ApplicationMode> values(OsmandSettings settings) {
        if (cachedFilteredValues.isEmpty()) {
            if (listener == null) {
                listener = new StateChangedListener<String>(){

                    @Override
                    public void stateChanged(String change) {
                        cachedFilteredValues = new ArrayList();
                    }
                };
                settings.AVAILABLE_APP_MODES.addListener(listener);
            }
            String available = settings.AVAILABLE_APP_MODES.get();
            cachedFilteredValues = new ArrayList<ApplicationMode>();
            for (ApplicationMode v : values) {
                if (available.indexOf(v.getStringKey() + ",") == -1 && v != DEFAULT) continue;
                cachedFilteredValues.add(v);
            }
        }
        return cachedFilteredValues;
    }

    public static List<ApplicationMode> allPossibleValues() {
        return new ArrayList<ApplicationMode>(values);
    }

    public static Set<ApplicationMode> regWidget(String widgetId, ApplicationMode ... am) {
        HashSet<ApplicationMode> set = new HashSet<ApplicationMode>();
        if (am == null) {
            set.addAll(values);
        } else {
            Collections.addAll(set, am);
        }
        for (ApplicationMode m : values) {
            if (!set.contains(m.getParent())) continue;
            set.add(m);
        }
        widgets.put(widgetId, set);
        return set;
    }

    public boolean isWidgetCollapsible(String key) {
        return false;
    }

    public boolean isWidgetVisible(String key) {
        Set<ApplicationMode> set = widgets.get(key);
        if (set == null) {
            return false;
        }
        return set.contains(this);
    }

    public static List<ApplicationMode> getModesDerivedFrom(ApplicationMode am) {
        ArrayList<ApplicationMode> list = new ArrayList<ApplicationMode>();
        for (ApplicationMode a : values) {
            if (a != am && a.getParent() != am) continue;
            list.add(a);
        }
        return list;
    }

    public ApplicationMode getParent() {
        return this.parent;
    }

    public int getSmallIconDark() {
        return this.smallIconDark;
    }

    public boolean hasFastSpeed() {
        return this.getDefaultSpeed() > 10.0f;
    }

    public int getResourceBearingDay() {
        return this.bearingIconDay;
    }

    public int getResourceBearingNight() {
        return this.bearingIconNight;
    }

    public int getResourceLocationDay() {
        return this.locationIconDay;
    }

    public int getResourceLocationNight() {
        return this.locationIconNight;
    }

    public String getStringKey() {
        return this.stringKey;
    }

    public int getIconId() {
        return this.iconId;
    }

    public int getStringResource() {
        return this.key;
    }

    public String toHumanString() {
        return "" + this.key;
    }

    public String toHumanStringCtx() {
        return OsmWindow.getInstance().getString(this.key);
    }

    public static ApplicationMode valueOfStringKey(String key, ApplicationMode def) {
        for (ApplicationMode p : values) {
            if (!p.getStringKey().equals(key)) continue;
            return p;
        }
        return def;
    }

    public float getDefaultSpeed() {
        return this.defaultSpeed;
    }

    public int getMinDistanceForTurn() {
        return this.minDistanceForTurn;
    }

    public int getArrivalDistance() {
        return this.arrivalDistance;
    }

    public boolean isDerivedRoutingFrom(ApplicationMode mode) {
        return this == mode || this.getParent() == mode;
    }

    static {
        ApplicationMode[] exceptDefault = new ApplicationMode[]{CAR, PEDESTRIAN, BICYCLE, BOAT, AIRCRAFT};
        ApplicationMode[] exceptPedestrianAndDefault = new ApplicationMode[]{CAR, BICYCLE, BOAT, AIRCRAFT};
        ApplicationMode[] exceptAirBoatDefault = new ApplicationMode[]{CAR, BICYCLE, PEDESTRIAN};
        ApplicationMode[] pedestrian = new ApplicationMode[]{PEDESTRIAN};
        ApplicationMode[] pedestrianBicycle = new ApplicationMode[]{PEDESTRIAN, BICYCLE};
        ApplicationMode[] all = null;
        ApplicationMode[] none = new ApplicationMode[]{};
        ApplicationMode.regWidget("next_turn", exceptPedestrianAndDefault);
        ApplicationMode.regWidget("next_turn_small", pedestrian);
        ApplicationMode.regWidget("next_next_turn", exceptPedestrianAndDefault);
        ApplicationMode.regWidget("intermediate_distance", exceptDefault);
        ApplicationMode.regWidget("distance", exceptDefault);
        ApplicationMode.regWidget("time", exceptDefault);
        ApplicationMode.regWidget("speed", exceptPedestrianAndDefault);
        ApplicationMode.regWidget("max_speed", CAR);
        ApplicationMode.regWidget("gps_info", none);
        ApplicationMode.regWidget("altitude", pedestrianBicycle);
        ApplicationMode.regWidget("compass", all);
        ApplicationMode.regWidget("config", none);
        ApplicationMode.regWidget("street_name", exceptAirBoatDefault);
        ApplicationMode.regWidget("back_to_location", all);
        ApplicationMode.regWidget("monitoring_services", none);
        ApplicationMode.regWidget("bgService", none);
        ApplicationMode.regWidget("layers", none);
    }

    private static class ApplicationModeBuilder {
        private ApplicationMode applicationMode;

        private ApplicationModeBuilder() {
        }

        public ApplicationMode reg() {
            values.add(this.applicationMode);
            return this.applicationMode;
        }

        public ApplicationModeBuilder icon(int bigIcon, int smallIconDark) {
            this.applicationMode.iconId = bigIcon;
            this.applicationMode.smallIconDark = smallIconDark;
            return this;
        }

        public ApplicationModeBuilder carLocation() {
            this.applicationMode.bearingIconDay = 0;
            this.applicationMode.bearingIconNight = 0;
            this.applicationMode.locationIconDay = 0;
            this.applicationMode.locationIconNight = 0;
            return this;
        }

        public ApplicationModeBuilder parent(ApplicationMode parent) {
            this.applicationMode.parent = parent;
            return this;
        }

        public ApplicationModeBuilder bicycleLocation() {
            this.applicationMode.bearingIconDay = 0;
            this.applicationMode.bearingIconNight = 0;
            this.applicationMode.locationIconDay = 0;
            this.applicationMode.locationIconNight = 0;
            return this;
        }

        public ApplicationModeBuilder defLocation() {
            this.applicationMode.bearingIconDay = 0;
            this.applicationMode.bearingIconNight = 0;
            this.applicationMode.locationIconDay = 0;
            this.applicationMode.locationIconNight = 0;
            return this;
        }

        public ApplicationModeBuilder speed(float defSpeed, int distForTurn) {
            this.applicationMode.defaultSpeed = defSpeed;
            this.applicationMode.minDistanceForTurn = distForTurn;
            return this;
        }

        public ApplicationModeBuilder arrivalDistance(int arrivalDistance) {
            this.applicationMode.arrivalDistance = arrivalDistance;
            return this;
        }
    }
}

