/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL32UTF8
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 4};

    CharacterSetAL32UTF8(int id) {
        super(id);
        this.rep = 6;
    }

    @Override
    public boolean isLossyFrom(CharacterSet from) {
        return !from.isUnicode();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        boolean ok = source.rep <= 1024;
        return ok;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            char[] chars = new char[bytes.length];
            int[] countArr = new int[]{count};
            int chars_index = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, offset, chars, 0, countArr, true);
            return new String(chars, 0, chars_index);
        }
        catch (SQLException e) {
            return "";
        }
    }

    @Override
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        try {
            char[] chars = new char[bytes.length];
            int[] countArr = new int[]{count};
            int clen = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, offset, chars, 0, countArr, false);
            return new String(chars, 0, clen);
        }
        catch (SQLException e) {
            CharacterSetAL32UTF8.failUTFConversion();
            return "";
        }
    }

    @Override
    public byte[] convertWithReplacement(String str) {
        return CharacterSetAL32UTF8.stringToAL32UTF8(str);
    }

    @Override
    public byte[] convert(String str) throws SQLException {
        return CharacterSetAL32UTF8.stringToAL32UTF8(str);
    }

    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        byte[] result;
        if (from.rep == 6) {
            result = CharacterSetAL32UTF8.useOrCopy(source, offset, count);
        } else {
            String s = from.toString(source, offset, count);
            result = CharacterSetAL32UTF8.stringToAL32UTF8(s);
        }
        return result;
    }

    @Override
    int decode(CharacterWalker walker) throws SQLException {
        byte c;
        int len;
        byte[] bytes = walker.bytes;
        int bytes_index = walker.next;
        int bytes_end = walker.end;
        if (bytes_index >= bytes_end) {
            CharacterSetAL32UTF8.failUTFConversion();
        }
        if ((len = CharacterSetAL32UTF8.getUTFByteLength(c = bytes[bytes_index])) == 0 || bytes_index + (len - 1) >= bytes_end) {
            CharacterSetAL32UTF8.failUTFConversion();
        }
        try {
            char[] chars = new char[2];
            int[] lenArr = new int[]{len};
            int chars_len = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, bytes_index, chars, 0, lenArr, false);
            walker.next += len;
            if (chars_len == 1) {
                return chars[0];
            }
            return Character.toCodePoint(chars[0], chars[1]);
        }
        catch (SQLException e) {
            CharacterSetAL32UTF8.failUTFConversion();
            return 0;
        }
    }

    @Override
    void encode(CharacterBuffer buffer, int c) throws SQLException {
        int n;
        if ((c & 0xFFFF0000) != 0) {
            CharacterSetAL32UTF8.need(buffer, 4);
            char[] chars = new char[]{(char)(c >>> 16), (char)c};
            n = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, buffer.bytes, buffer.next, 2);
        } else {
            CharacterSetAL32UTF8.need(buffer, 3);
            char[] chars = new char[]{(char)c};
            n = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, buffer.bytes, buffer.next, 1);
        }
        buffer.next += n;
    }

    private static int getUTFByteLength(byte b) {
        return m_byteLen[b >>> 4 & 0xF];
    }

    @Override
    public int encodedByteLength(String s) {
        return CharacterSet.string32UTF8Length(s);
    }

    @Override
    public int encodedByteLength(char[] carray) {
        return CharacterSet.charArray32UTF8Length(carray);
    }
}

