/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.StreamUtil;

public class MPInteger
extends BCPGObject {
    BigInteger value = null;

    public MPInteger(BCPGInputStream in) throws IOException {
        int length = StreamUtil.read2OctetLength(in);
        byte[] bytes = new byte[(length + 7) / 8];
        in.readFully(bytes);
        this.value = new BigInteger(1, bytes);
    }

    public MPInteger(BigInteger value) {
        if (value == null || value.signum() < 0) {
            throw new IllegalArgumentException("value must not be null, or negative");
        }
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        StreamUtil.write2OctetLength(out, this.value.bitLength());
        byte[] bytes = this.value.toByteArray();
        if (bytes[0] == 0) {
            out.write(bytes, 1, bytes.length - 1);
        } else {
            out.write(bytes, 0, bytes.length);
        }
    }
}

