/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="2.4.0")
public class WeightedRouting
implements Writeable {
    private final String attributeName;
    private final Map<String, Double> weights;
    private final int hashCode;

    public WeightedRouting() {
        this("", new HashMap<String, Double>(3));
    }

    public WeightedRouting(String attributeName, Map<String, Double> weights) {
        this.attributeName = attributeName;
        this.weights = Collections.unmodifiableMap(weights);
        this.hashCode = Objects.hash(this.attributeName, this.weights);
    }

    public WeightedRouting(WeightedRouting weightedRouting) {
        this(weightedRouting.attributeName(), weightedRouting.weights);
    }

    public WeightedRouting(StreamInput in) throws IOException {
        this(in.readString(), (Map)in.readGenericValue());
    }

    public boolean isSet() {
        return this.attributeName != null && !this.attributeName.isEmpty() && this.weights != null && !this.weights.isEmpty();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.attributeName);
        out.writeGenericValue(this.weights);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedRouting that = (WeightedRouting)o;
        if (!this.attributeName.equals(that.attributeName)) {
            return false;
        }
        return this.weights.equals(that.weights);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "WeightedRouting{" + this.attributeName + "}{" + this.weights().toString() + "}";
    }

    public Map<String, Double> weights() {
        return this.weights;
    }

    public String attributeName() {
        return this.attributeName;
    }
}

