/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.ClusterManagerMetrics;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.transport.ReceiveTimeoutTransportException;
import reactor.util.annotation.NonNull;

public abstract class AsyncShardFetchCache<K extends BaseNodeResponse> {
    private final Logger logger;
    private final String type;
    private final ClusterManagerMetrics clusterManagerMetrics;

    protected AsyncShardFetchCache(Logger logger, String type, ClusterManagerMetrics clusterManagerMetrics) {
        this.logger = logger;
        this.type = type;
        this.clusterManagerMetrics = clusterManagerMetrics;
    }

    abstract void initData(DiscoveryNode var1);

    abstract void putData(DiscoveryNode var1, K var2);

    abstract K getData(DiscoveryNode var1);

    @NonNull
    abstract Map<String, ? extends BaseNodeEntry> getCache();

    abstract void deleteShard(ShardId var1);

    int getInflightFetches() {
        int count = 0;
        for (BaseNodeEntry nodeEntry : this.getCache().values()) {
            if (!nodeEntry.isFetching()) continue;
            ++count;
        }
        return count;
    }

    void fillShardCacheWithDataNodes(DiscoveryNodes nodes) {
        for (DiscoveryNode node : nodes.getDataNodes().values()) {
            if (this.getCache().containsKey(node.getId())) continue;
            this.initData(node);
        }
        this.getCache().keySet().removeIf(nodeId -> !nodes.nodeExists((String)nodeId));
    }

    List<String> findNodesToFetch() {
        ArrayList<String> nodesToFetch = new ArrayList<String>();
        for (BaseNodeEntry nodeEntry : this.getCache().values()) {
            if (nodeEntry.hasData() || nodeEntry.isFetching()) continue;
            nodesToFetch.add(nodeEntry.getNodeId());
        }
        return nodesToFetch;
    }

    boolean hasAnyNodeFetching() {
        for (BaseNodeEntry nodeEntry : this.getCache().values()) {
            if (!nodeEntry.isFetching()) continue;
            return true;
        }
        return false;
    }

    Map<DiscoveryNode, K> getCacheData(DiscoveryNodes nodes, Set<String> failedNodes) {
        HashMap<DiscoveryNode, K> fetchData = new HashMap<DiscoveryNode, K>();
        Iterator<Map.Entry<String, BaseNodeEntry>> it = this.getCache().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, BaseNodeEntry> entry = it.next();
            String nodeId = entry.getKey();
            BaseNodeEntry nodeEntry = entry.getValue();
            DiscoveryNode node = nodes.get(nodeId);
            if (node == null) continue;
            if (nodeEntry.isFailed()) {
                it.remove();
                failedNodes.add(nodeEntry.getNodeId());
                continue;
            }
            K nodeResponse = this.getData(node);
            if (nodeResponse == null) continue;
            fetchData.put(node, nodeResponse);
        }
        return fetchData;
    }

    void processResponses(List<K> responses, long fetchingRound) {
        this.clusterManagerMetrics.incrementCounter(this.clusterManagerMetrics.asyncFetchSuccessCounter, Double.valueOf(responses.size()));
        for (BaseNodeResponse response : responses) {
            BaseNodeEntry nodeEntry = this.getCache().get(response.getNode().getId());
            if (nodeEntry == null || !this.validateNodeResponse(nodeEntry, fetchingRound)) continue;
            this.logger.trace("marking {} as done for [{}], result is [{}]", (Object)nodeEntry.getNodeId(), (Object)this.type, (Object)response);
            this.putData(response.getNode(), response);
        }
    }

    private boolean validateNodeResponse(BaseNodeEntry nodeEntry, long fetchingRound) {
        if (nodeEntry.getFetchingRound() != fetchingRound) {
            assert (nodeEntry.getFetchingRound() > fetchingRound) : "node entries only replaced by newer rounds";
            this.logger.trace("received response for [{}] from node {} for an older fetching round (expected: {} but was: {})", (Object)nodeEntry.getNodeId(), (Object)this.type, (Object)nodeEntry.getFetchingRound(), (Object)fetchingRound);
            return false;
        }
        if (nodeEntry.isFailed()) {
            this.logger.trace("node {} has failed for [{}] (failure [{}])", (Object)nodeEntry.getNodeId(), (Object)this.type, (Object)nodeEntry.getFailure());
            return false;
        }
        return true;
    }

    private void handleNodeFailure(BaseNodeEntry nodeEntry, FailedNodeException failure, long fetchingRound) {
        if (nodeEntry.getFetchingRound() != fetchingRound) {
            assert (nodeEntry.getFetchingRound() > fetchingRound) : "node entries only replaced by newer rounds";
            this.logger.trace("received failure for [{}] from node {} for an older fetching round (expected: {} but was: {})", (Object)nodeEntry.getNodeId(), (Object)this.type, (Object)nodeEntry.getFetchingRound(), (Object)fetchingRound);
        } else if (!nodeEntry.isFailed()) {
            Throwable unwrappedCause = ExceptionsHelper.unwrapCause((Throwable)failure.getCause());
            if (this.retryableException(unwrappedCause)) {
                nodeEntry.restartFetching();
            } else {
                this.logger.warn(() -> new ParameterizedMessage("failed to list shard for {} on node [{}]", (Object)this.type, (Object)failure.nodeId()), (Throwable)((Object)failure));
                nodeEntry.doneFetching(failure.getCause());
            }
        }
    }

    boolean retryableException(Throwable unwrappedCause) {
        return unwrappedCause instanceof OpenSearchRejectedExecutionException || unwrappedCause instanceof ReceiveTimeoutTransportException || unwrappedCause instanceof OpenSearchTimeoutException;
    }

    void processFailures(List<FailedNodeException> failures, long fetchingRound) {
        this.clusterManagerMetrics.incrementCounter(this.clusterManagerMetrics.asyncFetchFailureCounter, Double.valueOf(failures.size()));
        for (FailedNodeException failure : failures) {
            this.logger.trace("processing failure {} for [{}]", (Object)failure, (Object)this.type);
            BaseNodeEntry nodeEntry = this.getCache().get(failure.nodeId());
            if (nodeEntry == null) continue;
            this.handleNodeFailure(nodeEntry, failure, fetchingRound);
        }
    }

    void remove(String nodeId) {
        this.getCache().remove(nodeId);
    }

    void markAsFetching(List<String> nodeIds, long fetchingRound) {
        for (String nodeId : nodeIds) {
            this.getCache().get(nodeId).markAsFetching(fetchingRound);
        }
    }

    static class BaseNodeEntry {
        private final String nodeId;
        private boolean fetching;
        private boolean valueSet;
        private Throwable failure;
        private long fetchingRound;

        BaseNodeEntry(String nodeId) {
            this.nodeId = nodeId;
        }

        String getNodeId() {
            return this.nodeId;
        }

        boolean isFetching() {
            return this.fetching;
        }

        void markAsFetching(long fetchingRound) {
            assert (!this.fetching) : "double marking a node as fetching";
            this.fetching = true;
            this.fetchingRound = fetchingRound;
        }

        void doneFetching() {
            assert (this.fetching) : "setting value but not in fetching mode";
            assert (this.failure == null) : "setting value when failure already set";
            this.valueSet = true;
            this.fetching = false;
        }

        void doneFetching(Throwable failure) {
            assert (this.fetching) : "setting value but not in fetching mode";
            assert (!this.valueSet) : "setting failure when already set value";
            assert (failure != null) : "setting failure can't be null";
            this.failure = failure;
            this.fetching = false;
        }

        void restartFetching() {
            assert (this.fetching) : "restarting fetching, but not in fetching mode";
            assert (!this.valueSet) : "value can't be set when restarting fetching";
            assert (this.failure == null) : "failure can't be set when restarting fetching";
            this.fetching = false;
        }

        boolean isFailed() {
            return this.failure != null;
        }

        boolean hasData() {
            return this.valueSet || this.failure != null;
        }

        Throwable getFailure() {
            assert (this.hasData()) : "getting failure when data has not been fetched";
            return this.failure;
        }

        long getFetchingRound() {
            return this.fetchingRound;
        }
    }
}

