/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AssetIdListCopier;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.HostMaintenance;
import software.amazon.awssdk.services.ec2.model.HostRecovery;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateHostsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AllocateHostsRequest> {
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(AllocateHostsRequest.getter(AllocateHostsRequest::instanceFamily)).setter(AllocateHostsRequest.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("InstanceFamily").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(AllocateHostsRequest.getter(AllocateHostsRequest::tagSpecifications)).setter(AllocateHostsRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> HOST_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostRecovery").getter(AllocateHostsRequest.getter(AllocateHostsRequest::hostRecoveryAsString)).setter(AllocateHostsRequest.setter(Builder::hostRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRecovery").unmarshallLocationName("HostRecovery").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(AllocateHostsRequest.getter(AllocateHostsRequest::outpostArn)).setter(AllocateHostsRequest.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("OutpostArn").build()}).build();
    private static final SdkField<String> HOST_MAINTENANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostMaintenance").getter(AllocateHostsRequest.getter(AllocateHostsRequest::hostMaintenanceAsString)).setter(AllocateHostsRequest.setter(Builder::hostMaintenance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostMaintenance").unmarshallLocationName("HostMaintenance").build()}).build();
    private static final SdkField<List<String>> ASSET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssetIds").getter(AllocateHostsRequest.getter(AllocateHostsRequest::assetIds)).setter(AllocateHostsRequest.setter(Builder::assetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").unmarshallLocationName("AssetId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(AllocateHostsRequest.getter(AllocateHostsRequest::availabilityZoneId)).setter(AllocateHostsRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoPlacement").getter(AllocateHostsRequest.getter(AllocateHostsRequest::autoPlacementAsString)).setter(AllocateHostsRequest.setter(Builder::autoPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement").unmarshallLocationName("autoPlacement").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AllocateHostsRequest.getter(AllocateHostsRequest::clientToken)).setter(AllocateHostsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(AllocateHostsRequest.getter(AllocateHostsRequest::instanceType)).setter(AllocateHostsRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(AllocateHostsRequest.getter(AllocateHostsRequest::quantity)).setter(AllocateHostsRequest.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("quantity").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(AllocateHostsRequest.getter(AllocateHostsRequest::availabilityZone)).setter(AllocateHostsRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FAMILY_FIELD, TAG_SPECIFICATIONS_FIELD, HOST_RECOVERY_FIELD, OUTPOST_ARN_FIELD, HOST_MAINTENANCE_FIELD, ASSET_IDS_FIELD, AVAILABILITY_ZONE_ID_FIELD, AUTO_PLACEMENT_FIELD, CLIENT_TOKEN_FIELD, INSTANCE_TYPE_FIELD, QUANTITY_FIELD, AVAILABILITY_ZONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AllocateHostsRequest.memberNameToFieldInitializer();
    private final String instanceFamily;
    private final List<TagSpecification> tagSpecifications;
    private final String hostRecovery;
    private final String outpostArn;
    private final String hostMaintenance;
    private final List<String> assetIds;
    private final String availabilityZoneId;
    private final String autoPlacement;
    private final String clientToken;
    private final String instanceType;
    private final Integer quantity;
    private final String availabilityZone;

    private AllocateHostsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceFamily = builder.instanceFamily;
        this.tagSpecifications = builder.tagSpecifications;
        this.hostRecovery = builder.hostRecovery;
        this.outpostArn = builder.outpostArn;
        this.hostMaintenance = builder.hostMaintenance;
        this.assetIds = builder.assetIds;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.autoPlacement = builder.autoPlacement;
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.quantity = builder.quantity;
        this.availabilityZone = builder.availabilityZone;
    }

    public final String instanceFamily() {
        return this.instanceFamily;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final HostRecovery hostRecovery() {
        return HostRecovery.fromValue(this.hostRecovery);
    }

    public final String hostRecoveryAsString() {
        return this.hostRecovery;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final HostMaintenance hostMaintenance() {
        return HostMaintenance.fromValue(this.hostMaintenance);
    }

    public final String hostMaintenanceAsString() {
        return this.hostMaintenance;
    }

    public final boolean hasAssetIds() {
        return this.assetIds != null && !(this.assetIds instanceof SdkAutoConstructList);
    }

    public final List<String> assetIds() {
        return this.assetIds;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public final String autoPlacementAsString() {
        return this.autoPlacement;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostMaintenanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetIds() ? this.assetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsRequest)) {
            return false;
        }
        AllocateHostsRequest other = (AllocateHostsRequest)((Object)obj);
        return Objects.equals(this.instanceFamily(), other.instanceFamily()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.hostRecoveryAsString(), other.hostRecoveryAsString()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.hostMaintenanceAsString(), other.hostMaintenanceAsString()) && this.hasAssetIds() == other.hasAssetIds() && Objects.equals(this.assetIds(), other.assetIds()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.autoPlacementAsString(), other.autoPlacementAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public final String toString() {
        return ToString.builder((String)"AllocateHostsRequest").add("InstanceFamily", (Object)this.instanceFamily()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("HostRecovery", (Object)this.hostRecoveryAsString()).add("OutpostArn", (Object)this.outpostArn()).add("HostMaintenance", (Object)this.hostMaintenanceAsString()).add("AssetIds", this.hasAssetIds() ? this.assetIds() : null).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AutoPlacement", (Object)this.autoPlacementAsString()).add("ClientToken", (Object)this.clientToken()).add("InstanceType", (Object)this.instanceType()).add("Quantity", (Object)this.quantity()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "HostRecovery": {
                return Optional.ofNullable(clazz.cast(this.hostRecoveryAsString()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "HostMaintenance": {
                return Optional.ofNullable(clazz.cast(this.hostMaintenanceAsString()));
            }
            case "AssetIds": {
                return Optional.ofNullable(clazz.cast(this.assetIds()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AutoPlacement": {
                return Optional.ofNullable(clazz.cast(this.autoPlacementAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceFamily", INSTANCE_FAMILY_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("HostRecovery", HOST_RECOVERY_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("HostMaintenance", HOST_MAINTENANCE_FIELD);
        map.put("AssetId", ASSET_IDS_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AutoPlacement", AUTO_PLACEMENT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Quantity", QUANTITY_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllocateHostsRequest, T> g) {
        return obj -> g.apply((AllocateHostsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceFamily;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String hostRecovery;
        private String outpostArn;
        private String hostMaintenance;
        private List<String> assetIds = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZoneId;
        private String autoPlacement;
        private String clientToken;
        private String instanceType;
        private Integer quantity;
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsRequest model) {
            super(model);
            this.instanceFamily(model.instanceFamily);
            this.tagSpecifications(model.tagSpecifications);
            this.hostRecovery(model.hostRecovery);
            this.outpostArn(model.outpostArn);
            this.hostMaintenance(model.hostMaintenance);
            this.assetIds(model.assetIds);
            this.availabilityZoneId(model.availabilityZoneId);
            this.autoPlacement(model.autoPlacement);
            this.clientToken(model.clientToken);
            this.instanceType(model.instanceType);
            this.quantity(model.quantity);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHostRecovery() {
            return this.hostRecovery;
        }

        public final void setHostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
        }

        @Override
        public final Builder hostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
            return this;
        }

        @Override
        public final Builder hostRecovery(HostRecovery hostRecovery) {
            this.hostRecovery(hostRecovery == null ? null : hostRecovery.toString());
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getHostMaintenance() {
            return this.hostMaintenance;
        }

        public final void setHostMaintenance(String hostMaintenance) {
            this.hostMaintenance = hostMaintenance;
        }

        @Override
        public final Builder hostMaintenance(String hostMaintenance) {
            this.hostMaintenance = hostMaintenance;
            return this;
        }

        @Override
        public final Builder hostMaintenance(HostMaintenance hostMaintenance) {
            this.hostMaintenance(hostMaintenance == null ? null : hostMaintenance.toString());
            return this;
        }

        public final Collection<String> getAssetIds() {
            if (this.assetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetIds;
        }

        public final void setAssetIds(Collection<String> assetIds) {
            this.assetIds = AssetIdListCopier.copy(assetIds);
        }

        @Override
        public final Builder assetIds(Collection<String> assetIds) {
            this.assetIds = AssetIdListCopier.copy(assetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetIds(String ... assetIds) {
            this.assetIds(Arrays.asList(assetIds));
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getAutoPlacement() {
            return this.autoPlacement;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement == null ? null : autoPlacement.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateHostsRequest build() {
            return new AllocateHostsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateHostsRequest> {
        public Builder instanceFamily(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder hostRecovery(String var1);

        public Builder hostRecovery(HostRecovery var1);

        public Builder outpostArn(String var1);

        public Builder hostMaintenance(String var1);

        public Builder hostMaintenance(HostMaintenance var1);

        public Builder assetIds(Collection<String> var1);

        public Builder assetIds(String ... var1);

        public Builder availabilityZoneId(String var1);

        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder clientToken(String var1);

        public Builder instanceType(String var1);

        public Builder quantity(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

