/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ServiceLinkVirtualInterface;
import software.amazon.awssdk.services.ec2.model.ServiceLinkVirtualInterfaceSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceLinkVirtualInterfacesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeServiceLinkVirtualInterfacesResponse> {
    private static final SdkField<List<ServiceLinkVirtualInterface>> SERVICE_LINK_VIRTUAL_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceLinkVirtualInterfaces").getter(DescribeServiceLinkVirtualInterfacesResponse.getter(DescribeServiceLinkVirtualInterfacesResponse::serviceLinkVirtualInterfaces)).setter(DescribeServiceLinkVirtualInterfacesResponse.setter(Builder::serviceLinkVirtualInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkVirtualInterfaceSet").unmarshallLocationName("serviceLinkVirtualInterfaceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceLinkVirtualInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeServiceLinkVirtualInterfacesResponse.getter(DescribeServiceLinkVirtualInterfacesResponse::nextToken)).setter(DescribeServiceLinkVirtualInterfacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_LINK_VIRTUAL_INTERFACES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceLinkVirtualInterfacesResponse.memberNameToFieldInitializer();
    private final List<ServiceLinkVirtualInterface> serviceLinkVirtualInterfaces;
    private final String nextToken;

    private DescribeServiceLinkVirtualInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.serviceLinkVirtualInterfaces = builder.serviceLinkVirtualInterfaces;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceLinkVirtualInterfaces() {
        return this.serviceLinkVirtualInterfaces != null && !(this.serviceLinkVirtualInterfaces instanceof SdkAutoConstructList);
    }

    public final List<ServiceLinkVirtualInterface> serviceLinkVirtualInterfaces() {
        return this.serviceLinkVirtualInterfaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceLinkVirtualInterfaces() ? this.serviceLinkVirtualInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceLinkVirtualInterfacesResponse)) {
            return false;
        }
        DescribeServiceLinkVirtualInterfacesResponse other = (DescribeServiceLinkVirtualInterfacesResponse)((Object)obj);
        return this.hasServiceLinkVirtualInterfaces() == other.hasServiceLinkVirtualInterfaces() && Objects.equals(this.serviceLinkVirtualInterfaces(), other.serviceLinkVirtualInterfaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceLinkVirtualInterfacesResponse").add("ServiceLinkVirtualInterfaces", this.hasServiceLinkVirtualInterfaces() ? this.serviceLinkVirtualInterfaces() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceLinkVirtualInterfaces": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkVirtualInterfaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceLinkVirtualInterfaceSet", SERVICE_LINK_VIRTUAL_INTERFACES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceLinkVirtualInterfacesResponse, T> g) {
        return obj -> g.apply((DescribeServiceLinkVirtualInterfacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ServiceLinkVirtualInterface> serviceLinkVirtualInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceLinkVirtualInterfacesResponse model) {
            super(model);
            this.serviceLinkVirtualInterfaces(model.serviceLinkVirtualInterfaces);
            this.nextToken(model.nextToken);
        }

        public final List<ServiceLinkVirtualInterface.Builder> getServiceLinkVirtualInterfaces() {
            List<ServiceLinkVirtualInterface.Builder> result = ServiceLinkVirtualInterfaceSetCopier.copyToBuilder(this.serviceLinkVirtualInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceLinkVirtualInterfaces(Collection<ServiceLinkVirtualInterface.BuilderImpl> serviceLinkVirtualInterfaces) {
            this.serviceLinkVirtualInterfaces = ServiceLinkVirtualInterfaceSetCopier.copyFromBuilder(serviceLinkVirtualInterfaces);
        }

        @Override
        public final Builder serviceLinkVirtualInterfaces(Collection<ServiceLinkVirtualInterface> serviceLinkVirtualInterfaces) {
            this.serviceLinkVirtualInterfaces = ServiceLinkVirtualInterfaceSetCopier.copy(serviceLinkVirtualInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceLinkVirtualInterfaces(ServiceLinkVirtualInterface ... serviceLinkVirtualInterfaces) {
            this.serviceLinkVirtualInterfaces(Arrays.asList(serviceLinkVirtualInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceLinkVirtualInterfaces(Consumer<ServiceLinkVirtualInterface.Builder> ... serviceLinkVirtualInterfaces) {
            this.serviceLinkVirtualInterfaces(Stream.of(serviceLinkVirtualInterfaces).map(c -> (ServiceLinkVirtualInterface)((ServiceLinkVirtualInterface.Builder)ServiceLinkVirtualInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeServiceLinkVirtualInterfacesResponse build() {
            return new DescribeServiceLinkVirtualInterfacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceLinkVirtualInterfacesResponse> {
        public Builder serviceLinkVirtualInterfaces(Collection<ServiceLinkVirtualInterface> var1);

        public Builder serviceLinkVirtualInterfaces(ServiceLinkVirtualInterface ... var1);

        public Builder serviceLinkVirtualInterfaces(Consumer<ServiceLinkVirtualInterface.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

