/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.knn.index.DerivedKnnByteVectorField;
import org.opensearch.knn.index.DerivedKnnFloatVectorField;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.KNN10010Codec.KNN10010DerivedSourceStoredFieldsWriter;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;

public class DerivedSourceIndexOperationListener
implements IndexingOperationListener {
    @Generated
    private static final Logger log = LogManager.getLogger(DerivedSourceIndexOperationListener.class);

    public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        if (this.isRecoverySourceEnabled(operation)) {
            return operation;
        }
        Pair<Function<Map<String, Object>, Map<String, Object>>> transformers = this.createInjectTransformer(operation);
        if (transformers == null) {
            return operation;
        }
        Function<Map<String, Object>, Map<String, Object>> injectTransformer = transformers.first();
        Function<Map<String, Object>, Map<String, Object>> maskTransformer = transformers.second();
        Tuple originalSource = XContentHelper.convertToMap((BytesReference)operation.parsedDoc().source(), (boolean)true, (MediaType)operation.parsedDoc().getMediaType());
        Map<String, Object> cleanVectorSource = injectTransformer.apply((Map)originalSource.v2());
        try (BytesStreamOutput bStream = new BytesStreamOutput();){
            XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)((MediaType)originalSource.v1()), (OutputStream)bStream).map(cleanVectorSource);
            builder.close();
            operation.parsedDoc().setSource(bStream.bytes(), XContentType.valueOf((String)((MediaType)originalSource.v1()).subtype().toUpperCase(Locale.ROOT)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IndexableField field = operation.parsedDoc().rootDoc().getField("_source");
        if (field == null || field.storedValue() == null) {
            return operation;
        }
        Map<String, Object> maskedVectorSource = maskTransformer.apply((Map)originalSource.v2());
        try (BytesStreamOutput bStream = new BytesStreamOutput();){
            XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)((MediaType)originalSource.v1()), (OutputStream)bStream).map(maskedVectorSource);
            builder.close();
            if (field instanceof StoredField) {
                StoredField storedField = (StoredField)field;
                storedField.setBytesValue(bStream.bytes().toBytesRef());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return operation;
    }

    private Pair<Function<Map<String, Object>, Map<String, Object>>> createInjectTransformer(Engine.Index operation) {
        HashMap<String, List> injectedVectors = new HashMap<String, List>();
        for (ParseContext.Document document : operation.parsedDoc().docs()) {
            for (IndexableField indexableField : document) {
                DerivedKnnByteVectorField knnByteVectorField;
                DerivedKnnFloatVectorField knnVectorFieldType;
                if (indexableField instanceof DerivedKnnFloatVectorField && (knnVectorFieldType = (DerivedKnnFloatVectorField)indexableField).isDerivedEnabled()) {
                    injectedVectors.computeIfAbsent(indexableField.name(), k -> new ArrayList()).add(this.formatVector(VectorDataType.FLOAT, knnVectorFieldType.vectorValue()));
                }
                if (!(indexableField instanceof DerivedKnnByteVectorField) || !(knnByteVectorField = (DerivedKnnByteVectorField)indexableField).isDerivedEnabled()) continue;
                injectedVectors.computeIfAbsent(indexableField.name(), k -> new ArrayList()).add(this.formatVector(VectorDataType.BYTE, knnByteVectorField.vectorValue()));
            }
        }
        if (injectedVectors.isEmpty()) {
            return null;
        }
        HashMap<String, Function<Object, Object>> injectTransformers = new HashMap<String, Function<Object, Object>>();
        HashMap<String, Function<Object, Object>> maskTransformers = new HashMap<String, Function<Object, Object>>();
        for (Map.Entry entry : injectedVectors.entrySet()) {
            Iterator iterator = ((List)entry.getValue()).iterator();
            injectTransformers.put((String)entry.getKey(), o -> o == null ? o : iterator.next());
            maskTransformers.put((String)entry.getKey(), o -> o == null ? o : KNN10010DerivedSourceStoredFieldsWriter.MASK);
        }
        return new Pair<Function<Map<String, Object>, Map<String, Object>>>(XContentMapValues.transform(injectTransformers, (boolean)true), XContentMapValues.transform(maskTransformers, (boolean)true));
    }

    private boolean isRecoverySourceEnabled(Engine.Index operation) {
        return operation.parsedDoc().rootDoc().getField("_recovery_source") != null;
    }

    protected Object formatVector(VectorDataType vectorDataType, Object vectorValue) {
        if (vectorValue instanceof byte[]) {
            BytesRef vectorBytesRef = new BytesRef((byte[])vectorValue);
            return KNNVectorFieldMapperUtil.deserializeStoredVector(vectorBytesRef, vectorDataType);
        }
        return vectorValue;
    }

    private record Pair<T>(T first, T second) {
    }
}

