/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.get.GetResponse;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MLLongTermMemory;
import org.opensearch.ml.common.memorycontainer.MLMemoryHistory;
import org.opensearch.ml.common.memorycontainer.MLMemorySession;
import org.opensearch.ml.common.memorycontainer.MLWorkingMemory;
import org.opensearch.ml.common.memorycontainer.MemoryType;

public class MLGetMemoryResponse
extends ActionResponse
implements ToXContentObject {
    MLMemorySession session;
    MLWorkingMemory workingMemory;
    MLLongTermMemory longTermMemory;
    MLMemoryHistory memoryHistory;

    public MLGetMemoryResponse(MLMemorySession session, MLWorkingMemory workingMemory, MLLongTermMemory longTermMemory, MLMemoryHistory memoryHistory) {
        this.session = session;
        this.workingMemory = workingMemory;
        this.longTermMemory = longTermMemory;
        this.memoryHistory = memoryHistory;
    }

    public MLGetMemoryResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.session = new MLMemorySession(in);
        }
        if (in.readBoolean()) {
            this.workingMemory = new MLWorkingMemory(in);
        }
        if (in.readBoolean()) {
            this.longTermMemory = new MLLongTermMemory(in);
        }
        if (in.readBoolean()) {
            this.memoryHistory = new MLMemoryHistory(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.session != null) {
            out.writeBoolean(true);
            this.session.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.workingMemory != null) {
            out.writeBoolean(true);
            this.workingMemory.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.longTermMemory != null) {
            out.writeBoolean(true);
            this.longTermMemory.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.memoryHistory != null) {
            out.writeBoolean(true);
            this.memoryHistory.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MLGetMemoryResponse fromGetResponse(GetResponse getResponse, MemoryType memoryType) {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            switch (memoryType) {
                case SESSIONS: {
                    MLGetMemoryResponse mLGetMemoryResponse = MLGetMemoryResponse.builder().session(MLMemorySession.parse(parser)).build();
                    return mLGetMemoryResponse;
                }
                case WORKING: {
                    MLGetMemoryResponse mLGetMemoryResponse = MLGetMemoryResponse.builder().workingMemory(MLWorkingMemory.parse(parser)).build();
                    return mLGetMemoryResponse;
                }
                case LONG_TERM: {
                    MLGetMemoryResponse mLGetMemoryResponse = MLGetMemoryResponse.builder().longTermMemory(MLLongTermMemory.parse(parser)).build();
                    return mLGetMemoryResponse;
                }
                case HISTORY: {
                    MLGetMemoryResponse mLGetMemoryResponse = MLGetMemoryResponse.builder().memoryHistory(MLMemoryHistory.parse(parser)).build();
                    return mLGetMemoryResponse;
                }
            }
            throw new IllegalArgumentException("Invalid memory type: " + String.valueOf((Object)memoryType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.session != null) {
            this.session.toXContent(builder, params);
        } else if (this.workingMemory != null) {
            this.workingMemory.toXContent(builder, params);
        } else if (this.longTermMemory != null) {
            this.longTermMemory.toXContent(builder, params);
        } else if (this.memoryHistory != null) {
            this.memoryHistory.toXContent(builder, params);
        }
        return builder;
    }

    /*
     * Exception decompiling
     */
    public static MLGetMemoryResponse fromActionResponse(ActionResponse actionResponse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public static MLGetMemoryResponseBuilder builder() {
        return new MLGetMemoryResponseBuilder();
    }

    @Generated
    public MLMemorySession getSession() {
        return this.session;
    }

    @Generated
    public MLWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Generated
    public MLLongTermMemory getLongTermMemory() {
        return this.longTermMemory;
    }

    @Generated
    public MLMemoryHistory getMemoryHistory() {
        return this.memoryHistory;
    }

    @Generated
    public String toString() {
        return "MLGetMemoryResponse(session=" + String.valueOf(this.getSession()) + ", workingMemory=" + String.valueOf(this.getWorkingMemory()) + ", longTermMemory=" + String.valueOf(this.getLongTermMemory()) + ", memoryHistory=" + String.valueOf(this.getMemoryHistory()) + ")";
    }

    @Generated
    public static class MLGetMemoryResponseBuilder {
        @Generated
        private MLMemorySession session;
        @Generated
        private MLWorkingMemory workingMemory;
        @Generated
        private MLLongTermMemory longTermMemory;
        @Generated
        private MLMemoryHistory memoryHistory;

        @Generated
        MLGetMemoryResponseBuilder() {
        }

        @Generated
        public MLGetMemoryResponseBuilder session(MLMemorySession session) {
            this.session = session;
            return this;
        }

        @Generated
        public MLGetMemoryResponseBuilder workingMemory(MLWorkingMemory workingMemory) {
            this.workingMemory = workingMemory;
            return this;
        }

        @Generated
        public MLGetMemoryResponseBuilder longTermMemory(MLLongTermMemory longTermMemory) {
            this.longTermMemory = longTermMemory;
            return this;
        }

        @Generated
        public MLGetMemoryResponseBuilder memoryHistory(MLMemoryHistory memoryHistory) {
            this.memoryHistory = memoryHistory;
            return this;
        }

        @Generated
        public MLGetMemoryResponse build() {
            return new MLGetMemoryResponse(this.session, this.workingMemory, this.longTermMemory, this.memoryHistory);
        }

        @Generated
        public String toString() {
            return "MLGetMemoryResponse.MLGetMemoryResponseBuilder(session=" + String.valueOf(this.session) + ", workingMemory=" + String.valueOf(this.workingMemory) + ", longTermMemory=" + String.valueOf(this.longTermMemory) + ", memoryHistory=" + String.valueOf(this.memoryHistory) + ")";
        }
    }
}

