/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.optimization;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.neuralsearch.processor.optimization.InferenceFilter;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;

public class TextEmbeddingInferenceFilter
extends InferenceFilter {
    @Generated
    private static final Logger log = LogManager.getLogger(TextEmbeddingInferenceFilter.class);

    public TextEmbeddingInferenceFilter(Map<String, Object> fieldMap) {
        super(fieldMap);
    }

    @Override
    public Object filterInferenceValue(String embeddingKey, Object processValue, Map<String, Object> sourceAndMetadataMap, Map<String, Object> existingSourceAndMetadataMap, int index) {
        String textPath = (String)this.reversedFieldMap.get(embeddingKey);
        Optional<Object> existingValueOptional = ProcessorUtils.getValueFromSource(existingSourceAndMetadataMap, textPath);
        Optional<Object> embeddingValueOptional = ProcessorUtils.getValueFromSource(existingSourceAndMetadataMap, embeddingKey);
        if (existingValueOptional.isPresent() && embeddingValueOptional.isPresent()) {
            return this.copyEmbeddingForSingleObject(embeddingKey, processValue, existingValueOptional.get(), embeddingValueOptional.get(), sourceAndMetadataMap, index);
        }
        return processValue;
    }

    @Override
    public Object copyEmbeddingForSingleObject(String embeddingKey, Object processValue, Object existingValue, Object embeddingValue, Map<String, Object> sourceAndMetadataMap, int index) {
        if (Objects.equals(existingValue, processValue)) {
            ProcessorUtils.setValueToSource(sourceAndMetadataMap, embeddingKey, embeddingValue, index);
            return null;
        }
        return processValue;
    }

    @Override
    public List<Object> copyEmbeddingForListObject(String embeddingKey, List<Object> processList, List<Object> existingList, List<Object> embeddingList, Map<String, Object> sourceAndMetadataMap) {
        if (Objects.equals(processList, existingList)) {
            ProcessorUtils.setValueToSource(sourceAndMetadataMap, embeddingKey, embeddingList);
            return null;
        }
        return processList;
    }
}

