/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.codec.SparseTerms;
import org.opensearch.neuralsearch.sparse.codec.SparseTermsLuceneReader;
import org.opensearch.neuralsearch.sparse.common.PredicateUtils;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorField;

public class SparsePostingsProducer
extends FieldsProducer {
    private final FieldsProducer delegate;
    private final SegmentReadState state;
    private final Supplier<SparseTermsLuceneReader> readerSupplier;
    private SparseTermsLuceneReader reader;

    public SparsePostingsProducer(FieldsProducer delegate, SegmentReadState state, @NonNull Supplier<SparseTermsLuceneReader> readerSupplier) {
        Objects.requireNonNull(readerSupplier, "readerSupplier is marked non-null but is null");
        this.delegate = delegate;
        this.state = state;
        this.readerSupplier = readerSupplier;
        this.reader = null;
    }

    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    public Iterator<String> iterator() {
        return this.delegate.iterator();
    }

    public Terms terms(String field) throws IOException {
        FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
        if (!SparseVectorField.isSparseField(fieldInfo) || !PredicateUtils.shouldRunSeisPredicate.test(this.state.segmentInfo, fieldInfo)) {
            return this.delegate.terms(field);
        }
        CacheKey key = new CacheKey(this.state.segmentInfo, fieldInfo);
        if (this.reader == null) {
            this.reader = this.readerSupplier.get();
        }
        return new SparseTerms(key, this.reader, field);
    }

    public int size() {
        return 0;
    }

    @Generated
    public FieldsProducer getDelegate() {
        return this.delegate;
    }

    @Generated
    public SegmentReadState getState() {
        return this.state;
    }

    @Generated
    public Supplier<SparseTermsLuceneReader> getReaderSupplier() {
        return this.readerSupplier;
    }

    @Generated
    public SparseTermsLuceneReader getReader() {
        return this.reader;
    }
}

