/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.opensearch.neuralsearch.sparse.accessor.SparseVectorReader;
import org.opensearch.neuralsearch.sparse.data.SparseVector;
import org.opensearch.neuralsearch.sparse.query.SeismicBaseScorer;
import org.opensearch.neuralsearch.sparse.query.SparseQueryContext;

public class OrderedPostingWithClustersScorer
extends SeismicBaseScorer {
    private final Similarity.SimScorer simScorer;
    private final DocIdSetIterator conjunctionDisi;

    public OrderedPostingWithClustersScorer(String fieldName, SparseQueryContext sparseQueryContext, SparseVector queryVector, LeafReader leafReader, Bits acceptedDocs, @NonNull SparseVectorReader reader, Similarity.SimScorer simScorer, BitSetIterator filterBitSetIterator) throws IOException {
        super(leafReader, fieldName, sparseQueryContext, leafReader.maxDoc(), queryVector, reader, acceptedDocs);
        Objects.requireNonNull(reader, "reader is marked non-null but is null");
        this.simScorer = simScorer;
        List<Pair<Integer, Integer>> results = this.searchUpfront(sparseQueryContext.getK());
        SeismicBaseScorer.ResultsDocValueIterator resultsIterator = new SeismicBaseScorer.ResultsDocValueIterator(results);
        this.conjunctionDisi = filterBitSetIterator != null ? ConjunctionUtils.intersectIterators(List.of(resultsIterator, filterBitSetIterator)) : resultsIterator;
    }

    public int docID() {
        return this.conjunctionDisi.docID();
    }

    public DocIdSetIterator iterator() {
        return this.conjunctionDisi;
    }

    public float getMaxScore(int upTo) throws IOException {
        return 0.0f;
    }

    public float score() throws IOException {
        return this.simScorer.score((float)this.conjunctionDisi.cost(), 0L);
    }
}

