/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.resthandler;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.commons.notifications.action.SendNotificationResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.notifications.action.SendTestNotificationAction;
import org.opensearch.notifications.metrics.Metrics;
import org.opensearch.notifications.model.SendTestNotificationRequest;
import org.opensearch.notifications.resthandler.PluginBaseHandler;
import org.opensearch.notifications.resthandler.RestResponseToXContentListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/notifications/resthandler/SendTestMessageRestHandler;", "Lorg/opensearch/notifications/resthandler/PluginBaseHandler;", "()V", "executeRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "executeSendTestMessage", "getName", "", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "responseParams", "", "Companion", "opensearch-notifications"})
public final class SendTestMessageRestHandler
extends PluginBaseHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String REQUEST_URL = "/_plugins/_notifications/feature/test";

    @NotNull
    public String getName() {
        return "notifications_send_test";
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return CollectionsKt.listOf((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_notifications/feature/test/{config_id}", RestRequest.Method.GET, "/_plugins/_notifications/feature/test/{config_id}"));
    }

    @NotNull
    protected Set<String> responseParams() {
        return SetsKt.setOf((Object)"config_id");
    }

    @Override
    @NotNull
    protected BaseRestHandler.RestChannelConsumer executeRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestRequest.Method method = request.method();
        return switch (method == null ? -1 : WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1 -> this.executeSendTestMessage(request, client);
            case 2 -> this.executeSendTestMessage(request, client);
            default -> arg_0 -> SendTestMessageRestHandler.executeRequest$lambda$0(request, arg_0);
        };
    }

    private final BaseRestHandler.RestChannelConsumer executeSendTestMessage(RestRequest request, NodeClient client) {
        return arg_0 -> SendTestMessageRestHandler.executeSendTestMessage$lambda$1(request, client, arg_0);
    }

    private static final void executeRequest$lambda$0(RestRequest $request, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        it.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, $request.method() + " is not allowed"));
    }

    private static final void executeSendTestMessage$lambda$1(RestRequest $request, NodeClient $client, RestChannel it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Metrics.NOTIFICATIONS_SEND_TEST_MESSAGE_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_SEND_TEST_MESSAGE_INTERVAL_COUNT.getCounter().increment();
        String configId = $request.param("config_id");
        Intrinsics.checkNotNull((Object)configId);
        SendTestNotificationRequest sendTestNotificationRequest = new SendTestNotificationRequest(configId);
        ActionType<SendNotificationResponse> actionType = SendTestNotificationAction.Companion.getACTION_TYPE$opensearch_notifications();
        ActionRequest actionRequest = sendTestNotificationRequest;
        Intrinsics.checkNotNull((Object)it);
        $client.execute(actionType, actionRequest, (ActionListener)new RestResponseToXContentListener(it));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/notifications/resthandler/SendTestMessageRestHandler$Companion;", "", "()V", "REQUEST_URL", "", "opensearch-notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestRequest.Method.values().length];
            try {
                nArray[RestRequest.Method.POST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestRequest.Method.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

