/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.config.setting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingListener;

public class ClusterSettingsManager
implements ClusterStateListener {
    private static final Logger LOG = LogManager.getLogger(ClusterSettingsManager.class);
    private final Map<Setting<Integer>, List<ClusterSettingListener<Integer>>> intSettingListenerMap = new HashMap<Setting<Integer>, List<ClusterSettingListener<Integer>>>();
    private final Map<Setting<String>, List<ClusterSettingListener<String>>> stringSettingListenerMap = new HashMap<Setting<String>, List<ClusterSettingListener<String>>>();
    private final List<Setting<Integer>> managedIntSettings = new ArrayList<Setting<Integer>>();
    private final List<Setting<String>> managedStringSettings = new ArrayList<Setting<String>>();
    private final ClusterSettingsResponseHandler clusterSettingsResponseHandler;
    private boolean initialized = false;

    public ClusterSettingsManager(List<Setting<Integer>> intSettings, List<Setting<String>> stringSettings) {
        this.managedIntSettings.addAll(intSettings);
        this.managedStringSettings.addAll(stringSettings);
        this.clusterSettingsResponseHandler = new ClusterSettingsResponseHandler();
    }

    public void addSubscriberForIntSetting(Setting<Integer> setting, ClusterSettingListener<Integer> listener) {
        if (this.intSettingListenerMap.containsKey(setting)) {
            List<ClusterSettingListener<Integer>> currentListeners = this.intSettingListenerMap.get(setting);
            if (!currentListeners.contains(listener)) {
                currentListeners.add(listener);
                this.intSettingListenerMap.put(setting, currentListeners);
            }
        } else {
            this.intSettingListenerMap.put(setting, Collections.singletonList(listener));
        }
    }

    public void addSubscriberForStringSetting(Setting<String> setting, ClusterSettingListener<String> listener) {
        if (this.stringSettingListenerMap.containsKey(setting)) {
            List<ClusterSettingListener<String>> currentListeners = this.stringSettingListenerMap.get(setting);
            if (!currentListeners.contains(listener)) {
                currentListeners.add(listener);
                this.stringSettingListenerMap.put(setting, currentListeners);
            }
        } else {
            this.stringSettingListenerMap.put(setting, Collections.singletonList(listener));
        }
    }

    public void initialize() {
        if (!this.initialized) {
            if (this.clusterStatePresent()) {
                this.registerSettingUpdateListener();
                this.readAllManagedClusterSettings();
            } else {
                this.registerClusterStateListener(this);
            }
            this.initialized = true;
        }
    }

    public void updateSetting(Setting<Integer> setting, Integer newValue) {
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest();
        request.persistentSettings(Settings.builder().put(setting.getKey(), newValue.intValue()).build());
        OpenSearchResources.INSTANCE.getClient().admin().cluster().updateSettings(request);
    }

    public void updateSetting(Setting<String> setting, String newValue) {
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest();
        request.persistentSettings(Settings.builder().put(setting.getKey(), newValue).build());
        OpenSearchResources.INSTANCE.getClient().admin().cluster().updateSettings(request);
    }

    private void registerSettingUpdateListener() {
        for (Setting<Integer> setting : this.managedIntSettings) {
            OpenSearchResources.INSTANCE.getClusterService().getClusterSettings().addSettingsUpdateConsumer(setting, updatedVal -> this.callIntSettingListeners((Setting<Integer>)setting, (int)updatedVal));
        }
        for (Setting setting : this.managedStringSettings) {
            OpenSearchResources.INSTANCE.getClusterService().getClusterSettings().addSettingsUpdateConsumer(setting, updatedVal -> this.callStringSettingListeners((Setting<String>)setting, (String)updatedVal));
        }
    }

    private boolean clusterStatePresent() {
        try {
            ClusterState clusterState = OpenSearchResources.INSTANCE.getClusterService().state();
            return clusterState != null;
        }
        catch (AssertionError | Exception t) {
            LOG.error("Unable to retrieve cluster state: Exception: {}", (Object)((Throwable)t).getMessage());
            LOG.error(t);
            return false;
        }
    }

    private void readAllManagedClusterSettings() {
        LOG.debug("Trying to read initial cluster settings");
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.routingTable(false).nodes(false);
        OpenSearchResources.INSTANCE.getClient().admin().cluster().state(clusterStateRequest, (ActionListener)this.clusterSettingsResponseHandler);
    }

    private void registerClusterStateListener(ClusterStateListener clusterStateListener) {
        OpenSearchResources.INSTANCE.getClusterService().addListener(clusterStateListener);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state != null) {
            OpenSearchResources.INSTANCE.getClusterService().removeListener((ClusterStateListener)this);
            this.registerSettingUpdateListener();
            this.readAllManagedClusterSettings();
        }
    }

    private void callIntSettingListeners(Setting<Integer> setting, int settingValue) {
        try {
            List<ClusterSettingListener<Integer>> listeners = this.intSettingListenerMap.get(setting);
            if (listeners != null) {
                for (ClusterSettingListener<Integer> listener : listeners) {
                    listener.onSettingUpdate(settingValue);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    private void callStringSettingListeners(Setting<String> setting, String settingValue) {
        try {
            List<ClusterSettingListener<String>> listeners = this.stringSettingListenerMap.get(setting);
            if (listeners != null) {
                for (ClusterSettingListener<String> listener : listeners) {
                    listener.onSettingUpdate(settingValue);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    private class ClusterSettingsResponseHandler
    implements ActionListener<ClusterStateResponse> {
        private ClusterSettingsResponseHandler() {
        }

        public void onResponse(ClusterStateResponse clusterStateResponse) {
            Object settingValue;
            Settings clusterSettings = clusterStateResponse.getState().getMetadata().persistentSettings();
            for (Setting<Integer> setting : ClusterSettingsManager.this.managedIntSettings) {
                settingValue = clusterSettings.getAsInt(setting.getKey(), null);
                if (settingValue == null) continue;
                ClusterSettingsManager.this.callIntSettingListeners(setting, (Integer)settingValue);
            }
            for (Setting setting : ClusterSettingsManager.this.managedStringSettings) {
                settingValue = clusterSettings.get(setting.getKey(), "");
                if (settingValue == null) continue;
                ClusterSettingsManager.this.callStringSettingListeners((Setting<String>)setting, (String)settingValue);
            }
        }

        public void onFailure(Exception e) {
            LOG.error("Unable to read cluster settings. Exception: {}", (Object)e.getMessage());
            LOG.error((Object)e);
        }
    }
}

