/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.DefaultRedirectStrategy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RedirectStrategy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import reactor.core.publisher.Mono;

public final class RedirectPolicy
implements HttpPipelinePolicy {
    private final RedirectStrategy redirectStrategy;

    public RedirectPolicy() {
        this(new DefaultRedirectStrategy());
    }

    public RedirectPolicy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = Objects.requireNonNull(redirectStrategy, "'redirectStrategy' cannot be null.");
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.attemptRedirect(context, next, context.getHttpRequest(), 1, new HashSet<String>());
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.attemptRedirectSync(context, next, context.getHttpRequest(), 1, new HashSet<String>());
    }

    private Mono<HttpResponse> attemptRedirect(HttpPipelineCallContext context, HttpPipelineNextPolicy next, HttpRequest originalHttpRequest, int redirectAttempt, Set<String> attemptedRedirectUrls) {
        context.setHttpRequest(originalHttpRequest.copy());
        return next.clone().process().flatMap(httpResponse -> {
            if (this.redirectStrategy.shouldAttemptRedirect(context, (HttpResponse)httpResponse, redirectAttempt, attemptedRedirectUrls)) {
                HttpRequest redirectRequestCopy = this.createRedirectRequest((HttpResponse)httpResponse);
                return this.attemptRedirect(context, next, redirectRequestCopy, redirectAttempt + 1, attemptedRedirectUrls);
            }
            return Mono.just((Object)httpResponse);
        });
    }

    private HttpResponse attemptRedirectSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next, HttpRequest originalHttpRequest, int redirectAttempt, Set<String> attemptedRedirectUrls) {
        context.setHttpRequest(originalHttpRequest.copy());
        HttpResponse httpResponse = next.clone().processSync();
        if (this.redirectStrategy.shouldAttemptRedirect(context, httpResponse, redirectAttempt, attemptedRedirectUrls)) {
            HttpRequest redirectRequestCopy = this.createRedirectRequest(httpResponse);
            return this.attemptRedirectSync(context, next, redirectRequestCopy, redirectAttempt + 1, attemptedRedirectUrls);
        }
        return httpResponse;
    }

    private HttpRequest createRedirectRequest(HttpResponse redirectResponse) {
        redirectResponse.getRequest().getHeaders().remove(HttpHeaderName.AUTHORIZATION);
        HttpRequest redirectRequestCopy = this.redirectStrategy.createRedirectRequest(redirectResponse);
        redirectResponse.close();
        return redirectRequestCopy;
    }
}

