/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.actionlevel;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.selectivem.collections.CheckTable;
import com.selectivem.collections.CompactMapGroupBuilder;
import com.selectivem.collections.DeduplicatingCompactSubSetBuilder;
import com.selectivem.collections.ImmutableCompactSubSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.security.privileges.ClusterStateMetadataDependentPrivileges;
import org.opensearch.security.privileges.IndexPattern;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.actionlevel.RuntimeOptimizedActionPrivileges;
import org.opensearch.security.privileges.actionlevel.WellKnownActions;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.WildcardMatcher;

public class RoleBasedActionPrivileges
extends RuntimeOptimizedActionPrivileges {
    public static Setting<ByteSizeValue> PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE = Setting.memorySizeSetting((String)"plugins.security.privileges_evaluation.precomputed_privileges.max_heap_size", (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static Setting<Boolean> PRECOMPUTED_PRIVILEGES_ENABLED = Setting.boolSetting((String)"plugins.security.privileges_evaluation.precomputed_privileges.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger log = LogManager.getLogger(RoleBasedActionPrivileges.class);
    private final SecurityDynamicConfiguration<RoleV7> roles;
    private final FlattenedActionGroups actionGroups;
    private final ByteSizeValue statefulIndexMaxHeapSize;
    private final boolean statefulIndexEnabled;
    private final AtomicReference<StatefulIndexPrivileges> statefulIndex = new AtomicReference();
    final ClusterStateMetadataDependentPrivileges clusterStateMetadataDependentPrivileges = new ClusterStateMetadataDependentPrivileges(){

        @Override
        protected void updateClusterStateMetadata(Metadata metadata) {
            RoleBasedActionPrivileges.this.updateStatefulIndexPrivileges(metadata.getIndicesLookup(), metadata.version());
        }

        @Override
        protected long getCurrentlyUsedMetadataVersion() {
            StatefulIndexPrivileges statefulIndex = RoleBasedActionPrivileges.this.statefulIndex.get();
            return statefulIndex != null ? statefulIndex.metadataVersion : 0L;
        }
    };

    public RoleBasedActionPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, Settings settings) {
        super(new ClusterPrivileges(roles, actionGroups), new IndexPrivileges(roles, actionGroups));
        this.roles = roles;
        this.actionGroups = actionGroups;
        this.statefulIndexMaxHeapSize = (ByteSizeValue)PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE.get(settings);
        this.statefulIndexEnabled = (Boolean)PRECOMPUTED_PRIVILEGES_ENABLED.get(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatefulIndexPrivileges(Map<String, IndexAbstraction> indices, long metadataVersion) {
        if (!this.statefulIndexEnabled) {
            return;
        }
        StatefulIndexPrivileges statefulIndex = this.statefulIndex.get();
        indices = StatefulIndexPrivileges.relevantOnly(indices);
        if (statefulIndex == null || !statefulIndex.indices.equals(indices)) {
            long start = System.currentTimeMillis();
            this.statefulIndex.set(new StatefulIndexPrivileges(this.roles, this.actionGroups, indices, metadataVersion, this.statefulIndexMaxHeapSize));
            long duration = System.currentTimeMillis() - start;
            log.debug("Updating StatefulIndexPrivileges took {} ms", (Object)duration);
        } else {
            RoleBasedActionPrivileges roleBasedActionPrivileges = this;
            synchronized (roleBasedActionPrivileges) {
                if (statefulIndex.metadataVersion < metadataVersion) {
                    statefulIndex.metadataVersion = metadataVersion;
                }
            }
        }
    }

    int getEstimatedStatefulIndexByteSize() {
        StatefulIndexPrivileges statefulIndex = this.statefulIndex.get();
        if (statefulIndex != null) {
            return statefulIndex.estimatedByteSize;
        }
        return 0;
    }

    @Override
    protected RuntimeOptimizedActionPrivileges.StatefulIndexPrivileges currentStatefulIndexPrivileges() {
        return this.statefulIndex.get();
    }

    public ClusterStateMetadataDependentPrivileges clusterStateMetadataDependentPrivileges() {
        return this.clusterStateMetadataDependentPrivileges;
    }

    public FlattenedActionGroups flattenedActionGroups() {
        return this.actionGroups;
    }

    static class ClusterPrivileges
    extends RuntimeOptimizedActionPrivileges.ClusterPrivileges {
        private final ImmutableMap<String, ImmutableCompactSubSet<String>> actionToRoles;
        private final ImmutableSet<String> rolesWithWildcardPermissions;
        private final ImmutableMap<String, WildcardMatcher> rolesToActionMatcher;

        ClusterPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups) {
            DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(roles.getCEntries().keySet());
            HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder> actionToRoles = new HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder>();
            ImmutableSet.Builder rolesWithWildcardPermissions = ImmutableSet.builder();
            ImmutableMap.Builder rolesToActionMatcher = ImmutableMap.builder();
            for (Map.Entry<String, RoleV7> entry2 : roles.getCEntries().entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    roleSetBuilder.next((Object)roleName);
                    ImmutableSet<String> permissionPatterns = actionGroups.resolve(role.getCluster_permissions());
                    ArrayList<WildcardMatcher> wildcardMatchers = new ArrayList<WildcardMatcher>();
                    for (String permission : permissionPatterns) {
                        if (WildcardMatcher.isExact(permission)) {
                            actionToRoles.computeIfAbsent(permission, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                            continue;
                        }
                        if (permission.equals("*")) {
                            rolesWithWildcardPermissions.add((Object)roleName);
                            continue;
                        }
                        WildcardMatcher wildcardMatcher = WildcardMatcher.from(permission);
                        Set matchedActions = wildcardMatcher.getMatchAny((Collection<String>)WellKnownActions.CLUSTER_ACTIONS, Collectors.toUnmodifiableSet());
                        for (String action : matchedActions) {
                            actionToRoles.computeIfAbsent(action, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                        }
                        wildcardMatchers.add(wildcardMatcher);
                    }
                    if (wildcardMatchers.isEmpty()) continue;
                    rolesToActionMatcher.put((Object)roleName, (Object)WildcardMatcher.from(wildcardMatchers));
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry2.getKey(), (Object)e);
                }
            }
            DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
            this.actionToRoles = (ImmutableMap)actionToRoles.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)entry.getValue()).build(completedRoleSetBuilder)));
            this.rolesWithWildcardPermissions = rolesWithWildcardPermissions.build();
            this.rolesToActionMatcher = rolesToActionMatcher.build();
        }

        @Override
        protected boolean checkWildcardPrivilege(PrivilegesEvaluationContext context) {
            return CollectionUtils.containsAny(context.getMappedRoles(), this.rolesWithWildcardPermissions);
        }

        @Override
        protected boolean checkPrivilegeForWellKnownAction(PrivilegesEvaluationContext context, String action) {
            ImmutableCompactSubSet rolesWithPrivileges = (ImmutableCompactSubSet)this.actionToRoles.get((Object)action);
            return rolesWithPrivileges != null && rolesWithPrivileges.containsAny(context.getMappedRoles());
        }

        @Override
        protected boolean checkPrivilegeViaActionMatcher(PrivilegesEvaluationContext context, String action) {
            if (!WellKnownActions.CLUSTER_ACTIONS.contains((Object)action)) {
                for (String role : context.getMappedRoles()) {
                    WildcardMatcher matcher = (WildcardMatcher)this.rolesToActionMatcher.get((Object)role);
                    if (matcher == null || !matcher.test(action)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class IndexPrivileges
    extends RuntimeOptimizedActionPrivileges.StaticIndexPrivileges {
        private final ImmutableMap<String, ImmutableMap<String, IndexPattern>> rolesToActionToIndexPattern;
        private final ImmutableMap<String, ImmutableMap<WildcardMatcher, IndexPattern>> rolesToActionPatternToIndexPattern;
        private final ImmutableMap<String, ImmutableCompactSubSet<String>> actionToRolesWithWildcardIndexPrivileges;
        private final ImmutableMap<String, ImmutableMap<String, IndexPattern>> rolesToExplicitActionToIndexPattern;

        IndexPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups) {
            HashMap<String, Map> rolesToActionToIndexPattern = new HashMap<String, Map>();
            HashMap<String, Map> rolesToActionPatternToIndexPattern = new HashMap<String, Map>();
            HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder> actionToRolesWithWildcardIndexPrivileges = new HashMap<String, DeduplicatingCompactSubSetBuilder.SubSetBuilder>();
            HashMap<String, Map> rolesToExplicitActionToIndexPattern = new HashMap<String, Map>();
            Map<String, RoleV7> permissionEntries = roles.getCEntries();
            DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(permissionEntries.keySet());
            for (Map.Entry<String, RoleV7> entry2 : permissionEntries.entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    roleSetBuilder.next((Object)roleName);
                    for (RoleV7.Index indexPermissions : role.getIndex_permissions()) {
                        ImmutableSet<String> permissions = actionGroups.resolve(indexPermissions.getAllowed_actions());
                        for (String permission : permissions) {
                            if (WildcardMatcher.isExact(permission)) {
                                rolesToActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(permission, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                                if (WellKnownActions.EXPLICITLY_REQUIRED_INDEX_ACTIONS.contains((Object)permission)) {
                                    rolesToExplicitActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(permission, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                                }
                                if (!indexPermissions.getIndex_patterns().contains("*")) continue;
                                actionToRolesWithWildcardIndexPrivileges.computeIfAbsent(permission, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                                continue;
                            }
                            WildcardMatcher actionMatcher = WildcardMatcher.from(permission);
                            for (String action : actionMatcher.iterateMatching((Iterable<String>)WellKnownActions.INDEX_ACTIONS)) {
                                rolesToActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(action, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                                if (!indexPermissions.getIndex_patterns().contains("*")) continue;
                                actionToRolesWithWildcardIndexPrivileges.computeIfAbsent(permission, k -> roleSetBuilder.createSubSetBuilder()).add((Object)roleName);
                            }
                            rolesToActionPatternToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(actionMatcher, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                            if (actionMatcher == WildcardMatcher.ANY) continue;
                            for (String action : actionMatcher.iterateMatching((Iterable<String>)WellKnownActions.EXPLICITLY_REQUIRED_INDEX_ACTIONS)) {
                                rolesToExplicitActionToIndexPattern.computeIfAbsent(roleName, k -> new HashMap()).computeIfAbsent(action, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry2.getKey(), (Object)e);
                }
            }
            DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
            this.rolesToActionToIndexPattern = (ImmutableMap)rolesToActionToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableMap)((Map)entry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry2 -> ((IndexPattern.Builder)entry2.getValue()).build()))));
            this.rolesToActionPatternToIndexPattern = (ImmutableMap)rolesToActionPatternToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableMap)((Map)entry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry2 -> ((IndexPattern.Builder)entry2.getValue()).build()))));
            this.actionToRolesWithWildcardIndexPrivileges = (ImmutableMap)actionToRolesWithWildcardIndexPrivileges.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)entry.getValue()).build(completedRoleSetBuilder)));
            this.rolesToExplicitActionToIndexPattern = (ImmutableMap)rolesToExplicitActionToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableMap)((Map)entry.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry2 -> ((IndexPattern.Builder)entry2.getValue()).build()))));
        }

        @Override
        protected PrivilegesEvaluatorResponse providesPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices, CheckTable<String, String> checkTable) {
            ArrayList<PrivilegesEvaluationException> exceptions = new ArrayList<PrivilegesEvaluationException>();
            for (String role : context.getMappedRoles()) {
                ImmutableMap actionToIndexPattern = (ImmutableMap)this.rolesToActionToIndexPattern.get((Object)role);
                if (actionToIndexPattern == null) continue;
                this.checkPrivilegeWithIndexPatternOnWellKnownActions(context, actions, checkTable, (ImmutableMap<String, IndexPattern>)actionToIndexPattern, exceptions);
                if (!checkTable.isComplete()) continue;
                return PrivilegesEvaluatorResponse.ok();
            }
            if (!checkTable.isComplete() && !WellKnownActions.allWellKnownIndexActions(actions)) {
                for (String role : context.getMappedRoles()) {
                    ImmutableMap actionPatternToIndexPattern = (ImmutableMap)this.rolesToActionPatternToIndexPattern.get((Object)role);
                    if (actionPatternToIndexPattern == null) continue;
                    this.checkPrivilegesForNonWellKnownActions(context, actions, checkTable, (ImmutableMap<WildcardMatcher, IndexPattern>)actionPatternToIndexPattern, exceptions);
                    if (!checkTable.isComplete()) continue;
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            return this.responseForIncompletePrivileges(context, resolvedIndices, checkTable, exceptions);
        }

        @Override
        protected PrivilegesEvaluatorResponse checkWildcardIndexPrivilegesOnWellKnownActions(PrivilegesEvaluationContext context, Set<String> actions) {
            ImmutableSet<String> effectiveRoles = context.getMappedRoles();
            for (String action : actions) {
                ImmutableCompactSubSet rolesWithWildcardIndexPrivileges = (ImmutableCompactSubSet)this.actionToRolesWithWildcardIndexPrivileges.get((Object)action);
                if (rolesWithWildcardIndexPrivileges != null && rolesWithWildcardIndexPrivileges.containsAny(effectiveRoles)) continue;
                return null;
            }
            return PrivilegesEvaluatorResponse.ok();
        }

        @Override
        protected PrivilegesEvaluatorResponse providesExplicitPrivilege(PrivilegesEvaluationContext context, Set<String> actions, CheckTable<String, String> checkTable) {
            Map<String, IndexAbstraction> indexMetadata = context.getIndicesLookup();
            ArrayList<PrivilegesEvaluationException> exceptions = new ArrayList<PrivilegesEvaluationException>();
            for (String role : context.getMappedRoles()) {
                ImmutableMap actionToIndexPattern = (ImmutableMap)this.rolesToExplicitActionToIndexPattern.get((Object)role);
                if (actionToIndexPattern == null) continue;
                for (String action : actions) {
                    IndexPattern indexPattern = (IndexPattern)actionToIndexPattern.get((Object)action);
                    if (indexPattern == null) continue;
                    for (String index : checkTable.iterateUncheckedRows((Object)action)) {
                        try {
                            if (!indexPattern.matches(index, context, indexMetadata) || !checkTable.check((Object)index, (Object)action)) continue;
                            return PrivilegesEvaluatorResponse.ok();
                        }
                        catch (PrivilegesEvaluationException e) {
                            log.error("Error while evaluating index pattern of role {}. Ignoring entry", (Object)role, (Object)e);
                            exceptions.add(new PrivilegesEvaluationException("Error while evaluating role " + role, e));
                        }
                    }
                }
            }
            return PrivilegesEvaluatorResponse.insufficient(checkTable).reason("No explicit privileges have been provided for the referenced indices.").evaluationExceptions(exceptions);
        }
    }

    static class StatefulIndexPrivileges
    extends RuntimeOptimizedActionPrivileges.StatefulIndexPrivileges {
        private final Map<String, Map<String, ImmutableCompactSubSet<String>>> actionToIndexToRoles;
        private final Map<String, IndexAbstraction> indices;
        private final int estimatedByteSize;
        private long metadataVersion;

        StatefulIndexPrivileges(SecurityDynamicConfiguration<RoleV7> roles, FlattenedActionGroups actionGroups, Map<String, IndexAbstraction> indices, long metadataVersion, ByteSizeValue statefulIndexMaxHeapSize) {
            long startTime = System.currentTimeMillis();
            HashMap<String, CompactMapGroupBuilder.MapBuilder> actionToIndexToRoles = new HashMap<String, CompactMapGroupBuilder.MapBuilder>();
            DeduplicatingCompactSubSetBuilder roleSetBuilder = new DeduplicatingCompactSubSetBuilder(roles.getCEntries().keySet());
            CompactMapGroupBuilder indexMapBuilder = new CompactMapGroupBuilder(indices.keySet(), k2 -> roleSetBuilder.createSubSetBuilder());
            block2: for (Map.Entry<String, RoleV7> entry2 : roles.getCEntries().entrySet()) {
                try {
                    String roleName = entry2.getKey();
                    RoleV7 role = entry2.getValue();
                    roleSetBuilder.next((Object)roleName);
                    for (RoleV7.Index indexPermissions : role.getIndex_permissions()) {
                        List<IndexAbstraction> matchingIndices;
                        WildcardMatcher indexMatcher;
                        ImmutableSet<String> permissions = actionGroups.resolve(indexPermissions.getAllowed_actions());
                        if (indexPermissions.getIndex_patterns().contains("*") || (indexMatcher = IndexPattern.from(indexPermissions.getIndex_patterns()).getStaticPattern()) == WildcardMatcher.NONE || (matchingIndices = indexMatcher.matching(indices.values(), IndexAbstraction::getName)).isEmpty()) continue;
                        for (String permission : permissions) {
                            WildcardMatcher actionMatcher = WildcardMatcher.from(permission);
                            List matchedActions = actionMatcher.getMatchAny((Collection<String>)WellKnownActions.INDEX_ACTIONS, Collectors.toList());
                            for (IndexAbstraction index : matchingIndices) {
                                for (String action : matchedActions) {
                                    CompactMapGroupBuilder.MapBuilder indexToRoles = actionToIndexToRoles.computeIfAbsent(action, k -> indexMapBuilder.createMapBuilder());
                                    ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoles.get((Object)index.getName())).add((Object)roleName);
                                    if (index instanceof IndexAbstraction.Alias) {
                                        for (IndexMetadata subIndex : index.getIndices()) {
                                            String subIndexName = subIndex.getIndex().getName();
                                            if (indices.containsKey(subIndexName)) {
                                                ((DeduplicatingCompactSubSetBuilder.SubSetBuilder)indexToRoles.get((Object)subIndexName)).add((Object)roleName);
                                                continue;
                                            }
                                            log.debug("Ignoring member index {} of alias {}. This is usually the case because the index is closed or a data stream backing index.", (Object)subIndexName, (Object)index.getName());
                                        }
                                    }
                                    if ((long)(roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize()) <= statefulIndexMaxHeapSize.getBytes()) continue;
                                    log.info("Size of precomputed index privileges exceeds configured limit ({}). Using capped data structure.This might lead to slightly lower performance during privilege evaluation. Consider raising {}.", (Object)statefulIndexMaxHeapSize, (Object)PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE.getKey());
                                    break block2;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Unexpected exception while processing role: {}\nIgnoring role.", (Object)entry2.getKey(), (Object)e);
                }
            }
            DeduplicatingCompactSubSetBuilder.Completed completedRoleSetBuilder = roleSetBuilder.build();
            this.estimatedByteSize = roleSetBuilder.getEstimatedByteSize() + indexMapBuilder.getEstimatedByteSize();
            log.debug("Estimated size of StatefulIndexPermissions data structure: {}", (Object)this.estimatedByteSize);
            this.actionToIndexToRoles = (Map)actionToIndexToRoles.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((CompactMapGroupBuilder.MapBuilder)entry.getValue()).build(subSetBuilder -> subSetBuilder.build(completedRoleSetBuilder))));
            this.indices = ImmutableMap.copyOf(indices);
            this.metadataVersion = metadataVersion;
            long duration = System.currentTimeMillis() - startTime;
            if (duration > 30000L) {
                log.warn("Creation of StatefulIndexPrivileges took {} ms", (Object)duration);
            } else {
                log.debug("Creation of StatefulIndexPrivileges took {} ms", (Object)duration);
            }
        }

        @Override
        protected PrivilegesEvaluatorResponse providesPrivilege(Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices, PrivilegesEvaluationContext context, CheckTable<String, String> checkTable) {
            Map<String, IndexAbstraction> indexMetadata = context.getIndicesLookup();
            ImmutableSet<String> effectiveRoles = context.getMappedRoles();
            for (String action : actions) {
                Map<String, ImmutableCompactSubSet<String>> indexToRoles = this.actionToIndexToRoles.get(action);
                if (indexToRoles == null) continue;
                Iterator<String> iterator = resolvedIndices.getAllIndices().iterator();
                while (iterator.hasNext()) {
                    ImmutableCompactSubSet<String> rolesWithPrivileges;
                    String index;
                    String lookupIndex = index = iterator.next();
                    if (index.startsWith(".ds-")) {
                        lookupIndex = StatefulIndexPrivileges.backingIndexToDataStream(index, indexMetadata);
                    }
                    if ((rolesWithPrivileges = indexToRoles.get(lookupIndex)) == null || !rolesWithPrivileges.containsAny(effectiveRoles) || !checkTable.check((Object)index, (Object)action)) continue;
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            return null;
        }

        static String backingIndexToDataStream(String index, Map<String, IndexAbstraction> indexMetadata) {
            IndexAbstraction indexAbstraction = indexMetadata.get(index);
            if (indexAbstraction instanceof IndexAbstraction.Index && indexAbstraction.getParentDataStream() != null) {
                return indexAbstraction.getParentDataStream().getName();
            }
            return index;
        }

        static Map<String, IndexAbstraction> relevantOnly(Map<String, IndexAbstraction> indices) {
            boolean doFilter = false;
            for (IndexAbstraction indexAbstraction : indices.values()) {
                if (!(indexAbstraction instanceof IndexAbstraction.Index) || indexAbstraction.getParentDataStream() == null && indexAbstraction.getWriteIndex().getState() != IndexMetadata.State.CLOSE) continue;
                doFilter = true;
                break;
            }
            if (!doFilter) {
                return indices;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (IndexAbstraction indexAbstraction : indices.values()) {
                if (indexAbstraction instanceof IndexAbstraction.Index) {
                    if (indexAbstraction.getParentDataStream() != null || indexAbstraction.getWriteIndex().getState() == IndexMetadata.State.CLOSE) continue;
                    builder.put((Object)indexAbstraction.getName(), (Object)indexAbstraction);
                    continue;
                }
                builder.put((Object)indexAbstraction.getName(), (Object)indexAbstraction);
            }
            return builder.build();
        }
    }
}

