/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.user;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.security.user.User;

public abstract class UserFactory {
    public abstract User fromSerializedBase64(String var1);

    public static class Caching
    extends UserFactory {
        public static Setting<ByteSizeValue> MAX_SIZE = Setting.memorySizeSetting((String)"plugins.security.transport_user_cache.max_heap_size", (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static Setting<TimeValue> EXPIRE_AFTER_ACCESS = Setting.timeSetting((String)"plugins.security.transport_user_cache.expire_after_access", (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        private final Cache<String, User> serializedBase64ToUserCache;

        public Caching(Settings settings) {
            this.serializedBase64ToUserCache = CacheBuilder.newBuilder().weigher((key, user) -> 16 + key.length() + user.estimatedByteSize()).maximumWeight(((ByteSizeValue)MAX_SIZE.get(settings)).getBytes()).expireAfterAccess(Duration.ofMillis(((TimeValue)EXPIRE_AFTER_ACCESS.get(settings)).millis())).build();
        }

        @Override
        public User fromSerializedBase64(String serializedBase64) {
            try {
                return (User)this.serializedBase64ToUserCache.get((Object)serializedBase64, () -> User.fromSerializedBase64(serializedBase64));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public static class Simple
    extends UserFactory {
        @Override
        public User fromSerializedBase64(String serializedBase64) {
            return User.fromSerializedBase64(serializedBase64);
        }
    }
}

