/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.handler.AbstractSearchEntryHandler;

public class RangeEntryHandler
extends AbstractSearchEntryHandler {
    private static final int HASH_CODE_SEED = 839;
    private static final String END_OF_RANGE = "*";
    private static final String RANGE_FORMAT = "%1$s;Range=%2$s-%3$s";
    private static final String RANGE_PATTERN_STRING = "^(.*?);Range=([\\d\\*]+)-([\\d\\*]+)";
    private static final Pattern RANGE_PATTERN = Pattern.compile("^(.*?);Range=([\\d\\*]+)-([\\d\\*]+)", 2);

    @Override
    protected void handleAttributes(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        HashMap<LdapAttribute, Matcher> matchingAttrs = new HashMap<LdapAttribute, Matcher>();
        for (LdapAttribute ldapAttribute : entry.getAttributes()) {
            Matcher matcher = RANGE_PATTERN.matcher(ldapAttribute.getName());
            if (!matcher.find()) continue;
            matchingAttrs.put(ldapAttribute, matcher);
        }
        for (Map.Entry entry2 : matchingAttrs.entrySet()) {
            LdapAttribute la = (LdapAttribute)entry2.getKey();
            Matcher matcher = (Matcher)entry2.getValue();
            String msg = String.format("attribute '%s' entry '%s'", la.getName(), entry.getDn());
            String attrTypeName = matcher.group(1);
            this.logger.debug("Found Range option {}", (Object)msg);
            if (attrTypeName == null || attrTypeName.isEmpty()) {
                this.logger.error("Unable to determine the attribute type name for {}", (Object)msg);
                throw new IllegalArgumentException("Unable to determine the attribute type name for " + msg);
            }
            LdapAttribute newAttr = entry.getAttribute(attrTypeName);
            if (newAttr == null) {
                newAttr = new LdapAttribute(la.getSortBehavior(), la.isBinary());
                newAttr.setName(attrTypeName);
                entry.addAttribute(newAttr);
            }
            if (la.isBinary()) {
                newAttr.addBinaryValues(la.getBinaryValues());
            } else {
                newAttr.addStringValues(la.getStringValues());
            }
            entry.removeAttribute(la);
            if (la.getName().endsWith(END_OF_RANGE)) continue;
            int start = Integer.parseInt(matcher.group(2));
            int end = Integer.parseInt(matcher.group(3));
            int diff = end - start;
            String nextAttrID = String.format(RANGE_FORMAT, attrTypeName, end + 1, end + diff + 1);
            this.logger.debug("Searching for '{}' to increment {}", (Object)nextAttrID, (Object)msg);
            SearchOperation search = new SearchOperation(conn);
            SearchRequest sr = SearchRequest.newObjectScopeSearchRequest(entry.getDn(), new String[]{nextAttrID});
            SearchResult result = (SearchResult)search.execute(sr).getResult();
            entry.addAttributes(result.getEntry().getAttributes());
            this.handleAttributes(conn, request, entry);
        }
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(839, null);
    }
}

