/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class PSystemDitaaFactory
extends PSystemBasicFactory<PSystemDitaa> {
    private static final Pattern SCALE = Pattern.compile("scale=([\\d.]+)");

    public PSystemDitaaFactory() {
        super(DiagramType.DITAA);
    }

    @Override
    public PSystemDitaa initDiagram(UmlSource source, String startLine, PreprocessingArtifact preprocessing) {
        boolean performSeparationOfCommonEdges = true;
        if (startLine != null && (startLine.contains("-E") || startLine.contains("--no-separation"))) {
            performSeparationOfCommonEdges = false;
        }
        boolean dropShadows = true;
        if (startLine != null && (startLine.contains("-S") || startLine.contains("--no-shadows"))) {
            dropShadows = false;
        }
        boolean allCornersAreRound = false;
        if (startLine != null && (startLine.contains("-r") || startLine.contains("--round-corners"))) {
            allCornersAreRound = true;
        }
        boolean transparentBackground = false;
        if (startLine != null && (startLine.contains("-T") || startLine.contains("--transparent"))) {
            transparentBackground = true;
        }
        float scale = this.extractScale(startLine);
        return new PSystemDitaa(source, performSeparationOfCommonEdges, dropShadows, allCornersAreRound, transparentBackground, scale, preprocessing);
    }

    @Override
    public PSystemDitaa executeLine(UmlSource source, PSystemDitaa system, String line, PreprocessingArtifact preprocessing) {
        if (system == null && (line.equals("ditaa") || line.startsWith("ditaa("))) {
            boolean performSeparationOfCommonEdges = true;
            if (line.contains("-E") || line.contains("--no-separation")) {
                performSeparationOfCommonEdges = false;
            }
            boolean dropShadows = true;
            if (line.contains("-S") || line.contains("--no-shadows")) {
                dropShadows = false;
            }
            boolean allCornersAreRound = false;
            if (line.contains("-r") || line.contains("--round-corners")) {
                allCornersAreRound = true;
            }
            boolean transparentBackground = false;
            if (line.contains("-T") || line.contains("--transparent")) {
                transparentBackground = true;
            }
            float scale = this.extractScale(line);
            return new PSystemDitaa(source, performSeparationOfCommonEdges, dropShadows, allCornersAreRound, transparentBackground, scale, preprocessing);
        }
        if (system == null) {
            return null;
        }
        system.add(line);
        return system;
    }

    private float extractScale(String line) {
        if (line == null) {
            return 1.0f;
        }
        Matcher m = SCALE.matcher(line);
        if (m.find()) {
            String number = m.group(1);
            return Float.parseFloat(number);
        }
        return 1.0f;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return null;
    }
}

