/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.AbstractSelfLoopRouter;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.LabelPlacer;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.OrthogonalSelfLoopRouter;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.PolylineSelfLoopRouter;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.RoutingDirector;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.RoutingSlotAssigner;
import org.eclipse.elk.alg.layered.intermediate.loops.routing.SplineSelfLoopRouter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SelfLoopRouter
implements ILayoutProcessor<LGraph> {
    private final RoutingDirector routingDirector = new RoutingDirector();
    private final LabelPlacer labelPlacer = new LabelPlacer();
    private final RoutingSlotAssigner routingSlotAssigner = new RoutingSlotAssigner();

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Self-Loop routing", 1.0f);
        AbstractSelfLoopRouter router = this.routerForGraph(graph);
        ILabelManager labelManager = graph.getProperty(LabelManagementOptions.LABEL_MANAGER);
        graph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(lNode -> lNode.getType() == LNode.NodeType.NORMAL).filter(lNode -> lNode.hasProperty(InternalProperties.SELF_LOOP_HOLDER)).map(lNode -> lNode.getProperty(InternalProperties.SELF_LOOP_HOLDER)).forEach(slHolder -> this.processNode((SelfLoopHolder)slHolder, labelManager, router, progressMonitor));
        progressMonitor.done();
    }

    private AbstractSelfLoopRouter routerForGraph(LGraph graph) {
        switch (graph.getProperty(LayeredOptions.EDGE_ROUTING)) {
            case POLYLINE: {
                return new PolylineSelfLoopRouter();
            }
            case SPLINES: {
                return new SplineSelfLoopRouter();
            }
        }
        return new OrthogonalSelfLoopRouter();
    }

    private void processNode(SelfLoopHolder slHolder, ILabelManager labelManager, AbstractSelfLoopRouter slRouter, IElkProgressMonitor monitor) {
        this.routingDirector.determineLoopRoutes(slHolder);
        this.labelPlacer.placeLabels(slHolder, labelManager, monitor);
        this.routingSlotAssigner.assignRoutingSlots(slHolder);
        slRouter.routeSelfLoops(slHolder);
    }
}

