/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.EntityType;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.ClassType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TypeParameterDeclaration;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class TypeDeclaration
extends EntityDeclaration {
    private ClassType _classType;
    public static final TypeDeclaration NULL = new NullTypeDeclaration();

    public final JavaTokenNode getTypeKeyword() {
        switch (this._classType) {
            case CLASS: {
                return this.getChildByRole(Roles.CLASS_KEYWORD);
            }
            case INTERFACE: {
                return this.getChildByRole(Roles.INTERFACE_KEYWORD);
            }
            case ANNOTATION: {
                return this.getChildByRole(Roles.ANNOTATION_KEYWORD);
            }
            case ENUM: {
                return this.getChildByRole(Roles.ENUM_KEYWORD);
            }
        }
        return JavaTokenNode.NULL;
    }

    public final ClassType getClassType() {
        return this._classType;
    }

    public final void setClassType(ClassType classType) {
        this.verifyNotFrozen();
        this._classType = classType;
    }

    public final AstNodeCollection<TypeParameterDeclaration> getTypeParameters() {
        return this.getChildrenByRole(Roles.TYPE_PARAMETER);
    }

    public final AstNodeCollection<AstType> getInterfaces() {
        return this.getChildrenByRole(Roles.IMPLEMENTED_INTERFACE);
    }

    public final boolean isSealed() {
        return !this.getPermittedSubclasses().isEmpty();
    }

    public final AstNodeCollection<AstType> getPermittedSubclasses() {
        return this.getChildrenByRole(Roles.PERMITTED_SUBCLASSES);
    }

    public final AstType getBaseType() {
        return this.getChildByRole(Roles.BASE_TYPE);
    }

    public final void setBaseType(AstType value) {
        this.setChildByRole(Roles.BASE_TYPE, value);
    }

    public final JavaTokenNode getLeftBraceToken() {
        return this.getChildByRole(Roles.LEFT_BRACE);
    }

    public final AstNodeCollection<EntityDeclaration> getMembers() {
        return this.getChildrenByRole(Roles.TYPE_MEMBER);
    }

    public final JavaTokenNode getRightBraceToken() {
        return this.getChildByRole(Roles.RIGHT_BRACE);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.TYPE_DECLARATION;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.TYPE_DEFINITION;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitTypeDeclaration(this, data);
    }

    @Override
    public TypeDeclaration clone() {
        TypeDeclaration copy = (TypeDeclaration)super.clone();
        copy._classType = this._classType;
        return copy;
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof TypeDeclaration) {
            TypeDeclaration otherDeclaration = (TypeDeclaration)other;
            return !otherDeclaration.isNull() && this._classType == otherDeclaration._classType && TypeDeclaration.matchString(this.getName(), otherDeclaration.getName()) && this.matchAnnotationsAndModifiers(otherDeclaration, match) && this.getTypeParameters().matches(otherDeclaration.getTypeParameters(), match) && this.getBaseType().matches(otherDeclaration.getBaseType(), match) && this.getInterfaces().matches(otherDeclaration.getInterfaces(), match) && this.getMembers().matches(otherDeclaration.getMembers(), match);
        }
        return false;
    }

    private static final class NullTypeDeclaration
    extends TypeDeclaration {
        private NullTypeDeclaration() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

