/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.list;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OWLAxiomList
extends MList {
    private static final long serialVersionUID = 2024889684812090240L;
    private OWLOntologyManager manager;
    private OWLEditorKit editorKit;

    public OWLAxiomList(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.manager = editorKit.getModelManager().getOWLOntologyManager();
        this.setCellRenderer(new AxiomListItemRenderer());
    }

    public void setAxioms(Set<Set<OWLAxiom>> axiomSet, Set<OWLOntology> ontologies) {
        ArrayList<Object> items = new ArrayList<Object>();
        int count = 1;
        for (Set<OWLAxiom> axioms : axiomSet) {
            items.add("Explanation " + count + ": ");
            ++count;
            for (OWLAxiom ax : axioms) {
                for (OWLOntology ont : ontologies) {
                    if (!ont.containsAxiom(ax)) continue;
                    items.add(new AxiomListItem(ax, ont));
                }
            }
        }
        this.setListData(items.toArray());
        this.setFixedCellHeight(24);
    }

    protected void handleDelete() {
        super.handleDelete();
    }

    protected Border createPaddingBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof AxiomListItem) {
            return BorderFactory.createMatteBorder(1, 20, 1, 1, list.getBackground());
        }
        return super.createPaddingBorder(list, value, index, isSelected, cellHasFocus);
    }

    private class AxiomListItemRenderer
    implements ListCellRenderer {
        private OWLCellRenderer ren;

        public AxiomListItemRenderer() {
            this.ren = new OWLCellRenderer(OWLAxiomList.this.editorKit);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof AxiomListItem) {
                AxiomListItem item = (AxiomListItem)value;
                this.ren.setOntology(item.ontology);
                this.ren.setHighlightKeywords(true);
                this.ren.setWrap(false);
                return this.ren.getListCellRendererComponent(list, item.axiom, index, isSelected, cellHasFocus);
            }
            return this.ren.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private class AxiomListItem
    implements MListItem {
        private OWLAxiom axiom;
        private OWLOntology ontology;

        public AxiomListItem(OWLAxiom axiom, OWLOntology ontology) {
            this.axiom = axiom;
            this.ontology = ontology;
        }

        public boolean isEditable() {
            return false;
        }

        public void handleEdit() {
        }

        public boolean isDeleteable() {
            return this.ontology.containsAxiom(this.axiom);
        }

        public boolean handleDelete() {
            try {
                OWLAxiomList.this.manager.applyChange((OWLOntologyChange)new RemoveAxiom(this.ontology, this.axiom));
                return true;
            }
            catch (OWLOntologyChangeException e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }

        public String getTooltip() {
            if (this.ontology.containsAxiom(this.axiom)) {
                return "Asserted in " + String.valueOf(this.ontology.getOntologyID());
            }
            return "Deleted.  (Was asserted in " + String.valueOf(this.ontology.getOntologyID()) + ")";
        }
    }
}

