/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;

public abstract class OWLPropertyIcon
extends OWLEntityIcon {
    public static final BasicStroke HOLLOW_STROKE = new BasicStroke(2.0f);
    private Color iconColor;

    public OWLPropertyIcon(Color iconColor, OWLEntityIcon.FillType fillType) {
        super(fillType);
        this.iconColor = iconColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int iconHeight = this.getBaseSize();
            int propWidth = this.getIconWidth();
            int propHeight = 8;
            int xPadding = (this.getIconWidth() - propWidth) / 2;
            int yPadding = (this.getIconHeight() - propHeight) / 2;
            int rX = x + xPadding;
            int rY = y + yPadding;
            if (this.getFillType() == OWLEntityIcon.FillType.FILLED) {
                g2.setColor(this.getBorderColor());
                g2.fillRect(rX, rY, propWidth, propHeight);
                g2.setColor(this.getColor());
                g2.fillRect(rX + 1, rY + 1, propWidth - 2, propHeight - 2);
            } else {
                g2.setStroke(HOLLOW_STROKE);
                g2.setColor(this.getColor());
                g2.drawRect(rX + 1, rY + 1, propWidth - 2, propHeight - 2);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

