/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.annotation.Size;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000  2\u00020\u0001:\u0002\u001f B;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u000eJ \u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0007J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0019\u001a\u00020\nH\u0017J\u0017\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00020\b\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector;", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "transformSource", "transformDestination", "renderIntent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "transform", "", "<init>", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I[FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "intent", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getSource", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getDestination", "getRenderIntent-uksYyKA", "()I", "I", "r", "", "g", "b", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "color", "transformToColor-l2rxGTc$ui_graphics", "(J)J", "RgbConnector", "Companion", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector\n+ 2 Color.kt\nandroidx/compose/ui/graphics/Color\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,328:1\n219#2,7:329\n60#3:336\n70#3:338\n22#4:337\n22#4:339\n*S KotlinDebug\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector\n*L\n147#1:329,7\n149#1:336\n150#1:338\n149#1:337\n150#1:339\n*E\n"})
public class Connector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorSpace source;
    @NotNull
    private final ColorSpace destination;
    @NotNull
    private final ColorSpace transformSource;
    @NotNull
    private final ColorSpace transformDestination;
    private final int renderIntent;
    @Nullable
    private final float[] transform;

    private Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)transformSource, (String)"transformSource");
        Intrinsics.checkNotNullParameter((Object)transformDestination, (String)"transformDestination");
        this.source = source;
        this.destination = destination;
        this.transformSource = transformSource;
        this.transformDestination = transformDestination;
        this.renderIntent = renderIntent;
        this.transform = transform2;
    }

    @NotNull
    public final ColorSpace getSource() {
        return this.source;
    }

    @NotNull
    public final ColorSpace getDestination() {
        return this.destination;
    }

    public final int getRenderIntent-uksYyKA() {
        return this.renderIntent;
    }

    private Connector(ColorSpace source, ColorSpace destination, int intent) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this(source, destination, ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(source, Illuminant.INSTANCE.getD50(), null, 2, null) : source, ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(destination, Illuminant.INSTANCE.getD50(), null, 2, null) : destination, intent, Connector.Companion.computeTransform-YBCOT_4(source, destination, intent), null);
    }

    @Size(value=3L)
    @NotNull
    public final float[] transform(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.transform(fArray);
    }

    @Size(min=3L)
    @NotNull
    public float[] transform(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float[] xyz = this.transformSource.toXyz(v);
        if (this.transform != null) {
            xyz[0] = xyz[0] * this.transform[0];
            xyz[1] = xyz[1] * this.transform[1];
            xyz[2] = xyz[2] * this.transform[2];
        }
        return this.transformDestination.fromXyz(xyz);
    }

    public long transformToColor-l2rxGTc$ui_graphics(long color) {
        long packed;
        long arg0$iv = color;
        boolean bl = false;
        float r = Color.getRed-impl(arg0$iv);
        long arg0$iv2 = color;
        boolean bl2 = false;
        float g = Color.getGreen-impl(arg0$iv2);
        long arg0$iv3 = color;
        boolean bl3 = false;
        float b = Color.getBlue-impl(arg0$iv3);
        long arg0$iv4 = color;
        boolean bl4 = false;
        float a = Color.getAlpha-impl(arg0$iv4);
        long value$iv = packed = this.transformSource.toXy$ui_graphics(r, g, b);
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv = (int)(value$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float x = Float.intBitsToFloat(bits$iv$iv);
        long value$iv2 = packed;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv2 = (int)(value$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float y = Float.intBitsToFloat(bits$iv$iv2);
        float z = this.transformSource.toZ$ui_graphics(r, g, b);
        if (this.transform != null) {
            x *= this.transform[0];
            y *= this.transform[1];
            z *= this.transform[2];
        }
        return this.transformDestination.xyzaToColor-JlNiLsg$ui_graphics(x, y, z, a, this.destination);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform2, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, transformSource, transformDestination, renderIntent, transform2);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, int intent, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, intent);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$Companion;", "", "<init>", "()V", "computeTransform", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I)[F", "identity", "Landroidx/compose/ui/graphics/colorspace/Connector;", "identity$ui_graphics", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        private final float[] computeTransform-YBCOT_4(ColorSpace source, ColorSpace destination, int intent) {
            if (!RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                return null;
            }
            boolean srcRGB = ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            boolean dstRGB = ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                ColorSpace colorSpace = srcRGB ? source : destination;
                Intrinsics.checkNotNull((Object)colorSpace, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
                Rgb rgb = (Rgb)colorSpace;
                float[] srcXYZ = srcRGB ? rgb.getWhitePoint().toXyz$ui_graphics() : Illuminant.INSTANCE.getD50Xyz$ui_graphics();
                float[] dstXYZ = dstRGB ? rgb.getWhitePoint().toXyz$ui_graphics() : Illuminant.INSTANCE.getD50Xyz$ui_graphics();
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                return fArray;
            }
            return null;
        }

        @NotNull
        public final Connector identity$ui_graphics(@NotNull ColorSpace source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int n = RenderIntent.Companion.getRelative-uksYyKA();
            return new Connector(source, n){

                public float[] transform(float[] v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return v;
                }

                public long transformToColor-l2rxGTc$ui_graphics(long color) {
                    return color;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0017\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$RgbConnector;", "Landroidx/compose/ui/graphics/colorspace/Connector;", "mSource", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "mDestination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "<init>", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "mTransform", "", "transform", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "color", "transformToColor-l2rxGTc$ui_graphics", "(J)J", "computeTransform", "source", "destination", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;I)[F", "ui-graphics"})
    @SourceDebugExtension(value={"SMAP\nConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector$RgbConnector\n+ 2 Color.kt\nandroidx/compose/ui/graphics/Color\n+ 3 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n*L\n1#1,328:1\n219#2,7:329\n638#3:336\n653#3:337\n668#3:338\n*S KotlinDebug\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector$RgbConnector\n*L\n185#1:329,7\n189#1:336\n190#1:337\n191#1:338\n*E\n"})
    public static final class RgbConnector
    extends Connector {
        @NotNull
        private final Rgb mSource;
        @NotNull
        private final Rgb mDestination;
        @NotNull
        private final float[] mTransform;

        private RgbConnector(Rgb mSource, Rgb mDestination, int intent) {
            Intrinsics.checkNotNullParameter((Object)mSource, (String)"mSource");
            Intrinsics.checkNotNullParameter((Object)mDestination, (String)"mDestination");
            super(mSource, mDestination, mSource, mDestination, intent, null, null);
            this.mSource = mSource;
            this.mDestination = mDestination;
            this.mTransform = this.computeTransform-YBCOT_4(this.mSource, this.mDestination, intent);
        }

        @Override
        @NotNull
        public float[] transform(@NotNull float[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v[0] = (float)this.mSource.getEotfFunc$ui_graphics().invoke(v[0]);
            v[1] = (float)this.mSource.getEotfFunc$ui_graphics().invoke(v[1]);
            v[2] = (float)this.mSource.getEotfFunc$ui_graphics().invoke(v[2]);
            ColorSpaceKt.mul3x3Float3(this.mTransform, v);
            v[0] = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v[0]);
            v[1] = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v[1]);
            v[2] = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v[2]);
            return v;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long transformToColor-l2rxGTc$ui_graphics(long color) {
            void r1$iv;
            void r0$iv;
            void lhs$iv;
            float r1$iv2;
            void r0$iv32;
            void lhs$iv2;
            float r1$iv3;
            void r0$iv22;
            void lhs$iv3;
            long arg0$iv = color;
            boolean bl = false;
            float r = Color.getRed-impl(arg0$iv);
            long arg0$iv2 = color;
            boolean bl2 = false;
            float g = Color.getGreen-impl(arg0$iv2);
            long arg0$iv3 = color;
            boolean bl3 = false;
            float b = Color.getBlue-impl(arg0$iv3);
            long arg0$iv4 = color;
            boolean bl4 = false;
            float a = Color.getAlpha-impl(arg0$iv4);
            float v0 = (float)this.mSource.getEotfFunc$ui_graphics().invoke(r);
            float v1 = (float)this.mSource.getEotfFunc$ui_graphics().invoke(g);
            float v2 = (float)this.mSource.getEotfFunc$ui_graphics().invoke(b);
            float[] fArray = this.mTransform;
            float f = v0;
            float f2 = v1;
            float r2$iv = v2;
            boolean $i$f$mul3x3Float3_0 = false;
            void v01 = lhs$iv3[0] * r0$iv22 + lhs$iv3[3] * r1$iv3 + lhs$iv3[6] * r2$iv;
            float[] r0$iv22 = this.mTransform;
            r1$iv3 = v0;
            r2$iv = v1;
            float r2$iv2 = v2;
            boolean $i$f$mul3x3Float3_1 = false;
            void v11 = lhs$iv2[1] * r0$iv32 + lhs$iv2[4] * r1$iv2 + lhs$iv2[7] * r2$iv2;
            float[] r0$iv32 = this.mTransform;
            r1$iv2 = v0;
            r2$iv2 = v1;
            float r2$iv3 = v2;
            boolean $i$f$mul3x3Float3_2 = false;
            void v21 = lhs$iv[2] * r0$iv + lhs$iv[5] * r1$iv + lhs$iv[8] * r2$iv3;
            float v02 = (float)this.mDestination.getOetfFunc$ui_graphics().invoke((double)v01);
            float v12 = (float)this.mDestination.getOetfFunc$ui_graphics().invoke((double)v11);
            float v22 = (float)this.mDestination.getOetfFunc$ui_graphics().invoke((double)v21);
            return ColorKt.Color(v02, v12, v22, a, this.mDestination);
        }

        private final float[] computeTransform-YBCOT_4(Rgb source, Rgb destination, int intent) {
            if (ColorSpaceKt.compare(source.getWhitePoint(), destination.getWhitePoint())) {
                return ColorSpaceKt.mul3x3(destination.getInverseTransform$ui_graphics(), source.getTransform$ui_graphics());
            }
            float[] transform2 = source.getTransform$ui_graphics();
            float[] inverseTransform = destination.getInverseTransform$ui_graphics();
            float[] srcXYZ = source.getWhitePoint().toXyz$ui_graphics();
            float[] dstXYZ = destination.getWhitePoint().toXyz$ui_graphics();
            if (!ColorSpaceKt.compare(source.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] srcAdaptation = ColorSpaceKt.chromaticAdaptation(Adaptation.Companion.getBradford().getTransform$ui_graphics(), srcXYZ, Illuminant.INSTANCE.newD50Xyz$ui_graphics());
                transform2 = ColorSpaceKt.mul3x3(srcAdaptation, source.getTransform$ui_graphics());
            }
            if (!ColorSpaceKt.compare(destination.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] dstAdaptation = ColorSpaceKt.chromaticAdaptation(Adaptation.Companion.getBradford().getTransform$ui_graphics(), dstXYZ, Illuminant.INSTANCE.newD50Xyz$ui_graphics());
                inverseTransform = ColorSpaceKt.inverse3x3(ColorSpaceKt.mul3x3(dstAdaptation, destination.getTransform$ui_graphics()));
            }
            if (RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                transform2 = ColorSpaceKt.mul3x3Diag(fArray, transform2);
            }
            return ColorSpaceKt.mul3x3(inverseTransform, transform2);
        }

        public /* synthetic */ RgbConnector(Rgb mSource, Rgb mDestination, int intent, DefaultConstructorMarker $constructor_marker) {
            this(mSource, mDestination, intent);
        }
    }
}

