/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.tomcat.util.descriptor.tld.ImplicitTldRuleSet;
import org.apache.tomcat.util.descriptor.tld.TldParser;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.SAXException;

class ImplicitTagLibraryInfo
extends TagLibraryInfo {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    private static final String TAG_FILE_SUFFIX = ".tag";
    private static final String TAGX_FILE_SUFFIX = ".tagx";
    private static final String TAGS_SHORTNAME = "tags";
    private static final String TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "2.0";
    private static final String IMPLICIT_TLD = "implicit.tld";
    private final Map<String, String> tagFileMap;
    private final ParserController pc;
    private final PageInfo pi;
    private final List<TagFileInfo> list;

    ImplicitTagLibraryInfo(JspCompilationContext jspCompilationContext, ParserController parserController, PageInfo pageInfo, String string, String string2, ErrorDispatcher errorDispatcher) throws JasperException {
        super(string, null);
        this.pc = parserController;
        this.pi = pageInfo;
        this.tagFileMap = new ConcurrentHashMap<String, String>();
        this.list = Collections.synchronizedList(new ArrayList());
        this.functions = new FunctionInfo[0];
        this.tlibversion = TLIB_VERSION;
        this.jspversion = JSP_VERSION;
        if (!string2.startsWith(WEB_INF_TAGS)) {
            errorDispatcher.jspError("jsp.error.invalid.tagdir", string2);
        }
        if (string2.equals(WEB_INF_TAGS) || string2.equals("/WEB-INF/tags/")) {
            this.shortname = TAGS_SHORTNAME;
        } else {
            this.shortname = string2.substring(WEB_INF_TAGS.length());
            this.shortname = this.shortname.replace('/', '-');
        }
        Set<String> set = jspCompilationContext.getResourcePaths(string2);
        if (set != null) {
            for (String string3 : set) {
                String string4;
                if (string3.endsWith(TAG_FILE_SUFFIX) || string3.endsWith(TAGX_FILE_SUFFIX)) {
                    string4 = string3.endsWith(TAG_FILE_SUFFIX) ? TAG_FILE_SUFFIX : TAGX_FILE_SUFFIX;
                    String string5 = string3.substring(string3.lastIndexOf(47) + 1);
                    string5 = string5.substring(0, string5.lastIndexOf(string4));
                    this.tagFileMap.put(string5, string3);
                    continue;
                }
                if (!string3.endsWith(IMPLICIT_TLD)) continue;
                try {
                    URL uRL = jspCompilationContext.getResource(string3);
                    TldResourcePath tldResourcePath = new TldResourcePath(uRL, string3);
                    ServletContext servletContext = jspCompilationContext.getServletContext();
                    boolean bl = Boolean.parseBoolean(servletContext.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
                    String string6 = servletContext.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
                    boolean bl2 = string6 == null ? true : Boolean.parseBoolean(string6);
                    TldParser tldParser = new TldParser(true, bl, (RuleSet)new ImplicitTldRuleSet(), bl2);
                    string4 = tldParser.parse(tldResourcePath);
                }
                catch (IOException | SAXException exception) {
                    errorDispatcher.jspError(exception);
                    throw new JasperException(exception);
                }
                this.tlibversion = string4.getTlibVersion();
                this.jspversion = string4.getJspVersion();
                try {
                    double d = Double.parseDouble(this.jspversion);
                    if (d < 2.0) {
                        errorDispatcher.jspError("jsp.error.invalid.implicit.version", string3);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    errorDispatcher.jspError("jsp.error.invalid.implicit.version", string3);
                }
                if (pageInfo == null) continue;
                pageInfo.addDependant(string3, jspCompilationContext.getLastModified(string3));
            }
        }
    }

    public TagFileInfo getTagFile(String string) {
        TagFileInfo tagFileInfo = super.getTagFile(string);
        if (tagFileInfo == null) {
            String string2 = this.tagFileMap.get(string);
            if (string2 == null) {
                return null;
            }
            TagInfo tagInfo = null;
            try {
                tagInfo = TagFileProcessor.parseTagFileDirectives(this.pc, string, string2, null, this);
            }
            catch (JasperException jasperException) {
                throw new RuntimeException(jasperException.toString(), (Throwable)((Object)jasperException));
            }
            tagFileInfo = new TagFileInfo(string, string2, tagInfo);
            this.list.add(tagFileInfo);
            this.tagFiles = this.list.toArray(new TagFileInfo[0]);
        }
        return tagFileInfo;
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> collection = this.pi.getTaglibs();
        return collection.toArray(new TagLibraryInfo[0]);
    }
}

