/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre19Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre20Compat
extends Jre19Compat {
    private static final Log log = LogFactory.getLog(Jre20Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre20Compat.class);
    private static final boolean supported;
    private static final Method setNamedGroupsMethod;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public void setNamedGroupsMethod(Object object, String[] stringArray) {
        try {
            setNamedGroupsMethod.invoke(object, new Object[]{stringArray});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    static {
        Class<?> clazz = null;
        Method method = null;
        try {
            clazz = Class.forName("javax.net.ssl.SSLParameters");
            method = clazz.getMethod("setNamedGroups", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.debug((Object)sm.getString("jre20Compat.javaPre20"), (Throwable)noSuchMethodException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            log.error((Object)sm.getString("jre20Compat.unexpected"), (Throwable)reflectiveOperationException);
        }
        supported = method != null;
        setNamedGroupsMethod = method;
    }
}

