/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.JdbcGraphBuilder;

class SQLStatement {
    static final Object NEW_STATEMENT = new Object();
    static final Object NEW_PREPARED_STATEMENT = new Object();
    static final Object NEW_CALLABLE_STATEMENT = new Object();
    private List batch = new ArrayList();
    private ArrayList parameters = new ArrayList();
    private String sqlTemplate;
    private final int type;

    SQLStatement(int t) {
        this.type = t;
    }

    SQLStatement(int t, String sql) {
        this.sqlTemplate = sql;
        this.type = t;
    }

    String invoke(String methodName, String methodSignature, List parameters) {
        String select = null;
        switch (methodName) {
            case "executeQuery": {
                if (parameters.size() == 1) {
                    select = this.executeQuery();
                    break;
                }
                select = this.executeQuery((String)parameters.get(1));
                break;
            }
            case "executeUpdate": {
                if (parameters.size() == 1) {
                    select = this.executeUpdate();
                    break;
                }
                select = this.executeUpdate((String)parameters.get(1));
                break;
            }
            case "execute": {
                if (parameters.size() == 1) {
                    select = this.execute();
                    break;
                }
                select = this.execute((String)parameters.get(1));
                break;
            }
            case "addBatch": {
                if (parameters.size() == 1) {
                    this.addBatch();
                    break;
                }
                this.addBatch((String)parameters.get(1));
                break;
            }
            case "clearBatch": {
                this.clearBatch();
                break;
            }
            case "executeBatch": {
                select = this.executeBatch();
                break;
            }
            case "setDate": {
                this.setDate((Integer)parameters.get(1), (String)parameters.get(2));
                break;
            }
            case "setTimestamp": {
                this.setTimestamp((Integer)parameters.get(1), (String)parameters.get(2));
                break;
            }
            case "setNull": {
                this.setNull((Integer)parameters.get(1), (Integer)parameters.get(2));
                break;
            }
            default: {
                if (!methodName.startsWith("set") || parameters.size() < 3 || !(parameters.get(1) instanceof Integer)) break;
                this.setParameter(methodName, (Integer)parameters.get(1), parameters.get(2));
            }
        }
        return select;
    }

    String executeQuery(String sql) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeQuery {0}", new Object[]{sql});
        }
        return sql;
    }

    String executeUpdate(String sql) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeUpdate {0}", new Object[]{sql});
        }
        return sql;
    }

    String execute(String sql) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "execute {0}", new Object[]{sql});
        }
        return sql;
    }

    void addBatch() {
        this.batch.add(this.getFullSql());
    }

    void addBatch(String sql) {
        this.batch.add(sql);
    }

    void clearBatch() {
        this.batch.clear();
    }

    String executeBatch() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeBatch {0}", new Object[]{Arrays.toString(this.batch.toArray())});
        }
        return Arrays.toString(this.batch.toArray());
    }

    void setNull(int parameterIndex, int sqlType) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "setNull index:{0} type:{1}", new Object[]{parameterIndex, sqlType});
        }
        this.ensureCapacity(parameterIndex);
        this.parameters.set(parameterIndex, "NULL");
    }

    void setBoolean(int parameterIndex, Boolean x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
        this.parameters.add(x);
    }

    void setByte(int parameterIndex, byte x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setShort(int parameterIndex, short x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setInt(int parameterIndex, int x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setLong(int parameterIndex, long x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setFloat(int parameterIndex, float x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setDouble(int parameterIndex, double x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBigDecimal(int parameterIndex, BigDecimal x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setString(int parameterIndex, String x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBytes(int parameterIndex, byte[] x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setDate(int parameterIndex, String x) {
        this.ensureCapacity(parameterIndex);
        long time = Long.parseLong(x);
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "setDate index:{0} value:{1}", new Object[]{parameterIndex, new Date(time)});
        }
        this.parameters.set(parameterIndex, new Date(time));
    }

    void setTime(int parameterIndex, Time x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setTimestamp(int parameterIndex, String x) {
        this.ensureCapacity(parameterIndex);
        long time = Long.parseLong(x);
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "setTime index:{0} value:{1}", new Object[]{parameterIndex, new Timestamp(time)});
        }
        this.parameters.set(parameterIndex, new Timestamp(time));
    }

    void setAsciiStream(int parameterIndex, InputStream x, int length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setUnicodeStream(int parameterIndex, InputStream x, int length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBinaryStream(int parameterIndex, InputStream x, int length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    void setObject(int parameterIndex, Object x, int targetSqlType) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setObject(int parameterIndex, Object x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setCharacterStream(int parameterIndex, Reader reader, int length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setRef(int parameterIndex, Ref x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBlob(int parameterIndex, Blob x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setClob(int parameterIndex, Clob x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setArray(int parameterIndex, Array x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setDate(int parameterIndex, Date x, Calendar cal) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setTime(int parameterIndex, Time x, Calendar cal) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setNull(int parameterIndex, int sqlType, String typeName) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setURL(int parameterIndex, URL x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setRowId(int parameterIndex, RowId x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setNString(int parameterIndex, String value) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setNCharacterStream(int parameterIndex, Reader value, long length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setNClob(int parameterIndex, NClob value) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setClob(int parameterIndex, Reader reader, long length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBlob(int parameterIndex, InputStream inputStream, long length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setNClob(int parameterIndex, Reader reader, long length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setSQLXML(int parameterIndex, SQLXML xmlObject) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setAsciiStream(int parameterIndex, InputStream x, long length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBinaryStream(int parameterIndex, InputStream x, long length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setCharacterStream(int parameterIndex, Reader reader, long length) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setAsciiStream(int parameterIndex, InputStream x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBinaryStream(int parameterIndex, InputStream x) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setCharacterStream(int parameterIndex, Reader reader) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setNCharacterStream(int parameterIndex, Reader value) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setClob(int parameterIndex, Reader reader) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setBlob(int parameterIndex, InputStream inputStream) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    void setNClob(int parameterIndex, Reader reader) {
        this.parameters.ensureCapacity(parameterIndex + 1);
    }

    private void setParameter(String method, Integer parameterIndex, Object p) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "{0} index:{1} value:{2}", new Object[]{method, parameterIndex, p});
        }
        this.ensureCapacity(parameterIndex);
        this.parameters.set(parameterIndex, p);
    }

    String executeQuery() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeQuery {0}", new Object[]{this.getFullSql()});
        }
        return this.getFullSql();
    }

    String executeUpdate() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeUpdate {0}", new Object[]{this.getFullSql()});
        }
        return this.getFullSql();
    }

    String execute() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "execute {0}", new Object[]{this.getFullSql()});
        }
        return this.getFullSql();
    }

    private void ensureCapacity(Integer parameterIndex) {
        while (this.parameters.size() <= parameterIndex) {
            this.parameters.add(null);
        }
    }

    private String getFullSql() {
        if (this.sqlTemplate == null) {
            return null;
        }
        StringBuilder fullSql = new StringBuilder(this.sqlTemplate.length());
        int qindex = 0;
        int parindex = 1;
        do {
            String par;
            int lindex = qindex;
            if ((qindex = this.sqlTemplate.indexOf(63, qindex)) == -1) {
                qindex = this.sqlTemplate.length();
                par = "";
            } else {
                par = parindex >= this.parameters.size() ? "!!!!!UNSET" : this.formatParamter(this.parameters.get(parindex++));
            }
            fullSql.append(this.sqlTemplate.substring(lindex, qindex));
            fullSql.append(par);
        } while (++qindex < this.sqlTemplate.length());
        return fullSql.toString();
    }

    private String formatParamter(Object par) {
        if (par instanceof String) {
            return "'" + par + "'";
        }
        if (par == null) {
            return "*NULL*";
        }
        return par.toString();
    }

    public String toString() {
        return super.toString() + ":" + this.sqlTemplate;
    }

    int getType() {
        return this.type;
    }
}

