/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Exception;
import com.zeroc.IceInternal.Acceptor;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.StreamSocket;
import com.zeroc.IceInternal.TcpEndpointI;
import com.zeroc.IceInternal.TcpTransceiver;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceUtilInternal.Assert;
import com.zeroc.IceUtilInternal.StringUtil;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;

class TcpAcceptor
implements Acceptor {
    private TcpEndpointI _endpoint;
    private ProtocolInstance _instance;
    private ServerSocketChannel _fd;
    private int _backlog;
    private InetSocketAddress _addr;

    @Override
    public ServerSocketChannel fd() {
        return this._fd;
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
    }

    @Override
    public void close() {
        if (this._fd != null) {
            Network.closeSocketNoThrow(this._fd);
            this._fd = null;
        }
    }

    @Override
    public EndpointI listen() {
        try {
            this._addr = Network.doBind(this._fd, this._addr, this._backlog);
        }
        catch (Exception ex) {
            this._fd = null;
            throw ex;
        }
        this._endpoint = this._endpoint.endpoint(this);
        return this._endpoint;
    }

    @Override
    public Transceiver accept() {
        return new TcpTransceiver(this._instance, new StreamSocket(this._instance, Network.doAccept(this._fd)));
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._addr);
    }

    @Override
    public String toDetailedString() {
        StringBuffer s = new StringBuffer("local address = ");
        s.append(this.toString());
        ArrayList<String> intfs = Network.getHostsForEndpointExpand(this._addr.getAddress().getHostAddress(), this._instance.protocolSupport(), true);
        if (!intfs.isEmpty()) {
            s.append("\nlocal interfaces = ");
            s.append(StringUtil.joinString(intfs, ", "));
        }
        return s.toString();
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    TcpAcceptor(TcpEndpointI endpoint, ProtocolInstance instance, String host, int port) {
        this._endpoint = endpoint;
        this._instance = instance;
        this._backlog = instance.properties().getPropertyAsIntWithDefault("Ice.TCP.Backlog", 511);
        try {
            this._fd = Network.createTcpServerSocket();
            Network.setBlock(this._fd, false);
            Network.setTcpBufSize(this._fd, instance);
            if (!System.getProperty("os.name").startsWith("Windows")) {
                Network.setReuseAddress(this._fd, true);
            }
            this._addr = Network.getAddressForServer(host, port, instance.protocolSupport(), instance.preferIPv6());
        }
        catch (RuntimeException ex) {
            this._fd = null;
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._fd == null);
        }
        catch (java.lang.Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

