; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-globals
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -amdgpu-annotate-kernel-features  %s | FileCheck -check-prefixes=GCN,AKF_GCN %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -amdgpu-attributor %s | FileCheck -check-prefixes=GCN,ATTRIBUTOR_GCN %s

define internal void @indirect() {
; GCN-LABEL: define {{[^@]+}}@indirect
; GCN-SAME: () #[[ATTR0:[0-9]+]] {
; GCN-NEXT:    ret void
;
; CHECK-LABEL: define {{[^@]+}}@indirect
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    ret void
  ret void
}

define amdgpu_kernel void @test_simple_indirect_call() #0 {
; AKF_GCN-LABEL: define {{[^@]+}}@test_simple_indirect_call
; AKF_GCN-SAME: () #[[ATTR1:[0-9]+]] {
; AKF_GCN-NEXT:    [[FPTR:%.*]] = alloca void ()*, align 8
; AKF_GCN-NEXT:    store void ()* @indirect, void ()** [[FPTR]], align 8
; AKF_GCN-NEXT:    [[FP:%.*]] = load void ()*, void ()** [[FPTR]], align 8
; AKF_GCN-NEXT:    call void [[FP]]()
; AKF_GCN-NEXT:    ret void
;
; ATTRIBUTOR_GCN-LABEL: define {{[^@]+}}@test_simple_indirect_call
; ATTRIBUTOR_GCN-SAME: () #[[ATTR1:[0-9]+]] {
; ATTRIBUTOR_GCN-NEXT:    call void @indirect()
; ATTRIBUTOR_GCN-NEXT:    ret void
;
; CHECK-LABEL: define {{[^@]+}}@test_simple_indirect_call
; CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[FPTR:%.*]] = alloca void ()*, align 8
; CHECK-NEXT:    store void ()* @indirect, void ()** [[FPTR]], align 8
; CHECK-NEXT:    [[FP:%.*]] = load void ()*, void ()** [[FPTR]], align 8
; CHECK-NEXT:    call void [[FP]]()
; CHECK-NEXT:    ret void
  %fptr = alloca void()*
  store void()* @indirect, void()** %fptr
  %fp = load void()*, void()** %fptr
  call void %fp()
  ret void
}

attributes #0 = { "amdgpu-dispatch-id" }

;.
; AKF_GCN: attributes #[[ATTR0]] = { "amdgpu-dispatch-id" "amdgpu-dispatch-ptr" "amdgpu-implicitarg-ptr" "amdgpu-queue-ptr" "amdgpu-work-group-id-x" "amdgpu-work-group-id-y" "amdgpu-work-group-id-z" "amdgpu-work-item-id-x" "amdgpu-work-item-id-y" "amdgpu-work-item-id-z" }
; AKF_GCN: attributes #[[ATTR1]] = { "amdgpu-calls" "amdgpu-dispatch-id" "amdgpu-dispatch-ptr" "amdgpu-implicitarg-ptr" "amdgpu-queue-ptr" "amdgpu-stack-objects" "amdgpu-work-group-id-x" "amdgpu-work-group-id-y" "amdgpu-work-group-id-z" "amdgpu-work-item-id-x" "amdgpu-work-item-id-y" "amdgpu-work-item-id-z" }
;.
; ATTRIBUTOR_GCN: attributes #[[ATTR0]] = { "amdgpu-dispatch-id" "amdgpu-dispatch-ptr" "amdgpu-implicitarg-ptr" "amdgpu-queue-ptr" "amdgpu-work-group-id-x" "amdgpu-work-group-id-y" "amdgpu-work-group-id-z" "amdgpu-work-item-id-x" "amdgpu-work-item-id-y" "amdgpu-work-item-id-z" "uniform-work-group-size"="false" }
; ATTRIBUTOR_GCN: attributes #[[ATTR1]] = { "amdgpu-calls" "amdgpu-dispatch-id" "amdgpu-dispatch-ptr" "amdgpu-implicitarg-ptr" "amdgpu-queue-ptr" "amdgpu-stack-objects" "amdgpu-work-group-id-x" "amdgpu-work-group-id-y" "amdgpu-work-group-id-z" "amdgpu-work-item-id-x" "amdgpu-work-item-id-y" "amdgpu-work-item-id-z" "uniform-work-group-size"="false" }
;.
