; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instsimplify -S | FileCheck %s

declare void @llvm.assume(i1)
declare void @use(i1)

define void @basic_ugt(i32 %x, i32 %y) {
; CHECK-LABEL: @basic_ugt(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP1]])
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    ret void
;
  %cmp1 = icmp ugt i32 %x, %y
  call void @llvm.assume(i1 %cmp1)

  %cmp2 = icmp ugt i32 %x, %y
  call void @use(i1 %cmp2)
  %cmp3 = icmp uge i32 %x, %y
  call void @use(i1 %cmp3)
  %cmp4 = icmp ult i32 %x, %y
  call void @use(i1 %cmp4)
  %cmp5 = icmp ule i32 %x, %y
  call void @use(i1 %cmp5)

  %cmp6 = icmp ugt i32 %y, %x
  call void @use(i1 %cmp6)
  %cmp7 = icmp uge i32 %y, %x
  call void @use(i1 %cmp7)
  %cmp8 = icmp ult i32 %y, %x
  call void @use(i1 %cmp8)
  %cmp9 = icmp ule i32 %y, %x
  call void @use(i1 %cmp9)

  ret void
}

define void @basic_uge(i32 %x, i32 %y) {
; CHECK-LABEL: @basic_uge(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp uge i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP1]])
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @use(i1 [[CMP2]])
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[CMP5:%.*]] = icmp ule i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @use(i1 [[CMP5]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[CMP7:%.*]] = icmp uge i32 [[Y]], [[X]]
; CHECK-NEXT:    call void @use(i1 [[CMP7]])
; CHECK-NEXT:    [[CMP8:%.*]] = icmp ult i32 [[Y]], [[X]]
; CHECK-NEXT:    call void @use(i1 [[CMP8]])
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    ret void
;
  %cmp1 = icmp uge i32 %x, %y
  call void @llvm.assume(i1 %cmp1)

  %cmp2 = icmp ugt i32 %x, %y
  call void @use(i1 %cmp2)
  %cmp3 = icmp uge i32 %x, %y
  call void @use(i1 %cmp3)
  %cmp4 = icmp ult i32 %x, %y
  call void @use(i1 %cmp4)
  %cmp5 = icmp ule i32 %x, %y
  call void @use(i1 %cmp5)

  %cmp6 = icmp ugt i32 %y, %x
  call void @use(i1 %cmp6)
  %cmp7 = icmp uge i32 %y, %x
  call void @use(i1 %cmp7)
  %cmp8 = icmp ult i32 %y, %x
  call void @use(i1 %cmp8)
  %cmp9 = icmp ule i32 %y, %x
  call void @use(i1 %cmp9)

  ret void
}

; This does not simplify in InstSimplify, because AssumptionCache tracker
; does not track values through "and". The "and" assume will be broken
; down into two separate assume calls by InstCombine.
define void @and(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @and(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i32 [[Z:%.*]], [[Y]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[CMP1]], [[CMP2]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[AND]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ugt i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @use(i1 [[CMP3]])
; CHECK-NEXT:    [[CMP4:%.*]] = icmp uge i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @use(i1 [[CMP4]])
; CHECK-NEXT:    [[CMP5:%.*]] = icmp ugt i32 [[Z]], [[Y]]
; CHECK-NEXT:    call void @use(i1 [[CMP5]])
; CHECK-NEXT:    [[CMP6:%.*]] = icmp uge i32 [[Z]], [[Y]]
; CHECK-NEXT:    call void @use(i1 [[CMP6]])
; CHECK-NEXT:    ret void
;
  %cmp1 = icmp ugt i32 %x, %y
  %cmp2 = icmp ugt i32 %z, %y
  %and = and i1 %cmp1, %cmp2
  call void @llvm.assume(i1 %and)

  %cmp3 = icmp ugt i32 %x, %y
  call void @use(i1 %cmp3)
  %cmp4 = icmp uge i32 %x, %y
  call void @use(i1 %cmp4)
  %cmp5 = icmp ugt i32 %z, %y
  call void @use(i1 %cmp5)
  %cmp6 = icmp uge i32 %z, %y
  call void @use(i1 %cmp6)

  ret void
}
