; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck --check-prefixes=AVX2-SLOW %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck --check-prefixes=AVX2-FAST %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck --check-prefixes=AVX2-FAST %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i8_stride6_vf2(<2 x i8>* %in.vecptr0, <2 x i8>* %in.vecptr1, <2 x i8>* %in.vecptr2, <2 x i8>* %in.vecptr3, <2 x i8>* %in.vecptr4, <2 x i8>* %in.vecptr5, <12 x i8>* %out.vec) nounwind {
; SSE-LABEL: store_i8_stride6_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa (%rdx), %xmm1
; SSE-NEXT:    movdqa (%r8), %xmm2
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,5,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,1]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [255,255,255,255,255,0,255,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3],xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movq %xmm0, (%rax)
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE-NEXT:    movd %xmm0, 8(%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: store_i8_stride6_vf2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa (%rdx), %xmm1
; AVX1-NEXT:    vmovdqa (%r9), %xmm2
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3],xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1],zero,xmm0[2,6,10,14,3],zero,xmm0[u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm2[0],zero,zero,zero,zero,zero,xmm2[1,u,u,u,u]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX1-NEXT:    vmovq %xmm0, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i8_stride6_vf2:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm2
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3],xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1],zero,xmm0[2,6,10,14,3],zero,xmm0[u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm2[0],zero,zero,zero,zero,zero,xmm2[1,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX2-SLOW-NEXT:    vmovq %xmm0, (%rax)
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i8_stride6_vf2:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%r9), %xmm2
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3],xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1],zero,xmm0[2,6,10,14,3],zero,xmm0[u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm2[0],zero,zero,zero,zero,zero,xmm2[1,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX2-FAST-NEXT:    vmovq %xmm0, (%rax)
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride6_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r9), %xmm2
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1],xmm0[2],mem[2],xmm0[3],mem[3],xmm0[4],mem[4],xmm0[5],mem[5],xmm0[6],mem[6],xmm0[7],mem[7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,4,8,12,1],zero,xmm0[2,6,10,14,3],zero,xmm0[u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm2[0],zero,zero,zero,zero,zero,xmm2[1,u,u,u,u]
; AVX512-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpextrd $2, %xmm0, 8(%rax)
; AVX512-NEXT:    vmovq %xmm0, (%rax)
; AVX512-NEXT:    retq
  %in.vec0 = load <2 x i8>, <2 x i8>* %in.vecptr0, align 32
  %in.vec1 = load <2 x i8>, <2 x i8>* %in.vecptr1, align 32
  %in.vec2 = load <2 x i8>, <2 x i8>* %in.vecptr2, align 32
  %in.vec3 = load <2 x i8>, <2 x i8>* %in.vecptr3, align 32
  %in.vec4 = load <2 x i8>, <2 x i8>* %in.vecptr4, align 32
  %in.vec5 = load <2 x i8>, <2 x i8>* %in.vecptr5, align 32

  %concat01 = shufflevector <2 x i8> %in.vec0, <2 x i8> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %concat23 = shufflevector <2 x i8> %in.vec2, <2 x i8> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %concat45 = shufflevector <2 x i8> %in.vec4, <2 x i8> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %concat0123 = shufflevector <4 x i8> %concat01, <4 x i8> %concat23, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %concat45uu = shufflevector <4 x i8> %concat45, <4 x i8> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat012345 = shufflevector <8 x i8> %concat0123, <8 x i8> %concat45uu, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %interleaved.vec = shufflevector <12 x i8> %concat012345, <12 x i8> poison, <12 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11>

  store <12 x i8> %interleaved.vec, <12 x i8>* %out.vec, align 32

  ret void
}

define void @store_i8_stride6_vf4(<4 x i8>* %in.vecptr0, <4 x i8>* %in.vecptr1, <4 x i8>* %in.vecptr2, <4 x i8>* %in.vecptr3, <4 x i8>* %in.vecptr4, <4 x i8>* %in.vecptr5, <24 x i8>* %out.vec) nounwind {
; SSE-LABEL: store_i8_stride6_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa (%rdx), %xmm2
; SSE-NEXT:    movdqa (%r8), %xmm0
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[1],mem[1]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3],xmm2[4],xmm4[4],xmm2[5],xmm4[5],xmm2[6],xmm4[6],xmm2[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm3[0,1,2,3,4,5,4,6]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3],xmm1[4],xmm4[4],xmm1[5],xmm4[5],xmm1[6],xmm4[6],xmm1[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,6,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm5[3,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[1,3,2,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm6[0,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[0,2,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,1],xmm6[0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5,7,5]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm5[2,3]
; SSE-NEXT:    packuswb %xmm3, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1],xmm0[2],xmm4[2],xmm0[3],xmm4[3],xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,1,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,6,4,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm5
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    por %xmm7, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,3,1,4,5,6,7]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,0,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movq %xmm2, 16(%rax)
; SSE-NEXT:    movdqa %xmm3, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: store_i8_stride6_vf4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa (%rdx), %xmm1
; AVX1-NEXT:    vmovdqa (%r8), %xmm2
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[0,4,8,12],zero,zero,xmm0[1,5,9,13],zero,zero,xmm0[2,6,10,14]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[0,4],zero,zero,zero,zero,xmm1[1,5],zero,zero,zero,zero
; AVX1-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[3,7,11,15],zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[2,6],zero,zero,zero,zero,xmm1[3,7,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, 16(%rax)
; AVX1-NEXT:    vmovdqa %xmm2, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i8_stride6_vf4:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,ymm0[1,5,9,13],zero,zero,ymm0[2,6,10,14,18,22],zero,zero,zero,zero,ymm0[19,23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4],zero,zero,zero,zero,ymm0[1,5],zero,zero,zero,zero,zero,zero,ymm0[19,23,27,31],zero,zero,ymm0[u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vmovq %xmm1, 16(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i8_stride6_vf4:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12],zero,zero,ymm0[1,5,9,13],zero,zero,ymm0[2,6,10,14,18,22],zero,zero,zero,zero,ymm0[19,23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,ymm0[0,4],zero,zero,zero,zero,ymm0[1,5],zero,zero,zero,zero,zero,zero,ymm0[19,23,27,31],zero,zero,ymm0[u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vmovq %xmm1, 16(%rax)
; AVX2-FAST-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride6_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],mem[0],xmm2[1],mem[1]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,4,8,12,u,u,1,5,9,13,u,u,2,6,10,14,18,22,u,u,u,u,19,23,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,0,4,u,u,u,u,1,5,u,u,u,u,u,u,19,23,27,31,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    movw $1572, %cx # imm = 0x624
; AVX512-NEXT:    kmovd %ecx, %k1
; AVX512-NEXT:    vmovdqu16 %ymm0, %ymm1 {%k1}
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX512-NEXT:    vmovq %xmm0, 16(%rax)
; AVX512-NEXT:    vmovdqa %xmm1, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <4 x i8>, <4 x i8>* %in.vecptr0, align 32
  %in.vec1 = load <4 x i8>, <4 x i8>* %in.vecptr1, align 32
  %in.vec2 = load <4 x i8>, <4 x i8>* %in.vecptr2, align 32
  %in.vec3 = load <4 x i8>, <4 x i8>* %in.vecptr3, align 32
  %in.vec4 = load <4 x i8>, <4 x i8>* %in.vecptr4, align 32
  %in.vec5 = load <4 x i8>, <4 x i8>* %in.vecptr5, align 32

  %concat01 = shufflevector <4 x i8> %in.vec0, <4 x i8> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %concat23 = shufflevector <4 x i8> %in.vec2, <4 x i8> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %concat45 = shufflevector <4 x i8> %in.vec4, <4 x i8> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %concat0123 = shufflevector <8 x i8> %concat01, <8 x i8> %concat23, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %concat45uu = shufflevector <8 x i8> %concat45, <8 x i8> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat012345 = shufflevector <16 x i8> %concat0123, <16 x i8> %concat45uu, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %interleaved.vec = shufflevector <24 x i8> %concat012345, <24 x i8> poison, <24 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23>

  store <24 x i8> %interleaved.vec, <24 x i8>* %out.vec, align 32

  ret void
}

define void @store_i8_stride6_vf8(<8 x i8>* %in.vecptr0, <8 x i8>* %in.vecptr1, <8 x i8>* %in.vecptr2, <8 x i8>* %in.vecptr3, <8 x i8>* %in.vecptr4, <8 x i8>* %in.vecptr5, <48 x i8>* %out.vec) nounwind {
; SSE-LABEL: store_i8_stride6_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    movq {{.*#+}} xmm4 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3],xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,1,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm0[1,0,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,1,0,1]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,0,0,0]
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm7, %xmm5
; SSE-NEXT:    por %xmm6, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[2,2,3,3]
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm6, %xmm7
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm0[0,1,2,3,5,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,2,2,3]
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    por %xmm7, %xmm6
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm2[3,3,3,3]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm8, %xmm7
; SSE-NEXT:    por %xmm6, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,2,2]
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, 16(%rax)
; SSE-NEXT:    movdqa %xmm7, 32(%rax)
; SSE-NEXT:    movdqa %xmm5, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: store_i8_stride6_vf8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX1-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u],zero,zero,xmm1[3,11,u,u],zero,zero,xmm1[4,12,u,u],zero,zero
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[u,u,3,11],zero,zero,xmm0[u,u,4,12],zero,zero,xmm0[u,u,5,13]
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[2,10,u,u,u,u,3,11,u,u,u,u,4,12,u,u]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0],xmm3[1,2],xmm4[3],xmm3[4,5],xmm4[6],xmm3[7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,xmm1[0,8,u,u],zero,zero,xmm1[1,9,u,u],zero,zero,xmm1[2,10]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[0,8],zero,zero,xmm0[u,u,1,9],zero,zero,xmm0[u,u,2,10],zero,zero
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpshufb {{.*#+}} xmm5 = xmm2[u,u,u,u,0,8,u,u,u,u,1,9,u,u,u,u]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2],xmm4[3,4],xmm5[5],xmm4[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[u,u,6,14],zero,zero,xmm0[u,u,7,15],zero,zero,xmm0[u,u]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,13,u,u],zero,zero,xmm1[6,14,u,u],zero,zero,xmm1[7,15,u,u]
; AVX1-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[u,u,5,13,u,u,u,u,6,14,u,u,u,u,7,15]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX1-NEXT:    vmovdqa %xmm0, 32(%rax)
; AVX1-NEXT:    vmovaps %ymm3, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i8_stride6_vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm3[0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,u,u,u,u,19,27,u,u,u,u,20,28,u,u,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,19,27,u,u,u,u,20,28,u,u,u,u,21,29]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7],ymm4[8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[2,10,1,9,0,8,3,11,u,u,u,u,4,12,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[u,u,6,14],zero,zero,xmm0[u,u,7,15],zero,zero,xmm0[u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,13,u,u],zero,zero,xmm1[6,14,u,u],zero,zero,xmm1[7,15,u,u]
; AVX2-SLOW-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[u,u,5,13,u,u,u,u,6,14,u,u,u,u,7,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, 32(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, (%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i8_stride6_vf8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm3[0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,u,u,u,u,19,27,u,u,u,u,20,28,u,u,u,u]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,0,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,19,27,u,u,u,u,20,28,u,u,u,u,21,29]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7],ymm4[8],ymm3[9],ymm4[10,11],ymm3[12],ymm4[13,14],ymm3[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[2,10,1,9,0,8,3,11,u,u,u,u,4,12,u,u]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,0,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[u,u,6,14],zero,zero,xmm0[u,u,7,15],zero,zero,xmm0[u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,13,u,u],zero,zero,xmm1[6,14,u,u],zero,zero,xmm1[7,15,u,u]
; AVX2-FAST-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[u,u,5,13,u,u,u,u,6,14,u,u,u,u,7,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, 32(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, (%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride6_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,xmm0[u,u,6,14],zero,zero,xmm0[u,u,7,15],zero,zero,xmm0[u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[5,13,u,u],zero,zero,xmm1[6,14,u,u],zero,zero,xmm1[7,15,u,u]
; AVX512-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vextracti32x4 $2, %zmm2, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm1[u,u,5,13,u,u,u,u,6,14,u,u,u,u,7,15]
; AVX512-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2,3],xmm2[4],xmm0[5,6],xmm2[7]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm2 = ymm3[0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,u,u,u,u,19,27,u,u,u,u,20,28,u,u,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,3,0,1]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,19,27,u,u,u,u,20,28,u,u,u,u,21,29]
; AVX512-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3],ymm3[4],ymm2[5,6],ymm3[7],ymm2[8],ymm3[9],ymm2[10,11],ymm3[12],ymm2[13,14],ymm3[15]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[2,10,1,9,0,8,3,11,u,u,u,u,4,12,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,0,1]
; AVX512-NEXT:    movw $18724, %cx # imm = 0x4924
; AVX512-NEXT:    kmovd %ecx, %k1
; AVX512-NEXT:    vmovdqu16 %ymm1, %ymm2 {%k1}
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512-NEXT:    vmovdqa %ymm2, (%rax)
; AVX512-NEXT:    vextracti32x4 $2, %zmm0, 32(%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <8 x i8>, <8 x i8>* %in.vecptr0, align 32
  %in.vec1 = load <8 x i8>, <8 x i8>* %in.vecptr1, align 32
  %in.vec2 = load <8 x i8>, <8 x i8>* %in.vecptr2, align 32
  %in.vec3 = load <8 x i8>, <8 x i8>* %in.vecptr3, align 32
  %in.vec4 = load <8 x i8>, <8 x i8>* %in.vecptr4, align 32
  %in.vec5 = load <8 x i8>, <8 x i8>* %in.vecptr5, align 32

  %concat01 = shufflevector <8 x i8> %in.vec0, <8 x i8> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %concat23 = shufflevector <8 x i8> %in.vec2, <8 x i8> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %concat45 = shufflevector <8 x i8> %in.vec4, <8 x i8> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %concat0123 = shufflevector <16 x i8> %concat01, <16 x i8> %concat23, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %concat45uu = shufflevector <16 x i8> %concat45, <16 x i8> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat012345 = shufflevector <32 x i8> %concat0123, <32 x i8> %concat45uu, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %interleaved.vec = shufflevector <48 x i8> %concat012345, <48 x i8> poison, <48 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47>

  store <48 x i8> %interleaved.vec, <48 x i8>* %out.vec, align 32

  ret void
}

define void @store_i8_stride6_vf16(<16 x i8>* %in.vecptr0, <16 x i8>* %in.vecptr1, <16 x i8>* %in.vecptr2, <16 x i8>* %in.vecptr3, <16 x i8>* %in.vecptr4, <16 x i8>* %in.vecptr5, <96 x i8>* %out.vec) nounwind {
; SSE-LABEL: store_i8_stride6_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm6
; SSE-NEXT:    movdqa (%rsi), %xmm10
; SSE-NEXT:    movdqa (%rdx), %xmm5
; SSE-NEXT:    movdqa (%rcx), %xmm12
; SSE-NEXT:    movdqa (%r8), %xmm7
; SSE-NEXT:    movdqa (%r9), %xmm14
; SSE-NEXT:    movdqa %xmm6, %xmm11
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3],xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[0,0,1,1]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm12[0],xmm8[1],xmm12[1],xmm8[2],xmm12[2],xmm8[3],xmm12[3],xmm8[4],xmm12[4],xmm8[5],xmm12[5],xmm8[6],xmm12[6],xmm8[7],xmm12[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[1,0,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm7, %xmm13
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm14[0],xmm13[1],xmm14[1],xmm13[2],xmm14[2],xmm13[3],xmm14[3],xmm13[4],xmm14[4],xmm13[5],xmm14[5],xmm13[6],xmm14[6],xmm13[7],xmm14[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm13[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm9
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    por %xmm3, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm13[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm8[0,1,2,3,5,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,3]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[3,3,3,3]
; SSE-NEXT:    movdqa %xmm2, %xmm15
; SSE-NEXT:    pandn %xmm4, %xmm15
; SSE-NEXT:    por %xmm1, %xmm15
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm14[8],xmm7[9],xmm14[9],xmm7[10],xmm14[10],xmm7[11],xmm14[11],xmm7[12],xmm14[12],xmm7[13],xmm14[13],xmm7[14],xmm14[14],xmm7[15],xmm14[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm12[8],xmm5[9],xmm12[9],xmm5[10],xmm12[10],xmm5[11],xmm12[11],xmm5[12],xmm12[12],xmm5[13],xmm12[13],xmm5[14],xmm12[14],xmm5[15],xmm12[15]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm5[0,1,2,3,5,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,3]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm10[8],xmm6[9],xmm10[9],xmm6[10],xmm10[10],xmm6[11],xmm10[11],xmm6[12],xmm10[12],xmm6[13],xmm10[13],xmm6[14],xmm10[14],xmm6[15],xmm10[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[3,3,3,3]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[0,0,1,1]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[1,0,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm3[0,1,0,1]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm10, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[0,0,0,0]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pandn %xmm10, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,2,2]
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por %xmm6, %xmm3
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm11[1,1,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm13[1,1,2,2]
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, 16(%rax)
; SSE-NEXT:    movdqa %xmm6, 64(%rax)
; SSE-NEXT:    movdqa %xmm1, 48(%rax)
; SSE-NEXT:    movdqa %xmm4, 80(%rax)
; SSE-NEXT:    movdqa %xmm15, 32(%rax)
; SSE-NEXT:    movdqa %xmm9, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: store_i8_stride6_vf16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm8
; AVX1-NEXT:    vmovdqa (%rsi), %xmm9
; AVX1-NEXT:    vmovdqa (%rdx), %xmm10
; AVX1-NEXT:    vmovdqa (%rcx), %xmm4
; AVX1-NEXT:    vmovdqa (%r8), %xmm5
; AVX1-NEXT:    vmovdqa (%r9), %xmm6
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm8[0],xmm9[0],xmm8[1],xmm9[1],xmm8[2],xmm9[2],xmm8[3],xmm9[3],xmm8[4],xmm9[4],xmm8[5],xmm9[5],xmm8[6],xmm9[6],xmm8[7],xmm9[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm7[1,1,2,2]
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm10[0],xmm4[0],xmm10[1],xmm4[1],xmm10[2],xmm4[2],xmm10[3],xmm4[3],xmm10[4],xmm4[4],xmm10[5],xmm4[5],xmm10[6],xmm4[6],xmm10[7],xmm4[7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm1[3,3,3,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,4,4]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2],xmm0[3,4],xmm2[5],xmm0[6,7]
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3],xmm5[4],xmm6[4],xmm5[5],xmm6[5],xmm5[6],xmm6[6],xmm5[7],xmm6[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[1,1,2,2]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm11 = xmm3[0],xmm0[1,2],xmm3[3],xmm0[4,5],xmm3[6],xmm0[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm7[0,0,1,1]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm1[1,0,2,2,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0],xmm0[1],xmm3[2,3],xmm0[4],xmm3[5,6],xmm0[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[0,0,0,0]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm3[2],xmm0[3,4],xmm3[5],xmm0[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm3[0,0,0,0]
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm10[8],xmm4[8],xmm10[9],xmm4[9],xmm10[10],xmm4[10],xmm10[11],xmm4[11],xmm10[12],xmm4[12],xmm10[13],xmm4[13],xmm10[14],xmm4[14],xmm10[15],xmm4[15]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm4[1,0,2,2,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,1,0,1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1],xmm5[2],xmm6[3,4],xmm5[5],xmm6[6,7]
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm8[8],xmm9[8],xmm8[9],xmm9[9],xmm8[10],xmm9[10],xmm8[11],xmm9[11],xmm8[12],xmm9[12],xmm8[13],xmm9[13],xmm8[14],xmm9[14],xmm8[15],xmm9[15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm6[0,0,1,1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm5[1,2],xmm0[3],xmm5[4,5],xmm0[6],xmm5[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,3,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,6,7,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,2,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3],xmm2[4],xmm1[5,6],xmm2[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm7[3,3,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2],xmm1[3,4],xmm2[5],xmm1[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm6[3,3,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm3[2,2,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2],xmm2[3,4],xmm1[5],xmm2[6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm4[0,1,2,3,5,6,7,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,2,2,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1,2],xmm2[3],xmm1[4,5],xmm2[6],xmm1[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm6[1,1,2,2]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[1,1,2,2]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2,3],xmm2[4],xmm3[5,6],xmm2[7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm4[3,3,3,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,4,4]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2],xmm2[3,4],xmm3[5],xmm2[6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX1-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-NEXT:    vmovaps %ymm11, (%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i8_stride6_vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-SLOW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[0,2,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm3[0,8,u,u],zero,zero,ymm3[1,9,u,u],zero,zero,ymm3[2,10,u,u],zero,zero,ymm3[19,27,u,u],zero,zero,ymm3[20,28,u,u],zero,zero
; AVX2-SLOW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[0,2,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[0,8],zero,zero,zero,zero,ymm4[1,9],zero,zero,zero,zero,ymm4[2,10],zero,zero,zero,zero,ymm4[19,27],zero,zero,zero,zero,ymm4[20,28],zero,zero,zero,zero,ymm4[21,29]
; AVX2-SLOW-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[0,2,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,0,8,u,u,u,u,1,9,u,u,u,u,18,26,u,u,u,u,19,27,u,u,u,u,20,28,u,u]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,ymm4[5,13,u,u],zero,zero,ymm4[6,14,u,u],zero,zero,ymm4[7,15,u,u],zero,zero,ymm4[16,24,u,u],zero,zero,ymm4[17,25,u,u],zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm1[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[5,13],zero,zero,zero,zero,ymm6[6,14],zero,zero,zero,zero,ymm6[7,15],zero,zero,zero,zero,ymm6[16,24],zero,zero,zero,zero,ymm6[17,25],zero,zero,zero,zero,ymm6[18,26]
; AVX2-SLOW-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm0[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,6,14,u,u,u,u,7,15,u,u,u,u,16,24,u,u,u,u,17,25,u,u,u,u,18,26,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm4, %ymm6, %ymm4
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,ymm0[3,11,u,u],zero,zero,ymm0[4,12,u,u],zero,zero,ymm0[5,13,u,u],zero,zero,ymm0[22,30,u,u],zero,zero,ymm0[23,31,u,u],zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[1,3,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[2,10],zero,zero,zero,zero,ymm2[3,11],zero,zero,zero,zero,ymm2[4,12],zero,zero,zero,zero,ymm2[21,29],zero,zero,zero,zero,ymm2[22,30],zero,zero,zero,zero,ymm2[23,31]
; AVX2-SLOW-NEXT:    vpor %ymm0, %ymm2, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,3,1,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,3,11,u,u,u,u,4,12,u,u,u,u,21,29,u,u,u,u,22,30,u,u,u,u,23,31,u,u]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 32(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, (%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i8_stride6_vf16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm2
; AVX2-FAST-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[0,2,0,2]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = zero,zero,ymm3[0,8,u,u],zero,zero,ymm3[1,9,u,u],zero,zero,ymm3[2,10,u,u],zero,zero,ymm3[19,27,u,u],zero,zero,ymm3[20,28,u,u],zero,zero
; AVX2-FAST-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[0,2,0,2]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[0,8],zero,zero,zero,zero,ymm4[1,9],zero,zero,zero,zero,ymm4[2,10],zero,zero,zero,zero,ymm4[19,27],zero,zero,zero,zero,ymm4[20,28],zero,zero,zero,zero,ymm4[21,29]
; AVX2-FAST-NEXT:    vpor %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[0,2,0,2]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,u,u,0,8,u,u,u,u,1,9,u,u,u,u,18,26,u,u,u,u,19,27,u,u,u,u,20,28,u,u]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm2[0,2,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = zero,zero,ymm4[5,13,u,u],zero,zero,ymm4[6,14,u,u],zero,zero,ymm4[7,15,u,u],zero,zero,ymm4[16,24,u,u],zero,zero,ymm4[17,25,u,u],zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm1[0,2,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[5,13],zero,zero,zero,zero,ymm6[6,14],zero,zero,zero,zero,ymm6[7,15],zero,zero,zero,zero,ymm6[16,24],zero,zero,zero,zero,ymm6[17,25],zero,zero,zero,zero,ymm6[18,26]
; AVX2-FAST-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm0[0,2,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,6,14,u,u,u,u,7,15,u,u,u,u,16,24,u,u,u,u,17,25,u,u,u,u,18,26,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm4, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,ymm0[3,11,u,u],zero,zero,ymm0[4,12,u,u],zero,zero,ymm0[5,13,u,u],zero,zero,ymm0[22,30,u,u],zero,zero,ymm0[23,31,u,u],zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[1,3,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[2,10],zero,zero,zero,zero,ymm2[3,11],zero,zero,zero,zero,ymm2[4,12],zero,zero,zero,zero,ymm2[21,29],zero,zero,zero,zero,ymm2[22,30],zero,zero,zero,zero,ymm2[23,31]
; AVX2-FAST-NEXT:    vpor %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,3,1,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,3,11,u,u,u,u,4,12,u,u,u,u,21,29,u,u,u,u,22,30,u,u,u,u,23,31,u,u]
; AVX2-FAST-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, 32(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, (%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride6_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512-NEXT:    vpermq {{.*#+}} ymm3 = ymm0[0,2,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,6,14,u,u,u,u,7,15,u,u,u,u,16,24,u,u,u,u,17,25,u,u,u,u,18,26,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm4 = ymm1[0,2,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[5,13,u,u,u,u,6,14,u,u,u,u,7,15,u,u,u,u,16,24,u,u,u,u,17,25,u,u,u,u,18,26]
; AVX512-NEXT:    movw $18724, %cx # imm = 0x4924
; AVX512-NEXT:    kmovd %ecx, %k1
; AVX512-NEXT:    vmovdqu16 %ymm3, %ymm4 {%k1}
; AVX512-NEXT:    vpermq {{.*#+}} ymm3 = ymm2[0,2,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,5,13,u,u,u,u,6,14,u,u,u,u,7,15,u,u,u,u,16,24,u,u,u,u,17,25,u,u,u,u]
; AVX512-NEXT:    movw $9362, %cx # imm = 0x2492
; AVX512-NEXT:    kmovd %ecx, %k2
; AVX512-NEXT:    vmovdqu16 %ymm3, %ymm4 {%k2}
; AVX512-NEXT:    vpermq {{.*#+}} ymm3 = ymm1[0,2,0,2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,u,u,19,27,u,u,u,u,20,28,u,u,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm5 = ymm0[0,2,0,2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[0,8,u,u,u,u,1,9,u,u,u,u,2,10,u,u,u,u,19,27,u,u,u,u,20,28,u,u,u,u,21,29]
; AVX512-NEXT:    vmovdqu16 %ymm3, %ymm5 {%k2}
; AVX512-NEXT:    vpermq {{.*#+}} ymm3 = ymm2[0,2,0,2]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm3[u,u,u,u,0,8,u,u,u,u,1,9,u,u,u,u,18,26,u,u,u,u,19,27,u,u,u,u,20,28,u,u]
; AVX512-NEXT:    vmovdqu16 %ymm3, %ymm5 {%k1}
; AVX512-NEXT:    vinserti64x4 $1, %ymm4, %zmm5, %zmm3
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[1,3,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,3,11,u,u,u,u,4,12,u,u,u,u,21,29,u,u,u,u,22,30,u,u,u,u,23,31,u,u]
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[1,3,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,3,11,u,u,u,u,4,12,u,u,u,u,5,13,u,u,u,u,22,30,u,u,u,u,23,31,u,u,u,u]
; AVX512-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm2[1,3,1,3]
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[2,10,u,u,u,u,3,11,u,u,u,u,4,12,u,u,u,u,21,29,u,u,u,u,22,30,u,u,u,u,23,31]
; AVX512-NEXT:    movw $-28087, %cx # imm = 0x9249
; AVX512-NEXT:    kmovd %ecx, %k1
; AVX512-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512-NEXT:    vmovdqu64 %zmm3, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <16 x i8>, <16 x i8>* %in.vecptr0, align 32
  %in.vec1 = load <16 x i8>, <16 x i8>* %in.vecptr1, align 32
  %in.vec2 = load <16 x i8>, <16 x i8>* %in.vecptr2, align 32
  %in.vec3 = load <16 x i8>, <16 x i8>* %in.vecptr3, align 32
  %in.vec4 = load <16 x i8>, <16 x i8>* %in.vecptr4, align 32
  %in.vec5 = load <16 x i8>, <16 x i8>* %in.vecptr5, align 32

  %concat01 = shufflevector <16 x i8> %in.vec0, <16 x i8> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %concat23 = shufflevector <16 x i8> %in.vec2, <16 x i8> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %concat45 = shufflevector <16 x i8> %in.vec4, <16 x i8> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %concat0123 = shufflevector <32 x i8> %concat01, <32 x i8> %concat23, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %concat45uu = shufflevector <32 x i8> %concat45, <32 x i8> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat012345 = shufflevector <64 x i8> %concat0123, <64 x i8> %concat45uu, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %interleaved.vec = shufflevector <96 x i8> %concat012345, <96 x i8> poison, <96 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95>

  store <96 x i8> %interleaved.vec, <96 x i8>* %out.vec, align 32

  ret void
}

define void @store_i8_stride6_vf32(<32 x i8>* %in.vecptr0, <32 x i8>* %in.vecptr1, <32 x i8>* %in.vecptr2, <32 x i8>* %in.vecptr3, <32 x i8>* %in.vecptr4, <32 x i8>* %in.vecptr5, <192 x i8>* %out.vec) nounwind {
; SSE-LABEL: store_i8_stride6_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $56, %rsp
; SSE-NEXT:    movdqa 16(%rdi), %xmm10
; SSE-NEXT:    movdqa 16(%rsi), %xmm8
; SSE-NEXT:    movdqa 16(%rdx), %xmm9
; SSE-NEXT:    movdqa 16(%rcx), %xmm4
; SSE-NEXT:    movdqa (%r8), %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%r8), %xmm12
; SSE-NEXT:    movdqa 16(%r9), %xmm5
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm5[8],xmm0[9],xmm5[9],xmm0[10],xmm5[10],xmm0[11],xmm5[11],xmm0[12],xmm5[12],xmm0[13],xmm5[13],xmm0[14],xmm5[14],xmm0[15],xmm5[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm9, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm4[8],xmm6[9],xmm4[9],xmm6[10],xmm4[10],xmm6[11],xmm4[11],xmm6[12],xmm4[12],xmm6[13],xmm4[13],xmm6[14],xmm4[14],xmm6[15],xmm4[15]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm6[0,1,2,3,5,6,7,7]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,3]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm8[8],xmm11[9],xmm8[9],xmm11[10],xmm8[10],xmm11[11],xmm8[11],xmm11[12],xmm8[12],xmm11[13],xmm8[13],xmm11[14],xmm8[14],xmm11[15],xmm8[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[3,3,3,3]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm11[0,0,1,1]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[1,0,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,1,0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm6, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa (%r9), %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm7
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm5[0],xmm12[1],xmm5[1],xmm12[2],xmm5[2],xmm12[3],xmm5[3],xmm12[4],xmm5[4],xmm12[5],xmm5[5],xmm12[6],xmm5[6],xmm12[7],xmm5[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[2,2,3,3]
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1],xmm2[2],xmm4[2],xmm2[3],xmm4[3],xmm2[4],xmm4[4],xmm2[5],xmm4[5],xmm2[6],xmm4[6],xmm2[7],xmm4[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,5,6,7,7]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,2,2,3]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm8[0],xmm10[1],xmm8[1],xmm10[2],xmm8[2],xmm10[3],xmm8[3],xmm10[4],xmm8[4],xmm10[5],xmm8[5],xmm10[6],xmm8[6],xmm10[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm10[3,3,3,3]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsp) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[0,0,1,1]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm4[1,0,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    pand %xmm15, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm12[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm6[8],xmm0[9],xmm6[9],xmm0[10],xmm6[10],xmm0[11],xmm6[11],xmm0[12],xmm6[12],xmm0[13],xmm6[13],xmm0[14],xmm6[14],xmm0[15],xmm6[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,2,3,3]
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa (%rdx), %xmm8
; SSE-NEXT:    movdqa (%rcx), %xmm7
; SSE-NEXT:    movdqa %xmm8, %xmm13
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm7[8],xmm13[9],xmm7[9],xmm13[10],xmm7[10],xmm13[11],xmm7[11],xmm13[12],xmm7[12],xmm13[13],xmm7[13],xmm13[14],xmm7[14],xmm13[15],xmm7[15]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm13[0,1,2,3,5,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[2,2,2,3]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa (%rsi), %xmm10
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm10[8],xmm5[9],xmm10[9],xmm5[10],xmm10[10],xmm5[11],xmm10[11],xmm5[12],xmm10[12],xmm5[13],xmm10[13],xmm5[14],xmm10[14],xmm5[15],xmm10[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[3,3,3,3]
; SSE-NEXT:    movdqa %xmm15, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    pand %xmm15, %xmm6
; SSE-NEXT:    por %xmm6, %xmm14
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm13[1,0,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,1,1]
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm9
; SSE-NEXT:    pandn %xmm1, %xmm9
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    punpcklbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[0],mem[0],xmm2[1],mem[1],xmm2[2],mem[2],xmm2[3],mem[3],xmm2[4],mem[4],xmm2[5],mem[5],xmm2[6],mem[6],xmm2[7],mem[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,2,3,3]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3],xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,5,6,7,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,2,2,3]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm10[0],xmm4[1],xmm10[1],xmm4[2],xmm10[2],xmm4[3],xmm10[3],xmm4[4],xmm10[4],xmm4[5],xmm10[5],xmm4[6],xmm10[6],xmm4[7],xmm10[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[3,3,3,3]
; SSE-NEXT:    movdqa %xmm15, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm6
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[1,0,2,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,0,1,1]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,0,0,0]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm7
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[1,1,2,2]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    pshufd $165, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,1,2,2]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    pshuflw $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm15, %xmm11
; SSE-NEXT:    pandn %xmm7, %xmm11
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    pshufd $165, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,1,2,2]
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[1,1,2,2]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    pshuflw $255, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm15, %xmm12
; SSE-NEXT:    pandn %xmm7, %xmm12
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,2,2]
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    pshufd $165, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,1,2,2]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm13[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,4,4]
; SSE-NEXT:    movdqa %xmm15, %xmm7
; SSE-NEXT:    pandn %xmm5, %xmm7
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,2,2]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[3,3,3,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    por %xmm3, %xmm15
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm15, 16(%rax)
; SSE-NEXT:    movdqa %xmm7, 64(%rax)
; SSE-NEXT:    movdqa %xmm12, 112(%rax)
; SSE-NEXT:    movdqa %xmm11, 160(%rax)
; SSE-NEXT:    movdqa %xmm1, (%rax)
; SSE-NEXT:    movdqa %xmm6, 32(%rax)
; SSE-NEXT:    movdqa %xmm9, 48(%rax)
; SSE-NEXT:    movdqa %xmm14, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    addq $56, %rsp
; SSE-NEXT:    retq
;
; AVX1-LABEL: store_i8_stride6_vf32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa 16(%rsi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm13 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm13[0,0,1,1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm13[1,1,2,2]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps {{.*#+}} ymm9 = [65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535]
; AVX1-NEXT:    vandps %ymm0, %ymm9, %ymm0
; AVX1-NEXT:    vmovdqa 16(%rcx), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa 16(%rdx), %xmm2
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm6[1,0,2,2,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm6[3,3,3,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,4,4]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vandnps %ymm1, %ymm9, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovaps {{.*#+}} ymm14 = [65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535,65535,0,65535]
; AVX1-NEXT:    vandps %ymm0, %ymm14, %ymm0
; AVX1-NEXT:    vmovdqa (%r9), %xmm2
; AVX1-NEXT:    vmovdqa 16(%r9), %xmm4
; AVX1-NEXT:    vmovdqa (%r8), %xmm7
; AVX1-NEXT:    vmovdqa 16(%r8), %xmm3
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3],xmm3[4],xmm4[4],xmm3[5],xmm4[5],xmm3[6],xmm4[6],xmm3[7],xmm4[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm8 = xmm1[0,0,0,0]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[1,1,2,2]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm8, %ymm5
; AVX1-NEXT:    vandnps %ymm5, %ymm14, %ymm5
; AVX1-NEXT:    vorps %ymm5, %ymm0, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm7[0],xmm2[0],xmm7[1],xmm2[1],xmm7[2],xmm2[2],xmm7[3],xmm2[3],xmm7[4],xmm2[4],xmm7[5],xmm2[5],xmm7[6],xmm2[6],xmm7[7],xmm2[7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm8[2,2,3,3]
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm15 = xmm7[8],xmm2[8],xmm7[9],xmm2[9],xmm7[10],xmm2[10],xmm7[11],xmm2[11],xmm7[12],xmm2[12],xmm7[13],xmm2[13],xmm7[14],xmm2[14],xmm7[15],xmm2[15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm15[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vmovdqa (%rcx), %xmm5
; AVX1-NEXT:    vmovdqa (%rdx), %xmm7
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3],xmm7[4],xmm5[4],xmm7[5],xmm5[5],xmm7[6],xmm5[6],xmm7[7],xmm5[7]
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm10 = xmm7[8],xmm5[8],xmm7[9],xmm5[9],xmm7[10],xmm5[10],xmm7[11],xmm5[11],xmm7[12],xmm5[12],xmm7[13],xmm5[13],xmm7[14],xmm5[14],xmm7[15],xmm5[15]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm2[0,1,2,3,5,6,7,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,2,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm11 = xmm10[1,0,2,2,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm11[0,1,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX1-NEXT:    vandnps %ymm0, %ymm9, %ymm0
; AVX1-NEXT:    vandps %ymm5, %ymm9, %ymm5
; AVX1-NEXT:    vorps %ymm0, %ymm5, %ymm11
; AVX1-NEXT:    vmovdqa (%rsi), %xmm7
; AVX1-NEXT:    vmovdqa (%rdi), %xmm5
; AVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm5[0],xmm7[0],xmm5[1],xmm7[1],xmm5[2],xmm7[2],xmm5[3],xmm7[3],xmm5[4],xmm7[4],xmm5[5],xmm7[5],xmm5[6],xmm7[6],xmm5[7],xmm7[7]
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm5[8],xmm7[8],xmm5[9],xmm7[9],xmm5[10],xmm7[10],xmm5[11],xmm7[11],xmm5[12],xmm7[12],xmm5[13],xmm7[13],xmm5[14],xmm7[14],xmm5[15],xmm7[15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm12 = xmm7[0,0,1,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm12, %ymm5, %ymm5
; AVX1-NEXT:    vandps %ymm14, %ymm11, %ymm11
; AVX1-NEXT:    vandnps %ymm5, %ymm14, %ymm5
; AVX1-NEXT:    vorps %ymm5, %ymm11, %ymm12
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm4[8],xmm3[9],xmm4[9],xmm3[10],xmm4[10],xmm3[11],xmm4[11],xmm3[12],xmm4[12],xmm3[13],xmm4[13],xmm3[14],xmm4[14],xmm3[15],xmm4[15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,2,3,3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm4[0,0,0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm3
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm11 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm11 = xmm1[8],mem[8],xmm1[9],mem[9],xmm1[10],mem[10],xmm1[11],mem[11],xmm1[12],mem[12],xmm1[13],mem[13],xmm1[14],mem[14],xmm1[15],mem[15]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm6[0,1,2,3,5,6,7,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm11[1,0,2,2,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,1,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX1-NEXT:    vandnps %ymm3, %ymm9, %ymm3
; AVX1-NEXT:    vandps %ymm5, %ymm9, %ymm5
; AVX1-NEXT:    vorps %ymm3, %ymm5, %ymm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm13[3,3,3,3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm6 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm6 = xmm1[8],mem[8],xmm1[9],mem[9],xmm1[10],mem[10],xmm1[11],mem[11],xmm1[12],mem[12],xmm1[13],mem[13],xmm1[14],mem[14],xmm1[15],mem[15]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm6[0,0,1,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX1-NEXT:    vandps %ymm3, %ymm14, %ymm3
; AVX1-NEXT:    vandnps %ymm1, %ymm14, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm3, %ymm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,0,1,1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,2,2]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm2[1,0,2,2,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,0,1]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[3,3,3,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,4,4]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vandps %ymm0, %ymm9, %ymm0
; AVX1-NEXT:    vandnps %ymm1, %ymm9, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm8[0,0,0,0]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm8[1,1,2,2]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vandps %ymm0, %ymm14, %ymm0
; AVX1-NEXT:    vandnps %ymm1, %ymm14, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm7[1,1,2,2]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm7[3,3,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm15[1,1,2,2]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm15[2,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    vandnps %ymm0, %ymm9, %ymm0
; AVX1-NEXT:    vandps %ymm1, %ymm9, %ymm1
; AVX1-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm10[3,3,3,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,4,4]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm10[0,1,2,3,5,6,7,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    vandps %ymm0, %ymm14, %ymm0
; AVX1-NEXT:    vandnps %ymm1, %ymm14, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm6[1,1,2,2]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm6[3,3,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[1,1,2,2]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,3,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-NEXT:    vandnps %ymm1, %ymm9, %ymm1
; AVX1-NEXT:    vandps %ymm4, %ymm9, %ymm4
; AVX1-NEXT:    vorps %ymm1, %ymm4, %ymm1
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm11[3,3,3,3,4,5,6,7]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm11[0,1,2,3,5,6,7,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,2,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm4
; AVX1-NEXT:    vandps %ymm1, %ymm14, %ymm1
; AVX1-NEXT:    vandnps %ymm4, %ymm14, %ymm4
; AVX1-NEXT:    vorps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps %ymm1, 160(%rax)
; AVX1-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-NEXT:    vmovaps %ymm2, (%rax)
; AVX1-NEXT:    vmovaps %ymm3, 128(%rax)
; AVX1-NEXT:    vmovaps %ymm12, 32(%rax)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i8_stride6_vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $24, %rsp
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm8
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm11
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm12
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %ymm9
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = <5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm0, %xmm2, %xmm1
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, %xmm15
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-SLOW-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[0,0,0,1]
; AVX2-SLOW-NEXT:    vmovdqa (%r9), %xmm7
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm2 = <6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm7, %xmm3
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm5
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3],xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm1, %ymm2, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = <5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm4, %ymm13
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, %ymm0
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm11, %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm3[0],ymm13[0],ymm3[1],ymm13[1],ymm3[2],ymm13[2],ymm3[3],ymm13[3],ymm3[4],ymm13[4],ymm3[5],ymm13[5],ymm3[6],ymm13[6],ymm3[7],ymm13[7],ymm3[16],ymm13[16],ymm3[17],ymm13[17],ymm3[18],ymm13[18],ymm3[19],ymm13[19],ymm3[20],ymm13[20],ymm3[21],ymm13[21],ymm3[22],ymm13[22],ymm3[23],ymm13[23]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = <6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u,6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm13, %ymm9, %ymm14
; AVX2-SLOW-NEXT:    vpshufb %ymm13, %ymm12, %ymm13
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} ymm13 = ymm13[0],ymm14[0],ymm13[1],ymm14[1],ymm13[2],ymm14[2],ymm13[3],ymm14[3],ymm13[4],ymm14[4],ymm13[5],ymm14[5],ymm13[6],ymm14[6],ymm13[7],ymm14[7],ymm13[16],ymm14[16],ymm13[17],ymm14[17],ymm13[18],ymm14[18],ymm13[19],ymm14[19],ymm13[20],ymm14[20],ymm13[21],ymm14[21],ymm13[22],ymm14[22],ymm13[23],ymm14[23]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm3, %ymm13, %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,3,2,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,5]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm6[0],xmm15[0],xmm6[1],xmm15[1],xmm6[2],xmm15[2],xmm6[3],xmm15[3],xmm6[4],xmm15[4],xmm6[5],xmm15[5],xmm6[6],xmm15[6],xmm6[7],xmm15[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[1,0,3,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm15
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm8[0],ymm15[0],ymm8[1],ymm15[1],ymm8[2],ymm15[2],ymm8[3],ymm15[3],ymm8[4],ymm15[4],ymm8[5],ymm15[5],ymm8[6],ymm15[6],ymm8[7],ymm15[7],ymm8[16],ymm15[16],ymm8[17],ymm15[17],ymm8[18],ymm15[18],ymm8[19],ymm15[19],ymm8[20],ymm15[20],ymm8[21],ymm15[21],ymm8[22],ymm15[22],ymm8[23],ymm15[23]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm3[0,3,2,1,4,5,6,7,8,11,10,9,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5,6,5,8,9,10,11,12,13,14,13]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} ymm4 = ymm11[0],ymm0[0],ymm11[1],ymm0[1],ymm11[2],ymm0[2],ymm11[3],ymm0[3],ymm11[4],ymm0[4],ymm11[5],ymm0[5],ymm11[6],ymm0[6],ymm11[7],ymm0[7],ymm11[16],ymm0[16],ymm11[17],ymm0[17],ymm11[18],ymm0[18],ymm11[19],ymm0[19],ymm11[20],ymm0[20],ymm11[21],ymm0[21],ymm11[22],ymm0[22],ymm11[23],ymm0[23]
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, %ymm11
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm4[1,0,3,2,4,5,6,7,9,8,11,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm3, %ymm4, %ymm3
; AVX2-SLOW-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm7[8],xmm5[9],xmm7[9],xmm5[10],xmm7[10],xmm5[11],xmm7[11],xmm5[12],xmm7[12],xmm5[13],xmm7[13],xmm5[14],xmm7[14],xmm5[15],xmm7[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[4,5,10,11,8,9,6,7,12,13,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,0,1]
; AVX2-SLOW-NEXT:    vpunpckhbw {{.*#+}} xmm13 = xmm2[8],xmm1[8],xmm2[9],xmm1[9],xmm2[10],xmm1[10],xmm2[11],xmm1[11],xmm2[12],xmm1[12],xmm2[13],xmm1[13],xmm2[14],xmm1[14],xmm2[15],xmm1[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[8,9,6,7,12,13,10,11,14,15,14,15,14,15,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,0,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm4, %ymm13, %ymm4
; AVX2-SLOW-NEXT:    vpunpckhbw {{.*#+}} ymm13 = ymm12[8],ymm9[8],ymm12[9],ymm9[9],ymm12[10],ymm9[10],ymm12[11],ymm9[11],ymm12[12],ymm9[12],ymm12[13],ymm9[13],ymm12[14],ymm9[14],ymm12[15],ymm9[15],ymm12[24],ymm9[24],ymm12[25],ymm9[25],ymm12[26],ymm9[26],ymm12[27],ymm9[27],ymm12[28],ymm9[28],ymm12[29],ymm9[29],ymm12[30],ymm9[30],ymm12[31],ymm9[31]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20,21,26,27,24,25,22,23,28,29,26,27,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckhbw {{.*#+}} ymm14 = ymm8[8],ymm15[8],ymm8[9],ymm15[9],ymm8[10],ymm15[10],ymm8[11],ymm15[11],ymm8[12],ymm15[12],ymm8[13],ymm15[13],ymm8[14],ymm15[14],ymm8[15],ymm15[15],ymm8[24],ymm15[24],ymm8[25],ymm15[25],ymm8[26],ymm15[26],ymm8[27],ymm15[27],ymm8[28],ymm15[28],ymm8[29],ymm15[29],ymm8[30],ymm15[30],ymm8[31],ymm15[31]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm14 = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,22,23,28,29,26,27,30,31,30,31,30,31,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[2,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm13, %ymm14, %ymm10
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm13 = <u,u,u,u,u,u,u,u,8,7,6,9,u,u,10,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufb %xmm13, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm2[8],xmm1[8],xmm2[9],xmm1[9],xmm2[10],xmm1[10],xmm2[11],xmm1[11],xmm2[12],xmm1[12],xmm2[13],xmm1[13],xmm2[14],xmm1[14],xmm2[15],xmm1[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm13 = <8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,u,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %ymm13, %ymm15, %ymm14
; AVX2-SLOW-NEXT:    vpshufb %ymm13, %ymm8, %ymm8
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} ymm8 = ymm8[0],ymm14[0],ymm8[1],ymm14[1],ymm8[2],ymm14[2],ymm8[3],ymm14[3],ymm8[4],ymm14[4],ymm8[5],ymm14[5],ymm8[6],ymm14[6],ymm8[7],ymm14[7],ymm8[16],ymm14[16],ymm8[17],ymm14[17],ymm8[18],ymm14[18],ymm8[19],ymm14[19],ymm8[20],ymm14[20],ymm8[21],ymm14[21],ymm8[22],ymm14[22],ymm8[23],ymm14[23]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm5[0],xmm7[0],xmm5[1],xmm7[1],xmm5[2],xmm7[2],xmm5[3],xmm7[3],xmm5[4],xmm7[4],xmm5[5],xmm7[5],xmm5[6],xmm7[6],xmm5[7],xmm7[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,4,4]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    vpunpcklbw {{.*#+}} ymm5 = ymm12[0],ymm9[0],ymm12[1],ymm9[1],ymm12[2],ymm9[2],ymm12[3],ymm9[3],ymm12[4],ymm9[4],ymm12[5],ymm9[5],ymm12[6],ymm9[6],ymm12[7],ymm9[7],ymm12[16],ymm9[16],ymm12[17],ymm9[17],ymm12[18],ymm9[18],ymm12[19],ymm9[19],ymm12[20],ymm9[20],ymm12[21],ymm9[21],ymm12[22],ymm9[22],ymm12[23],ymm9[23]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm5[2,1,0,3,4,5,6,7,10,9,8,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm3, %ymm5, %ymm3
; AVX2-SLOW-NEXT:    vpunpckhbw {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm5 # 16-byte Folded Reload
; AVX2-SLOW-NEXT:    # xmm5 = xmm6[8],mem[8],xmm6[9],mem[9],xmm6[10],mem[10],xmm6[11],mem[11],xmm6[12],mem[12],xmm6[13],mem[13],xmm6[14],mem[14],xmm6[15],mem[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[10,11,8,9,6,7,12,13,14,15,14,15,14,15,14,15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm5[8],ymm11[8],ymm5[9],ymm11[9],ymm5[10],ymm11[10],ymm5[11],ymm11[11],ymm5[12],ymm11[12],ymm5[13],ymm11[13],ymm5[14],ymm11[14],ymm5[15],ymm11[15],ymm5[24],ymm11[24],ymm5[25],ymm11[25],ymm5[26],ymm11[26],ymm5[27],ymm11[27],ymm5[28],ymm11[28],ymm5[29],ymm11[29],ymm5[30],ymm11[30],ymm5[31],ymm11[31]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,22,23,28,29,30,31,30,31,30,31,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm10, %ymm5, %ymm2
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 128(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 160(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, 64(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 32(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 96(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-SLOW-NEXT:    addq $24, %rsp
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i8_stride6_vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $72, %rsp
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %ymm11
; AVX2-FAST-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %ymm3
; AVX2-FAST-NEXT:    vmovdqa (%r8), %ymm8
; AVX2-FAST-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%r9), %ymm6
; AVX2-FAST-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = <5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm2, %xmm1
; AVX2-FAST-NEXT:    vmovdqa %xmm2, %xmm7
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm15
; AVX2-FAST-NEXT:    vpshufb %xmm0, %xmm15, %xmm0
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-FAST-NEXT:    vmovdqa (%r9), %xmm14
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = <6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm14, %xmm2
; AVX2-FAST-NEXT:    vmovdqa (%r8), %xmm4
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,0,0,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255,0,0,u,u,255,255>
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = <5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm2, %ymm3, %ymm12
; AVX2-FAST-NEXT:    vmovdqa %ymm3, %ymm10
; AVX2-FAST-NEXT:    vpshufb %ymm2, %ymm11, %ymm2
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm12[0],ymm2[1],ymm12[1],ymm2[2],ymm12[2],ymm2[3],ymm12[3],ymm2[4],ymm12[4],ymm2[5],ymm12[5],ymm2[6],ymm12[6],ymm2[7],ymm12[7],ymm2[16],ymm12[16],ymm2[17],ymm12[17],ymm2[18],ymm12[18],ymm2[19],ymm12[19],ymm2[20],ymm12[20],ymm2[21],ymm12[21],ymm2[22],ymm12[22],ymm2[23],ymm12[23]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u,6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm6, %ymm13
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm8, %ymm12
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} ymm12 = ymm12[0],ymm13[0],ymm12[1],ymm13[1],ymm12[2],ymm13[2],ymm12[3],ymm13[3],ymm12[4],ymm13[4],ymm12[5],ymm13[5],ymm12[6],ymm13[6],ymm12[7],ymm13[7],ymm12[16],ymm13[16],ymm12[17],ymm13[17],ymm12[18],ymm13[18],ymm12[19],ymm13[19],ymm12[20],ymm13[20],ymm12[21],ymm13[21],ymm12[22],ymm13[22],ymm12[23],ymm13[23]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm2, %ymm12, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm4[8],xmm14[8],xmm4[9],xmm14[9],xmm4[10],xmm14[10],xmm4[11],xmm14[11],xmm4[12],xmm14[12],xmm4[13],xmm14[13],xmm4[14],xmm14[14],xmm4[15],xmm14[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,5,10,11,8,9,6,7,12,13,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-FAST-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[8,9,6,7,12,13,10,11,14,15,14,15,14,15,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,1,6,7,4,5,2,3,8,9,10,11,12,13,10,11]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm15[0],xmm7[0],xmm15[1],xmm7[1],xmm15[2],xmm7[2],xmm15[3],xmm7[3],xmm15[4],xmm7[4],xmm15[5],xmm7[5],xmm15[6],xmm7[6],xmm15[7],xmm7[7]
; AVX2-FAST-NEXT:    vmovdqa %xmm7, %xmm11
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[2,3,0,1,6,7,4,5,8,9,8,9,8,9,8,9]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqa (%rsi), %ymm3
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} ymm12 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[4],ymm3[4],ymm2[5],ymm3[5],ymm2[6],ymm3[6],ymm2[7],ymm3[7],ymm2[16],ymm3[16],ymm2[17],ymm3[17],ymm2[18],ymm3[18],ymm2[19],ymm3[19],ymm2[20],ymm3[20],ymm2[21],ymm3[21],ymm2[22],ymm3[22],ymm2[23],ymm3[23]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm12 = ymm12[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,17,22,23,20,21,18,19,24,25,26,27,28,29,26,27]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[2,2,2,3]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} ymm13 = ymm7[0],ymm10[0],ymm7[1],ymm10[1],ymm7[2],ymm10[2],ymm7[3],ymm10[3],ymm7[4],ymm10[4],ymm7[5],ymm10[5],ymm7[6],ymm10[6],ymm7[7],ymm10[7],ymm7[16],ymm10[16],ymm7[17],ymm10[17],ymm7[18],ymm10[18],ymm7[19],ymm10[19],ymm7[20],ymm10[20],ymm7[21],ymm10[21],ymm7[22],ymm10[22],ymm7[23],ymm10[23]
; AVX2-FAST-NEXT:    vmovdqa %ymm10, %ymm8
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,16,17,22,23,20,21,24,25,24,25,24,25,24,25]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm12, %ymm13, %ymm12
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FAST-NEXT:    vpunpckhbw {{.*#+}} ymm13 = ymm5[8],ymm6[8],ymm5[9],ymm6[9],ymm5[10],ymm6[10],ymm5[11],ymm6[11],ymm5[12],ymm6[12],ymm5[13],ymm6[13],ymm5[14],ymm6[14],ymm5[15],ymm6[15],ymm5[24],ymm6[24],ymm5[25],ymm6[25],ymm5[26],ymm6[26],ymm5[27],ymm6[27],ymm5[28],ymm6[28],ymm5[29],ymm6[29],ymm5[30],ymm6[30],ymm5[31],ymm6[31]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm13 = ymm13[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20,21,26,27,24,25,22,23,28,29,26,27,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-FAST-NEXT:    vpunpckhbw {{.*#+}} ymm10 = ymm2[8],ymm3[8],ymm2[9],ymm3[9],ymm2[10],ymm3[10],ymm2[11],ymm3[11],ymm2[12],ymm3[12],ymm2[13],ymm3[13],ymm2[14],ymm3[14],ymm2[15],ymm3[15],ymm2[24],ymm3[24],ymm2[25],ymm3[25],ymm2[26],ymm3[26],ymm2[27],ymm3[27],ymm2[28],ymm3[28],ymm2[29],ymm3[29],ymm2[30],ymm3[30],ymm2[31],ymm3[31]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,24,25,22,23,28,29,26,27,30,31,30,31,30,31,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm9, %ymm13, %ymm10, %ymm9
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = <u,u,u,u,u,u,u,u,8,7,6,9,u,u,10,u>
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,u,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm10, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpshufb %ymm10, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[4],ymm3[4],ymm2[5],ymm3[5],ymm2[6],ymm3[6],ymm2[7],ymm3[7],ymm2[16],ymm3[16],ymm2[17],ymm3[17],ymm2[18],ymm3[18],ymm2[19],ymm3[19],ymm2[20],ymm3[20],ymm2[21],ymm3[21],ymm2[22],ymm3[22],ymm2[23],ymm3[23]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, (%rsp), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm15[8],xmm11[8],xmm15[9],xmm11[9],xmm15[10],xmm11[10],xmm15[11],xmm11[11],xmm15[12],xmm11[12],xmm15[13],xmm11[13],xmm15[14],xmm11[14],xmm15[15],xmm11[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[10,11,8,9,6,7,12,13,14,15,14,15,14,15,14,15]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm4[0],xmm14[0],xmm4[1],xmm14[1],xmm4[2],xmm14[2],xmm4[3],xmm14[3],xmm4[4],xmm14[4],xmm4[5],xmm14[5],xmm4[6],xmm14[6],xmm4[7],xmm14[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[4,5,2,3,0,1,6,7,8,9,8,9,8,9,8,9]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,0,0,1]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    vpunpcklbw {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[4],ymm6[4],ymm5[5],ymm6[5],ymm5[6],ymm6[6],ymm5[7],ymm6[7],ymm5[16],ymm6[16],ymm5[17],ymm6[17],ymm5[18],ymm6[18],ymm5[19],ymm6[19],ymm5[20],ymm6[20],ymm5[21],ymm6[21],ymm5[22],ymm6[22],ymm5[23],ymm6[23]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,20,21,18,19,16,17,22,23,24,25,24,25,24,25,24,25]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm12, %ymm5, %ymm5
; AVX2-FAST-NEXT:    vpunpckhbw {{.*#+}} ymm6 = ymm7[8],ymm8[8],ymm7[9],ymm8[9],ymm7[10],ymm8[10],ymm7[11],ymm8[11],ymm7[12],ymm8[12],ymm7[13],ymm8[13],ymm7[14],ymm8[14],ymm7[15],ymm8[15],ymm7[24],ymm8[24],ymm7[25],ymm8[25],ymm7[26],ymm8[26],ymm7[27],ymm8[27],ymm7[28],ymm8[28],ymm7[29],ymm8[29],ymm7[30],ymm8[30],ymm7[31],ymm8[31]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,24,25,22,23,28,29,30,31,30,31,30,31,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,3]
; AVX2-FAST-NEXT:    vpblendvb %ymm1, %ymm9, %ymm6, %ymm1
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm2, 128(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, 160(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, 96(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, (%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 32(%rax)
; AVX2-FAST-NEXT:    addq $72, %rsp
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: store_i8_stride6_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %ymm8
; AVX512-NEXT:    vmovdqa (%rsi), %ymm9
; AVX512-NEXT:    vmovdqa (%rdx), %ymm10
; AVX512-NEXT:    vmovdqa (%rcx), %ymm11
; AVX512-NEXT:    vmovdqa (%r8), %ymm12
; AVX512-NEXT:    vmovdqa (%r9), %ymm13
; AVX512-NEXT:    vmovdqa (%rsi), %xmm6
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,u,u,u,u,u,u,8,7,6,9,u,u,10,u>
; AVX512-NEXT:    vpshufb %xmm7, %xmm6, %xmm0
; AVX512-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512-NEXT:    vpshufb %xmm7, %xmm1, %xmm7
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm7[8],xmm0[8],xmm7[9],xmm0[9],xmm7[10],xmm0[10],xmm7[11],xmm0[11],xmm7[12],xmm0[12],xmm7[13],xmm0[13],xmm7[14],xmm0[14],xmm7[15],xmm0[15]
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX512-NEXT:    vmovdqa (%rcx), %xmm14
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm2 = <5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm2, %xmm14, %xmm3
; AVX512-NEXT:    vmovdqa (%rdx), %xmm4
; AVX512-NEXT:    vpshufb %xmm2, %xmm4, %xmm2
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1],xmm2[2],xmm3[2],xmm2[3],xmm3[3],xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,0,0,1]
; AVX512-NEXT:    movw $18724, %cx # imm = 0x4924
; AVX512-NEXT:    kmovd %ecx, %k1
; AVX512-NEXT:    vmovdqu16 %ymm0, %ymm2 {%k1}
; AVX512-NEXT:    vmovdqa (%r9), %xmm0
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm3 = <6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %xmm3, %xmm0, %xmm5
; AVX512-NEXT:    vmovdqa (%r8), %xmm7
; AVX512-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3],xmm3[4],xmm5[4],xmm3[5],xmm5[5],xmm3[6],xmm5[6],xmm3[7],xmm5[7]
; AVX512-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,0,0,1]
; AVX512-NEXT:    movw $9362, %cx # imm = 0x2492
; AVX512-NEXT:    kmovd %ecx, %k2
; AVX512-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k2}
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm5 = [0,3,2,1,0,3,2,1,0,3,2,1,4,5,6,5]
; AVX512-NEXT:    vpermw %ymm3, %ymm5, %ymm3
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm4[0],xmm14[0],xmm4[1],xmm14[1],xmm4[2],xmm14[2],xmm4[3],xmm14[3],xmm4[4],xmm14[4],xmm4[5],xmm14[5],xmm4[6],xmm14[6],xmm4[7],xmm14[7]
; AVX512-NEXT:    vprold $16, %xmm5, %xmm5
; AVX512-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,0,0,1]
; AVX512-NEXT:    vmovdqu16 %ymm5, %ymm3 {%k2}
; AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm7[0],xmm0[0],xmm7[1],xmm0[1],xmm7[2],xmm0[2],xmm7[3],xmm0[3],xmm7[4],xmm0[4],xmm7[5],xmm0[5],xmm7[6],xmm0[6],xmm7[7],xmm0[7]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm15 = [2,1,0,3,2,1,0,3,2,1,0,3,4,4,4,4]
; AVX512-NEXT:    vpermw %ymm5, %ymm15, %ymm3 {%k1}
; AVX512-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm12[0],ymm13[0],ymm12[1],ymm13[1],ymm12[2],ymm13[2],ymm12[3],ymm13[3],ymm12[4],ymm13[4],ymm12[5],ymm13[5],ymm12[6],ymm13[6],ymm12[7],ymm13[7],ymm12[16],ymm13[16],ymm12[17],ymm13[17],ymm12[18],ymm13[18],ymm12[19],ymm13[19],ymm12[20],ymm13[20],ymm12[21],ymm13[21],ymm12[22],ymm13[22],ymm12[23],ymm13[23]
; AVX512-NEXT:    vpunpcklbw {{.*#+}} ymm5 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[4],ymm9[4],ymm8[5],ymm9[5],ymm8[6],ymm9[6],ymm8[7],ymm9[7],ymm8[16],ymm9[16],ymm8[17],ymm9[17],ymm8[18],ymm9[18],ymm8[19],ymm9[19],ymm8[20],ymm9[20],ymm8[21],ymm9[21],ymm8[22],ymm9[22],ymm8[23],ymm9[23]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm15 = [8,11,10,9,8,11,10,9,8,11,10,9,12,13,14,13]
; AVX512-NEXT:    vpermw %ymm5, %ymm15, %ymm5
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm15 = [10,9,8,11,10,9,8,11,10,9,8,11,12,12,12,12]
; AVX512-NEXT:    vpermw %ymm3, %ymm15, %ymm5 {%k1}
; AVX512-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm10[0],ymm11[0],ymm10[1],ymm11[1],ymm10[2],ymm11[2],ymm10[3],ymm11[3],ymm10[4],ymm11[4],ymm10[5],ymm11[5],ymm10[6],ymm11[6],ymm10[7],ymm11[7],ymm10[16],ymm11[16],ymm10[17],ymm11[17],ymm10[18],ymm11[18],ymm10[19],ymm11[19],ymm10[20],ymm11[20],ymm10[21],ymm11[21],ymm10[22],ymm11[22],ymm10[23],ymm11[23]
; AVX512-NEXT:    vprold $16, %ymm3, %ymm3
; AVX512-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,3]
; AVX512-NEXT:    vmovdqu16 %ymm3, %ymm5 {%k2}
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm7[8],xmm0[8],xmm7[9],xmm0[9],xmm7[10],xmm0[10],xmm7[11],xmm0[11],xmm7[12],xmm0[12],xmm7[13],xmm0[13],xmm7[14],xmm0[14],xmm7[15],xmm0[15]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm3 = [2,5,4,3,2,5,4,3,2,5,4,3,6,5,6,7]
; AVX512-NEXT:    vpermw %ymm0, %ymm3, %ymm0
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm3 = [4,3,6,5,4,3,6,5,4,3,6,5,7,7,7,7]
; AVX512-NEXT:    vpermw %ymm1, %ymm3, %ymm0 {%k2}
; AVX512-NEXT:    vpunpckhbw {{.*#+}} xmm1 = xmm4[8],xmm14[8],xmm4[9],xmm14[9],xmm4[10],xmm14[10],xmm4[11],xmm14[11],xmm4[12],xmm14[12],xmm4[13],xmm14[13],xmm4[14],xmm14[14],xmm4[15],xmm14[15]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm3 = [5,4,3,6,5,4,3,6,5,4,3,6,7,7,7,7]
; AVX512-NEXT:    vpermw %ymm1, %ymm3, %ymm0 {%k1}
; AVX512-NEXT:    vinserti64x4 $1, %ymm5, %zmm0, %zmm0
; AVX512-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm10[8],ymm11[8],ymm10[9],ymm11[9],ymm10[10],ymm11[10],ymm10[11],ymm11[11],ymm10[12],ymm11[12],ymm10[13],ymm11[13],ymm10[14],ymm11[14],ymm10[15],ymm11[15],ymm10[24],ymm11[24],ymm10[25],ymm11[25],ymm10[26],ymm11[26],ymm10[27],ymm11[27],ymm10[28],ymm11[28],ymm10[29],ymm11[29],ymm10[30],ymm11[30],ymm10[31],ymm11[31]
; AVX512-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm12[8],ymm13[8],ymm12[9],ymm13[9],ymm12[10],ymm13[10],ymm12[11],ymm13[11],ymm12[12],ymm13[12],ymm12[13],ymm13[13],ymm12[14],ymm13[14],ymm12[15],ymm13[15],ymm12[24],ymm13[24],ymm12[25],ymm13[25],ymm12[26],ymm13[26],ymm12[27],ymm13[27],ymm12[28],ymm13[28],ymm12[29],ymm13[29],ymm12[30],ymm13[30],ymm12[31],ymm13[31]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [10,13,12,11,10,13,12,11,10,13,12,11,14,13,14,15]
; AVX512-NEXT:    vpermw %ymm3, %ymm4, %ymm3
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [13,12,11,14,13,12,11,14,13,12,11,14,15,15,15,15]
; AVX512-NEXT:    vpermw %ymm1, %ymm4, %ymm3 {%k1}
; AVX512-NEXT:    vpunpckhbw {{.*#+}} ymm1 = ymm8[8],ymm9[8],ymm8[9],ymm9[9],ymm8[10],ymm9[10],ymm8[11],ymm9[11],ymm8[12],ymm9[12],ymm8[13],ymm9[13],ymm8[14],ymm9[14],ymm8[15],ymm9[15],ymm8[24],ymm9[24],ymm8[25],ymm9[25],ymm8[26],ymm9[26],ymm8[27],ymm9[27],ymm8[28],ymm9[28],ymm8[29],ymm9[29],ymm8[30],ymm9[30],ymm8[31],ymm9[31]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [12,11,14,13,12,11,14,13,12,11,14,13,15,15,15,15]
; AVX512-NEXT:    vpermw %ymm1, %ymm4, %ymm3 {%k2}
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = <6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u,6,5,8,7,u,9,u,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %ymm1, %ymm13, %ymm4
; AVX512-NEXT:    vpshufb %ymm1, %ymm12, %ymm1
; AVX512-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[1],ymm4[1],ymm1[2],ymm4[2],ymm1[3],ymm4[3],ymm1[4],ymm4[4],ymm1[5],ymm4[5],ymm1[6],ymm4[6],ymm1[7],ymm4[7],ymm1[16],ymm4[16],ymm1[17],ymm4[17],ymm1[18],ymm4[18],ymm1[19],ymm4[19],ymm1[20],ymm4[20],ymm1[21],ymm4[21],ymm1[22],ymm4[22],ymm1[23],ymm4[23]
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = <5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,5,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %ymm4, %ymm11, %ymm5
; AVX512-NEXT:    vpshufb %ymm4, %ymm10, %ymm4
; AVX512-NEXT:    vpunpcklbw {{.*#+}} ymm4 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[4],ymm5[4],ymm4[5],ymm5[5],ymm4[6],ymm5[6],ymm4[7],ymm5[7],ymm4[16],ymm5[16],ymm4[17],ymm5[17],ymm4[18],ymm5[18],ymm4[19],ymm5[19],ymm4[20],ymm5[20],ymm4[21],ymm5[21],ymm4[22],ymm5[22],ymm4[23],ymm5[23]
; AVX512-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[2,2,2,3]
; AVX512-NEXT:    vmovdqu16 %ymm1, %ymm4 {%k2}
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = <8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,u,8,7,6,9,u,u,10,u,u,u,u,u,u,u,u,u>
; AVX512-NEXT:    vpshufb %ymm1, %ymm9, %ymm5
; AVX512-NEXT:    vpshufb %ymm1, %ymm8, %ymm1
; AVX512-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[1],ymm5[1],ymm1[2],ymm5[2],ymm1[3],ymm5[3],ymm1[4],ymm5[4],ymm1[5],ymm5[5],ymm1[6],ymm5[6],ymm1[7],ymm5[7],ymm1[16],ymm5[16],ymm1[17],ymm5[17],ymm1[18],ymm5[18],ymm1[19],ymm5[19],ymm1[20],ymm5[20],ymm1[21],ymm5[21],ymm1[22],ymm5[22],ymm1[23],ymm5[23]
; AVX512-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX512-NEXT:    vmovdqu16 %ymm1, %ymm4 {%k1}
; AVX512-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, 128(%rax)
; AVX512-NEXT:    vmovdqu64 %zmm0, 64(%rax)
; AVX512-NEXT:    vmovdqu64 %zmm2, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <32 x i8>, <32 x i8>* %in.vecptr0, align 32
  %in.vec1 = load <32 x i8>, <32 x i8>* %in.vecptr1, align 32
  %in.vec2 = load <32 x i8>, <32 x i8>* %in.vecptr2, align 32
  %in.vec3 = load <32 x i8>, <32 x i8>* %in.vecptr3, align 32
  %in.vec4 = load <32 x i8>, <32 x i8>* %in.vecptr4, align 32
  %in.vec5 = load <32 x i8>, <32 x i8>* %in.vecptr5, align 32

  %concat01 = shufflevector <32 x i8> %in.vec0, <32 x i8> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %concat23 = shufflevector <32 x i8> %in.vec2, <32 x i8> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %concat45 = shufflevector <32 x i8> %in.vec4, <32 x i8> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %concat0123 = shufflevector <64 x i8> %concat01, <64 x i8> %concat23, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %concat45uu = shufflevector <64 x i8> %concat45, <64 x i8> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat012345 = shufflevector <128 x i8> %concat0123, <128 x i8> %concat45uu, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %interleaved.vec = shufflevector <192 x i8> %concat012345, <192 x i8> poison, <192 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191>

  store <192 x i8> %interleaved.vec, <192 x i8>* %out.vec, align 32

  ret void
}
