/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.IntNum;

public class ValuesMap
extends MethodProc
implements CanInline,
Inlineable {
    public static final ValuesMap valuesMap = new ValuesMap(-1);
    public static final ValuesMap valuesMapWithPos = new ValuesMap(1);
    private final int startCounter;

    private ValuesMap(int startCounter) {
        this.startCounter = startCounter;
    }

    public int numArgs() {
        return 8194;
    }

    public void apply(CallContext ctx) throws Throwable {
        Procedure proc = (Procedure)ctx.getNextArg();
        Consumer out = ctx.consumer;
        Object val = ctx.getNextArg();
        Procedure.checkArgCount(proc, 1);
        if (val instanceof Values) {
            int ipos = 0;
            int count = this.startCounter;
            Values values = (Values)val;
            while ((ipos = values.nextPos(ipos)) != 0) {
                Object v = values.getPosPrevious(ipos);
                if (this.startCounter >= 0) {
                    proc.check2(v, IntNum.make(count++), ctx);
                } else {
                    proc.check1(v, ctx);
                }
                ctx.runUntilDone();
            }
        } else {
            if (this.startCounter >= 0) {
                proc.check2(val, IntNum.make(this.startCounter), ctx);
            } else {
                proc.check1(val, ctx);
            }
            ctx.runUntilDone();
        }
    }

    private LambdaExp canInline(ApplyExp exp) {
        Expression arg0;
        Expression[] args = exp.getArgs();
        if (args.length == 2 && (arg0 = args[0]) instanceof LambdaExp) {
            LambdaExp lexp = (LambdaExp)arg0;
            if (lexp.min_args == lexp.max_args && lexp.min_args == (this.startCounter >= 0 ? 2 : 1)) {
                return lexp;
            }
        }
        return null;
    }

    public Expression inline(ApplyExp exp, ExpWalker walker) {
        LambdaExp lexp = this.canInline(exp);
        if (lexp != null) {
            lexp.setInlineOnly(true);
            lexp.returnContinuation = exp;
        }
        return exp;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        LambdaExp lambda = this.canInline(exp);
        if (lambda == null) {
            ApplyExp.compile(exp, comp, target);
            return;
        }
        Expression[] args = exp.getArgs();
        if (!(target instanceof IgnoreTarget || target instanceof ConsumerTarget || target instanceof SeriesTarget)) {
            ConsumerTarget.compileUsingConsumer(exp, comp, target);
            return;
        }
        Expression vals = args[1];
        ValuesMap.compileInlined(lambda, vals, this.startCounter, null, comp, target);
    }

    public static void compileInlined(LambdaExp lambda, Expression vals, int startCounter, Method matchesMethod, Compilation comp, Target target) {
        Declaration counterDecl;
        Variable counter;
        Declaration param = lambda.firstDecl();
        CodeAttr code = comp.getCode();
        SeriesTarget starget = new SeriesTarget();
        starget.scope = code.pushScope();
        if (startCounter >= 0) {
            counter = starget.scope.addVariable(code, Type.int_type, "position");
            code.emitPushInt(startCounter);
            code.emitStore(counter);
            counterDecl = new Declaration(counter);
        } else {
            counter = null;
            counterDecl = null;
        }
        starget.function = new Label(code);
        starget.done = target instanceof SeriesTarget ? ((SeriesTarget)target).done : new Label(code);
        if (param.isSimple()) {
            param.allocateVariable(code);
        } else {
            param = new Declaration(code.addLocal(param.getType(), param.getName()));
        }
        starget.param = param;
        ClassType retAddrType = Type.pointer_type;
        Variable retAddr = code.addLocal(retAddrType);
        vals.compileWithPosition(comp, starget);
        starget.function.define(code);
        code.pushType(retAddrType);
        code.emitStore(retAddr);
        Expression[] args = startCounter >= 0 ? new Expression[]{new ReferenceExp(param), new ReferenceExp(counterDecl)} : new Expression[]{new ReferenceExp(param)};
        Expression app = new ApplyExp(lambda, args);
        if (matchesMethod != null) {
            if (((Expression)app).getType().getImplementationType() != Type.boolean_type) {
                app = new ApplyExp(matchesMethod, new Expression[]{app, new ReferenceExp(counterDecl)});
            }
            app = new IfExp(app, new ReferenceExp(param), QuoteExp.voidExp);
        }
        if (target instanceof SeriesTarget) {
            SeriesTarget atarget = (SeriesTarget)target;
            Label done = atarget.done;
            atarget.done = null;
            ((Expression)app).compile(comp, target);
            atarget.done = done;
        } else {
            ((Expression)app).compile(comp, target);
        }
        if (startCounter >= 0) {
            code.emitInc(counter, (short)1);
        }
        code.emitRet(retAddr);
        code.popScope();
        if (!(target instanceof SeriesTarget)) {
            starget.done.define(code);
        }
    }

    public Type getReturnType(Expression[] args) {
        return Type.pointer_type;
    }
}

