/* -------------------------------------------
     This file was created with csUtility.java
#
#    Name:     cp1258 to Unicode table
#    Unicode version: 2.0
#    Table version: 2.01
#    Table format:  Format A
#    Date:          04/15/98
#
#    Contact:       cpxlate@microsoft.com
#
#    General notes: none
#
#    Format: Three tab-separated columns
#        Column #1 is the cp1258 code (in hex)
#        Column #2 is the Unicode (in hex as 0xXXXX)
#        Column #3 is the Unicode name (follows a comment sign, '#')
#
#    The entries are in cp1258 order
#
0x00	0x0000	#NULL
0x01	0x0001	#START OF HEADING
0x02	0x0002	#START OF TEXT
0x03	0x0003	#END OF TEXT
0x04	0x0004	#END OF TRANSMISSION
0x05	0x0005	#ENQUIRY
0x06	0x0006	#ACKNOWLEDGE
0x07	0x0007	#BELL
0x08	0x0008	#BACKSPACE
0x09	0x0009	#HORIZONTAL TABULATION
0x0A	0x000A	#LINE FEED
0x0B	0x000B	#VERTICAL TABULATION
0x0C	0x000C	#FORM FEED
0x0D	0x000D	#CARRIAGE RETURN
0x0E	0x000E	#SHIFT OUT
0x0F	0x000F	#SHIFT IN
0x10	0x0010	#DATA LINK ESCAPE
0x11	0x0011	#DEVICE CONTROL ONE
0x12	0x0012	#DEVICE CONTROL TWO
0x13	0x0013	#DEVICE CONTROL THREE
0x14	0x0014	#DEVICE CONTROL FOUR
0x15	0x0015	#NEGATIVE ACKNOWLEDGE
0x16	0x0016	#SYNCHRONOUS IDLE
0x17	0x0017	#END OF TRANSMISSION BLOCK
0x18	0x0018	#CANCEL
0x19	0x0019	#END OF MEDIUM
0x1A	0x001A	#SUBSTITUTE
0x1B	0x001B	#ESCAPE
0x1C	0x001C	#FILE SEPARATOR
0x1D	0x001D	#GROUP SEPARATOR
0x1E	0x001E	#RECORD SEPARATOR
0x1F	0x001F	#UNIT SEPARATOR
0x20	0x0020	#SPACE
0x21	0x0021	#EXCLAMATION MARK
0x22	0x0022	#QUOTATION MARK
0x23	0x0023	#NUMBER SIGN
0x24	0x0024	#DOLLAR SIGN
0x25	0x0025	#PERCENT SIGN
0x26	0x0026	#AMPERSAND
0x27	0x0027	#APOSTROPHE
0x28	0x0028	#LEFT PARENTHESIS
0x29	0x0029	#RIGHT PARENTHESIS
0x2A	0x002A	#ASTERISK
0x2B	0x002B	#PLUS SIGN
0x2C	0x002C	#COMMA
0x2D	0x002D	#HYPHEN-MINUS
0x2E	0x002E	#FULL STOP
0x2F	0x002F	#SOLIDUS
0x30	0x0030	#DIGIT ZERO
0x31	0x0031	#DIGIT ONE
0x32	0x0032	#DIGIT TWO
0x33	0x0033	#DIGIT THREE
0x34	0x0034	#DIGIT FOUR
0x35	0x0035	#DIGIT FIVE
0x36	0x0036	#DIGIT SIX
0x37	0x0037	#DIGIT SEVEN
0x38	0x0038	#DIGIT EIGHT
0x39	0x0039	#DIGIT NINE
0x3A	0x003A	#COLON
0x3B	0x003B	#SEMICOLON
0x3C	0x003C	#LESS-THAN SIGN
0x3D	0x003D	#EQUALS SIGN
0x3E	0x003E	#GREATER-THAN SIGN
0x3F	0x003F	#QUESTION MARK
0x40	0x0040	#COMMERCIAL AT
0x41	0x0041	#LATIN CAPITAL LETTER A
0x42	0x0042	#LATIN CAPITAL LETTER B
0x43	0x0043	#LATIN CAPITAL LETTER C
0x44	0x0044	#LATIN CAPITAL LETTER D
0x45	0x0045	#LATIN CAPITAL LETTER E
0x46	0x0046	#LATIN CAPITAL LETTER F
0x47	0x0047	#LATIN CAPITAL LETTER G
0x48	0x0048	#LATIN CAPITAL LETTER H
0x49	0x0049	#LATIN CAPITAL LETTER I
0x4A	0x004A	#LATIN CAPITAL LETTER J
0x4B	0x004B	#LATIN CAPITAL LETTER K
0x4C	0x004C	#LATIN CAPITAL LETTER L
0x4D	0x004D	#LATIN CAPITAL LETTER M
0x4E	0x004E	#LATIN CAPITAL LETTER N
0x4F	0x004F	#LATIN CAPITAL LETTER O
0x50	0x0050	#LATIN CAPITAL LETTER P
0x51	0x0051	#LATIN CAPITAL LETTER Q
0x52	0x0052	#LATIN CAPITAL LETTER R
0x53	0x0053	#LATIN CAPITAL LETTER S
0x54	0x0054	#LATIN CAPITAL LETTER T
0x55	0x0055	#LATIN CAPITAL LETTER U
0x56	0x0056	#LATIN CAPITAL LETTER V
0x57	0x0057	#LATIN CAPITAL LETTER W
0x58	0x0058	#LATIN CAPITAL LETTER X
0x59	0x0059	#LATIN CAPITAL LETTER Y
0x5A	0x005A	#LATIN CAPITAL LETTER Z
0x5B	0x005B	#LEFT SQUARE BRACKET
0x5C	0x005C	#REVERSE SOLIDUS
0x5D	0x005D	#RIGHT SQUARE BRACKET
0x5E	0x005E	#CIRCUMFLEX ACCENT
0x5F	0x005F	#LOW LINE
0x60	0x0060	#GRAVE ACCENT
0x61	0x0061	#LATIN SMALL LETTER A
0x62	0x0062	#LATIN SMALL LETTER B
0x63	0x0063	#LATIN SMALL LETTER C
0x64	0x0064	#LATIN SMALL LETTER D
0x65	0x0065	#LATIN SMALL LETTER E
0x66	0x0066	#LATIN SMALL LETTER F
0x67	0x0067	#LATIN SMALL LETTER G
0x68	0x0068	#LATIN SMALL LETTER H
0x69	0x0069	#LATIN SMALL LETTER I
0x6A	0x006A	#LATIN SMALL LETTER J
0x6B	0x006B	#LATIN SMALL LETTER K
0x6C	0x006C	#LATIN SMALL LETTER L
0x6D	0x006D	#LATIN SMALL LETTER M
0x6E	0x006E	#LATIN SMALL LETTER N
0x6F	0x006F	#LATIN SMALL LETTER O
0x70	0x0070	#LATIN SMALL LETTER P
0x71	0x0071	#LATIN SMALL LETTER Q
0x72	0x0072	#LATIN SMALL LETTER R
0x73	0x0073	#LATIN SMALL LETTER S
0x74	0x0074	#LATIN SMALL LETTER T
0x75	0x0075	#LATIN SMALL LETTER U
0x76	0x0076	#LATIN SMALL LETTER V
0x77	0x0077	#LATIN SMALL LETTER W
0x78	0x0078	#LATIN SMALL LETTER X
0x79	0x0079	#LATIN SMALL LETTER Y
0x7A	0x007A	#LATIN SMALL LETTER Z
0x7B	0x007B	#LEFT CURLY BRACKET
0x7C	0x007C	#VERTICAL LINE
0x7D	0x007D	#RIGHT CURLY BRACKET
0x7E	0x007E	#TILDE
0x7F	0x007F	#DELETE
0x80	0x20AC	#EURO SIGN
0x81	      	#UNDEFINED
0x82	0x201A	#SINGLE LOW-9 QUOTATION MARK
0x83	0x0192	#LATIN SMALL LETTER F WITH HOOK
0x84	0x201E	#DOUBLE LOW-9 QUOTATION MARK
0x85	0x2026	#HORIZONTAL ELLIPSIS
0x86	0x2020	#DAGGER
0x87	0x2021	#DOUBLE DAGGER
0x88	0x02C6	#MODIFIER LETTER CIRCUMFLEX ACCENT
0x89	0x2030	#PER MILLE SIGN
0x8A	      	#UNDEFINED
0x8B	0x2039	#SINGLE LEFT-POINTING ANGLE QUOTATION MARK
0x8C	0x0152	#LATIN CAPITAL LIGATURE OE
0x8D	      	#UNDEFINED
0x8E	      	#UNDEFINED
0x8F	      	#UNDEFINED
0x90	      	#UNDEFINED
0x91	0x2018	#LEFT SINGLE QUOTATION MARK
0x92	0x2019	#RIGHT SINGLE QUOTATION MARK
0x93	0x201C	#LEFT DOUBLE QUOTATION MARK
0x94	0x201D	#RIGHT DOUBLE QUOTATION MARK
0x95	0x2022	#BULLET
0x96	0x2013	#EN DASH
0x97	0x2014	#EM DASH
0x98	0x02DC	#SMALL TILDE
0x99	0x2122	#TRADE MARK SIGN
0x9A	      	#UNDEFINED
0x9B	0x203A	#SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
0x9C	0x0153	#LATIN SMALL LIGATURE OE
0x9D	      	#UNDEFINED
0x9E	      	#UNDEFINED
0x9F	0x0178	#LATIN CAPITAL LETTER Y WITH DIAERESIS
0xA0	0x00A0	#NO-BREAK SPACE
0xA1	0x00A1	#INVERTED EXCLAMATION MARK
0xA2	0x00A2	#CENT SIGN
0xA3	0x00A3	#POUND SIGN
0xA4	0x00A4	#CURRENCY SIGN
0xA5	0x00A5	#YEN SIGN
0xA6	0x00A6	#BROKEN BAR
0xA7	0x00A7	#SECTION SIGN
0xA8	0x00A8	#DIAERESIS
0xA9	0x00A9	#COPYRIGHT SIGN
0xAA	0x00AA	#FEMININE ORDINAL INDICATOR
0xAB	0x00AB	#LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
0xAC	0x00AC	#NOT SIGN
0xAD	0x00AD	#SOFT HYPHEN
0xAE	0x00AE	#REGISTERED SIGN
0xAF	0x00AF	#MACRON
0xB0	0x00B0	#DEGREE SIGN
0xB1	0x00B1	#PLUS-MINUS SIGN
0xB2	0x00B2	#SUPERSCRIPT TWO
0xB3	0x00B3	#SUPERSCRIPT THREE
0xB4	0x00B4	#ACUTE ACCENT
0xB5	0x00B5	#MICRO SIGN
0xB6	0x00B6	#PILCROW SIGN
0xB7	0x00B7	#MIDDLE DOT
0xB8	0x00B8	#CEDILLA
0xB9	0x00B9	#SUPERSCRIPT ONE
0xBA	0x00BA	#MASCULINE ORDINAL INDICATOR
0xBB	0x00BB	#RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
0xBC	0x00BC	#VULGAR FRACTION ONE QUARTER
0xBD	0x00BD	#VULGAR FRACTION ONE HALF
0xBE	0x00BE	#VULGAR FRACTION THREE QUARTERS
0xBF	0x00BF	#INVERTED QUESTION MARK
0xC0	0x00C0	#LATIN CAPITAL LETTER A WITH GRAVE
0xC1	0x00C1	#LATIN CAPITAL LETTER A WITH ACUTE
0xC2	0x00C2	#LATIN CAPITAL LETTER A WITH CIRCUMFLEX
0xC3	0x0102	#LATIN CAPITAL LETTER A WITH BREVE
0xC4	0x00C4	#LATIN CAPITAL LETTER A WITH DIAERESIS
0xC5	0x00C5	#LATIN CAPITAL LETTER A WITH RING ABOVE
0xC6	0x00C6	#LATIN CAPITAL LETTER AE
0xC7	0x00C7	#LATIN CAPITAL LETTER C WITH CEDILLA
0xC8	0x00C8	#LATIN CAPITAL LETTER E WITH GRAVE
0xC9	0x00C9	#LATIN CAPITAL LETTER E WITH ACUTE
0xCA	0x00CA	#LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0xCB	0x00CB	#LATIN CAPITAL LETTER E WITH DIAERESIS
0xCC	0x0300	#COMBINING GRAVE ACCENT
0xCD	0x00CD	#LATIN CAPITAL LETTER I WITH ACUTE
0xCE	0x00CE	#LATIN CAPITAL LETTER I WITH CIRCUMFLEX
0xCF	0x00CF	#LATIN CAPITAL LETTER I WITH DIAERESIS
0xD0	0x0110	#LATIN CAPITAL LETTER D WITH STROKE
0xD1	0x00D1	#LATIN CAPITAL LETTER N WITH TILDE
0xD2	0x0309	#COMBINING HOOK ABOVE
0xD3	0x00D3	#LATIN CAPITAL LETTER O WITH ACUTE
0xD4	0x00D4	#LATIN CAPITAL LETTER O WITH CIRCUMFLEX
0xD5	0x01A0	#LATIN CAPITAL LETTER O WITH HORN
0xD6	0x00D6	#LATIN CAPITAL LETTER O WITH DIAERESIS
0xD7	0x00D7	#MULTIPLICATION SIGN
0xD8	0x00D8	#LATIN CAPITAL LETTER O WITH STROKE
0xD9	0x00D9	#LATIN CAPITAL LETTER U WITH GRAVE
0xDA	0x00DA	#LATIN CAPITAL LETTER U WITH ACUTE
0xDB	0x00DB	#LATIN CAPITAL LETTER U WITH CIRCUMFLEX
0xDC	0x00DC	#LATIN CAPITAL LETTER U WITH DIAERESIS
0xDD	0x01AF	#LATIN CAPITAL LETTER U WITH HORN
0xDE	0x0303	#COMBINING TILDE
0xDF	0x00DF	#LATIN SMALL LETTER SHARP S
0xE0	0x00E0	#LATIN SMALL LETTER A WITH GRAVE
0xE1	0x00E1	#LATIN SMALL LETTER A WITH ACUTE
0xE2	0x00E2	#LATIN SMALL LETTER A WITH CIRCUMFLEX
0xE3	0x0103	#LATIN SMALL LETTER A WITH BREVE
0xE4	0x00E4	#LATIN SMALL LETTER A WITH DIAERESIS
0xE5	0x00E5	#LATIN SMALL LETTER A WITH RING ABOVE
0xE6	0x00E6	#LATIN SMALL LETTER AE
0xE7	0x00E7	#LATIN SMALL LETTER C WITH CEDILLA
0xE8	0x00E8	#LATIN SMALL LETTER E WITH GRAVE
0xE9	0x00E9	#LATIN SMALL LETTER E WITH ACUTE
0xEA	0x00EA	#LATIN SMALL LETTER E WITH CIRCUMFLEX
0xEB	0x00EB	#LATIN SMALL LETTER E WITH DIAERESIS
0xEC	0x0301	#COMBINING ACUTE ACCENT
0xED	0x00ED	#LATIN SMALL LETTER I WITH ACUTE
0xEE	0x00EE	#LATIN SMALL LETTER I WITH CIRCUMFLEX
0xEF	0x00EF	#LATIN SMALL LETTER I WITH DIAERESIS
0xF0	0x0111	#LATIN SMALL LETTER D WITH STROKE
0xF1	0x00F1	#LATIN SMALL LETTER N WITH TILDE
0xF2	0x0323	#COMBINING DOT BELOW
0xF3	0x00F3	#LATIN SMALL LETTER O WITH ACUTE
0xF4	0x00F4	#LATIN SMALL LETTER O WITH CIRCUMFLEX
0xF5	0x01A1	#LATIN SMALL LETTER O WITH HORN
0xF6	0x00F6	#LATIN SMALL LETTER O WITH DIAERESIS
0xF7	0x00F7	#DIVISION SIGN
0xF8	0x00F8	#LATIN SMALL LETTER O WITH STROKE
0xF9	0x00F9	#LATIN SMALL LETTER U WITH GRAVE
0xFA	0x00FA	#LATIN SMALL LETTER U WITH ACUTE
0xFB	0x00FB	#LATIN SMALL LETTER U WITH CIRCUMFLEX
0xFC	0x00FC	#LATIN SMALL LETTER U WITH DIAERESIS
0xFD	0x01B0	#LATIN SMALL LETTER U WITH HORN
0xFE	0x20AB	#DONG SIGN
0xFF	0x00FF	#LATIN SMALL LETTER Y WITH DIAERESIS

   -------------------------------------------- */

static const int CANT_MAP_CHARACTER = 0;

static const USHORT to_unicode_map[256] = {
/* 00 */  0x0000,	//#NULL
/* 01 */  0x0001,	//#START OF HEADING
/* 02 */  0x0002,	//#START OF TEXT
/* 03 */  0x0003,	//#END OF TEXT
/* 04 */  0x0004,	//#END OF TRANSMISSION
/* 05 */  0x0005,	//#ENQUIRY
/* 06 */  0x0006,	//#ACKNOWLEDGE
/* 07 */  0x0007,	//#BELL
/* 08 */  0x0008,	//#BACKSPACE
/* 09 */  0x0009,	//#HORIZONTAL TABULATION
/* 0A */  0x000A,	//#LINE FEED
/* 0B */  0x000B,	//#VERTICAL TABULATION
/* 0C */  0x000C,	//#FORM FEED
/* 0D */  0x000D,	//#CARRIAGE RETURN
/* 0E */  0x000E,	//#SHIFT OUT
/* 0F */  0x000F,	//#SHIFT IN
/* 10 */  0x0010,	//#DATA LINK ESCAPE
/* 11 */  0x0011,	//	#DEVICE CONTROL ONE
/* 12 */  0x0012,	//	#DEVICE CONTROL TWO
/* 13 */  0x0013,	//	#DEVICE CONTROL THREE
/* 14 */  0x0014,	//	#DEVICE CONTROL FOUR
/* 15 */  0x0015,	//	#NEGATIVE ACKNOWLEDGE
/* 16 */  0x0016,	//	#SYNCHRONOUS IDLE
/* 17 */  0x0017,	//	#END OF TRANSMISSION BLOCK
/* 18 */  0x0018,	//	#CANCEL
/* 19 */  0x0019,	//	#END OF MEDIUM
/* 1A */  0x001A,	//	#SUBSTITUTE
/* 1B */  0x001B,	//	#ESCAPE
/* 1C */  0x001C,	//	#FILE SEPARATOR
/* 1D */  0x001D,	//	#GROUP SEPARATOR
/* 1E */  0x001E,	//	#RECORD SEPARATOR
/* 1F */  0x001F,	//	#UNIT SEPARATOR
/* 20 */  0x0020,	//	#SPACE
/* 21 */  0x0021,	//	#EXCLAMATION MARK
/* 22 */  0x0022,	//	#QUOTATION MARK
/* 23 */  0x0023,	//	#NUMBER SIGN
/* 24 */  0x0024,	//	#DOLLAR SIGN
/* 25 */  0x0025,	//	#PERCENT SIGN
/* 26 */  0x0026,	//	#AMPERSAND
/* 27 */  0x0027,	//	#APOSTROPHE
/* 28 */  0x0028,	//	#LEFT PARENTHESIS
/* 29 */  0x0029,	//	#RIGHT PARENTHESIS
/* 2A */  0x002A,	//	#ASTERISK
/* 2B */  0x002B,	//	#PLUS SIGN
/* 2C */  0x002C,	//	#COMMA
/* 2D */  0x002D,	//	#HYPHEN-MINUS
/* 2E */  0x002E,	//	#FULL STOP
/* 2F */  0x002F,	//	#SOLIDUS
/* 30 */  0x0030,	//	#DIGIT ZERO
/* 31 */  0x0031,	//	#DIGIT ONE
/* 32 */  0x0032,	//	#DIGIT TWO
/* 33 */  0x0033,	//	#DIGIT THREE
/* 34 */  0x0034,	//	#DIGIT FOUR
/* 35 */  0x0035,	//	#DIGIT FIVE
/* 36 */  0x0036,	//	#DIGIT SIX
/* 37 */  0x0037,	//	#DIGIT SEVEN
/* 38 */  0x0038,	//	#DIGIT EIGHT
/* 39 */  0x0039,	//	#DIGIT NINE
/* 3A */  0x003A,	//	#COLON
/* 3B */  0x003B,	//	#SEMICOLON
/* 3C */  0x003C,	//	#LESS-THAN SIGN
/* 3D */  0x003D,	//	#EQUALS SIGN
/* 3E */  0x003E,	//	#GREATER-THAN SIGN
/* 3F */  0x003F,	//	#QUESTION MARK
/* 40 */  0x0040,	//	#COMMERCIAL AT
/* 41 */  0x0041,	//	#LATIN CAPITAL LETTER A
/* 42 */  0x0042,	//	#LATIN CAPITAL LETTER B
/* 43 */  0x0043,	//	#LATIN CAPITAL LETTER C
/* 44 */  0x0044,	//	#LATIN CAPITAL LETTER D
/* 45 */  0x0045,	//	#LATIN CAPITAL LETTER E
/* 46 */  0x0046,	//	#LATIN CAPITAL LETTER F
/* 47 */  0x0047,	//	#LATIN CAPITAL LETTER G
/* 48 */  0x0048,	//	#LATIN CAPITAL LETTER H
/* 49 */  0x0049,	//	#LATIN CAPITAL LETTER I
/* 4A */  0x004A,	//	#LATIN CAPITAL LETTER J
/* 4B */  0x004B,	//	#LATIN CAPITAL LETTER K
/* 4C */  0x004C,	//	#LATIN CAPITAL LETTER L
/* 4D */  0x004D,	//	#LATIN CAPITAL LETTER M
/* 4E */  0x004E,	//	#LATIN CAPITAL LETTER N
/* 4F */  0x004F,	//	#LATIN CAPITAL LETTER O
/* 50 */  0x0050,	//	#LATIN CAPITAL LETTER P
/* 51 */  0x0051,	//	#LATIN CAPITAL LETTER Q
/* 52 */  0x0052,	//	#LATIN CAPITAL LETTER R
/* 53 */  0x0053,	//	#LATIN CAPITAL LETTER S
/* 54 */  0x0054,	//	#LATIN CAPITAL LETTER T
/* 55 */  0x0055,	//	#LATIN CAPITAL LETTER U
/* 56 */  0x0056,	//	#LATIN CAPITAL LETTER V
/* 57 */  0x0057,	//	#LATIN CAPITAL LETTER W
/* 58 */  0x0058,	//	#LATIN CAPITAL LETTER X
/* 59 */  0x0059,	//	#LATIN CAPITAL LETTER Y
/* 5A */  0x005A,	//	#LATIN CAPITAL LETTER Z
/* 5B */  0x005B,	//	#LEFT SQUARE BRACKET
/* 5C */  0x005C,	//	#REVERSE SOLIDUS
/* 5D */  0x005D,	//	#RIGHT SQUARE BRACKET
/* 5E */  0x005E,	//	#CIRCUMFLEX ACCENT
/* 5F */  0x005F,	//	#LOW LINE
/* 60 */  0x0060,	//	#GRAVE ACCENT
/* 61 */  0x0061,	//	#LATIN SMALL LETTER A
/* 62 */  0x0062,	//	#LATIN SMALL LETTER B
/* 63 */  0x0063,	//	#LATIN SMALL LETTER C
/* 64 */  0x0064,	//	#LATIN SMALL LETTER D
/* 65 */  0x0065,	//	#LATIN SMALL LETTER E
/* 66 */  0x0066,	//	#LATIN SMALL LETTER F
/* 67 */  0x0067,	//	#LATIN SMALL LETTER G
/* 68 */  0x0068,	//	#LATIN SMALL LETTER H
/* 69 */  0x0069,	//	#LATIN SMALL LETTER I
/* 6A */  0x006A,	//	#LATIN SMALL LETTER J
/* 6B */  0x006B,	//	#LATIN SMALL LETTER K
/* 6C */  0x006C,	//	#LATIN SMALL LETTER L
/* 6D */  0x006D,	//	#LATIN SMALL LETTER M
/* 6E */  0x006E,	//	#LATIN SMALL LETTER N
/* 6F */  0x006F,	//	#LATIN SMALL LETTER O
/* 70 */  0x0070,	//	#LATIN SMALL LETTER P
/* 71 */  0x0071,	//	#LATIN SMALL LETTER Q
/* 72 */  0x0072,	//	#LATIN SMALL LETTER R
/* 73 */  0x0073,	//	#LATIN SMALL LETTER S
/* 74 */  0x0074,	//		#LATIN SMALL LETTER T
/* 75 */  0x0075,	//		#LATIN SMALL LETTER U
/* 76 */  0x0076,	//		#LATIN SMALL LETTER V
/* 77 */  0x0077,	//		#LATIN SMALL LETTER W
/* 78 */  0x0078,	//		#LATIN SMALL LETTER X
/* 79 */  0x0079,	//		#LATIN SMALL LETTER Y
/* 7A */  0x007A,	//		#LATIN SMALL LETTER Z
/* 7B */  0x007B,	//		#LEFT CURLY BRACKET
/* 7C */  0x007C,	//		#VERTICAL LINE
/* 7D */  0x007D,	//		#RIGHT CURLY BRACKET
/* 7E */  0x007E,	//		#TILDE
/* 7F */  0x007F,	//		#DELETE
/* 80 */  0x20AC,	//		#EURO SIGN
/* 81 */   CANT_MAP_CHARACTER   ,     		//	     #UNDEFINED
/* 82 */  0x201A,	//		#SINGLE LOW-9 QUOTATION MARK
/* 83 */  0x0192,	//	#LATIN SMALL LETTER F WITH HOOK
/* 84 */  0x201E,	//		#DOUBLE LOW-9 QUOTATION MARK
/* 85 */  0x2026,	//		#HORIZONTAL ELLIPSIS
/* 86 */  0x2020,	//		#DAGGER
/* 87 */  0x2021,	//		#DOUBLE DAGGER
/* 88 */  0x02C6,	//		#MODIFIER LETTER CIRCUMFLEX ACCENT
/* 89 */  0x2030,	//		#PER MILLE SIGN
/* 8A */   CANT_MAP_CHARACTER   ,     		//	#UNDEFINED
/* 8B */  0x2039,	//		#SINGLE LEFT-POINTING ANGLE QUOTATION
/* 8C */  0x0152,	//		#LATIN CAPITAL LIGATURE OE
/* 8D */  CANT_MAP_CHARACTER   ,      	  //		#UNDEFINED
/* 8E */  CANT_MAP_CHARACTER   ,      		//	#UNDEFINED
/* 8F */   CANT_MAP_CHARACTER   ,     		//	#UNDEFINED
/* 90 */   CANT_MAP_CHARACTER   ,     		//	#UNDEFINED
/* 91 */  0x2018,	//		#LEFT SINGLE QUOTATION MARK
/* 92 */  0x2019,	//		#RIGHT SINGLE QUOTATION MARK
/* 93 */  0x201C,	//	#LEFT DOUBLE QUOTATION MARK
/* 94 */  0x201D,	//		#RIGHT DOUBLE QUOTATION MARK
/* 95 */  0x2022,	//		#BULLET
/* 96 */  0x2013,	//		#EN DASH
/* 97 */  0x2014,	//		#EM DASH
/* 98 */  0x02DC,	//		#SMALL TILDE
/* 99 */  0x2122,	//	#TRADE MARK SIGN
/* 9A */   CANT_MAP_CHARACTER   ,     		//	    #UNDEFINED
/* 9B */  0x203A,	//		#SINGLE RIGHT-POINTING ANGLE QUOTATION
/* 9C */  0x0153,	//		#LATIN SMALL LIGATURE OE
/* 9D */  CANT_MAP_CHARACTER   ,      	//		   #UNDEFINED
/* 9E */   CANT_MAP_CHARACTER   ,         	//	 	#UNDEFINED
/* 9F */  0x0178,	//		#LATIN CAPITAL LETTER Y WITH DIAERESIS
/* A0 */  0x00A0,	//		#NO-BREAK SPACE
/* A1 */  0x00A1,	//		#INVERTED EXCLAMATION MARK
/* A2 */  0x00A2,	//		#CENT SIGN
/* A3 */  0x00A3,	//		#POUND SIGN
/* A4 */  0x00A4,	//		#CURRENCY SIGN
/* A5 */  0x00A5,	//		#YEN SIGN
/* A6 */  0x00A6,	//		#BROKEN BAR
/* A7 */  0x00A7,	//		#SECTION SIGN
/* A8 */  0x00A8,	//		#DIAERESIS
/* A9 */  0x00A9,	//	#COPYRIGHT SIGN
/* AA */  0x00AA,	//		#FEMININE ORDINAL INDICATOR
/* AB */  0x00AB,	//		#LEFT-POINTING DOUBLE ANGLE QUOTATION
/* AC */  0x00AC,	//		#NOT SIGN
/* AD */  0x00AD,	//	AD	#SOFT HYPHEN
/* AE */  0x00AE,	//		#REGISTERED SIGN
/* AF */  0x00AF,	//		#MACRON
/* B0 */  0x00B0,	//		#DEGREE SIGN
/* B1 */  0x00B1,	//		#PLUS-MINUS SIGN
/* B2 */  0x00B2,	//		#SUPERSCRIPT TWO
/* B3 */  0x00B3,	//		#SUPERSCRIPT THREE
/* B4 */  0x00B4,	//		#ACUTE ACCENT
/* B5 */  0x00B5,	//		#MICRO SIGN
/* B6 */  0x00B6,	//		#PILCROW SIGN
/* B7 */  0x00B7,	//		#MIDDLE DOT
/* B8 */  0x00B8,	//		#CEDILLA
/* B9 */  0x00B9,	//	#SUPERSCRIPT ONE
/* BA */  0x00BA,	//		#MASCULINE ORDINAL INDICATOR
/* BB */  0x00BB,	//		#RIGHT-POINTING DOUBLE ANGLE QUOTATIO
/* BC */  0x00BC,	//		#VULGAR FRACTION ONE QUARTER
/* BD */  0x00BD,	//	BD	#VULGAR FRACTION ONE HALF
/* BE */  0x00BE,	//		#VULGAR FRACTION THREE QUARTERS
/* BF */  0x00BF,	//	#INVERTED QUESTION MARK
/* C0 */  0x00C0,	//		#LATIN CAPITAL LETTER A WITH GRAVE
/* C1 */  0x00C1,	//		#LATIN CAPITAL LETTER A WITH ACUTE
/* C2 */  0x00C2,	//		#LATIN CAPITAL LETTER A WITH CIRCUMFLEX
/* C3 */  0x0102,	//		#LATIN CAPITAL LETTER A WITH BREVE
/* C4 */  0x00C4,	//		#LATIN CAPITAL LETTER A WITH DIAERESIS
/* C5 */  0x00C5,	//		#LATIN CAPITAL LETTER A WITH RING ABOVE
/* C6 */  0x00C6,	//		#LATIN CAPITAL LETTER AE
/* C7 */  0x00C7,	//		#LATIN CAPITAL LETTER C WITH CEDILLA
/* C8 */  0x00C8,	//		#LATIN CAPITAL LETTER E WITH GRAVE
/* C9 */  0x00C9,	//		#LATIN CAPITAL LETTER E WITH ACUTE
/* CA */  0x00CA,	//		#LATIN CAPITAL LETTER E WITH CIRCUMFLEX
/* CB */  0x00CB,	//		#LATIN CAPITAL LETTER E WITH DIAERESIS
/* CC */  0x0300,	//		#COMBINING GRAVE ACCENT
/* CD */ 0x00CD	,//		    #LATIN CAPITAL LETTER I WITH ACUTE
/* CE */  0x00CE,	//		#LATIN CAPITAL LETTER I WITH CIRCUMFLEX
/* CF */  0x00CF,	//	#LATIN CAPITAL LETTER I WITH DIAERESIS
/* D0 */  0x0110,	//		#LATIN CAPITAL LETTER D WITH STROKE
/* D1 */  0x00D1,	//		#LATIN CAPITAL LETTER N WITH TILDE
/* D2 */  0x0309,	//		#COMBINING HOOK ABOVE
/* D3 */  0x00D3,	//		#LATIN CAPITAL LETTER O WITH ACUTE
/* D4 */  0x00D4,	//		#LATIN CAPITAL LETTER O WITH CIRCUMFLEX
/* D5 */  0x01A0,	//		#LATIN CAPITAL LETTER O WITH HORN
/* D6 */  0x00D6,	//		#LATIN CAPITAL LETTER O WITH DIAERESIS
/* D7 */  0x00D7,	//		#MULTIPLICATION SIGN
/* D8 */  0x00D8,	//		#LATIN CAPITAL LETTER O WITH STROKE
/* D9 */  0x00D9,	//		#LATIN CAPITAL LETTER U WITH GRAVE
/* DA */ 0x00DA,	//		   #LATIN CAPITAL LETTER U WITH ACUTE
/* DB */ 0x00DB,	//,			#LATIN CAPITAL LETTER U WITH CIRCUMFLEX
/* DC */ 0x00DC	,//			#LATIN CAPITAL LETTER U WITH DIAERESIS
/* DD */ 0x01AF	,//			#LATIN CAPITAL LETTER U WITH HORN
/* DE */  0x0303,	//		#COMBINING TILDE
/* DF */  0x00DF,	//	#LATIN SMALL LETTER SHARP S
/* E0 */  0x00E0,	//		#LATIN SMALL LETTER A WITH GRAVE
/* E1 */  0x00E1,	//		#LATIN SMALL LETTER A WITH ACUTE
/* E2 */  0x00E2,	//		#LATIN SMALL LETTER A WITH CIRCUMFLEX
/* E3 */  0x0103,	//		#LATIN SMALL LETTER A WITH BREVE
/* E4 */  0x00E4,	//		#LATIN SMALL LETTER A WITH DIAERESIS
/* E5 */  0x00E5,	//	#LATIN SMALL LETTER A WITH RING ABOVE
/* E6 */  0x00E6,	//	#LATIN SMALL LETTER AE
/* E7 */  0x00E7,	//	#LATIN SMALL LETTER C WITH CEDILLA
/* E8 */  0x00E8,	//	#LATIN SMALL LETTER E WITH GRAVE
/* E9 */  0x00E9,	//	#LATIN SMALL LETTER E WITH ACUTE
/* EA */  0x00EA,	//	#LATIN SMALL LETTER E WITH CIRCUMFLEX
/* EB */  0x00EB,	//	#LATIN SMALL LETTER E WITH DIAERESIS
/* EC */  0x0301,	//	#COMBINING ACUTE ACCENT
/* ED */  0x00ED,	//	#LATIN SMALL LETTER I WITH ACUTE
/* EE */  0x00EE,	//	#LATIN SMALL LETTER I WITH CIRCUMFLEX
/* EF */  0x00EF,	//	#LATIN SMALL LETTER I WITH DIAERESIS
/* F0 */  0x0111,	//	#LATIN SMALL LETTER D WITH STROKE
/* F1 */  0x00F1,	//	#LATIN SMALL LETTER N WITH TILDE
/* F2 */  0x0323,	//	#COMBINING DOT BELOW
/* F3 */  0x00F3,	//	#LATIN SMALL LETTER O WITH ACUTE
/* F4 */  0x00F4,	//	#LATIN SMALL LETTER O WITH CIRCUMFLEX
/* F5 */  0x01A1,	//	#LATIN SMALL LETTER O WITH HORN
/* F6 */  0x00F6,	//	#LATIN SMALL LETTER O WITH DIAERESIS
/* F7 */  0x00F7,	//	#DIVISION SIGN
/* F8 */  0x00F8,	//	#LATIN SMALL LETTER O WITH STROKE
/* F9 */  0x00F9,	//	#LATIN SMALL LETTER U WITH GRAVE
/* FA */  0x00FA,	//	#LATIN SMALL LETTER U WITH ACUTE
/* FB */  0x00FB,	//	#LATIN SMALL LETTER U WITH CIRCUMFLEX
/* FC */  0x00FC,	//	#LATIN SMALL LETTER U WITH DIAERESIS
/* FD */  0x01B0 , //	#LATIN SMALL LETTER U WITH HORN
/* FE */  0x20AB  ,//	#DONG SIGN
/* FF */  0x00FF  ,//,	#LATIN SMALL LETTER Y WITH DIAERESIS
};


#ifndef CANT_MAP_CHARACTER
#define CANT_MAP_CHARACTER 0
#endif

static const UCHAR from_unicode_mapping_array[] = {
/* U+XX00 */	CANT_MAP_CHARACTER,	/* 0 */
/* U+XX01 */	CANT_MAP_CHARACTER,	/* 1 */
/* U+XX02 */	CANT_MAP_CHARACTER,	/* 2 */
/* U+XX03 */	CANT_MAP_CHARACTER,	/* 3 */
/* U+XX04 */	CANT_MAP_CHARACTER,	/* 4 */
/* U+XX05 */	CANT_MAP_CHARACTER,	/* 5 */
/* U+XX06 */	CANT_MAP_CHARACTER,	/* 6 */
/* U+XX07 */	CANT_MAP_CHARACTER,	/* 7 */
/* U+XX08 */	CANT_MAP_CHARACTER,	/* 8 */
/* U+XX09 */	CANT_MAP_CHARACTER,	/* 9 */
/* U+XX0A */	CANT_MAP_CHARACTER,	/* 10 */
/* U+XX0B */	CANT_MAP_CHARACTER,	/* 11 */
/* U+XX0C */	CANT_MAP_CHARACTER,	/* 12 */
/* U+XX0D */	CANT_MAP_CHARACTER,	/* 13 */
/* U+XX0E */	CANT_MAP_CHARACTER,	/* 14 */
/* U+XX0F */	CANT_MAP_CHARACTER,	/* 15 */
/* U+XX10 */	CANT_MAP_CHARACTER,	/* 16 */
/* U+XX11 */	CANT_MAP_CHARACTER,	/* 17 */
/* U+XX12 */	CANT_MAP_CHARACTER,	/* 18 */
/* U+XX13 */	CANT_MAP_CHARACTER,	/* 19 */
/* U+XX14 */	CANT_MAP_CHARACTER,	/* 20 */
/* U+XX15 */	CANT_MAP_CHARACTER,	/* 21 */
/* U+XX16 */	CANT_MAP_CHARACTER,	/* 22 */
/* U+XX17 */	CANT_MAP_CHARACTER,	/* 23 */
/* U+XX18 */	CANT_MAP_CHARACTER,	/* 24 */
/* U+XX19 */	CANT_MAP_CHARACTER,	/* 25 */
/* U+XX1A */	CANT_MAP_CHARACTER,	/* 26 */
/* U+XX1B */	CANT_MAP_CHARACTER,	/* 27 */
/* U+XX1C */	CANT_MAP_CHARACTER,	/* 28 */
/* U+XX1D */	CANT_MAP_CHARACTER,	/* 29 */
/* U+XX1E */	CANT_MAP_CHARACTER,	/* 30 */
/* U+XX1F */	CANT_MAP_CHARACTER,	/* 31 */
/* U+XX20 */	CANT_MAP_CHARACTER,	/* 32 */
/* U+XX21 */	CANT_MAP_CHARACTER,	/* 33 */
/* U+XX22 */	CANT_MAP_CHARACTER,	/* 34 */
/* U+XX23 */	CANT_MAP_CHARACTER,	/* 35 */
/* U+XX24 */	CANT_MAP_CHARACTER,	/* 36 */
/* U+XX25 */	CANT_MAP_CHARACTER,	/* 37 */
/* U+XX26 */	CANT_MAP_CHARACTER,	/* 38 */
/* U+XX27 */	CANT_MAP_CHARACTER,	/* 39 */
/* U+XX28 */	CANT_MAP_CHARACTER,	/* 40 */
/* U+XX29 */	CANT_MAP_CHARACTER,	/* 41 */
/* U+XX2A */	CANT_MAP_CHARACTER,	/* 42 */
/* U+XX2B */	CANT_MAP_CHARACTER,	/* 43 */
/* U+XX2C */	CANT_MAP_CHARACTER,	/* 44 */
/* U+XX2D */	CANT_MAP_CHARACTER,	/* 45 */
/* U+XX2E */	CANT_MAP_CHARACTER,	/* 46 */
/* U+XX2F */	CANT_MAP_CHARACTER,	/* 47 */
/* U+XX30 */	CANT_MAP_CHARACTER,	/* 48 */
/* U+XX31 */	CANT_MAP_CHARACTER,	/* 49 */
/* U+XX32 */	CANT_MAP_CHARACTER,	/* 50 */
/* U+XX33 */	CANT_MAP_CHARACTER,	/* 51 */
/* U+XX34 */	CANT_MAP_CHARACTER,	/* 52 */
/* U+XX35 */	CANT_MAP_CHARACTER,	/* 53 */
/* U+XX36 */	CANT_MAP_CHARACTER,	/* 54 */
/* U+XX37 */	CANT_MAP_CHARACTER,	/* 55 */
/* U+XX38 */	CANT_MAP_CHARACTER,	/* 56 */
/* U+XX39 */	CANT_MAP_CHARACTER,	/* 57 */
/* U+XX3A */	CANT_MAP_CHARACTER,	/* 58 */
/* U+XX3B */	CANT_MAP_CHARACTER,	/* 59 */
/* U+XX3C */	CANT_MAP_CHARACTER,	/* 60 */
/* U+XX3D */	CANT_MAP_CHARACTER,	/* 61 */
/* U+XX3E */	CANT_MAP_CHARACTER,	/* 62 */
/* U+XX3F */	CANT_MAP_CHARACTER,	/* 63 */
/* U+XX40 */	CANT_MAP_CHARACTER,	/* 64 */
/* U+XX41 */	CANT_MAP_CHARACTER,	/* 65 */
/* U+XX42 */	CANT_MAP_CHARACTER,	/* 66 */
/* U+XX43 */	CANT_MAP_CHARACTER,	/* 67 */
/* U+XX44 */	CANT_MAP_CHARACTER,	/* 68 */
/* U+XX45 */	CANT_MAP_CHARACTER,	/* 69 */
/* U+XX46 */	CANT_MAP_CHARACTER,	/* 70 */
/* U+XX47 */	CANT_MAP_CHARACTER,	/* 71 */
/* U+XX48 */	CANT_MAP_CHARACTER,	/* 72 */
/* U+XX49 */	CANT_MAP_CHARACTER,	/* 73 */
/* U+XX4A */	CANT_MAP_CHARACTER,	/* 74 */
/* U+XX4B */	CANT_MAP_CHARACTER,	/* 75 */
/* U+XX4C */	CANT_MAP_CHARACTER,	/* 76 */
/* U+XX4D */	CANT_MAP_CHARACTER,	/* 77 */
/* U+XX4E */	CANT_MAP_CHARACTER,	/* 78 */
/* U+XX4F */	CANT_MAP_CHARACTER,	/* 79 */
/* U+XX50 */	CANT_MAP_CHARACTER,	/* 80 */
/* U+XX51 */	CANT_MAP_CHARACTER,	/* 81 */
/* U+XX52 */	CANT_MAP_CHARACTER,	/* 82 */
/* U+XX53 */	CANT_MAP_CHARACTER,	/* 83 */
/* U+XX54 */	CANT_MAP_CHARACTER,	/* 84 */
/* U+XX55 */	CANT_MAP_CHARACTER,	/* 85 */
/* U+XX56 */	CANT_MAP_CHARACTER,	/* 86 */
/* U+XX57 */	CANT_MAP_CHARACTER,	/* 87 */
/* U+XX58 */	CANT_MAP_CHARACTER,	/* 88 */
/* U+XX59 */	CANT_MAP_CHARACTER,	/* 89 */
/* U+XX5A */	CANT_MAP_CHARACTER,	/* 90 */
/* U+XX5B */	CANT_MAP_CHARACTER,	/* 91 */
/* U+XX5C */	CANT_MAP_CHARACTER,	/* 92 */
/* U+XX5D */	CANT_MAP_CHARACTER,	/* 93 */
/* U+XX5E */	CANT_MAP_CHARACTER,	/* 94 */
/* U+XX5F */	CANT_MAP_CHARACTER,	/* 95 */
/* U+XX60 */	CANT_MAP_CHARACTER,	/* 96 */
/* U+XX61 */	CANT_MAP_CHARACTER,	/* 97 */
/* U+XX62 */	CANT_MAP_CHARACTER,	/* 98 */
/* U+XX63 */	CANT_MAP_CHARACTER,	/* 99 */
/* U+XX64 */	CANT_MAP_CHARACTER,	/* 100 */
/* U+XX65 */	CANT_MAP_CHARACTER,	/* 101 */
/* U+XX66 */	CANT_MAP_CHARACTER,	/* 102 */
/* U+XX67 */	CANT_MAP_CHARACTER,	/* 103 */
/* U+XX68 */	CANT_MAP_CHARACTER,	/* 104 */
/* U+XX69 */	CANT_MAP_CHARACTER,	/* 105 */
/* U+XX6A */	CANT_MAP_CHARACTER,	/* 106 */
/* U+XX6B */	CANT_MAP_CHARACTER,	/* 107 */
/* U+XX6C */	CANT_MAP_CHARACTER,	/* 108 */
/* U+XX6D */	CANT_MAP_CHARACTER,	/* 109 */
/* U+XX6E */	CANT_MAP_CHARACTER,	/* 110 */
/* U+XX6F */	CANT_MAP_CHARACTER,	/* 111 */
/* U+XX70 */	CANT_MAP_CHARACTER,	/* 112 */
/* U+XX71 */	CANT_MAP_CHARACTER,	/* 113 */
/* U+XX72 */	CANT_MAP_CHARACTER,	/* 114 */
/* U+XX73 */	CANT_MAP_CHARACTER,	/* 115 */
/* U+XX74 */	CANT_MAP_CHARACTER,	/* 116 */
/* U+XX75 */	CANT_MAP_CHARACTER,	/* 117 */
/* U+XX76 */	CANT_MAP_CHARACTER,	/* 118 */
/* U+XX77 */	CANT_MAP_CHARACTER,	/* 119 */
/* U+XX78 */	CANT_MAP_CHARACTER,	/* 120 */
/* U+XX79 */	CANT_MAP_CHARACTER,	/* 121 */
/* U+XX7A */	CANT_MAP_CHARACTER,	/* 122 */
/* U+XX7B */	CANT_MAP_CHARACTER,	/* 123 */
/* U+XX7C */	CANT_MAP_CHARACTER,	/* 124 */
/* U+XX7D */	CANT_MAP_CHARACTER,	/* 125 */
/* U+XX7E */	CANT_MAP_CHARACTER,	/* 126 */
/* U+XX7F */	CANT_MAP_CHARACTER,	/* 127 */
/* U+XX80 */	CANT_MAP_CHARACTER,	/* 128 */
/* U+XX81 */	CANT_MAP_CHARACTER,	/* 129 */
/* U+XX82 */	CANT_MAP_CHARACTER,	/* 130 */
/* U+XX83 */	CANT_MAP_CHARACTER,	/* 131 */
/* U+XX84 */	CANT_MAP_CHARACTER,	/* 132 */
/* U+XX85 */	CANT_MAP_CHARACTER,	/* 133 */
/* U+XX86 */	CANT_MAP_CHARACTER,	/* 134 */
/* U+XX87 */	CANT_MAP_CHARACTER,	/* 135 */
/* U+XX88 */	CANT_MAP_CHARACTER,	/* 136 */
/* U+XX89 */	CANT_MAP_CHARACTER,	/* 137 */
/* U+XX8A */	CANT_MAP_CHARACTER,	/* 138 */
/* U+XX8B */	CANT_MAP_CHARACTER,	/* 139 */
/* U+XX8C */	CANT_MAP_CHARACTER,	/* 140 */
/* U+XX8D */	CANT_MAP_CHARACTER,	/* 141 */
/* U+XX8E */	CANT_MAP_CHARACTER,	/* 142 */
/* U+XX8F */	CANT_MAP_CHARACTER,	/* 143 */
/* U+XX90 */	CANT_MAP_CHARACTER,	/* 144 */
/* U+XX91 */	CANT_MAP_CHARACTER,	/* 145 */
/* U+XX92 */	CANT_MAP_CHARACTER,	/* 146 */
/* U+XX93 */	CANT_MAP_CHARACTER,	/* 147 */
/* U+XX94 */	CANT_MAP_CHARACTER,	/* 148 */
/* U+XX95 */	CANT_MAP_CHARACTER,	/* 149 */
/* U+XX96 */	CANT_MAP_CHARACTER,	/* 150 */
/* U+XX97 */	CANT_MAP_CHARACTER,	/* 151 */
/* U+XX98 */	CANT_MAP_CHARACTER,	/* 152 */
/* U+XX99 */	CANT_MAP_CHARACTER,	/* 153 */
/* U+XX9A */	CANT_MAP_CHARACTER,	/* 154 */
/* U+XX9B */	CANT_MAP_CHARACTER,	/* 155 */
/* U+XX9C */	CANT_MAP_CHARACTER,	/* 156 */
/* U+XX9D */	CANT_MAP_CHARACTER,	/* 157 */
/* U+XX9E */	CANT_MAP_CHARACTER,	/* 158 */
/* U+XX9F */	CANT_MAP_CHARACTER,	/* 159 */
/* U+XXA0 */	CANT_MAP_CHARACTER,	/* 160 */
/* U+XXA1 */	CANT_MAP_CHARACTER,	/* 161 */
/* U+XXA2 */	CANT_MAP_CHARACTER,	/* 162 */
/* U+XXA3 */	CANT_MAP_CHARACTER,	/* 163 */
/* U+XXA4 */	CANT_MAP_CHARACTER,	/* 164 */
/* U+XXA5 */	CANT_MAP_CHARACTER,	/* 165 */
/* U+XXA6 */	CANT_MAP_CHARACTER,	/* 166 */
/* U+XXA7 */	CANT_MAP_CHARACTER,	/* 167 */
/* U+XXA8 */	CANT_MAP_CHARACTER,	/* 168 */
/* U+XXA9 */	CANT_MAP_CHARACTER,	/* 169 */
/* U+XXAA */	CANT_MAP_CHARACTER,	/* 170 */
/* U+XXAB */	CANT_MAP_CHARACTER,	/* 171 */
/* U+XXAC */	CANT_MAP_CHARACTER,	/* 172 */
/* U+XXAD */	CANT_MAP_CHARACTER,	/* 173 */
/* U+XXAE */	CANT_MAP_CHARACTER,	/* 174 */
/* U+XXAF */	CANT_MAP_CHARACTER,	/* 175 */
/* U+XXB0 */	CANT_MAP_CHARACTER,	/* 176 */
/* U+XXB1 */	CANT_MAP_CHARACTER,	/* 177 */
/* U+XXB2 */	CANT_MAP_CHARACTER,	/* 178 */
/* U+XXB3 */	CANT_MAP_CHARACTER,	/* 179 */
/* U+XXB4 */	CANT_MAP_CHARACTER,	/* 180 */
/* U+XXB5 */	CANT_MAP_CHARACTER,	/* 181 */
/* U+XXB6 */	CANT_MAP_CHARACTER,	/* 182 */
/* U+XXB7 */	CANT_MAP_CHARACTER,	/* 183 */
/* U+XXB8 */	CANT_MAP_CHARACTER,	/* 184 */
/* U+XXB9 */	CANT_MAP_CHARACTER,	/* 185 */
/* U+XXBA */	CANT_MAP_CHARACTER,	/* 186 */
/* U+XXBB */	CANT_MAP_CHARACTER,	/* 187 */
/* U+XXBC */	CANT_MAP_CHARACTER,	/* 188 */
/* U+XXBD */	CANT_MAP_CHARACTER,	/* 189 */
/* U+XXBE */	CANT_MAP_CHARACTER,	/* 190 */
/* U+XXBF */	CANT_MAP_CHARACTER,	/* 191 */
/* U+XXC0 */	CANT_MAP_CHARACTER,	/* 192 */
/* U+XXC1 */	CANT_MAP_CHARACTER,	/* 193 */
/* U+XXC2 */	CANT_MAP_CHARACTER,	/* 194 */
/* U+XXC3 */	CANT_MAP_CHARACTER,	/* 195 */
/* U+XXC4 */	CANT_MAP_CHARACTER,	/* 196 */
/* U+XXC5 */	CANT_MAP_CHARACTER,	/* 197 */
/* U+XXC6 */	CANT_MAP_CHARACTER,	/* 198 */
/* U+XXC7 */	CANT_MAP_CHARACTER,	/* 199 */
/* U+XXC8 */	CANT_MAP_CHARACTER,	/* 200 */
/* U+XXC9 */	CANT_MAP_CHARACTER,	/* 201 */
/* U+XXCA */	CANT_MAP_CHARACTER,	/* 202 */
/* U+XXCB */	CANT_MAP_CHARACTER,	/* 203 */
/* U+XXCC */	CANT_MAP_CHARACTER,	/* 204 */
/* U+XXCD */	CANT_MAP_CHARACTER,	/* 205 */
/* U+XXCE */	CANT_MAP_CHARACTER,	/* 206 */
/* U+XXCF */	CANT_MAP_CHARACTER,	/* 207 */
/* U+XXD0 */	CANT_MAP_CHARACTER,	/* 208 */
/* U+XXD1 */	CANT_MAP_CHARACTER,	/* 209 */
/* U+XXD2 */	CANT_MAP_CHARACTER,	/* 210 */
/* U+XXD3 */	CANT_MAP_CHARACTER,	/* 211 */
/* U+XXD4 */	CANT_MAP_CHARACTER,	/* 212 */
/* U+XXD5 */	CANT_MAP_CHARACTER,	/* 213 */
/* U+XXD6 */	CANT_MAP_CHARACTER,	/* 214 */
/* U+XXD7 */	CANT_MAP_CHARACTER,	/* 215 */
/* U+XXD8 */	CANT_MAP_CHARACTER,	/* 216 */
/* U+XXD9 */	CANT_MAP_CHARACTER,	/* 217 */
/* U+XXDA */	CANT_MAP_CHARACTER,	/* 218 */
/* U+XXDB */	CANT_MAP_CHARACTER,	/* 219 */
/* U+XXDC */	CANT_MAP_CHARACTER,	/* 220 */
/* U+XXDD */	CANT_MAP_CHARACTER,	/* 221 */
/* U+XXDE */	CANT_MAP_CHARACTER,	/* 222 */
/* U+XXDF */	CANT_MAP_CHARACTER,	/* 223 */
/* U+XXE0 */	CANT_MAP_CHARACTER,	/* 224 */
/* U+XXE1 */	CANT_MAP_CHARACTER,	/* 225 */
/* U+XXE2 */	CANT_MAP_CHARACTER,	/* 226 */
/* U+XXE3 */	CANT_MAP_CHARACTER,	/* 227 */
/* U+XXE4 */	CANT_MAP_CHARACTER,	/* 228 */
/* U+XXE5 */	CANT_MAP_CHARACTER,	/* 229 */
/* U+XXE6 */	CANT_MAP_CHARACTER,	/* 230 */
/* U+XXE7 */	CANT_MAP_CHARACTER,	/* 231 */
/* U+XXE8 */	CANT_MAP_CHARACTER,	/* 232 */
/* U+XXE9 */	CANT_MAP_CHARACTER,	/* 233 */
/* U+XXEA */	CANT_MAP_CHARACTER,	/* 234 */
/* U+XXEB */	CANT_MAP_CHARACTER,	/* 235 */
/* U+XXEC */	CANT_MAP_CHARACTER,	/* 236 */
/* U+XXED */	CANT_MAP_CHARACTER,	/* 237 */
/* U+XXEE */	CANT_MAP_CHARACTER,	/* 238 */
/* U+XXEF */	CANT_MAP_CHARACTER,	/* 239 */
/* U+XXF0 */	CANT_MAP_CHARACTER,	/* 240 */
/* U+XXF1 */	CANT_MAP_CHARACTER,	/* 241 */
/* U+XXF2 */	CANT_MAP_CHARACTER,	/* 242 */
/* U+XXF3 */	CANT_MAP_CHARACTER,	/* 243 */
/* U+XXF4 */	CANT_MAP_CHARACTER,	/* 244 */
/* U+XXF5 */	CANT_MAP_CHARACTER,	/* 245 */
/* U+XXF6 */	CANT_MAP_CHARACTER,	/* 246 */
/* U+XXF7 */	CANT_MAP_CHARACTER,	/* 247 */
/* U+XXF8 */	CANT_MAP_CHARACTER,	/* 248 */
/* U+XXF9 */	CANT_MAP_CHARACTER,	/* 249 */
/* U+XXFA */	CANT_MAP_CHARACTER,	/* 250 */
/* U+XXFB */	CANT_MAP_CHARACTER,	/* 251 */
/* U+XXFC */	CANT_MAP_CHARACTER,	/* 252 */
/* U+XXFD */	CANT_MAP_CHARACTER,	/* 253 */
/* U+XXFE */	CANT_MAP_CHARACTER,	/* 254 */
/* U+XXFF */	CANT_MAP_CHARACTER,	/* 255 */
/*	0x0000 	*/	0x00	,
/*	0x0001 	*/	0x01	,
/*	0x0002 	*/	0x02	,
/*	0x0003 	*/	0x03	,
/*	0x0004 	*/	0x04	,
/*	0x0005 	*/	0x05	,
/*	0x0006 	*/	0x06	,
/*	0x0007 	*/	0x07	,
/*	0x0008 	*/	0x08	,
/*	0x0009 	*/	0x09	,
/*	0x000A	*/	0x0A	,
/*	0x000B	*/	0x0B	,
/*	0x000C	*/	0x0C	,
/*	0x000D	*/	0x0D	,
/*	0x000E 	*/	0x0E	,
/*	0x000F 	*/	0x0F	,
/*	0x0010 	*/	0x10	,
/*	0x0011 	*/	0x11	,
/*	0x0012 	*/	0x12	,
/*	0x0013 	*/	0x13	,
/*	0x0014 	*/	0x14	,
/*	0x0015 	*/	0x15	,
/*	0x0016 	*/	0x16	,
/*	0x0017 	*/	0x17	,
/*	0x0018 	*/	0x18	,
/*	0x0019 	*/	0x19	,
/*	0x001A	*/	0x1A	,
/*	0x001B	*/	0x1B	,
/*	0x001C	*/	0x1C	,
/*	0x001D	*/	0x1D	,
/*	0x001E 	*/	0x1E	,
/*	0x001F 	*/	0x1F	,
/*	0x0020 	*/	0x20	,
/*	0x0021 	*/	0x21	,
/*	0x0022 	*/	0x22	,
/*	0x0023 	*/	0x23	,
/*	0x0024 	*/	0x24	,
/*	0x0025 	*/	0x25	,
/*	0x0026 	*/	0x26	,
/*	0x0027 	*/	0x27	,
/*	0x0028 	*/	0x28	,
/*	0x0029 	*/	0x29	,
/*	0x002A	*/	0x2A	,
/*	0x002B	*/	0x2B	,
/*	0x002C	*/	0x2C	,
/*	0x002D	*/	0x2D	,
/*	0x002E 	*/	0x2E	,
/*	0x002F 	*/	0x2F	,
/*	0x0030 	*/	0x30	,
/*	0x0031 	*/	0x31	,
/*	0x0032 	*/	0x32	,
/*	0x0033 	*/	0x33	,
/*	0x0034 	*/	0x34	,
/*	0x0035 	*/	0x35	,
/*	0x0036 	*/	0x36	,
/*	0x0037 	*/	0x37	,
/*	0x0038 	*/	0x38	,
/*	0x0039 	*/	0x39	,
/*	0x003A	*/	0x3A	,
/*	0x003B	*/	0x3B	,
/*	0x003C	*/	0x3C	,
/*	0x003D	*/	0x3D	,
/*	0x003E 	*/	0x3E	,
/*	0x003F 	*/	0x3F	,
/*	0x0040 	*/	0x40	,
/*	0x0041 	*/	0x41	,
/*	0x0042 	*/	0x42	,
/*	0x0043 	*/	0x43	,
/*	0x0044 	*/	0x44	,
/*	0x0045 	*/	0x45	,
/*	0x0046 	*/	0x46	,
/*	0x0047 	*/	0x47	,
/*	0x0048 	*/	0x48	,
/*	0x0049 	*/	0x49	,
/*	0x004A	*/	0x4A	,
/*	0x004B	*/	0x4B	,
/*	0x004C	*/	0x4C	,
/*	0x004D	*/	0x4D	,
/*	0x004E 	*/	0x4E	,
/*	0x004F 	*/	0x4F	,
/*	0x0050 	*/	0x50	,
/*	0x0051 	*/	0x51	,
/*	0x0052 	*/	0x52	,
/*	0x0053 	*/	0x53	,
/*	0x0054 	*/	0x54	,
/*	0x0055 	*/	0x55	,
/*	0x0056 	*/	0x56	,
/*	0x0057 	*/	0x57	,
/*	0x0058 	*/	0x58	,
/*	0x0059 	*/	0x59	,
/*	0x005A	*/	0x5A	,
/*	0x005B	*/	0x5B	,
/*	0x005C	*/	0x5C	,
/*	0x005D	*/	0x5D	,
/*	0x005E 	*/	0x5E	,
/*	0x005F 	*/	0x5F	,
/*	0x0060 	*/	0x60	,
/*	0x0061 	*/	0x61	,
/*	0x0062 	*/	0x62	,
/*	0x0063 	*/	0x63	,
/*	0x0064 	*/	0x64	,
/*	0x0065 	*/	0x65	,
/*	0x0066 	*/	0x66	,
/*	0x0067 	*/	0x67	,
/*	0x0068 	*/	0x68	,
/*	0x0069 	*/	0x69	,
/*	0x006A	*/	0x6A	,
/*	0x006B	*/	0x6B	,
/*	0x006C	*/	0x6C	,
/*	0x006D	*/	0x6D	,
/*	0x006E 	*/	0x6E	,
/*	0x006F 	*/	0x6F	,
/*	0x0070 	*/	0x70	,
/*	0x0071 	*/	0x71	,
/*	0x0072 	*/	0x72	,
/*	0x0073 	*/	0x73	,
/*	0x0074 	*/	0x74	,
/*	0x0075 	*/	0x75	,
/*	0x0076 	*/	0x76	,
/*	0x0077 	*/	0x77	,
/*	0x0078 	*/	0x78	,
/*	0x0079 	*/	0x79	,
/*	0x007A	*/	0x7A	,
/*	0x007B	*/	0x7B	,
/*	0x007C	*/	0x7C	,
/*	0x007D	*/	0x7D	,
/*	0x007E 	*/	0x7E	,
/*	0x007F 	*/	0x7F	,
/*	0x0080 	*/	CANT_MAP_CHARACTER	,
/*	0x0081 	*/	CANT_MAP_CHARACTER	,
/*	0x0082 	*/	CANT_MAP_CHARACTER	,
/*	0x0083 	*/	CANT_MAP_CHARACTER	,
/*	0x0084 	*/	CANT_MAP_CHARACTER	,
/*	0x0085 	*/	CANT_MAP_CHARACTER	,
/*	0x0086 	*/	CANT_MAP_CHARACTER	,
/*	0x0087 	*/	CANT_MAP_CHARACTER	,
/*	0x0088 	*/	CANT_MAP_CHARACTER	,
/*	0x0089 	*/	CANT_MAP_CHARACTER	,
/*	0x008A	*/	CANT_MAP_CHARACTER	,
/*	0x008B	*/	CANT_MAP_CHARACTER	,
/*	0x008C	*/	CANT_MAP_CHARACTER	,
/*	0x008D	*/	CANT_MAP_CHARACTER	,
/*	0x008E 	*/	CANT_MAP_CHARACTER	,
/*	0x008F 	*/	CANT_MAP_CHARACTER	,
/*	0x0090 	*/	CANT_MAP_CHARACTER	,
/*	0x0091 	*/	CANT_MAP_CHARACTER	,
/*	0x0092 	*/	CANT_MAP_CHARACTER	,
/*	0x0093 	*/	CANT_MAP_CHARACTER	,
/*	0x0094 	*/	CANT_MAP_CHARACTER	,
/*	0x0095 	*/	CANT_MAP_CHARACTER	,
/*	0x0096 	*/	CANT_MAP_CHARACTER	,
/*	0x0097 	*/	CANT_MAP_CHARACTER	,
/*	0x0098 	*/	CANT_MAP_CHARACTER	,
/*	0x0099 	*/	CANT_MAP_CHARACTER	,
/*	0x009A	*/	CANT_MAP_CHARACTER	,
/*	0x009B	*/	CANT_MAP_CHARACTER	,
/*	0x009C	*/	CANT_MAP_CHARACTER	,
/*	0x009D	*/	CANT_MAP_CHARACTER	,
/*	0x009E 	*/	CANT_MAP_CHARACTER	,
/*	0x009F 	*/	CANT_MAP_CHARACTER	,
/*	0x00A0	*/	0xA0	,
/*	0x00A1	*/	0xA1	,
/*	0x00A2	*/	0xA2	,
/*	0x00A3	*/	0xA3	,
/*	0x00A4	*/	0xA4	,
/*	0x00A5	*/	0xA5	,
/*	0x00A6	*/	0xA6	,
/*	0x00A7	*/	0xA7	,
/*	0x00A8	*/	0xA8	,
/*	0x00A9	*/	0xA9	,
/*	0x00AA	*/	0xAA	,
/*	0x00AB	*/	0xAB	,
/*	0x00AC	*/	0xAC	,
/*	0x00AD	*/	0xAD	,
/*	0x00AE	*/	0xAE	,
/*	0x00AF 	*/	0xAF	,
/*	0x00B0	*/	0xB0	,
/*	0x00B1	*/	0xB1	,
/*	0x00B2	*/	0xB2	,
/*	0x00B3	*/	0xB3	,
/*	0x00B4	*/	0xB4	,
/*	0x00B5	*/	0xB5	,
/*	0x00B6	*/	0xB6	,
/*	0x00B7	*/	0xB7	,
/*	0x00B8	*/	0xB8	,
/*	0x00B9	*/	0xB9	,
/*	0x00BA	*/	0xBA	,
/*	0x00BB	*/	0xBB	,
/*	0x00BC	*/	0xBC	,
/*	0x00BD	*/	0xBD	,
/*	0x00BE	*/	0xBE	,
/*	0x00BF 	*/	0xBF	,
/*	0x00C0	*/	0xC0	,
/*	0x00C1	*/	0xC1	,
/*	0x00C2	*/	0xC2	,
/*	0x00C3	*/	CANT_MAP_CHARACTER	,
/*	0x00C4	*/	0xC4	,
/*	0x00C5	*/	0xC5	,
/*	0x00C6	*/	0xC6	,
/*	0x00C7	*/	0xC7	,
/*	0x00C8	*/	0xC8	,
/*	0x00C9	*/	0xC9	,
/*	0x00CA	*/	0xCA	,
/*	0x00CB	*/	0xCB	,
/*	0x00CC	*/	CANT_MAP_CHARACTER	,
/*	0x00CD	*/	0xCD	,
/*	0x00CE	*/	0xCE	,
/*	0x00CF 	*/	0xCF	,
/*	0x00D0	*/	CANT_MAP_CHARACTER	,
/*	0x00D1	*/	0xD1	,
/*	0x00D2	*/	CANT_MAP_CHARACTER	,
/*	0x00D3	*/	0xD3	,
/*	0x00D4	*/	0xD4	,
/*	0x00D5	*/	CANT_MAP_CHARACTER	,
/*	0x00D6	*/	0xD6	,
/*	0x00D7	*/	0xD7	,
/*	0x00D8	*/	0xD8	,
/*	0x00D9	*/	0xD9	,
/*	0x00DA	*/	0xDA	,
/*	0x00DB	*/	0xDB	,
/*	0x00DC	*/	0xDC	,
/*	0x00DD	*/	CANT_MAP_CHARACTER	,
/*	0x00DE	*/	CANT_MAP_CHARACTER	,
/*	0x00DF	*/	0xDF	,
/*	0x00E0 	*/	0xE0	,
/*	0x00E1 	*/	0xE1	,
/*	0x00E2 	*/	0xE2	,
/*	0x00E3 	*/	CANT_MAP_CHARACTER	,
/*	0x00E4 	*/	0xE4	,
/*	0x00E5 	*/	0xE5	,
/*	0x00E6 	*/	0xE6	,
/*	0x00E7 	*/	0xE7	,
/*	0x00E8 	*/	0xE8	,
/*	0x00E9 	*/	0xE9	,
/*	0x00EA	*/	0xEA	,
/*	0x00EB	*/	0xEB	,
/*	0x00EC	*/	CANT_MAP_CHARACTER	,
/*	0x00ED	*/	0xED	,
/*	0x00EE 	*/	0xEE	,
/*	0x00EF 	*/	0xEF	,
/*	0x00F0 	*/	CANT_MAP_CHARACTER	,
/*	0x00F1 	*/	0xF1	,
/*	0x00F2 	*/	CANT_MAP_CHARACTER	,
/*	0x00F3 	*/	0xF3	,
/*	0x00F4 	*/	0xF4	,
/*	0x00F5 	*/	CANT_MAP_CHARACTER	,
/*	0x00F6 	*/	0xF6	,
/*	0x00F7 	*/	0xF7	,
/*	0x00F8 	*/	0xF8	,
/*	0x00F9 	*/	0xF9	,
/*	0x00FA 	*/	0xFA	,
/*	0x00FB 	*/	0xFB	,
/*	0x00FC 	*/	0xFC	,
/*	0x00FD	*/	CANT_MAP_CHARACTER	,
/*	0x00FE 	*/	CANT_MAP_CHARACTER	,
/*	0x00FF 	*/	0xFF	,
/*	0x0100 	*/	CANT_MAP_CHARACTER	,
/*	0x0101 	*/	CANT_MAP_CHARACTER	,
/*	0x0102 	*/	0xC3	,
/*	0x0103 	*/	0xE3	,
/*	0x0104 	*/	CANT_MAP_CHARACTER	,
/*	0x0105 	*/	CANT_MAP_CHARACTER	,
/*	0x0106 	*/	CANT_MAP_CHARACTER	,
/*	0x0107 	*/	CANT_MAP_CHARACTER	,
/*	0x0108 	*/	CANT_MAP_CHARACTER	,
/*	0x0109 	*/	CANT_MAP_CHARACTER	,
/*	0x010A	*/	CANT_MAP_CHARACTER	,
/*	0x010B	*/	CANT_MAP_CHARACTER	,
/*	0x010C	*/	CANT_MAP_CHARACTER	,
/*	0x010D	*/	CANT_MAP_CHARACTER	,
/*	0x010E 	*/	CANT_MAP_CHARACTER	,
/*	0x010F 	*/	CANT_MAP_CHARACTER	,
/*	0x0110 	*/	0xD0	,
/*	0x0111 	*/	0xF0	,
/*	0x0112 	*/	CANT_MAP_CHARACTER	,
/*	0x0113 	*/	CANT_MAP_CHARACTER	,
/*	0x0114 	*/	CANT_MAP_CHARACTER	,
/*	0x0115 	*/	CANT_MAP_CHARACTER	,
/*	0x0116 	*/	CANT_MAP_CHARACTER	,
/*	0x0117 	*/	CANT_MAP_CHARACTER	,
/*	0x0118 	*/	CANT_MAP_CHARACTER	,
/*	0x0119 	*/	CANT_MAP_CHARACTER	,
/*	0x011A	*/	CANT_MAP_CHARACTER	,
/*	0x011B	*/	CANT_MAP_CHARACTER	,
/*	0x011C	*/	CANT_MAP_CHARACTER	,
/*	0x011D	*/	CANT_MAP_CHARACTER	,
/*	0x011E 	*/	CANT_MAP_CHARACTER	,
/*	0x011F 	*/	CANT_MAP_CHARACTER	,
/*	0x0120 	*/	CANT_MAP_CHARACTER	,
/*	0x0121 	*/	CANT_MAP_CHARACTER	,
/*	0x0122 	*/	CANT_MAP_CHARACTER	,
/*	0x0123 	*/	CANT_MAP_CHARACTER	,
/*	0x0124 	*/	CANT_MAP_CHARACTER	,
/*	0x0125 	*/	CANT_MAP_CHARACTER	,
/*	0x0126 	*/	CANT_MAP_CHARACTER	,
/*	0x0127 	*/	CANT_MAP_CHARACTER	,
/*	0x0128 	*/	CANT_MAP_CHARACTER	,
/*	0x0129 	*/	CANT_MAP_CHARACTER	,
/*	0x012A	*/	CANT_MAP_CHARACTER	,
/*	0x012B	*/	CANT_MAP_CHARACTER	,
/*	0x012C	*/	CANT_MAP_CHARACTER	,
/*	0x012D	*/	CANT_MAP_CHARACTER	,
/*	0x012E 	*/	CANT_MAP_CHARACTER	,
/*	0x012F 	*/	CANT_MAP_CHARACTER	,
/*	0x0130 	*/	CANT_MAP_CHARACTER	,
/*	0x0131 	*/	CANT_MAP_CHARACTER	,
/*	0x0132 	*/	CANT_MAP_CHARACTER	,
/*	0x0133 	*/	CANT_MAP_CHARACTER	,
/*	0x0134 	*/	CANT_MAP_CHARACTER	,
/*	0x0135 	*/	CANT_MAP_CHARACTER	,
/*	0x0136 	*/	CANT_MAP_CHARACTER	,
/*	0x0137 	*/	CANT_MAP_CHARACTER	,
/*	0x0138 	*/	CANT_MAP_CHARACTER	,
/*	0x0139 	*/	CANT_MAP_CHARACTER	,
/*	0x013A	*/	CANT_MAP_CHARACTER	,
/*	0x013B	*/	CANT_MAP_CHARACTER	,
/*	0x013C	*/	CANT_MAP_CHARACTER	,
/*	0x013D	*/	CANT_MAP_CHARACTER	,
/*	0x013E 	*/	CANT_MAP_CHARACTER	,
/*	0x013F 	*/	CANT_MAP_CHARACTER	,
/*	0x0140 	*/	CANT_MAP_CHARACTER	,
/*	0x0141 	*/	CANT_MAP_CHARACTER	,
/*	0x0142 	*/	CANT_MAP_CHARACTER	,
/*	0x0143 	*/	CANT_MAP_CHARACTER	,
/*	0x0144 	*/	CANT_MAP_CHARACTER	,
/*	0x0145 	*/	CANT_MAP_CHARACTER	,
/*	0x0146 	*/	CANT_MAP_CHARACTER	,
/*	0x0147 	*/	CANT_MAP_CHARACTER	,
/*	0x0148 	*/	CANT_MAP_CHARACTER	,
/*	0x0149 	*/	CANT_MAP_CHARACTER	,
/*	0x014A	*/	CANT_MAP_CHARACTER	,
/*	0x014B	*/	CANT_MAP_CHARACTER	,
/*	0x014C	*/	CANT_MAP_CHARACTER	,
/*	0x014D	*/	CANT_MAP_CHARACTER	,
/*	0x014E 	*/	CANT_MAP_CHARACTER	,
/*	0x014F 	*/	CANT_MAP_CHARACTER	,
/*	0x0150 	*/	CANT_MAP_CHARACTER	,
/*	0x0151 	*/	CANT_MAP_CHARACTER	,
/*	0x0152 	*/	0x8C	,
/*	0x0153 	*/	0x9C	,
/*	0x0154 	*/	CANT_MAP_CHARACTER	,
/*	0x0155 	*/	CANT_MAP_CHARACTER	,
/*	0x0156 	*/	CANT_MAP_CHARACTER	,
/*	0x0157 	*/	CANT_MAP_CHARACTER	,
/*	0x0158 	*/	CANT_MAP_CHARACTER	,
/*	0x0159 	*/	CANT_MAP_CHARACTER	,
/*	0x015A	*/	CANT_MAP_CHARACTER	,
/*	0x015B	*/	CANT_MAP_CHARACTER	,
/*	0x015C	*/	CANT_MAP_CHARACTER	,
/*	0x015D	*/	CANT_MAP_CHARACTER	,
/*	0x015E 	*/	CANT_MAP_CHARACTER	,
/*	0x015F 	*/	CANT_MAP_CHARACTER	,
/*	0x0160 	*/	CANT_MAP_CHARACTER	,
/*	0x0161 	*/	CANT_MAP_CHARACTER	,
/*	0x0162 	*/	CANT_MAP_CHARACTER	,
/*	0x0163 	*/	CANT_MAP_CHARACTER	,
/*	0x0164 	*/	CANT_MAP_CHARACTER	,
/*	0x0165 	*/	CANT_MAP_CHARACTER	,
/*	0x0166 	*/	CANT_MAP_CHARACTER	,
/*	0x0167 	*/	CANT_MAP_CHARACTER	,
/*	0x0168 	*/	CANT_MAP_CHARACTER	,
/*	0x0169 	*/	CANT_MAP_CHARACTER	,
/*	0x016A	*/	CANT_MAP_CHARACTER	,
/*	0x016B	*/	CANT_MAP_CHARACTER	,
/*	0x016C	*/	CANT_MAP_CHARACTER	,
/*	0x016D	*/	CANT_MAP_CHARACTER	,
/*	0x016E 	*/	CANT_MAP_CHARACTER	,
/*	0x016F 	*/	CANT_MAP_CHARACTER	,
/*	0x0170 	*/	CANT_MAP_CHARACTER	,
/*	0x0171 	*/	CANT_MAP_CHARACTER	,
/*	0x0172 	*/	CANT_MAP_CHARACTER	,
/*	0x0173 	*/	CANT_MAP_CHARACTER	,
/*	0x0174 	*/	CANT_MAP_CHARACTER	,
/*	0x0175 	*/	CANT_MAP_CHARACTER	,
/*	0x0176 	*/	CANT_MAP_CHARACTER	,
/*	0x0177 	*/	CANT_MAP_CHARACTER	,
/*	0x0178 	*/	0x9F	,
/*	0x0179 	*/	CANT_MAP_CHARACTER	,
/*	0x017A	*/	CANT_MAP_CHARACTER	,
/*	0x017B	*/	CANT_MAP_CHARACTER	,
/*	0x017C	*/	CANT_MAP_CHARACTER	,
/*	0x017D	*/	CANT_MAP_CHARACTER	,
/*	0x017E 	*/	CANT_MAP_CHARACTER	,
/*	0x017F 	*/	CANT_MAP_CHARACTER	,
/*	0x0180 	*/	CANT_MAP_CHARACTER	,
/*	0x0181 	*/	CANT_MAP_CHARACTER	,
/*	0x0182 	*/	CANT_MAP_CHARACTER	,
/*	0x0183 	*/	CANT_MAP_CHARACTER	,
/*	0x0184 	*/	CANT_MAP_CHARACTER	,
/*	0x0185 	*/	CANT_MAP_CHARACTER	,
/*	0x0186 	*/	CANT_MAP_CHARACTER	,
/*	0x0187 	*/	CANT_MAP_CHARACTER	,
/*	0x0188 	*/	CANT_MAP_CHARACTER	,
/*	0x0189 	*/	CANT_MAP_CHARACTER	,
/*	0x018A	*/	CANT_MAP_CHARACTER	,
/*	0x018B	*/	CANT_MAP_CHARACTER	,
/*	0x018C	*/	CANT_MAP_CHARACTER	,
/*	0x018D	*/	CANT_MAP_CHARACTER	,
/*	0x018E 	*/	CANT_MAP_CHARACTER	,
/*	0x018F 	*/	CANT_MAP_CHARACTER	,
/*	0x0190 	*/	CANT_MAP_CHARACTER	,
/*	0x0191 	*/	CANT_MAP_CHARACTER	,
/*	0x0192 	*/	0x83	,
/*	0x0193 	*/	CANT_MAP_CHARACTER	,
/*	0x0194 	*/	CANT_MAP_CHARACTER	,
/*	0x0195 	*/	CANT_MAP_CHARACTER	,
/*	0x0196 	*/	CANT_MAP_CHARACTER	,
/*	0x0197 	*/	CANT_MAP_CHARACTER	,
/*	0x0198 	*/	CANT_MAP_CHARACTER	,
/*	0x0199 	*/	CANT_MAP_CHARACTER	,
/*	0x019A	*/	CANT_MAP_CHARACTER	,
/*	0x019B	*/	CANT_MAP_CHARACTER	,
/*	0x019C	*/	CANT_MAP_CHARACTER	,
/*	0x019D	*/	CANT_MAP_CHARACTER	,
/*	0x019E 	*/	CANT_MAP_CHARACTER	,
/*	0x019F 	*/	CANT_MAP_CHARACTER	,
/*	0x01A0	*/	0xD5	,
/*	0x01A1	*/	0xF5	,
/*	0x01A2	*/	CANT_MAP_CHARACTER	,
/*	0x01A3	*/	CANT_MAP_CHARACTER	,
/*	0x01A4	*/	CANT_MAP_CHARACTER	,
/*	0x01A5	*/	CANT_MAP_CHARACTER	,
/*	0x01A6	*/	CANT_MAP_CHARACTER	,
/*	0x01A7	*/	CANT_MAP_CHARACTER	,
/*	0x01A8	*/	CANT_MAP_CHARACTER	,
/*	0x01A9	*/	CANT_MAP_CHARACTER	,
/*	0x01AA	*/	CANT_MAP_CHARACTER	,
/*	0x01AB	*/	CANT_MAP_CHARACTER	,
/*	0x01AC	*/	CANT_MAP_CHARACTER	,
/*	0x01AD	*/	CANT_MAP_CHARACTER	,
/*	0x01AE	*/	CANT_MAP_CHARACTER	,
/*	0x01AF 	*/	0xDD	,
/*	0x01B0	*/	0xFD	,
/*	0x01B1	*/	CANT_MAP_CHARACTER	,
/*	0x01B2	*/	CANT_MAP_CHARACTER	,
/*	0x01B3	*/	CANT_MAP_CHARACTER	,
/*	0x01B4	*/	CANT_MAP_CHARACTER	,
/*	0x01B5	*/	CANT_MAP_CHARACTER	,
/*	0x01B6	*/	CANT_MAP_CHARACTER	,
/*	0x01B7	*/	CANT_MAP_CHARACTER	,
/*	0x01B8	*/	CANT_MAP_CHARACTER	,
/*	0x01B9	*/	CANT_MAP_CHARACTER	,
/*	0x01BA	*/	CANT_MAP_CHARACTER	,
/*	0x01BB	*/	CANT_MAP_CHARACTER	,
/*	0x01BC	*/	CANT_MAP_CHARACTER	,
/*	0x01BD	*/	CANT_MAP_CHARACTER	,
/*	0x01BE	*/	CANT_MAP_CHARACTER	,
/*	0x01BF 	*/	CANT_MAP_CHARACTER	,
/*	0x01C0	*/	CANT_MAP_CHARACTER	,
/*	0x01C1	*/	CANT_MAP_CHARACTER	,
/*	0x01C2	*/	CANT_MAP_CHARACTER	,
/*	0x01C3	*/	CANT_MAP_CHARACTER	,
/*	0x01C4	*/	CANT_MAP_CHARACTER	,
/*	0x01C5	*/	CANT_MAP_CHARACTER	,
/*	0x01C6	*/	CANT_MAP_CHARACTER	,
/*	0x01C7	*/	CANT_MAP_CHARACTER	,
/*	0x01C8	*/	CANT_MAP_CHARACTER	,
/*	0x01C9	*/	CANT_MAP_CHARACTER	,
/*	0x01CA	*/	CANT_MAP_CHARACTER	,
/*	0x01CB	*/	CANT_MAP_CHARACTER	,
/*	0x01CC	*/	CANT_MAP_CHARACTER	,
/*	0x01CD	*/	CANT_MAP_CHARACTER	,
/*	0x01CE	*/	CANT_MAP_CHARACTER	,
/*	0x01CF 	*/	CANT_MAP_CHARACTER	,
/*	0x01D0	*/	CANT_MAP_CHARACTER	,
/*	0x01D1	*/	CANT_MAP_CHARACTER	,
/*	0x01D2	*/	CANT_MAP_CHARACTER	,
/*	0x01D3	*/	CANT_MAP_CHARACTER	,
/*	0x01D4	*/	CANT_MAP_CHARACTER	,
/*	0x01D5	*/	CANT_MAP_CHARACTER	,
/*	0x01D6	*/	CANT_MAP_CHARACTER	,
/*	0x01D7	*/	CANT_MAP_CHARACTER	,
/*	0x01D8	*/	CANT_MAP_CHARACTER	,
/*	0x01D9	*/	CANT_MAP_CHARACTER	,
/*	0x01DA	*/	CANT_MAP_CHARACTER	,
/*	0x01DB	*/	CANT_MAP_CHARACTER	,
/*	0x01DC	*/	CANT_MAP_CHARACTER	,
/*	0x01DD	*/	CANT_MAP_CHARACTER	,
/*	0x01DE	*/	CANT_MAP_CHARACTER	,
/*	0x01DF	*/	CANT_MAP_CHARACTER	,
/*	0x01E0 	*/	CANT_MAP_CHARACTER	,
/*	0x01E1 	*/	CANT_MAP_CHARACTER	,
/*	0x01E2 	*/	CANT_MAP_CHARACTER	,
/*	0x01E3 	*/	CANT_MAP_CHARACTER	,
/*	0x01E4 	*/	CANT_MAP_CHARACTER	,
/*	0x01E5 	*/	CANT_MAP_CHARACTER	,
/*	0x01E6 	*/	CANT_MAP_CHARACTER	,
/*	0x01E7 	*/	CANT_MAP_CHARACTER	,
/*	0x01E8 	*/	CANT_MAP_CHARACTER	,
/*	0x01E9 	*/	CANT_MAP_CHARACTER	,
/*	0x01EA	*/	CANT_MAP_CHARACTER	,
/*	0x01EB	*/	CANT_MAP_CHARACTER	,
/*	0x01EC	*/	CANT_MAP_CHARACTER	,
/*	0x01ED	*/	CANT_MAP_CHARACTER	,
/*	0x01EE 	*/	CANT_MAP_CHARACTER	,
/*	0x01EF 	*/	CANT_MAP_CHARACTER	,
/*	0x01F0 	*/	CANT_MAP_CHARACTER	,
/*	0x01F1 	*/	CANT_MAP_CHARACTER	,
/*	0x01F2 	*/	CANT_MAP_CHARACTER	,
/*	0x01F3 	*/	CANT_MAP_CHARACTER	,
/*	0x01F4 	*/	CANT_MAP_CHARACTER	,
/*	0x01F5 	*/	CANT_MAP_CHARACTER	,
/*	0x01F6 	*/	CANT_MAP_CHARACTER	,
/*	0x01F7 	*/	CANT_MAP_CHARACTER	,
/*	0x01F8 	*/	CANT_MAP_CHARACTER	,
/*	0x01F9 	*/	CANT_MAP_CHARACTER	,
/*	0x01FA 	*/	CANT_MAP_CHARACTER	,
/*	0x01FB 	*/	CANT_MAP_CHARACTER	,
/*	0x01FC 	*/	CANT_MAP_CHARACTER	,
/*	0x01FD	*/	CANT_MAP_CHARACTER	,
/*	0x01FE 	*/	CANT_MAP_CHARACTER	,
/*	0x01FF 	*/	CANT_MAP_CHARACTER	,
/*	0x0200 	*/	CANT_MAP_CHARACTER	,
/*	0x0201 	*/	CANT_MAP_CHARACTER	,
/*	0x0202 	*/	CANT_MAP_CHARACTER	,
/*	0x0203 	*/	CANT_MAP_CHARACTER	,
/*	0x0204 	*/	CANT_MAP_CHARACTER	,
/*	0x0205 	*/	CANT_MAP_CHARACTER	,
/*	0x0206 	*/	CANT_MAP_CHARACTER	,
/*	0x0207 	*/	CANT_MAP_CHARACTER	,
/*	0x0208 	*/	CANT_MAP_CHARACTER	,
/*	0x0209 	*/	CANT_MAP_CHARACTER	,
/*	0x020A	*/	CANT_MAP_CHARACTER	,
/*	0x020B	*/	CANT_MAP_CHARACTER	,
/*	0x020C	*/	CANT_MAP_CHARACTER	,
/*	0x020D	*/	CANT_MAP_CHARACTER	,
/*	0x020E 	*/	CANT_MAP_CHARACTER	,
/*	0x020F 	*/	CANT_MAP_CHARACTER	,
/*	0x0210 	*/	CANT_MAP_CHARACTER	,
/*	0x0211 	*/	CANT_MAP_CHARACTER	,
/*	0x0212 	*/	CANT_MAP_CHARACTER	,
/*	0x0213 	*/	CANT_MAP_CHARACTER	,
/*	0x0214 	*/	CANT_MAP_CHARACTER	,
/*	0x0215 	*/	CANT_MAP_CHARACTER	,
/*	0x0216 	*/	CANT_MAP_CHARACTER	,
/*	0x0217 	*/	CANT_MAP_CHARACTER	,
/*	0x0218 	*/	CANT_MAP_CHARACTER	,
/*	0x0219 	*/	CANT_MAP_CHARACTER	,
/*	0x021A	*/	CANT_MAP_CHARACTER	,
/*	0x021B	*/	CANT_MAP_CHARACTER	,
/*	0x021C	*/	CANT_MAP_CHARACTER	,
/*	0x021D	*/	CANT_MAP_CHARACTER	,
/*	0x021E 	*/	CANT_MAP_CHARACTER	,
/*	0x021F 	*/	CANT_MAP_CHARACTER	,
/*	0x0220 	*/	CANT_MAP_CHARACTER	,
/*	0x0221 	*/	CANT_MAP_CHARACTER	,
/*	0x0222 	*/	CANT_MAP_CHARACTER	,
/*	0x0223 	*/	CANT_MAP_CHARACTER	,
/*	0x0224 	*/	CANT_MAP_CHARACTER	,
/*	0x0225 	*/	CANT_MAP_CHARACTER	,
/*	0x0226 	*/	CANT_MAP_CHARACTER	,
/*	0x0227 	*/	CANT_MAP_CHARACTER	,
/*	0x0228 	*/	CANT_MAP_CHARACTER	,
/*	0x0229 	*/	CANT_MAP_CHARACTER	,
/*	0x022A	*/	CANT_MAP_CHARACTER	,
/*	0x022B	*/	CANT_MAP_CHARACTER	,
/*	0x022C	*/	CANT_MAP_CHARACTER	,
/*	0x022D	*/	CANT_MAP_CHARACTER	,
/*	0x022E 	*/	CANT_MAP_CHARACTER	,
/*	0x022F 	*/	CANT_MAP_CHARACTER	,
/*	0x0230 	*/	CANT_MAP_CHARACTER	,
/*	0x0231 	*/	CANT_MAP_CHARACTER	,
/*	0x0232 	*/	CANT_MAP_CHARACTER	,
/*	0x0233 	*/	CANT_MAP_CHARACTER	,
/*	0x0234 	*/	CANT_MAP_CHARACTER	,
/*	0x0235 	*/	CANT_MAP_CHARACTER	,
/*	0x0236 	*/	CANT_MAP_CHARACTER	,
/*	0x0237 	*/	CANT_MAP_CHARACTER	,
/*	0x0238 	*/	CANT_MAP_CHARACTER	,
/*	0x0239 	*/	CANT_MAP_CHARACTER	,
/*	0x023A	*/	CANT_MAP_CHARACTER	,
/*	0x023B	*/	CANT_MAP_CHARACTER	,
/*	0x023C	*/	CANT_MAP_CHARACTER	,
/*	0x023D	*/	CANT_MAP_CHARACTER	,
/*	0x023E 	*/	CANT_MAP_CHARACTER	,
/*	0x023F 	*/	CANT_MAP_CHARACTER	,
/*	0x0240 	*/	CANT_MAP_CHARACTER	,
/*	0x0241 	*/	CANT_MAP_CHARACTER	,
/*	0x0242 	*/	CANT_MAP_CHARACTER	,
/*	0x0243 	*/	CANT_MAP_CHARACTER	,
/*	0x0244 	*/	CANT_MAP_CHARACTER	,
/*	0x0245 	*/	CANT_MAP_CHARACTER	,
/*	0x0246 	*/	CANT_MAP_CHARACTER	,
/*	0x0247 	*/	CANT_MAP_CHARACTER	,
/*	0x0248 	*/	CANT_MAP_CHARACTER	,
/*	0x0249 	*/	CANT_MAP_CHARACTER	,
/*	0x024A	*/	CANT_MAP_CHARACTER	,
/*	0x024B	*/	CANT_MAP_CHARACTER	,
/*	0x024C	*/	CANT_MAP_CHARACTER	,
/*	0x024D	*/	CANT_MAP_CHARACTER	,
/*	0x024E 	*/	CANT_MAP_CHARACTER	,
/*	0x024F 	*/	CANT_MAP_CHARACTER	,
/*	0x0250 	*/	CANT_MAP_CHARACTER	,
/*	0x0251 	*/	CANT_MAP_CHARACTER	,
/*	0x0252 	*/	CANT_MAP_CHARACTER	,
/*	0x0253 	*/	CANT_MAP_CHARACTER	,
/*	0x0254 	*/	CANT_MAP_CHARACTER	,
/*	0x0255 	*/	CANT_MAP_CHARACTER	,
/*	0x0256 	*/	CANT_MAP_CHARACTER	,
/*	0x0257 	*/	CANT_MAP_CHARACTER	,
/*	0x0258 	*/	CANT_MAP_CHARACTER	,
/*	0x0259 	*/	CANT_MAP_CHARACTER	,
/*	0x025A	*/	CANT_MAP_CHARACTER	,
/*	0x025B	*/	CANT_MAP_CHARACTER	,
/*	0x025C	*/	CANT_MAP_CHARACTER	,
/*	0x025D	*/	CANT_MAP_CHARACTER	,
/*	0x025E 	*/	CANT_MAP_CHARACTER	,
/*	0x025F 	*/	CANT_MAP_CHARACTER	,
/*	0x0260 	*/	CANT_MAP_CHARACTER	,
/*	0x0261 	*/	CANT_MAP_CHARACTER	,
/*	0x0262 	*/	CANT_MAP_CHARACTER	,
/*	0x0263 	*/	CANT_MAP_CHARACTER	,
/*	0x0264 	*/	CANT_MAP_CHARACTER	,
/*	0x0265 	*/	CANT_MAP_CHARACTER	,
/*	0x0266 	*/	CANT_MAP_CHARACTER	,
/*	0x0267 	*/	CANT_MAP_CHARACTER	,
/*	0x0268 	*/	CANT_MAP_CHARACTER	,
/*	0x0269 	*/	CANT_MAP_CHARACTER	,
/*	0x026A	*/	CANT_MAP_CHARACTER	,
/*	0x026B	*/	CANT_MAP_CHARACTER	,
/*	0x026C	*/	CANT_MAP_CHARACTER	,
/*	0x026D	*/	CANT_MAP_CHARACTER	,
/*	0x026E 	*/	CANT_MAP_CHARACTER	,
/*	0x026F 	*/	CANT_MAP_CHARACTER	,
/*	0x0270 	*/	CANT_MAP_CHARACTER	,
/*	0x0271 	*/	CANT_MAP_CHARACTER	,
/*	0x0272 	*/	CANT_MAP_CHARACTER	,
/*	0x0273 	*/	CANT_MAP_CHARACTER	,
/*	0x0274 	*/	CANT_MAP_CHARACTER	,
/*	0x0275 	*/	CANT_MAP_CHARACTER	,
/*	0x0276 	*/	CANT_MAP_CHARACTER	,
/*	0x0277 	*/	CANT_MAP_CHARACTER	,
/*	0x0278 	*/	CANT_MAP_CHARACTER	,
/*	0x0279 	*/	CANT_MAP_CHARACTER	,
/*	0x027A	*/	CANT_MAP_CHARACTER	,
/*	0x027B	*/	CANT_MAP_CHARACTER	,
/*	0x027C	*/	CANT_MAP_CHARACTER	,
/*	0x027D	*/	CANT_MAP_CHARACTER	,
/*	0x027E 	*/	CANT_MAP_CHARACTER	,
/*	0x027F 	*/	CANT_MAP_CHARACTER	,
/*	0x0280 	*/	CANT_MAP_CHARACTER	,
/*	0x0281 	*/	CANT_MAP_CHARACTER	,
/*	0x0282 	*/	CANT_MAP_CHARACTER	,
/*	0x0283 	*/	CANT_MAP_CHARACTER	,
/*	0x0284 	*/	CANT_MAP_CHARACTER	,
/*	0x0285 	*/	CANT_MAP_CHARACTER	,
/*	0x0286 	*/	CANT_MAP_CHARACTER	,
/*	0x0287 	*/	CANT_MAP_CHARACTER	,
/*	0x0288 	*/	CANT_MAP_CHARACTER	,
/*	0x0289 	*/	CANT_MAP_CHARACTER	,
/*	0x028A	*/	CANT_MAP_CHARACTER	,
/*	0x028B	*/	CANT_MAP_CHARACTER	,
/*	0x028C	*/	CANT_MAP_CHARACTER	,
/*	0x028D	*/	CANT_MAP_CHARACTER	,
/*	0x028E 	*/	CANT_MAP_CHARACTER	,
/*	0x028F 	*/	CANT_MAP_CHARACTER	,
/*	0x0290 	*/	CANT_MAP_CHARACTER	,
/*	0x0291 	*/	CANT_MAP_CHARACTER	,
/*	0x0292 	*/	CANT_MAP_CHARACTER	,
/*	0x0293 	*/	CANT_MAP_CHARACTER	,
/*	0x0294 	*/	CANT_MAP_CHARACTER	,
/*	0x0295 	*/	CANT_MAP_CHARACTER	,
/*	0x0296 	*/	CANT_MAP_CHARACTER	,
/*	0x0297 	*/	CANT_MAP_CHARACTER	,
/*	0x0298 	*/	CANT_MAP_CHARACTER	,
/*	0x0299 	*/	CANT_MAP_CHARACTER	,
/*	0x029A	*/	CANT_MAP_CHARACTER	,
/*	0x029B	*/	CANT_MAP_CHARACTER	,
/*	0x029C	*/	CANT_MAP_CHARACTER	,
/*	0x029D	*/	CANT_MAP_CHARACTER	,
/*	0x029E 	*/	CANT_MAP_CHARACTER	,
/*	0x029F 	*/	CANT_MAP_CHARACTER	,
/*	0x02A0	*/	CANT_MAP_CHARACTER	,
/*	0x02A1	*/	CANT_MAP_CHARACTER	,
/*	0x02A2	*/	CANT_MAP_CHARACTER	,
/*	0x02A3	*/	CANT_MAP_CHARACTER	,
/*	0x02A4	*/	CANT_MAP_CHARACTER	,
/*	0x02A5	*/	CANT_MAP_CHARACTER	,
/*	0x02A6	*/	CANT_MAP_CHARACTER	,
/*	0x02A7	*/	CANT_MAP_CHARACTER	,
/*	0x02A8	*/	CANT_MAP_CHARACTER	,
/*	0x02A9	*/	CANT_MAP_CHARACTER	,
/*	0x02AA	*/	CANT_MAP_CHARACTER	,
/*	0x02AB	*/	CANT_MAP_CHARACTER	,
/*	0x02AC	*/	CANT_MAP_CHARACTER	,
/*	0x02AD	*/	CANT_MAP_CHARACTER	,
/*	0x02AE	*/	CANT_MAP_CHARACTER	,
/*	0x02AF 	*/	CANT_MAP_CHARACTER	,
/*	0x02B0	*/	CANT_MAP_CHARACTER	,
/*	0x02B1	*/	CANT_MAP_CHARACTER	,
/*	0x02B2	*/	CANT_MAP_CHARACTER	,
/*	0x02B3	*/	CANT_MAP_CHARACTER	,
/*	0x02B4	*/	CANT_MAP_CHARACTER	,
/*	0x02B5	*/	CANT_MAP_CHARACTER	,
/*	0x02B6	*/	CANT_MAP_CHARACTER	,
/*	0x02B7	*/	CANT_MAP_CHARACTER	,
/*	0x02B8	*/	CANT_MAP_CHARACTER	,
/*	0x02B9	*/	CANT_MAP_CHARACTER	,
/*	0x02BA	*/	CANT_MAP_CHARACTER	,
/*	0x02BB	*/	CANT_MAP_CHARACTER	,
/*	0x02BC	*/	CANT_MAP_CHARACTER	,
/*	0x02BD	*/	CANT_MAP_CHARACTER	,
/*	0x02BE	*/	CANT_MAP_CHARACTER	,
/*	0x02BF 	*/	CANT_MAP_CHARACTER	,
/*	0x02C0	*/	CANT_MAP_CHARACTER	,
/*	0x02C1	*/	CANT_MAP_CHARACTER	,
/*	0x02C2	*/	CANT_MAP_CHARACTER	,
/*	0x02C3	*/	CANT_MAP_CHARACTER	,
/*	0x02C4	*/	CANT_MAP_CHARACTER	,
/*	0x02C5	*/	CANT_MAP_CHARACTER	,
/*	0x02C6	*/	0x88	,
/*	0x02C7	*/	CANT_MAP_CHARACTER	,
/*	0x02C8	*/	CANT_MAP_CHARACTER	,
/*	0x02C9	*/	CANT_MAP_CHARACTER	,
/*	0x02CA	*/	CANT_MAP_CHARACTER	,
/*	0x02CB	*/	CANT_MAP_CHARACTER	,
/*	0x02CC	*/	CANT_MAP_CHARACTER	,
/*	0x02CD	*/	CANT_MAP_CHARACTER	,
/*	0x02CE	*/	CANT_MAP_CHARACTER	,
/*	0x02CF 	*/	CANT_MAP_CHARACTER	,
/*	0x02D0	*/	CANT_MAP_CHARACTER	,
/*	0x02D1	*/	CANT_MAP_CHARACTER	,
/*	0x02D2	*/	CANT_MAP_CHARACTER	,
/*	0x02D3	*/	CANT_MAP_CHARACTER	,
/*	0x02D4	*/	CANT_MAP_CHARACTER	,
/*	0x02D5	*/	CANT_MAP_CHARACTER	,
/*	0x02D6	*/	CANT_MAP_CHARACTER	,
/*	0x02D7	*/	CANT_MAP_CHARACTER	,
/*	0x02D8	*/	CANT_MAP_CHARACTER	,
/*	0x02D9	*/	CANT_MAP_CHARACTER	,
/*	0x02DA	*/	CANT_MAP_CHARACTER	,
/*	0x02DB	*/	CANT_MAP_CHARACTER	,
/*	0x02DC	*/	0x98	,
/*	0x02DD	*/	CANT_MAP_CHARACTER	,
/*	0x02DE	*/	CANT_MAP_CHARACTER	,
/*	0x02DF	*/	CANT_MAP_CHARACTER	,
/*	0x02E0 	*/	CANT_MAP_CHARACTER	,
/*	0x02E1 	*/	CANT_MAP_CHARACTER	,
/*	0x02E2 	*/	CANT_MAP_CHARACTER	,
/*	0x02E3 	*/	CANT_MAP_CHARACTER	,
/*	0x02E4 	*/	CANT_MAP_CHARACTER	,
/*	0x02E5 	*/	CANT_MAP_CHARACTER	,
/*	0x02E6 	*/	CANT_MAP_CHARACTER	,
/*	0x02E7 	*/	CANT_MAP_CHARACTER	,
/*	0x02E8 	*/	CANT_MAP_CHARACTER	,
/*	0x02E9 	*/	CANT_MAP_CHARACTER	,
/*	0x02EA	*/	CANT_MAP_CHARACTER	,
/*	0x02EB	*/	CANT_MAP_CHARACTER	,
/*	0x02EC	*/	CANT_MAP_CHARACTER	,
/*	0x02ED	*/	CANT_MAP_CHARACTER	,
/*	0x02EE 	*/	CANT_MAP_CHARACTER	,
/*	0x02EF 	*/	CANT_MAP_CHARACTER	,
/*	0x02F0 	*/	CANT_MAP_CHARACTER	,
/*	0x02F1 	*/	CANT_MAP_CHARACTER	,
/*	0x02F2 	*/	CANT_MAP_CHARACTER	,
/*	0x02F3 	*/	CANT_MAP_CHARACTER	,
/*	0x02F4 	*/	CANT_MAP_CHARACTER	,
/*	0x02F5 	*/	CANT_MAP_CHARACTER	,
/*	0x02F6 	*/	CANT_MAP_CHARACTER	,
/*	0x02F7 	*/	CANT_MAP_CHARACTER	,
/*	0x02F8 	*/	CANT_MAP_CHARACTER	,
/*	0x02F9 	*/	CANT_MAP_CHARACTER	,
/*	0x02FA 	*/	CANT_MAP_CHARACTER	,
/*	0x02FB 	*/	CANT_MAP_CHARACTER	,
/*	0x02FC 	*/	CANT_MAP_CHARACTER	,
/*	0x02FD	*/	CANT_MAP_CHARACTER	,
/*	0x02FE 	*/	CANT_MAP_CHARACTER	,
/*	0x02FF 	*/	CANT_MAP_CHARACTER	,
/*	0x0300 	*/	0xCC	,
/*	0x0301 	*/	0xEC	,
/*	0x0302 	*/	CANT_MAP_CHARACTER	,
/*	0x0303 	*/	0xDE	,
/*	0x0304 	*/	CANT_MAP_CHARACTER	,
/*	0x0305 	*/	CANT_MAP_CHARACTER	,
/*	0x0306 	*/	CANT_MAP_CHARACTER	,
/*	0x0307 	*/	CANT_MAP_CHARACTER	,
/*	0x0308 	*/	CANT_MAP_CHARACTER	,
/*	0x0309 	*/	0xD2	,
/*	0x030A	*/	CANT_MAP_CHARACTER	,
/*	0x030B	*/	CANT_MAP_CHARACTER	,
/*	0x030C	*/	CANT_MAP_CHARACTER	,
/*	0x030D	*/	CANT_MAP_CHARACTER	,
/*	0x030E 	*/	CANT_MAP_CHARACTER	,
/*	0x030F 	*/	CANT_MAP_CHARACTER	,
/*	0x0310 	*/	CANT_MAP_CHARACTER	,
/*	0x0311 	*/	CANT_MAP_CHARACTER	,
/*	0x0312 	*/	CANT_MAP_CHARACTER	,
/*	0x0313 	*/	CANT_MAP_CHARACTER	,
/*	0x0314 	*/	CANT_MAP_CHARACTER	,
/*	0x0315 	*/	CANT_MAP_CHARACTER	,
/*	0x0316 	*/	CANT_MAP_CHARACTER	,
/*	0x0317 	*/	CANT_MAP_CHARACTER	,
/*	0x0318 	*/	CANT_MAP_CHARACTER	,
/*	0x0319 	*/	CANT_MAP_CHARACTER	,
/*	0x031A	*/	CANT_MAP_CHARACTER	,
/*	0x031B	*/	CANT_MAP_CHARACTER	,
/*	0x031C	*/	CANT_MAP_CHARACTER	,
/*	0x031D	*/	CANT_MAP_CHARACTER	,
/*	0x031E 	*/	CANT_MAP_CHARACTER	,
/*	0x031F 	*/	CANT_MAP_CHARACTER	,
/*	0x0320 	*/	CANT_MAP_CHARACTER	,
/*	0x0321 	*/	CANT_MAP_CHARACTER	,
/*	0x0322 	*/	CANT_MAP_CHARACTER	,
/*	0x0323 	*/	0xF2	,
/*	0x0324 	*/	CANT_MAP_CHARACTER	,
/*	0x0325 	*/	CANT_MAP_CHARACTER	,
/*	0x0326 	*/	CANT_MAP_CHARACTER	,
/*	0x0327 	*/	CANT_MAP_CHARACTER	,
/*	0x0328 	*/	CANT_MAP_CHARACTER	,
/*	0x0329 	*/	CANT_MAP_CHARACTER	,
/*	0x032A	*/	CANT_MAP_CHARACTER	,
/*	0x032B	*/	CANT_MAP_CHARACTER	,
/*	0x032C	*/	CANT_MAP_CHARACTER	,
/*	0x032D	*/	CANT_MAP_CHARACTER	,
/*	0x032E 	*/	CANT_MAP_CHARACTER	,
/*	0x032F 	*/	CANT_MAP_CHARACTER	,
/*	0x0330 	*/	CANT_MAP_CHARACTER	,
/*	0x0331 	*/	CANT_MAP_CHARACTER	,
/*	0x0332 	*/	CANT_MAP_CHARACTER	,
/*	0x0333 	*/	CANT_MAP_CHARACTER	,
/*	0x0334 	*/	CANT_MAP_CHARACTER	,
/*	0x0335 	*/	CANT_MAP_CHARACTER	,
/*	0x0336 	*/	CANT_MAP_CHARACTER	,
/*	0x0337 	*/	CANT_MAP_CHARACTER	,
/*	0x0338 	*/	CANT_MAP_CHARACTER	,
/*	0x0339 	*/	CANT_MAP_CHARACTER	,
/*	0x033A	*/	CANT_MAP_CHARACTER	,
/*	0x033B	*/	CANT_MAP_CHARACTER	,
/*	0x033C	*/	CANT_MAP_CHARACTER	,
/*	0x033D	*/	CANT_MAP_CHARACTER	,
/*	0x033E 	*/	CANT_MAP_CHARACTER	,
/*	0x033F 	*/	CANT_MAP_CHARACTER	,
/*	0x0340 	*/	CANT_MAP_CHARACTER	,
/*	0x0341 	*/	CANT_MAP_CHARACTER	,
/*	0x0342 	*/	CANT_MAP_CHARACTER	,
/*	0x0343 	*/	CANT_MAP_CHARACTER	,
/*	0x0344 	*/	CANT_MAP_CHARACTER	,
/*	0x0345 	*/	CANT_MAP_CHARACTER	,
/*	0x0346 	*/	CANT_MAP_CHARACTER	,
/*	0x0347 	*/	CANT_MAP_CHARACTER	,
/*	0x0348 	*/	CANT_MAP_CHARACTER	,
/*	0x0349 	*/	CANT_MAP_CHARACTER	,
/*	0x034A	*/	CANT_MAP_CHARACTER	,
/*	0x034B	*/	CANT_MAP_CHARACTER	,
/*	0x034C	*/	CANT_MAP_CHARACTER	,
/*	0x034D	*/	CANT_MAP_CHARACTER	,
/*	0x034E 	*/	CANT_MAP_CHARACTER	,
/*	0x034F 	*/	CANT_MAP_CHARACTER	,
/*	0x0350 	*/	CANT_MAP_CHARACTER	,
/*	0x0351 	*/	CANT_MAP_CHARACTER	,
/*	0x0352 	*/	CANT_MAP_CHARACTER	,
/*	0x0353 	*/	CANT_MAP_CHARACTER	,
/*	0x0354 	*/	CANT_MAP_CHARACTER	,
/*	0x0355 	*/	CANT_MAP_CHARACTER	,
/*	0x0356 	*/	CANT_MAP_CHARACTER	,
/*	0x0357 	*/	CANT_MAP_CHARACTER	,
/*	0x0358 	*/	CANT_MAP_CHARACTER	,
/*	0x0359 	*/	CANT_MAP_CHARACTER	,
/*	0x035A	*/	CANT_MAP_CHARACTER	,
/*	0x035B	*/	CANT_MAP_CHARACTER	,
/*	0x035C	*/	CANT_MAP_CHARACTER	,
/*	0x035D	*/	CANT_MAP_CHARACTER	,
/*	0x035E 	*/	CANT_MAP_CHARACTER	,
/*	0x035F 	*/	CANT_MAP_CHARACTER	,
/*	0x0360 	*/	CANT_MAP_CHARACTER	,
/*	0x0361 	*/	CANT_MAP_CHARACTER	,
/*	0x0362 	*/	CANT_MAP_CHARACTER	,
/*	0x0363 	*/	CANT_MAP_CHARACTER	,
/*	0x0364 	*/	CANT_MAP_CHARACTER	,
/*	0x0365 	*/	CANT_MAP_CHARACTER	,
/*	0x0366 	*/	CANT_MAP_CHARACTER	,
/*	0x0367 	*/	CANT_MAP_CHARACTER	,
/*	0x0368 	*/	CANT_MAP_CHARACTER	,
/*	0x0369 	*/	CANT_MAP_CHARACTER	,
/*	0x036A	*/	CANT_MAP_CHARACTER	,
/*	0x036B	*/	CANT_MAP_CHARACTER	,
/*	0x036C	*/	CANT_MAP_CHARACTER	,
/*	0x036D	*/	CANT_MAP_CHARACTER	,
/*	0x036E 	*/	CANT_MAP_CHARACTER	,
/*	0x036F 	*/	CANT_MAP_CHARACTER	,
/*	0x0370 	*/	CANT_MAP_CHARACTER	,
/*	0x0371 	*/	CANT_MAP_CHARACTER	,
/*	0x0372 	*/	CANT_MAP_CHARACTER	,
/*	0x0373 	*/	CANT_MAP_CHARACTER	,
/*	0x0374 	*/	CANT_MAP_CHARACTER	,
/*	0x0375 	*/	CANT_MAP_CHARACTER	,
/*	0x0376 	*/	CANT_MAP_CHARACTER	,
/*	0x0377 	*/	CANT_MAP_CHARACTER	,
/*	0x0378 	*/	CANT_MAP_CHARACTER	,
/*	0x0379 	*/	CANT_MAP_CHARACTER	,
/*	0x037A	*/	CANT_MAP_CHARACTER	,
/*	0x037B	*/	CANT_MAP_CHARACTER	,
/*	0x037C	*/	CANT_MAP_CHARACTER	,
/*	0x037D	*/	CANT_MAP_CHARACTER	,
/*	0x037E 	*/	CANT_MAP_CHARACTER	,
/*	0x037F 	*/	CANT_MAP_CHARACTER	,
/*	0x0380 	*/	CANT_MAP_CHARACTER	,
/*	0x0381 	*/	CANT_MAP_CHARACTER	,
/*	0x0382 	*/	CANT_MAP_CHARACTER	,
/*	0x0383 	*/	CANT_MAP_CHARACTER	,
/*	0x0384 	*/	CANT_MAP_CHARACTER	,
/*	0x0385 	*/	CANT_MAP_CHARACTER	,
/*	0x0386 	*/	CANT_MAP_CHARACTER	,
/*	0x0387 	*/	CANT_MAP_CHARACTER	,
/*	0x0388 	*/	CANT_MAP_CHARACTER	,
/*	0x0389 	*/	CANT_MAP_CHARACTER	,
/*	0x038A	*/	CANT_MAP_CHARACTER	,
/*	0x038B	*/	CANT_MAP_CHARACTER	,
/*	0x038C	*/	CANT_MAP_CHARACTER	,
/*	0x038D	*/	CANT_MAP_CHARACTER	,
/*	0x038E 	*/	CANT_MAP_CHARACTER	,
/*	0x038F 	*/	CANT_MAP_CHARACTER	,
/*	0x0390 	*/	CANT_MAP_CHARACTER	,
/*	0x0391 	*/	CANT_MAP_CHARACTER	,
/*	0x0392 	*/	CANT_MAP_CHARACTER	,
/*	0x0393 	*/	CANT_MAP_CHARACTER	,
/*	0x0394 	*/	CANT_MAP_CHARACTER	,
/*	0x0395 	*/	CANT_MAP_CHARACTER	,
/*	0x0396 	*/	CANT_MAP_CHARACTER	,
/*	0x0397 	*/	CANT_MAP_CHARACTER	,
/*	0x0398 	*/	CANT_MAP_CHARACTER	,
/*	0x0399 	*/	CANT_MAP_CHARACTER	,
/*	0x039A	*/	CANT_MAP_CHARACTER	,
/*	0x039B	*/	CANT_MAP_CHARACTER	,
/*	0x039C	*/	CANT_MAP_CHARACTER	,
/*	0x039D	*/	CANT_MAP_CHARACTER	,
/*	0x039E 	*/	CANT_MAP_CHARACTER	,
/*	0x039F 	*/	CANT_MAP_CHARACTER	,
/*	0x03A0	*/	CANT_MAP_CHARACTER	,
/*	0x03A1	*/	CANT_MAP_CHARACTER	,
/*	0x03A2	*/	CANT_MAP_CHARACTER	,
/*	0x03A3	*/	CANT_MAP_CHARACTER	,
/*	0x03A4	*/	CANT_MAP_CHARACTER	,
/*	0x03A5	*/	CANT_MAP_CHARACTER	,
/*	0x03A6	*/	CANT_MAP_CHARACTER	,
/*	0x03A7	*/	CANT_MAP_CHARACTER	,
/*	0x03A8	*/	CANT_MAP_CHARACTER	,
/*	0x03A9	*/	CANT_MAP_CHARACTER	,
/*	0x03AA	*/	CANT_MAP_CHARACTER	,
/*	0x03AB	*/	CANT_MAP_CHARACTER	,
/*	0x03AC	*/	CANT_MAP_CHARACTER	,
/*	0x03AD	*/	CANT_MAP_CHARACTER	,
/*	0x03AE	*/	CANT_MAP_CHARACTER	,
/*	0x03AF 	*/	CANT_MAP_CHARACTER	,
/*	0x03B0	*/	CANT_MAP_CHARACTER	,
/*	0x03B1	*/	CANT_MAP_CHARACTER	,
/*	0x03B2	*/	CANT_MAP_CHARACTER	,
/*	0x03B3	*/	CANT_MAP_CHARACTER	,
/*	0x03B4	*/	CANT_MAP_CHARACTER	,
/*	0x03B5	*/	CANT_MAP_CHARACTER	,
/*	0x03B6	*/	CANT_MAP_CHARACTER	,
/*	0x03B7	*/	CANT_MAP_CHARACTER	,
/*	0x03B8	*/	CANT_MAP_CHARACTER	,
/*	0x03B9	*/	CANT_MAP_CHARACTER	,
/*	0x03BA	*/	CANT_MAP_CHARACTER	,
/*	0x03BB	*/	CANT_MAP_CHARACTER	,
/*	0x03BC	*/	CANT_MAP_CHARACTER	,
/*	0x03BD	*/	CANT_MAP_CHARACTER	,
/*	0x03BE	*/	CANT_MAP_CHARACTER	,
/*	0x03BF 	*/	CANT_MAP_CHARACTER	,
/*	0x03C0	*/	CANT_MAP_CHARACTER	,
/*	0x03C1	*/	CANT_MAP_CHARACTER	,
/*	0x03C2	*/	CANT_MAP_CHARACTER	,
/*	0x03C3	*/	CANT_MAP_CHARACTER	,
/*	0x03C4	*/	CANT_MAP_CHARACTER	,
/*	0x03C5	*/	CANT_MAP_CHARACTER	,
/*	0x03C6	*/	CANT_MAP_CHARACTER	,
/*	0x03C7	*/	CANT_MAP_CHARACTER	,
/*	0x03C8	*/	CANT_MAP_CHARACTER	,
/*	0x03C9	*/	CANT_MAP_CHARACTER	,
/*	0x03CA	*/	CANT_MAP_CHARACTER	,
/*	0x03CB	*/	CANT_MAP_CHARACTER	,
/*	0x03CC	*/	CANT_MAP_CHARACTER	,
/*	0x03CD	*/	CANT_MAP_CHARACTER	,
/*	0x03CE	*/	CANT_MAP_CHARACTER	,
/*	0x03CF 	*/	CANT_MAP_CHARACTER	,
/*	0x03D0	*/	CANT_MAP_CHARACTER	,
/*	0x03D1	*/	CANT_MAP_CHARACTER	,
/*	0x03D2	*/	CANT_MAP_CHARACTER	,
/*	0x03D3	*/	CANT_MAP_CHARACTER	,
/*	0x03D4	*/	CANT_MAP_CHARACTER	,
/*	0x03D5	*/	CANT_MAP_CHARACTER	,
/*	0x03D6	*/	CANT_MAP_CHARACTER	,
/*	0x03D7	*/	CANT_MAP_CHARACTER	,
/*	0x03D8	*/	CANT_MAP_CHARACTER	,
/*	0x03D9	*/	CANT_MAP_CHARACTER	,
/*	0x03DA	*/	CANT_MAP_CHARACTER	,
/*	0x03DB	*/	CANT_MAP_CHARACTER	,
/*	0x03DC	*/	CANT_MAP_CHARACTER	,
/*	0x03DD	*/	CANT_MAP_CHARACTER	,
/*	0x03DE	*/	CANT_MAP_CHARACTER	,
/*	0x03DF	*/	CANT_MAP_CHARACTER	,
/*	0x03E0 	*/	CANT_MAP_CHARACTER	,
/*	0x03E1 	*/	CANT_MAP_CHARACTER	,
/*	0x03E2 	*/	CANT_MAP_CHARACTER	,
/*	0x03E3 	*/	CANT_MAP_CHARACTER	,
/*	0x03E4 	*/	CANT_MAP_CHARACTER	,
/*	0x03E5 	*/	CANT_MAP_CHARACTER	,
/*	0x03E6 	*/	CANT_MAP_CHARACTER	,
/*	0x03E7 	*/	CANT_MAP_CHARACTER	,
/*	0x03E8 	*/	CANT_MAP_CHARACTER	,
/*	0x03E9 	*/	CANT_MAP_CHARACTER	,
/*	0x03EA	*/	CANT_MAP_CHARACTER	,
/*	0x03EB	*/	CANT_MAP_CHARACTER	,
/*	0x03EC	*/	CANT_MAP_CHARACTER	,
/*	0x03ED	*/	CANT_MAP_CHARACTER	,
/*	0x03EE 	*/	CANT_MAP_CHARACTER	,
/*	0x03EF 	*/	CANT_MAP_CHARACTER	,
/*	0x03F0 	*/	CANT_MAP_CHARACTER	,
/*	0x03F1 	*/	CANT_MAP_CHARACTER	,
/*	0x03F2 	*/	CANT_MAP_CHARACTER	,
/*	0x03F3 	*/	CANT_MAP_CHARACTER	,
/*	0x03F4 	*/	CANT_MAP_CHARACTER	,
/*	0x03F5 	*/	CANT_MAP_CHARACTER	,
/*	0x03F6 	*/	CANT_MAP_CHARACTER	,
/*	0x03F7 	*/	CANT_MAP_CHARACTER	,
/*	0x03F8 	*/	CANT_MAP_CHARACTER	,
/*	0x03F9 	*/	CANT_MAP_CHARACTER	,
/*	0x03FA 	*/	CANT_MAP_CHARACTER	,
/*	0x03FB 	*/	CANT_MAP_CHARACTER	,
/*	0x03FC 	*/	CANT_MAP_CHARACTER	,
/*	0x03FD	*/	CANT_MAP_CHARACTER	,
/*	0x03FE 	*/	CANT_MAP_CHARACTER	,
/*	0x03FF 	*/	CANT_MAP_CHARACTER	,
/*	0x2000 	*/	CANT_MAP_CHARACTER	,
/*	0x2001 	*/	CANT_MAP_CHARACTER	,
/*	0x2002 	*/	CANT_MAP_CHARACTER	,
/*	0x2003 	*/	CANT_MAP_CHARACTER	,
/*	0x2004 	*/	CANT_MAP_CHARACTER	,
/*	0x2005 	*/	CANT_MAP_CHARACTER	,
/*	0x2006 	*/	CANT_MAP_CHARACTER	,
/*	0x2007 	*/	CANT_MAP_CHARACTER	,
/*	0x2008 	*/	CANT_MAP_CHARACTER	,
/*	0x2009 	*/	CANT_MAP_CHARACTER	,
/*	0x200A	*/	CANT_MAP_CHARACTER	,
/*	0x200B	*/	CANT_MAP_CHARACTER	,
/*	0x200C	*/	CANT_MAP_CHARACTER	,
/*	0x200D	*/	CANT_MAP_CHARACTER	,
/*	0x200E 	*/	CANT_MAP_CHARACTER	,
/*	0x200F 	*/	CANT_MAP_CHARACTER	,
/*	0x2010 	*/	CANT_MAP_CHARACTER	,
/*	0x2011 	*/	CANT_MAP_CHARACTER	,
/*	0x2012 	*/	CANT_MAP_CHARACTER	,
/*	0x2013 	*/	0x96	,
/*	0x2014 	*/	0x97	,
/*	0x2015 	*/	CANT_MAP_CHARACTER	,
/*	0x2016 	*/	CANT_MAP_CHARACTER	,
/*	0x2017 	*/	CANT_MAP_CHARACTER	,
/*	0x2018 	*/	0x91	,
/*	0x2019 	*/	0x92	,
/*	0x201A	*/	0x82	,
/*	0x201B	*/	CANT_MAP_CHARACTER	,
/*	0x201C	*/	0x93	,
/*	0x201D	*/	0x94	,
/*	0x201E 	*/	0x84	,
/*	0x201F 	*/	CANT_MAP_CHARACTER	,
/*	0x2020 	*/	0x86	,
/*	0x2021 	*/	0x87	,
/*	0x2022 	*/	0x95	,
/*	0x2023 	*/	CANT_MAP_CHARACTER	,
/*	0x2024 	*/	CANT_MAP_CHARACTER	,
/*	0x2025 	*/	CANT_MAP_CHARACTER	,
/*	0x2026 	*/	0x85	,
/*	0x2027 	*/	CANT_MAP_CHARACTER	,
/*	0x2028 	*/	CANT_MAP_CHARACTER	,
/*	0x2029 	*/	CANT_MAP_CHARACTER	,
/*	0x202A	*/	CANT_MAP_CHARACTER	,
/*	0x202B	*/	CANT_MAP_CHARACTER	,
/*	0x202C	*/	CANT_MAP_CHARACTER	,
/*	0x202D	*/	CANT_MAP_CHARACTER	,
/*	0x202E 	*/	CANT_MAP_CHARACTER	,
/*	0x202F 	*/	CANT_MAP_CHARACTER	,
/*	0x2030 	*/	0x89	,
/*	0x2031 	*/	CANT_MAP_CHARACTER	,
/*	0x2032 	*/	CANT_MAP_CHARACTER	,
/*	0x2033 	*/	CANT_MAP_CHARACTER	,
/*	0x2034 	*/	CANT_MAP_CHARACTER	,
/*	0x2035 	*/	CANT_MAP_CHARACTER	,
/*	0x2036 	*/	CANT_MAP_CHARACTER	,
/*	0x2037 	*/	CANT_MAP_CHARACTER	,
/*	0x2038 	*/	CANT_MAP_CHARACTER	,
/*	0x2039 	*/	0x8B	,
/*	0x203A	*/	0x9B	,
/*	0x203B	*/	CANT_MAP_CHARACTER	,
/*	0x203C	*/	CANT_MAP_CHARACTER	,
/*	0x203D	*/	CANT_MAP_CHARACTER	,
/*	0x203E 	*/	CANT_MAP_CHARACTER	,
/*	0x203F 	*/	CANT_MAP_CHARACTER	,
/*	0x2040 	*/	CANT_MAP_CHARACTER	,
/*	0x2041 	*/	CANT_MAP_CHARACTER	,
/*	0x2042 	*/	CANT_MAP_CHARACTER	,
/*	0x2043 	*/	CANT_MAP_CHARACTER	,
/*	0x2044 	*/	CANT_MAP_CHARACTER	,
/*	0x2045 	*/	CANT_MAP_CHARACTER	,
/*	0x2046 	*/	CANT_MAP_CHARACTER	,
/*	0x2047 	*/	CANT_MAP_CHARACTER	,
/*	0x2048 	*/	CANT_MAP_CHARACTER	,
/*	0x2049 	*/	CANT_MAP_CHARACTER	,
/*	0x204A	*/	CANT_MAP_CHARACTER	,
/*	0x204B	*/	CANT_MAP_CHARACTER	,
/*	0x204C	*/	CANT_MAP_CHARACTER	,
/*	0x204D	*/	CANT_MAP_CHARACTER	,
/*	0x204E 	*/	CANT_MAP_CHARACTER	,
/*	0x204F 	*/	CANT_MAP_CHARACTER	,
/*	0x2050 	*/	CANT_MAP_CHARACTER	,
/*	0x2051 	*/	CANT_MAP_CHARACTER	,
/*	0x2052 	*/	CANT_MAP_CHARACTER	,
/*	0x2053 	*/	CANT_MAP_CHARACTER	,
/*	0x2054 	*/	CANT_MAP_CHARACTER	,
/*	0x2055 	*/	CANT_MAP_CHARACTER	,
/*	0x2056 	*/	CANT_MAP_CHARACTER	,
/*	0x2057 	*/	CANT_MAP_CHARACTER	,
/*	0x2058 	*/	CANT_MAP_CHARACTER	,
/*	0x2059 	*/	CANT_MAP_CHARACTER	,
/*	0x205A	*/	CANT_MAP_CHARACTER	,
/*	0x205B	*/	CANT_MAP_CHARACTER	,
/*	0x205C	*/	CANT_MAP_CHARACTER	,
/*	0x205D	*/	CANT_MAP_CHARACTER	,
/*	0x205E 	*/	CANT_MAP_CHARACTER	,
/*	0x205F 	*/	CANT_MAP_CHARACTER	,
/*	0x2060 	*/	CANT_MAP_CHARACTER	,
/*	0x2061 	*/	CANT_MAP_CHARACTER	,
/*	0x2062 	*/	CANT_MAP_CHARACTER	,
/*	0x2063 	*/	CANT_MAP_CHARACTER	,
/*	0x2064 	*/	CANT_MAP_CHARACTER	,
/*	0x2065 	*/	CANT_MAP_CHARACTER	,
/*	0x2066 	*/	CANT_MAP_CHARACTER	,
/*	0x2067 	*/	CANT_MAP_CHARACTER	,
/*	0x2068 	*/	CANT_MAP_CHARACTER	,
/*	0x2069 	*/	CANT_MAP_CHARACTER	,
/*	0x206A	*/	CANT_MAP_CHARACTER	,
/*	0x206B	*/	CANT_MAP_CHARACTER	,
/*	0x206C	*/	CANT_MAP_CHARACTER	,
/*	0x206D	*/	CANT_MAP_CHARACTER	,
/*	0x206E 	*/	CANT_MAP_CHARACTER	,
/*	0x206F 	*/	CANT_MAP_CHARACTER	,
/*	0x2070 	*/	CANT_MAP_CHARACTER	,
/*	0x2071 	*/	CANT_MAP_CHARACTER	,
/*	0x2072 	*/	CANT_MAP_CHARACTER	,
/*	0x2073 	*/	CANT_MAP_CHARACTER	,
/*	0x2074 	*/	CANT_MAP_CHARACTER	,
/*	0x2075 	*/	CANT_MAP_CHARACTER	,
/*	0x2076 	*/	CANT_MAP_CHARACTER	,
/*	0x2077 	*/	CANT_MAP_CHARACTER	,
/*	0x2078 	*/	CANT_MAP_CHARACTER	,
/*	0x2079 	*/	CANT_MAP_CHARACTER	,
/*	0x207A	*/	CANT_MAP_CHARACTER	,
/*	0x207B	*/	CANT_MAP_CHARACTER	,
/*	0x207C	*/	CANT_MAP_CHARACTER	,
/*	0x207D	*/	CANT_MAP_CHARACTER	,
/*	0x207E 	*/	CANT_MAP_CHARACTER	,
/*	0x207F 	*/	CANT_MAP_CHARACTER	,
/*	0x2080 	*/	CANT_MAP_CHARACTER	,
/*	0x2081 	*/	CANT_MAP_CHARACTER	,
/*	0x2082 	*/	CANT_MAP_CHARACTER	,
/*	0x2083 	*/	CANT_MAP_CHARACTER	,
/*	0x2084 	*/	CANT_MAP_CHARACTER	,
/*	0x2085 	*/	CANT_MAP_CHARACTER	,
/*	0x2086 	*/	CANT_MAP_CHARACTER	,
/*	0x2087 	*/	CANT_MAP_CHARACTER	,
/*	0x2088 	*/	CANT_MAP_CHARACTER	,
/*	0x2089 	*/	CANT_MAP_CHARACTER	,
/*	0x208A	*/	CANT_MAP_CHARACTER	,
/*	0x208B	*/	CANT_MAP_CHARACTER	,
/*	0x208C	*/	CANT_MAP_CHARACTER	,
/*	0x208D	*/	CANT_MAP_CHARACTER	,
/*	0x208E 	*/	CANT_MAP_CHARACTER	,
/*	0x208F 	*/	CANT_MAP_CHARACTER	,
/*	0x2090 	*/	CANT_MAP_CHARACTER	,
/*	0x2091 	*/	CANT_MAP_CHARACTER	,
/*	0x2092 	*/	CANT_MAP_CHARACTER	,
/*	0x2093 	*/	CANT_MAP_CHARACTER	,
/*	0x2094 	*/	CANT_MAP_CHARACTER	,
/*	0x2095 	*/	CANT_MAP_CHARACTER	,
/*	0x2096 	*/	CANT_MAP_CHARACTER	,
/*	0x2097 	*/	CANT_MAP_CHARACTER	,
/*	0x2098 	*/	CANT_MAP_CHARACTER	,
/*	0x2099 	*/	CANT_MAP_CHARACTER	,
/*	0x209A	*/	CANT_MAP_CHARACTER	,
/*	0x209B	*/	CANT_MAP_CHARACTER	,
/*	0x209C	*/	CANT_MAP_CHARACTER	,
/*	0x209D	*/	CANT_MAP_CHARACTER	,
/*	0x209E 	*/	CANT_MAP_CHARACTER	,
/*	0x209F 	*/	CANT_MAP_CHARACTER	,
/*	0x20A0	*/	CANT_MAP_CHARACTER	,
/*	0x20A1	*/	CANT_MAP_CHARACTER	,
/*	0x20A2	*/	CANT_MAP_CHARACTER	,
/*	0x20A3	*/	CANT_MAP_CHARACTER	,
/*	0x20A4	*/	CANT_MAP_CHARACTER	,
/*	0x20A5	*/	CANT_MAP_CHARACTER	,
/*	0x20A6	*/	CANT_MAP_CHARACTER	,
/*	0x20A7	*/	CANT_MAP_CHARACTER	,
/*	0x20A8	*/	CANT_MAP_CHARACTER	,
/*	0x20A9	*/	CANT_MAP_CHARACTER	,
/*	0x20AA	*/	CANT_MAP_CHARACTER	,
/*	0x20AB	*/	0xFE	,
/*	0x20AC	*/	0x80	,
/*	0x20AD	*/	CANT_MAP_CHARACTER	,
/*	0x20AE	*/	CANT_MAP_CHARACTER	,
/*	0x20AF 	*/	CANT_MAP_CHARACTER	,
/*	0x20B0	*/	CANT_MAP_CHARACTER	,
/*	0x20B1	*/	CANT_MAP_CHARACTER	,
/*	0x20B2	*/	CANT_MAP_CHARACTER	,
/*	0x20B3	*/	CANT_MAP_CHARACTER	,
/*	0x20B4	*/	CANT_MAP_CHARACTER	,
/*	0x20B5	*/	CANT_MAP_CHARACTER	,
/*	0x20B6	*/	CANT_MAP_CHARACTER	,
/*	0x20B7	*/	CANT_MAP_CHARACTER	,
/*	0x20B8	*/	CANT_MAP_CHARACTER	,
/*	0x20B9	*/	CANT_MAP_CHARACTER	,
/*	0x20BA	*/	CANT_MAP_CHARACTER	,
/*	0x20BB	*/	CANT_MAP_CHARACTER	,
/*	0x20BC	*/	CANT_MAP_CHARACTER	,
/*	0x20BD	*/	CANT_MAP_CHARACTER	,
/*	0x20BE	*/	CANT_MAP_CHARACTER	,
/*	0x20BF 	*/	CANT_MAP_CHARACTER	,
/*	0x20C0	*/	CANT_MAP_CHARACTER	,
/*	0x20C1	*/	CANT_MAP_CHARACTER	,
/*	0x20C2	*/	CANT_MAP_CHARACTER	,
/*	0x20C3	*/	CANT_MAP_CHARACTER	,
/*	0x20C4	*/	CANT_MAP_CHARACTER	,
/*	0x20C5	*/	CANT_MAP_CHARACTER	,
/*	0x20C6	*/	CANT_MAP_CHARACTER	,
/*	0x20C7	*/	CANT_MAP_CHARACTER	,
/*	0x20C8	*/	CANT_MAP_CHARACTER	,
/*	0x20C9	*/	CANT_MAP_CHARACTER	,
/*	0x20CA	*/	CANT_MAP_CHARACTER	,
/*	0x20CB	*/	CANT_MAP_CHARACTER	,
/*	0x20CC	*/	CANT_MAP_CHARACTER	,
/*	0x20CD	*/	CANT_MAP_CHARACTER	,
/*	0x20CE	*/	CANT_MAP_CHARACTER	,
/*	0x20CF 	*/	CANT_MAP_CHARACTER	,
/*	0x20D0	*/	CANT_MAP_CHARACTER	,
/*	0x20D1	*/	CANT_MAP_CHARACTER	,
/*	0x20D2	*/	CANT_MAP_CHARACTER	,
/*	0x20D3	*/	CANT_MAP_CHARACTER	,
/*	0x20D4	*/	CANT_MAP_CHARACTER	,
/*	0x20D5	*/	CANT_MAP_CHARACTER	,
/*	0x20D6	*/	CANT_MAP_CHARACTER	,
/*	0x20D7	*/	CANT_MAP_CHARACTER	,
/*	0x20D8	*/	CANT_MAP_CHARACTER	,
/*	0x20D9	*/	CANT_MAP_CHARACTER	,
/*	0x20DA	*/	CANT_MAP_CHARACTER	,
/*	0x20DB	*/	CANT_MAP_CHARACTER	,
/*	0x20DC	*/	CANT_MAP_CHARACTER	,
/*	0x20DD	*/	CANT_MAP_CHARACTER	,
/*	0x20DE	*/	CANT_MAP_CHARACTER	,
/*	0x20DF	*/	CANT_MAP_CHARACTER	,
/*	0x20E0 	*/	CANT_MAP_CHARACTER	,
/*	0x20E1 	*/	CANT_MAP_CHARACTER	,
/*	0x20E2 	*/	CANT_MAP_CHARACTER	,
/*	0x20E3 	*/	CANT_MAP_CHARACTER	,
/*	0x20E4 	*/	CANT_MAP_CHARACTER	,
/*	0x20E5 	*/	CANT_MAP_CHARACTER	,
/*	0x20E6 	*/	CANT_MAP_CHARACTER	,
/*	0x20E7 	*/	CANT_MAP_CHARACTER	,
/*	0x20E8 	*/	CANT_MAP_CHARACTER	,
/*	0x20E9 	*/	CANT_MAP_CHARACTER	,
/*	0x20EA	*/	CANT_MAP_CHARACTER	,
/*	0x20EB	*/	CANT_MAP_CHARACTER	,
/*	0x20EC	*/	CANT_MAP_CHARACTER	,
/*	0x20ED	*/	CANT_MAP_CHARACTER	,
/*	0x20EE 	*/	CANT_MAP_CHARACTER	,
/*	0x20EF 	*/	CANT_MAP_CHARACTER	,
/*	0x20F0 	*/	CANT_MAP_CHARACTER	,
/*	0x20F1 	*/	CANT_MAP_CHARACTER	,
/*	0x20F2 	*/	CANT_MAP_CHARACTER	,
/*	0x20F3 	*/	CANT_MAP_CHARACTER	,
/*	0x20F4 	*/	CANT_MAP_CHARACTER	,
/*	0x20F5 	*/	CANT_MAP_CHARACTER	,
/*	0x20F6 	*/	CANT_MAP_CHARACTER	,
/*	0x20F7 	*/	CANT_MAP_CHARACTER	,
/*	0x20F8 	*/	CANT_MAP_CHARACTER	,
/*	0x20F9 	*/	CANT_MAP_CHARACTER	,
/*	0x20FA 	*/	CANT_MAP_CHARACTER	,
/*	0x20FB 	*/	CANT_MAP_CHARACTER	,
/*	0x20FC 	*/	CANT_MAP_CHARACTER	,
/*	0x20FD	*/	CANT_MAP_CHARACTER	,
/*	0x20FE 	*/	CANT_MAP_CHARACTER	,
/*	0x20FF 	*/	CANT_MAP_CHARACTER	,
/*	0x2100 	*/	CANT_MAP_CHARACTER	,
/*	0x2101 	*/	CANT_MAP_CHARACTER	,
/*	0x2102 	*/	CANT_MAP_CHARACTER	,
/*	0x2103 	*/	CANT_MAP_CHARACTER	,
/*	0x2104 	*/	CANT_MAP_CHARACTER	,
/*	0x2105 	*/	CANT_MAP_CHARACTER	,
/*	0x2106 	*/	CANT_MAP_CHARACTER	,
/*	0x2107 	*/	CANT_MAP_CHARACTER	,
/*	0x2108 	*/	CANT_MAP_CHARACTER	,
/*	0x2109 	*/	CANT_MAP_CHARACTER	,
/*	0x210A	*/	CANT_MAP_CHARACTER	,
/*	0x210B	*/	CANT_MAP_CHARACTER	,
/*	0x210C	*/	CANT_MAP_CHARACTER	,
/*	0x210D	*/	CANT_MAP_CHARACTER	,
/*	0x210E 	*/	CANT_MAP_CHARACTER	,
/*	0x210F 	*/	CANT_MAP_CHARACTER	,
/*	0x2110 	*/	CANT_MAP_CHARACTER	,
/*	0x2111 	*/	CANT_MAP_CHARACTER	,
/*	0x2112 	*/	CANT_MAP_CHARACTER	,
/*	0x2113 	*/	CANT_MAP_CHARACTER	,
/*	0x2114 	*/	CANT_MAP_CHARACTER	,
/*	0x2115 	*/	CANT_MAP_CHARACTER	,
/*	0x2116 	*/	CANT_MAP_CHARACTER	,
/*	0x2117 	*/	CANT_MAP_CHARACTER	,
/*	0x2118 	*/	CANT_MAP_CHARACTER	,
/*	0x2119 	*/	CANT_MAP_CHARACTER	,
/*	0x211A	*/	CANT_MAP_CHARACTER	,
/*	0x211B	*/	CANT_MAP_CHARACTER	,
/*	0x211C	*/	CANT_MAP_CHARACTER	,
/*	0x211D	*/	CANT_MAP_CHARACTER	,
/*	0x211E 	*/	CANT_MAP_CHARACTER	,
/*	0x211F 	*/	CANT_MAP_CHARACTER	,
/*	0x2120 	*/	CANT_MAP_CHARACTER	,
/*	0x2121 	*/	CANT_MAP_CHARACTER	,
/*	0x2122 	*/	0x99	,
/*	0x2123 	*/	CANT_MAP_CHARACTER	,
/*	0x2124 	*/	CANT_MAP_CHARACTER	,
/*	0x2125 	*/	CANT_MAP_CHARACTER	,
/*	0x2126 	*/	CANT_MAP_CHARACTER	,
/*	0x2127 	*/	CANT_MAP_CHARACTER	,
/*	0x2128 	*/	CANT_MAP_CHARACTER	,
/*	0x2129 	*/	CANT_MAP_CHARACTER	,
/*	0x212A	*/	CANT_MAP_CHARACTER	,
/*	0x212B	*/	CANT_MAP_CHARACTER	,
/*	0x212C	*/	CANT_MAP_CHARACTER	,
/*	0x212D	*/	CANT_MAP_CHARACTER	,
/*	0x212E 	*/	CANT_MAP_CHARACTER	,
/*	0x212F 	*/	CANT_MAP_CHARACTER	,
/*	0x2130 	*/	CANT_MAP_CHARACTER	,
/*	0x2131 	*/	CANT_MAP_CHARACTER	,
/*	0x2132 	*/	CANT_MAP_CHARACTER	,
/*	0x2133 	*/	CANT_MAP_CHARACTER	,
/*	0x2134 	*/	CANT_MAP_CHARACTER	,
/*	0x2135 	*/	CANT_MAP_CHARACTER	,
/*	0x2136 	*/	CANT_MAP_CHARACTER	,
/*	0x2137 	*/	CANT_MAP_CHARACTER	,
/*	0x2138 	*/	CANT_MAP_CHARACTER	,
/*	0x2139 	*/	CANT_MAP_CHARACTER	,
/*	0x213A	*/	CANT_MAP_CHARACTER	,
/*	0x213B	*/	CANT_MAP_CHARACTER	,
/*	0x213C	*/	CANT_MAP_CHARACTER	,
/*	0x213D	*/	CANT_MAP_CHARACTER	,
/*	0x213E 	*/	CANT_MAP_CHARACTER	,
/*	0x213F 	*/	CANT_MAP_CHARACTER	,
/*	0x2140 	*/	CANT_MAP_CHARACTER	,
/*	0x2141 	*/	CANT_MAP_CHARACTER	,
/*	0x2142 	*/	CANT_MAP_CHARACTER	,
/*	0x2143 	*/	CANT_MAP_CHARACTER	,
/*	0x2144 	*/	CANT_MAP_CHARACTER	,
/*	0x2145 	*/	CANT_MAP_CHARACTER	,
/*	0x2146 	*/	CANT_MAP_CHARACTER	,
/*	0x2147 	*/	CANT_MAP_CHARACTER	,
/*	0x2148 	*/	CANT_MAP_CHARACTER	,
/*	0x2149 	*/	CANT_MAP_CHARACTER	,
/*	0x214A	*/	CANT_MAP_CHARACTER	,
/*	0x214B	*/	CANT_MAP_CHARACTER	,
/*	0x214C	*/	CANT_MAP_CHARACTER	,
/*	0x214D	*/	CANT_MAP_CHARACTER	,
/*	0x214E 	*/	CANT_MAP_CHARACTER	,
/*	0x214F 	*/	CANT_MAP_CHARACTER	,
/*	0x2150 	*/	CANT_MAP_CHARACTER	,
/*	0x2151 	*/	CANT_MAP_CHARACTER	,
/*	0x2152 	*/	CANT_MAP_CHARACTER	,
/*	0x2153 	*/	CANT_MAP_CHARACTER	,
/*	0x2154 	*/	CANT_MAP_CHARACTER	,
/*	0x2155 	*/	CANT_MAP_CHARACTER	,
/*	0x2156 	*/	CANT_MAP_CHARACTER	,
/*	0x2157 	*/	CANT_MAP_CHARACTER	,
/*	0x2158 	*/	CANT_MAP_CHARACTER	,
/*	0x2159 	*/	CANT_MAP_CHARACTER	,
/*	0x215A	*/	CANT_MAP_CHARACTER	,
/*	0x215B	*/	CANT_MAP_CHARACTER	,
/*	0x215C	*/	CANT_MAP_CHARACTER	,
/*	0x215D	*/	CANT_MAP_CHARACTER	,
/*	0x215E 	*/	CANT_MAP_CHARACTER	,
/*	0x215F 	*/	CANT_MAP_CHARACTER	,
/*	0x2160 	*/	CANT_MAP_CHARACTER	,
/*	0x2161 	*/	CANT_MAP_CHARACTER	,
/*	0x2162 	*/	CANT_MAP_CHARACTER	,
/*	0x2163 	*/	CANT_MAP_CHARACTER	,
/*	0x2164 	*/	CANT_MAP_CHARACTER	,
/*	0x2165 	*/	CANT_MAP_CHARACTER	,
/*	0x2166 	*/	CANT_MAP_CHARACTER	,
/*	0x2167 	*/	CANT_MAP_CHARACTER	,
/*	0x2168 	*/	CANT_MAP_CHARACTER	,
/*	0x2169 	*/	CANT_MAP_CHARACTER	,
/*	0x216A	*/	CANT_MAP_CHARACTER	,
/*	0x216B	*/	CANT_MAP_CHARACTER	,
/*	0x216C	*/	CANT_MAP_CHARACTER	,
/*	0x216D	*/	CANT_MAP_CHARACTER	,
/*	0x216E 	*/	CANT_MAP_CHARACTER	,
/*	0x216F 	*/	CANT_MAP_CHARACTER	,
/*	0x2170 	*/	CANT_MAP_CHARACTER	,
/*	0x2171 	*/	CANT_MAP_CHARACTER	,
/*	0x2172 	*/	CANT_MAP_CHARACTER	,
/*	0x2173 	*/	CANT_MAP_CHARACTER	,
/*	0x2174 	*/	CANT_MAP_CHARACTER	,
/*	0x2175 	*/	CANT_MAP_CHARACTER	,
/*	0x2176 	*/	CANT_MAP_CHARACTER	,
/*	0x2177 	*/	CANT_MAP_CHARACTER	,
/*	0x2178 	*/	CANT_MAP_CHARACTER	,
/*	0x2179 	*/	CANT_MAP_CHARACTER	,
/*	0x217A	*/	CANT_MAP_CHARACTER	,
/*	0x217B	*/	CANT_MAP_CHARACTER	,
/*	0x217C	*/	CANT_MAP_CHARACTER	,
/*	0x217D	*/	CANT_MAP_CHARACTER	,
/*	0x217E 	*/	CANT_MAP_CHARACTER	,
/*	0x217F 	*/	CANT_MAP_CHARACTER	,
/*	0x2180 	*/	CANT_MAP_CHARACTER	,
/*	0x2181 	*/	CANT_MAP_CHARACTER	,
/*	0x2182 	*/	CANT_MAP_CHARACTER	,
/*	0x2183 	*/	CANT_MAP_CHARACTER	,
/*	0x2184 	*/	CANT_MAP_CHARACTER	,
/*	0x2185 	*/	CANT_MAP_CHARACTER	,
/*	0x2186 	*/	CANT_MAP_CHARACTER	,
/*	0x2187 	*/	CANT_MAP_CHARACTER	,
/*	0x2188 	*/	CANT_MAP_CHARACTER	,
/*	0x2189 	*/	CANT_MAP_CHARACTER	,
/*	0x218A	*/	CANT_MAP_CHARACTER	,
/*	0x218B	*/	CANT_MAP_CHARACTER	,
/*	0x218C	*/	CANT_MAP_CHARACTER	,
/*	0x218D	*/	CANT_MAP_CHARACTER	,
/*	0x218E 	*/	CANT_MAP_CHARACTER	,
/*	0x218F 	*/	CANT_MAP_CHARACTER	,
/*	0x2190 	*/	CANT_MAP_CHARACTER	,
/*	0x2191 	*/	CANT_MAP_CHARACTER	,
/*	0x2192 	*/	CANT_MAP_CHARACTER	,
/*	0x2193 	*/	CANT_MAP_CHARACTER	,
/*	0x2194 	*/	CANT_MAP_CHARACTER	,
/*	0x2195 	*/	CANT_MAP_CHARACTER	,
/*	0x2196 	*/	CANT_MAP_CHARACTER	,
/*	0x2197 	*/	CANT_MAP_CHARACTER	,
/*	0x2198 	*/	CANT_MAP_CHARACTER	,
/*	0x2199 	*/	CANT_MAP_CHARACTER	,
/*	0x219A	*/	CANT_MAP_CHARACTER	,
/*	0x219B	*/	CANT_MAP_CHARACTER	,
/*	0x219C	*/	CANT_MAP_CHARACTER	,
/*	0x219D	*/	CANT_MAP_CHARACTER	,
/*	0x219E 	*/	CANT_MAP_CHARACTER	,
/*	0x219F 	*/	CANT_MAP_CHARACTER	,
/*	0x21A0	*/	CANT_MAP_CHARACTER	,
/*	0x21A1	*/	CANT_MAP_CHARACTER	,
/*	0x21A2	*/	CANT_MAP_CHARACTER	,
/*	0x21A3	*/	CANT_MAP_CHARACTER	,
/*	0x21A4	*/	CANT_MAP_CHARACTER	,
/*	0x21A5	*/	CANT_MAP_CHARACTER	,
/*	0x21A6	*/	CANT_MAP_CHARACTER	,
/*	0x21A7	*/	CANT_MAP_CHARACTER	,
/*	0x21A8	*/	CANT_MAP_CHARACTER	,
/*	0x21A9	*/	CANT_MAP_CHARACTER	,
/*	0x21AA	*/	CANT_MAP_CHARACTER	,
/*	0x21AB	*/	CANT_MAP_CHARACTER	,
/*	0x21AC	*/	CANT_MAP_CHARACTER	,
/*	0x21AD	*/	CANT_MAP_CHARACTER	,
/*	0x21AE	*/	CANT_MAP_CHARACTER	,
/*	0x21AF 	*/	CANT_MAP_CHARACTER	,
/*	0x21B0	*/	CANT_MAP_CHARACTER	,
/*	0x21B1	*/	CANT_MAP_CHARACTER	,
/*	0x21B2	*/	CANT_MAP_CHARACTER	,
/*	0x21B3	*/	CANT_MAP_CHARACTER	,
/*	0x21B4	*/	CANT_MAP_CHARACTER	,
/*	0x21B5	*/	CANT_MAP_CHARACTER	,
/*	0x21B6	*/	CANT_MAP_CHARACTER	,
/*	0x21B7	*/	CANT_MAP_CHARACTER	,
/*	0x21B8	*/	CANT_MAP_CHARACTER	,
/*	0x21B9	*/	CANT_MAP_CHARACTER	,
/*	0x21BA	*/	CANT_MAP_CHARACTER	,
/*	0x21BB	*/	CANT_MAP_CHARACTER	,
/*	0x21BC	*/	CANT_MAP_CHARACTER	,
/*	0x21BD	*/	CANT_MAP_CHARACTER	,
/*	0x21BE	*/	CANT_MAP_CHARACTER	,
/*	0x21BF 	*/	CANT_MAP_CHARACTER	,
/*	0x21C0	*/	CANT_MAP_CHARACTER	,
/*	0x21C1	*/	CANT_MAP_CHARACTER	,
/*	0x21C2	*/	CANT_MAP_CHARACTER	,
/*	0x21C3	*/	CANT_MAP_CHARACTER	,
/*	0x21C4	*/	CANT_MAP_CHARACTER	,
/*	0x21C5	*/	CANT_MAP_CHARACTER	,
/*	0x21C6	*/	CANT_MAP_CHARACTER	,
/*	0x21C7	*/	CANT_MAP_CHARACTER	,
/*	0x21C8	*/	CANT_MAP_CHARACTER	,
/*	0x21C9	*/	CANT_MAP_CHARACTER	,
/*	0x21CA	*/	CANT_MAP_CHARACTER	,
/*	0x21CB	*/	CANT_MAP_CHARACTER	,
/*	0x21CC	*/	CANT_MAP_CHARACTER	,
/*	0x21CD	*/	CANT_MAP_CHARACTER	,
/*	0x21CE	*/	CANT_MAP_CHARACTER	,
/*	0x21CF 	*/	CANT_MAP_CHARACTER	,
/*	0x21D0	*/	CANT_MAP_CHARACTER	,
/*	0x21D1	*/	CANT_MAP_CHARACTER	,
/*	0x21D2	*/	CANT_MAP_CHARACTER	,
/*	0x21D3	*/	CANT_MAP_CHARACTER	,
/*	0x21D4	*/	CANT_MAP_CHARACTER	,
/*	0x21D5	*/	CANT_MAP_CHARACTER	,
/*	0x21D6	*/	CANT_MAP_CHARACTER	,
/*	0x21D7	*/	CANT_MAP_CHARACTER	,
/*	0x21D8	*/	CANT_MAP_CHARACTER	,
/*	0x21D9	*/	CANT_MAP_CHARACTER	,
/*	0x21DA	*/	CANT_MAP_CHARACTER	,
/*	0x21DB	*/	CANT_MAP_CHARACTER	,
/*	0x21DC	*/	CANT_MAP_CHARACTER	,
/*	0x21DD	*/	CANT_MAP_CHARACTER	,
/*	0x21DE	*/	CANT_MAP_CHARACTER	,
/*	0x21DF	*/	CANT_MAP_CHARACTER	,
/*	0x21E0 	*/	CANT_MAP_CHARACTER	,
/*	0x21E1 	*/	CANT_MAP_CHARACTER	,
/*	0x21E2 	*/	CANT_MAP_CHARACTER	,
/*	0x21E3 	*/	CANT_MAP_CHARACTER	,
/*	0x21E4 	*/	CANT_MAP_CHARACTER	,
/*	0x21E5 	*/	CANT_MAP_CHARACTER	,
/*	0x21E6 	*/	CANT_MAP_CHARACTER	,
/*	0x21E7 	*/	CANT_MAP_CHARACTER	,
/*	0x21E8 	*/	CANT_MAP_CHARACTER	,
/*	0x21E9 	*/	CANT_MAP_CHARACTER	,
/*	0x21EA	*/	CANT_MAP_CHARACTER	,
/*	0x21EB	*/	CANT_MAP_CHARACTER	,
/*	0x21EC	*/	CANT_MAP_CHARACTER	,
/*	0x21ED	*/	CANT_MAP_CHARACTER	,
/*	0x21EE 	*/	CANT_MAP_CHARACTER	,
/*	0x21EF 	*/	CANT_MAP_CHARACTER	,
/*	0x21F0 	*/	CANT_MAP_CHARACTER	,
/*	0x21F1 	*/	CANT_MAP_CHARACTER	,
/*	0x21F2 	*/	CANT_MAP_CHARACTER	,
/*	0x21F3 	*/	CANT_MAP_CHARACTER	,
/*	0x21F4 	*/	CANT_MAP_CHARACTER	,
/*	0x21F5 	*/	CANT_MAP_CHARACTER	,
/*	0x21F6 	*/	CANT_MAP_CHARACTER	,
/*	0x21F7 	*/	CANT_MAP_CHARACTER	,
/*	0x21F8 	*/	CANT_MAP_CHARACTER	,
/*	0x21F9 	*/	CANT_MAP_CHARACTER	,
/*	0x21FA 	*/	CANT_MAP_CHARACTER	,
/*	0x21FB 	*/	CANT_MAP_CHARACTER	,
/*	0x21FC 	*/	CANT_MAP_CHARACTER	,
/*	0x21FD	*/	CANT_MAP_CHARACTER	,
/*	0x21FE 	*/	CANT_MAP_CHARACTER	,
/*	0x21FF 	*/	CANT_MAP_CHARACTER	,
	0 /* END OF MAP TABLE */
};
static const USHORT from_unicode_map[256] = {
/* U+00-- */	256,
/* U+01-- */	512,
/* U+02-- */	768,
/* U+03-- */	1024,
/* U+04-- */	0,
/* U+05-- */	0,
/* U+06-- */	0,
/* U+07-- */	0,
/* U+08-- */	0,
/* U+09-- */	0,
/* U+0A-- */	0,
/* U+0B-- */	0,
/* U+0C-- */	0,
/* U+0D-- */	0,
/* U+0E-- */	0,
/* U+0F-- */	0,
/* U+10-- */	0,
/* U+11-- */	0,
/* U+12-- */	0,
/* U+13-- */	0,
/* U+14-- */	0,
/* U+15-- */	0,
/* U+16-- */	0,
/* U+17-- */	0,
/* U+18-- */	0,
/* U+19-- */	0,
/* U+1A-- */	0,
/* U+1B-- */	0,
/* U+1C-- */	0,
/* U+1D-- */	0,
/* U+1E-- */	0,
/* U+1F-- */	0,
/* U+20-- */	1024,
/* U+21-- */	1280,
/* U+22-- */	0,
/* U+23-- */	0,
/* U+24-- */	0,
/* U+25-- */	0,
/* U+26-- */	0,
/* U+27-- */	0,
/* U+28-- */	0,
/* U+29-- */	0,
/* U+2A-- */	0,
/* U+2B-- */	0,
/* U+2C-- */	0,
/* U+2D-- */	0,
/* U+2E-- */	0,
/* U+2F-- */	0,
/* U+30-- */	0,
/* U+31-- */	0,
/* U+32-- */	0,
/* U+33-- */	0,
/* U+34-- */	0,
/* U+35-- */	0,
/* U+36-- */	0,
/* U+37-- */	0,
/* U+38-- */	0,
/* U+39-- */	0,
/* U+3A-- */	0,
/* U+3B-- */	0,
/* U+3C-- */	0,
/* U+3D-- */	0,
/* U+3E-- */	0,
/* U+3F-- */	0,
/* U+40-- */	0,
/* U+41-- */	0,
/* U+42-- */	0,
/* U+43-- */	0,
/* U+44-- */	0,
/* U+45-- */	0,
/* U+46-- */	0,
/* U+47-- */	0,
/* U+48-- */	0,
/* U+49-- */	0,
/* U+4A-- */	0,
/* U+4B-- */	0,
/* U+4C-- */	0,
/* U+4D-- */	0,
/* U+4E-- */	0,
/* U+4F-- */	0,
/* U+50-- */	0,
/* U+51-- */	0,
/* U+52-- */	0,
/* U+53-- */	0,
/* U+54-- */	0,
/* U+55-- */	0,
/* U+56-- */	0,
/* U+57-- */	0,
/* U+58-- */	0,
/* U+59-- */	0,
/* U+5A-- */	0,
/* U+5B-- */	0,
/* U+5C-- */	0,
/* U+5D-- */	0,
/* U+5E-- */	0,
/* U+5F-- */	0,
/* U+60-- */	0,
/* U+61-- */	0,
/* U+62-- */	0,
/* U+63-- */	0,
/* U+64-- */	0,
/* U+65-- */	0,
/* U+66-- */	0,
/* U+67-- */	0,
/* U+68-- */	0,
/* U+69-- */	0,
/* U+6A-- */	0,
/* U+6B-- */	0,
/* U+6C-- */	0,
/* U+6D-- */	0,
/* U+6E-- */	0,
/* U+6F-- */	0,
/* U+70-- */	0,
/* U+71-- */	0,
/* U+72-- */	0,
/* U+73-- */	0,
/* U+74-- */	0,
/* U+75-- */	0,
/* U+76-- */	0,
/* U+77-- */	0,
/* U+78-- */	0,
/* U+79-- */	0,
/* U+7A-- */	0,
/* U+7B-- */	0,
/* U+7C-- */	0,
/* U+7D-- */	0,
/* U+7E-- */	0,
/* U+7F-- */	0,
/* U+80-- */	0,
/* U+81-- */	0,
/* U+82-- */	0,
/* U+83-- */	0,
/* U+84-- */	0,
/* U+85-- */	0,
/* U+86-- */	0,
/* U+87-- */	0,
/* U+88-- */	0,
/* U+89-- */	0,
/* U+8A-- */	0,
/* U+8B-- */	0,
/* U+8C-- */	0,
/* U+8D-- */	0,
/* U+8E-- */	0,
/* U+8F-- */	0,
/* U+90-- */	0,
/* U+91-- */	0,
/* U+92-- */	0,
/* U+93-- */	0,
/* U+94-- */	0,
/* U+95-- */	0,
/* U+96-- */	0,
/* U+97-- */	0,
/* U+98-- */	0,
/* U+99-- */	0,
/* U+9A-- */	0,
/* U+9B-- */	0,
/* U+9C-- */	0,
/* U+9D-- */	0,
/* U+9E-- */	0,
/* U+9F-- */	0,
/* U+A0-- */	0,
/* U+A1-- */	0,
/* U+A2-- */	0,
/* U+A3-- */	0,
/* U+A4-- */	0,
/* U+A5-- */	0,
/* U+A6-- */	0,
/* U+A7-- */	0,
/* U+A8-- */	0,
/* U+A9-- */	0,
/* U+AA-- */	0,
/* U+AB-- */	0,
/* U+AC-- */	0,
/* U+AD-- */	0,
/* U+AE-- */	0,
/* U+AF-- */	0,
/* U+B0-- */	0,
/* U+B1-- */	0,
/* U+B2-- */	0,
/* U+B3-- */	0,
/* U+B4-- */	0,
/* U+B5-- */	0,
/* U+B6-- */	0,
/* U+B7-- */	0,
/* U+B8-- */	0,
/* U+B9-- */	0,
/* U+BA-- */	0,
/* U+BB-- */	0,
/* U+BC-- */	0,
/* U+BD-- */	0,
/* U+BE-- */	0,
/* U+BF-- */	0,
/* U+C0-- */	0,
/* U+C1-- */	0,
/* U+C2-- */	0,
/* U+C3-- */	0,
/* U+C4-- */	0,
/* U+C5-- */	0,
/* U+C6-- */	0,
/* U+C7-- */	0,
/* U+C8-- */	0,
/* U+C9-- */	0,
/* U+CA-- */	0,
/* U+CB-- */	0,
/* U+CC-- */	0,
/* U+CD-- */	0,
/* U+CE-- */	0,
/* U+CF-- */	0,
/* U+D0-- */	0,
/* U+D1-- */	0,
/* U+D2-- */	0,
/* U+D3-- */	0,
/* U+D4-- */	0,
/* U+D5-- */	0,
/* U+D6-- */	0,
/* U+D7-- */	0,
/* U+D8-- */	0,
/* U+D9-- */	0,
/* U+DA-- */	0,
/* U+DB-- */	0,
/* U+DC-- */	0,
/* U+DD-- */	0,
/* U+DE-- */	0,
/* U+DF-- */	0,
/* U+E0-- */	0,
/* U+E1-- */	0,
/* U+E2-- */	0,
/* U+E3-- */	0,
/* U+E4-- */	0,
/* U+E5-- */	0,
/* U+E6-- */	0,
/* U+E7-- */	0,
/* U+E8-- */	0,
/* U+E9-- */	0,
/* U+EA-- */	0,
/* U+EB-- */	0,
/* U+EC-- */	0,
/* U+ED-- */	0,
/* U+EE-- */	0,
/* U+EF-- */	0,
/* U+F0-- */	0,
/* U+F1-- */	0,
/* U+F2-- */	0,
/* U+F3-- */	0,
/* U+F4-- */	0,
/* U+F5-- */	0,
/* U+F6-- */	0,
/* U+F7-- */	0,
/* U+F8-- */	0,
/* U+F9-- */	0,
/* U+FA-- */	0,
/* U+FB-- */	0,
/* U+FC-- */	0,
/* U+FD-- */	0,
/* U+FE-- */	0,
/* U+FF-- */	0,
};
