/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.TestEnumMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestsForMapsInJavaUtil {
    public static Test suite() {
        return new TestsForMapsInJavaUtil().allTests();
    }

    public Test allTests() {
        TestSuite suite = new TestSuite("java.util Maps");
        suite.addTest(this.testsForEmptyMap());
        suite.addTest(this.testsForSingletonMap());
        suite.addTest(this.testsForHashMap());
        suite.addTest(this.testsForLinkedHashMap());
        suite.addTest(this.testsForTreeMap());
        suite.addTest(this.testsForEnumMap());
        suite.addTest(this.testsForConcurrentHashMap());
        return suite;
    }

    protected Collection<Method> suppressForEmptyMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForSingletonMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForHashMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForLinkedHashMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForTreeMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForEnumMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForConcurrentHashMap() {
        return Collections.emptySet();
    }

    public Test testsForEmptyMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.emptyMap();
            }
        }).named("emptyMap")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionSize.ZERO)).suppressing(this.suppressForEmptyMap())).createTestSuite();
    }

    public Test testsForSingletonMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.singletonMap(entries[0].getKey(), entries[0].getValue());
            }
        }).named("singletonMap")).withFeatures(MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.SERIALIZABLE, CollectionSize.ONE)).suppressing(this.suppressForSingletonMap())).createTestSuite();
    }

    public Test testsForHashMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.toHashMap(entries);
            }

            @Override
            public Iterable<Map.Entry<String, String>> order(List<Map.Entry<String, String>> insertionOrder) {
                throw new UnsupportedOperationException();
            }
        }).named("HashMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForHashMap())).createTestSuite();
    }

    public Test testsForLinkedHashMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new LinkedHashMap(), entries);
            }
        }).named("LinkedHashMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForLinkedHashMap())).createTestSuite();
    }

    public Test testsForTreeMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new TreeMap(TestsForMapsInJavaUtil.arbitraryNullFriendlyComparator()), entries);
            }
        }).named("TreeMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForTreeMap())).createTestSuite();
    }

    public Test testsForEnumMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestEnumMapGenerator(){

            @Override
            protected Map<AnEnum, String> create(Map.Entry<AnEnum, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new EnumMap(AnEnum.class), entries);
            }
        }).named("EnumMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_VALUES, MapFeature.RESTRICTS_KEYS, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForEnumMap())).createTestSuite();
    }

    public Test testsForConcurrentHashMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new ConcurrentHashMap(), entries);
            }
        }).named("ConcurrentHashMap")).withFeatures(MapFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForConcurrentHashMap())).createTestSuite();
    }

    private static Map<String, String> toHashMap(Map.Entry<String, String>[] entries) {
        return TestsForMapsInJavaUtil.populate(new HashMap(), entries);
    }

    private static <T> Map<T, String> populate(Map<T, String> map, Map.Entry<T, String>[] entries) {
        for (Map.Entry<T, String> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static <T> Comparator<T> arbitraryNullFriendlyComparator() {
        return new NullFriendlyComparator();
    }

    private static final class NullFriendlyComparator<T>
    implements Comparator<T>,
    Serializable {
        private NullFriendlyComparator() {
        }

        @Override
        public int compare(T left, T right) {
            return String.valueOf(left).compareTo(String.valueOf(right));
        }
    }
}

