/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ConfirmConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.UserAbortedException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConfirmationCommandProcessor
implements CommandProcessor {
    public Command process(Command process) throws CliCommandoException {
        ConfirmConfig confirm = process.getCurrentCommandConfig().getConfirmation();
        if (confirm == null || process.getCurrentCommandConfig().doesParameterExist("Force") && Boolean.parseBoolean(process.getCurrentCommandConfig().getParameter("Force").getValue())) {
            return process;
        }
        System.out.println(StringUtils.formatTextColumn(confirm.getExplanatoryText()));
        boolean readStdIn = true;
        System.out.flush();
        while (readStdIn) {
            System.out.print(StringUtils.formatTextColumn(confirm.getChallengeText() + " [Ny] "));
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            String input = "";
            try {
                input = stdin.readLine();
            }
            catch (IOException e) {
                throw new BadInputException(ErrorMessages.ErrorCode.CANNOT_READ_FILE, "standard input", e.getMessage());
            }
            if (StringUtils.isEmpty(input)) {
                input = "";
            }
            if (input.toLowerCase().equals("yes") || input.toLowerCase().equals("y")) {
                readStdIn = false;
                continue;
            }
            throw new UserAbortedException(ErrorMessages.ErrorCode.ABORTING_COMMAND, process.getCurrentCommandConfig().getName());
        }
        return process;
    }
}

