/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRC32InputStream
extends InputStream {
    private final InputStream delegate;
    private final CRC32 crc32 = new CRC32();

    public CRC32InputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public int getCRC32() {
        return (int)this.crc32.getValue();
    }

    @Override
    public int read() throws IOException {
        int value = this.delegate.read();
        if (value != -1) {
            this.crc32.update(value);
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.delegate.read(b);
        if (result != -1) {
            this.crc32.update(b, 0, result);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        int result = this.delegate.read(b, off, length);
        this.crc32.update(b, off, result);
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readLimit) {
        this.delegate.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

