/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentDragAndDrop;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Settings;
import org.fest.swing.driver.ComponentEnabledCondition;
import org.fest.swing.driver.ComponentPerformDefaultAccessibleActionTask;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.query.ComponentHasFocusQuery;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.query.ComponentVisibleQuery;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Strings;

public class ComponentDriver {
    private static final String ENABLED_PROPERTY = "enabled";
    private static final String SIZE_PROPERTY = "size";
    private static final String VISIBLE_PROPERTY = "visible";
    protected final Robot robot;
    private final ComponentDragAndDrop dragAndDrop;

    public ComponentDriver(Robot robot) {
        this.robot = robot;
        this.dragAndDrop = new ComponentDragAndDrop(robot);
    }

    @RunsInEDT
    public void click(Component c) {
        ComponentDriver.assertIsEnabledAndShowing(c);
        this.robot.click(c);
    }

    @RunsInEDT
    public void click(Component c, MouseButton button) {
        this.click(c, button, 1);
    }

    @RunsInEDT
    public void click(Component c, MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            throw new NullPointerException("The given MouseClickInfo should not be null");
        }
        this.click(c, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    public void doubleClick(Component c) {
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClick(Component c) {
        this.click(c, MouseButton.RIGHT_BUTTON);
    }

    @RunsInEDT
    public void click(Component c, MouseButton button, int times) {
        if (button == null) {
            throw new NullPointerException("The given MouseButton should not be null");
        }
        ComponentDriver.assertIsEnabledAndShowing(c);
        this.robot.click(c, button, times);
    }

    @RunsInEDT
    public void click(Component c, Point where) {
        ComponentDriver.assertIsEnabledAndShowing(c);
        this.robot.click(c, where);
    }

    protected Settings settings() {
        return this.robot.settings();
    }

    @RunsInEDT
    public void requireSize(Component c, Dimension size) {
        Assertions.assertThat((Object)ComponentSizeQuery.sizeOf(c)).as(ComponentDriver.propertyName(c, SIZE_PROPERTY)).isEqualTo((Object)size);
    }

    @RunsInEDT
    public void requireVisible(Component c) {
        Assertions.assertThat((boolean)ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c)).isTrue();
    }

    @RunsInEDT
    public void requireNotVisible(Component c) {
        Assertions.assertThat((boolean)ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c)).isFalse();
    }

    @RunsInEDT
    private static Description visibleProperty(Component c) {
        return ComponentDriver.propertyName(c, VISIBLE_PROPERTY);
    }

    @RunsInEDT
    public void requireFocused(Component c) {
        Assertions.assertThat((boolean)ComponentHasFocusQuery.hasFocus(c)).as(ComponentDriver.requiredFocusedErrorMessage(c)).isTrue();
    }

    private static Description requiredFocusedErrorMessage(final Component c) {
        return new GuiLazyLoadingDescription(){

            protected String loadDescription() {
                return Strings.concat((Object[])new Object[]{"Expected component ", Formatting.format(c), " to have input focus"});
            }
        };
    }

    @RunsInEDT
    public void requireEnabled(Component c) {
        Assertions.assertThat((boolean)ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c)).isTrue();
    }

    @RunsInEDT
    public void requireEnabled(Component c, Timeout timeout) {
        Pause.pause((Condition)ComponentEnabledCondition.untilIsEnabled(c), timeout);
    }

    @RunsInEDT
    public void requireDisabled(Component c) {
        Assertions.assertThat((boolean)ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c)).isFalse();
    }

    @RunsInEDT
    private static Description enabledProperty(Component c) {
        return ComponentDriver.propertyName(c, ENABLED_PROPERTY);
    }

    @RunsInEDT
    public void pressAndReleaseKeys(Component c, int ... keyCodes) {
        if (keyCodes == null) {
            throw new NullPointerException("The array of key codes should not be null");
        }
        ComponentDriver.assertIsEnabledAndShowing(c);
        this.focusAndWaitForFocusGain(c);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    public void pressAndReleaseKey(Component c, KeyPressInfo keyPressInfo) {
        if (keyPressInfo == null) {
            throw new NullPointerException("The given KeyPressInfo should not be null");
        }
        this.pressAndReleaseKey(c, keyPressInfo.keyCode(), keyPressInfo.modifiers());
    }

    @RunsInEDT
    public void pressAndReleaseKey(Component c, int keyCode, int[] modifiers) {
        this.focusAndWaitForFocusGain(c);
        this.robot.pressAndReleaseKey(keyCode, modifiers);
    }

    @RunsInEDT
    public void pressKey(Component c, int keyCode) {
        this.focusAndWaitForFocusGain(c);
        this.robot.pressKey(keyCode);
    }

    @RunsInEDT
    public void releaseKey(Component c, int keyCode) {
        this.focusAndWaitForFocusGain(c);
        this.robot.releaseKey(keyCode);
    }

    @RunsInEDT
    public void focusAndWaitForFocusGain(Component c) {
        ComponentDriver.assertIsEnabledAndShowing(c);
        this.robot.focusAndWaitForFocusGain(c);
    }

    @RunsInEDT
    public void focus(Component c) {
        ComponentDriver.assertIsEnabledAndShowing(c);
        this.robot.focus(c);
    }

    @RunsInEDT
    protected final void drag(Component c, Point where) {
        this.dragAndDrop.drag(c, where);
    }

    @RunsInEDT
    protected final void drop(Component c, Point where) {
        this.dragAndDrop.drop(c, where);
    }

    protected final void dragOver(Component c, Point where) {
        this.dragAndDrop.dragOver(c, where);
    }

    @RunsInCurrentThread
    protected final void performAccessibleActionOf(Component c) {
        ComponentPerformDefaultAccessibleActionTask.performDefaultAccessibleAction(c);
        this.robot.waitForIdle();
    }

    @RunsInCurrentThread
    protected final boolean waitForShowing(Component c, long timeout) {
        if (this.robot.isReadyForInput(c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.robot.isReadyForInput(c)) {
            Component invoker;
            if (c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof JMenu) {
                this.robot.jitter(invoker);
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    @RunsInEDT
    public JPopupMenu invokePopupMenu(Component c) {
        ComponentDriver.assertIsEnabledAndShowing(c);
        return this.robot.showPopupMenu(c);
    }

    @RunsInEDT
    public JPopupMenu invokePopupMenu(Component c, Point p) {
        if (p == null) {
            throw new NullPointerException("The given point should not be null");
        }
        ComponentDriver.assertIsEnabledAndShowing(c);
        return this.robot.showPopupMenu(c, p);
    }

    @RunsInEDT
    protected static void assertIsEnabledAndShowing(final Component c) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(c);
            }
        });
    }

    @RunsInEDT
    public static Description propertyName(final Component c, final String propertyName) {
        return new GuiLazyLoadingDescription(){

            protected String loadDescription() {
                return Strings.concat((Object[])new Object[]{Formatting.format(c), " - property:", Strings.quote((String)propertyName)});
            }
        };
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(Component c, Point p) {
        this.moveMouseIgnoringAnyError(c, p.x, p.y);
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(Component c, int x, int y) {
        try {
            this.robot.moveMouse(c, x, y);
        }
        catch (RuntimeException ignored) {
            // empty catch block
        }
    }
}

