/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.ResetActionHandler;
import org.eclipse.egit.ui.internal.repository.SelectResetTypePage;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode<?>> {
    public static final String ID = "org.eclipse.egit.ui.team.Reset";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String currentBranch;
        final RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        try {
            currentBranch = node.getRepository().getFullBranch();
        }
        catch (IOException e1) {
            throw new ExecutionException(e1.getMessage(), (Throwable)e1);
        }
        if (!(node.getObject() instanceof Ref)) {
            return new ResetActionHandler().execute(event);
        }
        final String targetBranch = ((Ref)node.getObject()).getName();
        final String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(node.getRepository());
        Wizard wiz = new Wizard(){

            public void addPages() {
                this.addPage((IWizardPage)new SelectResetTypePage(repoName, node.getRepository(), currentBranch, targetBranch));
                this.setWindowTitle(UIText.ResetCommand_WizardTitle);
            }

            public boolean performFinish() {
                final ResetCommand.ResetType resetType = ((SelectResetTypePage)this.getPages()[0]).getResetType();
                if (resetType == ResetCommand.ResetType.HARD && !MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.ResetTargetSelectionDialog_ResetQuestion, (String)UIText.ResetTargetSelectionDialog_ResetConfirmQuestion)) {
                    return true;
                }
                try {
                    this.getContainer().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            String jobname = NLS.bind((String)UIText.ResetAction_reset, (Object)targetBranch);
                            ResetOperation operation = new ResetOperation(node.getRepository(), targetBranch, resetType);
                            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)jobname, (Object)JobFamilies.RESET);
                        }
                    });
                }
                catch (InvocationTargetException ite) {
                    Activator.handleError(UIText.ResetCommand_ResetFailureMessage, ite.getCause(), true);
                    return false;
                }
                catch (InterruptedException interruptedException) {}
                return true;
            }
        };
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)wiz);
        dlg.setHelpAvailable(false);
        dlg.open();
        return null;
    }
}

