/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.buildmodel.IStepVisitor;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BuildDescriptionGnuMakefileGenerator {
    private static final String OUT_STEP_RULE = "post_build";
    private static final String IN_STEP_RULE = "pre_build";
    private static final String ALL = "all";
    private static final String TARGET_SEPARATOR = ":";
    private static final String LINE_SEPARATOR = "\n";
    private static final String TAB = "\t";
    private static final String SPACE = " ";
    private static final String ENCODING = "utf-8";
    private static final String VAR_SOURCES = "SOURCES";
    private static final String VAR_TARGETS = "TARGETS";
    private static final String EQUALS = "=";
    private static final String VARREF_PREFIX = "${";
    private static final String VARREF_SUFFIX = "}";
    private static final String DOT_DOT_SLASH = "../";
    private static final String DOT_DOT_BACKSLASH = "..\\";
    private IBuildDescription fDes;

    public BuildDescriptionGnuMakefileGenerator(IBuildDescription des) {
        this.fDes = des;
    }

    public void store(OutputStream stream) throws CoreException {
        Writer writer = this.createWriter(stream);
        try {
            writer.write(VAR_SOURCES);
            writer.write(EQUALS);
            IBuildStep step = this.fDes.getInputStep();
            String tmp = this.toString(step.getOutputResources());
            writer.write(tmp);
            writer.write(LINE_SEPARATOR);
            writer.write(LINE_SEPARATOR);
            writer.write(VAR_TARGETS);
            writer.write(EQUALS);
            step = this.fDes.getOutputStep();
            tmp = this.toString(step.getInputResources());
            writer.write(tmp);
            writer.write(LINE_SEPARATOR);
            writer.write(LINE_SEPARATOR);
            writer.write(LINE_SEPARATOR);
            this.writeRuleHeader(writer, ALL, "pre_build post_build");
            writer.write(LINE_SEPARATOR);
            writer.write(LINE_SEPARATOR);
            this.write(writer, this.fDes.getOutputStep());
            this.write(writer, this.fDes.getInputStep());
            BuildDescriptionManager.accept(new DescriptionVisitor(writer), this.fDes, true);
            writer.flush();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getString("BuildDescriptionGnuMakefileGenerator.1"), (Throwable)e));
        }
    }

    protected Writer createWriter(OutputStream stream) {
        try {
            return new OutputStreamWriter(stream, ENCODING);
        }
        catch (UnsupportedEncodingException e1) {
            ManagedBuilderCorePlugin.log(e1);
            return new OutputStreamWriter(stream);
        }
    }

    protected String createVarRef(String var) {
        return new StringBuffer().append(VARREF_PREFIX).append(var).append(VARREF_SUFFIX).toString();
    }

    protected void write(Writer writer, IBuildStep step) throws CoreException, IOException {
        String deps;
        String target;
        writer.write(LINE_SEPARATOR);
        if (step == this.fDes.getOutputStep()) {
            target = OUT_STEP_RULE;
            deps = this.createVarRef(VAR_TARGETS);
        } else if (step == this.fDes.getInputStep()) {
            target = IN_STEP_RULE;
            deps = "";
        } else {
            IBuildResource[] inputs = step.getInputResources();
            IBuildResource[] outputs = step.getOutputResources();
            target = this.toString(outputs);
            deps = this.toString(inputs);
        }
        this.writeRuleHeader(writer, target, deps);
        IBuildCommand[] cmds = step.getCommands(null, null, null, true);
        int i = 0;
        while (i < cmds.length) {
            String cmdStr = this.toString(cmds[i]);
            this.writeCommand(writer, cmdStr);
            ++i;
        }
        writer.write(LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
    }

    protected void writeCommand(Writer writer, String cmd) throws IOException {
        writer.write(TAB);
        writer.write(cmd);
        writer.write(LINE_SEPARATOR);
    }

    protected String toString(IBuildCommand cmd) {
        StringBuffer buf = new StringBuffer();
        buf.append(cmd.getCommand());
        String argsString = CDataUtil.arrayToString((String[])cmd.getArgs(), (String)SPACE);
        if (argsString != null && argsString.length() != 0) {
            buf.append(SPACE);
            buf.append(argsString);
        }
        return this.removeDotDotSlashesAndBackSlashesHack(buf.toString());
    }

    protected void writeRuleHeader(Writer writer, String target, String deps) throws IOException {
        writer.write(target);
        writer.write(TARGET_SEPARATOR);
        writer.write(SPACE);
        writer.write(deps);
        writer.write(LINE_SEPARATOR);
    }

    protected String toString(IBuildResource[] rcs) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < rcs.length) {
            if (i != 0) {
                buf.append(SPACE);
            }
            buf.append(this.toString(rcs[i]));
            ++i;
        }
        return buf.toString();
    }

    protected String toString(IBuildResource rc) {
        return this.removeDotDotSlashesAndBackSlashesHack(BuildDescriptionManager.getRelPath(this.fDes.getDefaultBuildDirLocation(), rc.getLocation()).toString());
    }

    private String removeDotDotSlashesAndBackSlashesHack(String str) {
        str = this.removeDotDotSlashes(str);
        return this.removeDotDotBackslashes(str);
    }

    private String removeDotDotSlashes(String str) {
        int index = str.indexOf(DOT_DOT_SLASH, 0);
        if (index != -1) {
            StringBuffer buf = new StringBuffer();
            int start = 0;
            while (index != -1) {
                buf.append(str.substring(start, index));
                start = index + DOT_DOT_SLASH.length();
                index = str.indexOf(DOT_DOT_SLASH, start);
            }
            buf.append(str.substring(start));
            return buf.toString();
        }
        return str;
    }

    private String removeDotDotBackslashes(String str) {
        int index = str.indexOf(DOT_DOT_BACKSLASH, 0);
        if (index != -1) {
            StringBuffer buf = new StringBuffer();
            int start = 0;
            while (index != -1) {
                buf.append(str.substring(start, index));
                start = index + DOT_DOT_BACKSLASH.length();
                index = str.indexOf(DOT_DOT_BACKSLASH, start);
            }
            buf.append(str.substring(start));
            return buf.toString();
        }
        return str;
    }

    private class DescriptionVisitor
    implements IStepVisitor {
        Writer fWriter;

        DescriptionVisitor(Writer writer) {
            this.fWriter = writer;
        }

        @Override
        public int visit(IBuildStep step) throws CoreException {
            if (step == BuildDescriptionGnuMakefileGenerator.this.fDes.getInputStep() || step == BuildDescriptionGnuMakefileGenerator.this.fDes.getOutputStep()) {
                return 1;
            }
            try {
                BuildDescriptionGnuMakefileGenerator.this.write(this.fWriter, step);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), ManagedMakeMessages.getString("BuildDescriptionGnuMakefileGenerator.0"), (Throwable)e));
            }
            return 1;
        }
    }
}

