/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;

public class DsfTerminateCommand
implements ITerminateHandler {
    private final DsfSession fSession;
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfTerminateCommand(DsfSession session) {
        this.fSession = session;
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(IEnabledStateRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext) && !(request.getElements()[0] instanceof GdbLaunch)) {
            request.setEnabled(false);
            request.done();
            return;
        }
        if (request.getElements()[0] instanceof GdbLaunch) {
            this.canExecute((GdbLaunch)request.getElements()[0], request);
            return;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        IProcesses.IProcessDMContext processDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IProcesses.IProcessDMContext.class);
        if (processDmc == null) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.canExecute(processDmc, request);
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext) && !(request.getElements()[0] instanceof GdbLaunch)) {
            request.done();
            return false;
        }
        if (request.getElements()[0] instanceof GdbLaunch) {
            return this.execute((GdbLaunch)request.getElements()[0], request);
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        IProcesses.IProcessDMContext processDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IProcesses.IProcessDMContext.class);
        if (processDmc == null) {
            request.done();
            return false;
        }
        return this.execute(processDmc, request);
    }

    private void canExecute(GdbLaunch launch, IEnabledStateRequest request) {
        request.setEnabled(launch.canTerminate());
        request.done();
    }

    private boolean execute(GdbLaunch launch, final IDebugCommandRequest request) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IGDBControl commandControl = (IGDBControl)DsfTerminateCommand.this.fTracker.getService(IGDBControl.class);
                    if (commandControl != null) {
                        commandControl.terminate((RequestMonitor)new ImmediateRequestMonitor(){

                            protected void handleCompleted() {
                                if (!this.isSuccess()) {
                                    request.setStatus(this.getStatus());
                                    request.done();
                                } else {
                                    DsfTerminateCommand.this.waitForTermination(request);
                                }
                            }
                        });
                    } else {
                        request.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.done();
        }
        return false;
    }

    private void canExecute(final IProcesses.IProcessDMContext processDmc, final IEnabledStateRequest request) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IProcesses procService = (IProcesses)DsfTerminateCommand.this.fTracker.getService(IProcesses.class);
                    if (procService == null) {
                        request.setEnabled(false);
                        request.done();
                    } else {
                        procService.canTerminate((IProcesses.IThreadDMContext)processDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<Boolean>(){

                            protected void handleCompleted() {
                                request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                                request.done();
                            }
                        });
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.setEnabled(false);
            request.done();
        }
    }

    private boolean execute(final IProcesses.IProcessDMContext processDmc, final IDebugCommandRequest request) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IProcesses procService = (IProcesses)DsfTerminateCommand.this.fTracker.getService(IProcesses.class);
                    if (procService != null) {
                        procService.terminate((IProcesses.IThreadDMContext)processDmc, (RequestMonitor)new ImmediateRequestMonitor(){

                            protected void handleCompleted() {
                                if (!this.isSuccess()) {
                                    request.setStatus(this.getStatus());
                                    request.done();
                                } else {
                                    DsfTerminateCommand.this.waitForTermination(request);
                                }
                            }
                        });
                    } else {
                        request.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.done();
        }
        return false;
    }

    private void waitForTermination(final IDebugCommandRequest request) {
        if (!DsfSession.isSessionActive((String)this.fSession.getId())) {
            request.done();
            return;
        }
        final DsfSession.SessionEndedListener endedListener = new DsfSession.SessionEndedListener(){

            public void sessionEnded(DsfSession session) {
                if (DsfTerminateCommand.this.fSession.equals((Object)session)) {
                    DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
                    request.done();
                }
            }
        };
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)endedListener);
        this.fExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                if (DsfSession.isSessionActive((String)DsfTerminateCommand.this.fSession.getId())) {
                    DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)endedListener);
                    request.setStatus(Status.CANCEL_STATUS);
                    request.done();
                }
            }
        }, 1L, TimeUnit.MINUTES);
    }
}

