/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchImages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.launch.ui.CAbstractMainTab;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class CMainTab
extends CAbstractMainTab {
    public static final String TAB_ID = "org.eclipse.cdt.dsf.gdb.launch.mainTab";
    private static final String CORE_FILE = LaunchMessages.getString((String)"CMainTab.CoreFile_type");
    private static final String TRACE_FILE = LaunchMessages.getString((String)"CMainTab.TraceFile_type");
    protected Combo fCoreTypeCombo;
    private final boolean fDontCheckProgram;
    private final boolean fSpecifyCoreFile;
    private final boolean fIncludeBuildSettings;
    public static final int DONT_CHECK_PROGRAM = 2;
    public static final int SPECIFY_CORE_FILE = 4;
    public static final int INCLUDE_BUILD_SETTINGS = 8;

    public CMainTab() {
        this(8);
    }

    public CMainTab(int flags) {
        this.fDontCheckProgram = (flags & 2) != 0;
        this.fSpecifyCoreFile = (flags & 4) != 0;
        this.fIncludeBuildSettings = (flags & 8) != 0;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GdbUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.dsf.gdb.ui.launch_configuration_dialog_main_tab");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createExeFileGroup(comp, 1);
        this.createProjectGroup(comp, 1);
        if (this.fIncludeBuildSettings) {
            this.createBuildOptionGroup(comp, 1);
        }
        this.createVerticalSpacer(comp, 1);
        if (this.fSpecifyCoreFile) {
            this.createCoreFileGroup(comp, 1);
        }
        GdbUIPlugin.setDialogShell(parent.getShell());
    }

    protected void createExeFileGroup(Composite parent, int colSpan) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        mainComp.setLayoutData((Object)gd);
        this.fProgLabel = new Label(mainComp, 0);
        this.fProgLabel.setText(LaunchMessages.getString((String)"CMainTab.C/C++_Application"));
        gd = new GridData();
        this.fProgLabel.setLayoutData((Object)gd);
        this.fProgText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.fProgText.setLayoutData((Object)gd);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite buttonComp = new Composite(mainComp, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(128);
        buttonComp.setLayoutData((Object)gd);
        buttonComp.setFont(parent.getFont());
        this.createVariablesButton(buttonComp, LaunchMessages.getString((String)"CMainTab.Variables"), this.fProgText);
        this.fSearchButton = this.createPushButton(buttonComp, LaunchMessages.getString((String)"CMainTab.Search..."), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMainTab.this.handleSearchButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseForBinaryButton = this.createPushButton(buttonComp, LaunchMessages.getString((String)"Launch.common.Browse_2"), null);
        browseForBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String text = CMainTab.this.handleBrowseButtonSelected(LaunchMessages.getString((String)"CMaintab.Application_Selection"));
                if (text != null) {
                    CMainTab.this.fProgText.setText(text);
                }
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createCoreFileGroup(Composite parent, int colSpan) {
        Composite coreComp = new Composite(parent, 0);
        GridLayout coreLayout = new GridLayout();
        coreLayout.numColumns = 3;
        coreLayout.marginHeight = 0;
        coreLayout.marginWidth = 0;
        coreComp.setLayout((Layout)coreLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        coreComp.setLayoutData((Object)gd);
        Label comboLabel = new Label(coreComp, 0);
        comboLabel.setText(LaunchMessages.getString((String)"CMainTab.Post_mortem_file_type"));
        comboLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.fCoreTypeCombo = new Combo(coreComp, 12);
        this.fCoreTypeCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.fCoreTypeCombo.add(CORE_FILE);
        this.fCoreTypeCombo.add(TRACE_FILE);
        this.fCoreLabel = new Label(coreComp, 0);
        this.fCoreLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.fCoreText = new Text(coreComp, 2052);
        gd = new GridData(768);
        this.fCoreText.setLayoutData((Object)gd);
        this.fCoreText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseForCoreButton = this.createPushButton(coreComp, LaunchMessages.getString((String)"Launch.common.Browse_3"), null);
        browseForCoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String text;
                String coreType = CMainTab.this.getSelectedCoreType();
                if (coreType.equals("CORE_FILE")) {
                    text = CMainTab.this.handleBrowseButtonSelected(LaunchMessages.getString((String)"CMaintab.Core_Selection"));
                } else if (coreType.equals("TRACE_FILE")) {
                    text = CMainTab.this.handleBrowseButtonSelected(LaunchMessages.getString((String)"CMaintab.Trace_Selection"));
                } else {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"Unknown core file type");
                    }
                    text = CMainTab.this.handleBrowseButtonSelected(LaunchMessages.getString((String)"CMaintab.Core_Selection"));
                }
                if (text != null) {
                    CMainTab.this.fCoreText.setText(text);
                }
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fCoreTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CMainTab.this.updateCoreFileLabel();
                CMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fCoreTypeCombo.select(0);
    }

    protected String handleBrowseButtonSelected(String title) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setText(title);
        fileDialog.setFileName(this.fProgText.getText());
        return fileDialog.open();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.filterPlatform = this.getPlatform(config);
        this.updateProjectFromConfig(config);
        this.updateProgramFromConfig(config);
        this.updateCoreFromConfig(config);
        this.updateBuildOptionFromConfig(config);
    }

    protected void updateCoreFromConfig(ILaunchConfiguration config) {
        if (this.fCoreText != null) {
            String coreName = "";
            String coreType = "CORE_FILE";
            try {
                coreName = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
                coreType = config.getAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", "CORE_FILE");
            }
            catch (CoreException ce) {
                GdbUIPlugin.log(ce);
            }
            this.fCoreText.setText(coreName);
            if (coreType.equals("CORE_FILE")) {
                this.fCoreTypeCombo.setText(CORE_FILE);
            } else if (coreType.equals("TRACE_FILE")) {
                this.fCoreTypeCombo.setText(TRACE_FILE);
            } else {
                assert (false) : "Unknown core file type";
                this.fCoreTypeCombo.setText(CORE_FILE);
            }
            this.updateCoreFileLabel();
        }
    }

    protected String getSelectedCoreType() {
        int selectedIndex = this.fCoreTypeCombo.getSelectionIndex();
        if (this.fCoreTypeCombo.getItem(selectedIndex).equals(CORE_FILE)) {
            return "CORE_FILE";
        }
        if (this.fCoreTypeCombo.getItem(selectedIndex).equals(TRACE_FILE)) {
            return "TRACE_FILE";
        }
        assert (false) : "Unknown post mortem file type";
        return "CORE_FILE";
    }

    protected void updateCoreFileLabel() {
        String coreType = this.getSelectedCoreType();
        if (coreType.equals("CORE_FILE")) {
            this.fCoreLabel.setText(LaunchMessages.getString((String)"CMainTab.CoreFile_path"));
        } else if (coreType.equals("TRACE_FILE")) {
            this.fCoreLabel.setText(LaunchMessages.getString((String)"CMainTab.TraceFile_path"));
        } else {
            assert (false) : "Unknown post mortem file type";
            this.fCoreLabel.setText(LaunchMessages.getString((String)"CMainTab.CoreFile_path"));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        ICProject cProject = this.getCProject();
        if (cProject != null && cProject.exists()) {
            config.setMappedResources(new IResource[]{cProject.getProject()});
        } else {
            config.setMappedResources(null);
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fProgText.getText());
        if (this.fCoreText != null) {
            config.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", this.fCoreText.getText());
            config.setAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", this.getSelectedCoreType());
        }
    }

    protected void handleSearchButtonSelected() {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString((String)"CMainTab.Project_required"), (String)LaunchMessages.getString((String)"CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                IBinary belement;
                if (!(element instanceof ICElement)) {
                    return super.getImage(element);
                }
                ICElement celement = (ICElement)element;
                if (celement.getElementType() == 14 && (belement = (IBinary)celement).isExecutable()) {
                    return DebugUITools.getImage((String)"IMG_ACT_RUN");
                }
                return super.getImage(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements((Object[])this.getBinaryFiles(this.getCProject()));
        dialog.setMessage(LaunchMessages.getString((String)"CMainTab.Choose_program_to_run"));
        dialog.setTitle(LaunchMessages.getString((String)"CMainTab.Program_Selection"));
        dialog.setUpperListLabel(LaunchMessages.getString((String)"Launch.common.BinariesColon"));
        dialog.setLowerListLabel(LaunchMessages.getString((String)"Launch.common.QualifierColon"));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            IBinary binary = (IBinary)dialog.getFirstResult();
            this.fProgText.setText(binary.getResource().getProjectRelativePath().toString());
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        String coreName;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.fDontCheckProgram) {
            String programName = this.fProgText.getText().trim();
            try {
                programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName);
            }
            catch (CoreException coreException) {}
            if (programName.length() == 0) {
                this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_not_specified"));
                return false;
            }
            if (programName.equals(".") || programName.equals("..")) {
                this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_does_not_exist"));
                return false;
            }
            Path exePath = new Path(programName);
            if (exePath.isAbsolute()) {
                File executable = exePath.toFile();
                if (!executable.exists()) {
                    this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_does_not_exist"));
                    return false;
                }
                if (!executable.isFile()) {
                    this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Selection_must_be_file"));
                    return false;
                }
            } else {
                String projectName = this.fProjText.getText().trim();
                if (projectName.length() == 0) {
                    this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Project_not_specified"));
                    return false;
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.exists()) {
                    this.setErrorMessage(LaunchMessages.getString((String)"Launch.common.Project_does_not_exist"));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Project_must_be_opened"));
                    return false;
                }
                if (!project.getFile(programName).exists()) {
                    this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.Program_does_not_exist"));
                    return false;
                }
            }
        }
        if (this.fCoreText != null && !(coreName = this.fCoreText.getText().trim()).equals("")) {
            Path corePath;
            try {
                coreName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(coreName, false);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
            coreName = coreName.trim();
            File filePath = new File(coreName);
            if (!filePath.isDirectory() && !(corePath = new Path(coreName)).toFile().exists()) {
                this.setErrorMessage(LaunchMessages.getString((String)"CMainTab.File_does_not_exist"));
                return false;
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
        config.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", true);
        ICElement cElement = null;
        cElement = this.getContext((ILaunchConfiguration)config, this.getPlatform((ILaunchConfiguration)config));
        if (cElement != null) {
            this.initializeCProject(cElement, config);
            this.initializeProgramName(cElement, config);
        } else {
            config.setMappedResources(null);
        }
    }

    protected void initializeProgramName(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        String name;
        boolean renamed = false;
        if (!(cElement instanceof IBinary)) {
            cElement = cElement.getCProject();
        }
        if (cElement instanceof ICProject) {
            IProject project = cElement.getCProject().getProject();
            name = project.getName();
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigName = projDes.getActiveConfiguration().getName();
                name = String.valueOf(name) + " " + buildConfigName;
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
            renamed = true;
        }
        IBinary binary = null;
        if (cElement instanceof ICProject) {
            IBinary[] bins = this.getBinaryFiles((ICProject)cElement);
            if (bins != null && bins.length == 1) {
                binary = bins[0];
            }
        } else if (cElement instanceof IBinary) {
            binary = (IBinary)cElement;
        }
        if (binary != null) {
            String path = binary.getResource().getProjectRelativePath().toOSString();
            config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", path);
            if (!renamed) {
                String name2 = binary.getElementName();
                int index = name2.lastIndexOf(46);
                if (index > 0) {
                    name2 = name2.substring(0, index);
                }
                name2 = this.getLaunchConfigurationDialog().generateName(name2);
                config.rename(name2);
                renamed = true;
            }
        }
        if (!renamed) {
            name = this.getLaunchConfigurationDialog().generateName(cElement.getCProject().getElementName());
            config.rename(name);
        }
    }

    public String getId() {
        return TAB_ID;
    }

    public String getName() {
        return LaunchMessages.getString((String)"CMainTab.Main");
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_MAIN_TAB);
    }
}

