/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.toolchains;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.toolkit.ToolkitVersion;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import org.eclipse.cdt.managedbuilder.core.IManagedIsToolChainSupported;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.Version;

public class CudaToolchainSupportDetector
implements IManagedIsToolChainSupported {
    public static ToolkitVersion detectToolchainVersion(IToolChain tc) {
        ToolkitVersion[] toolkitVersionArray = ToolkitVersion.supportedToolkits;
        int n = ToolkitVersion.supportedToolkits.length;
        int n2 = 0;
        while (n2 < n) {
            ToolkitVersion ver = toolkitVersionArray[n2];
            if (CoreUtil.equals((Object)ver.label, (Object)tc.getName())) {
                return ver;
            }
            ++n2;
        }
        return ToolkitVersion.latest;
    }

    protected static ICudaToolkit getToolkitByName(final String name) {
        try {
            return (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                    ICudaToolkit tk = service.getToolkitByName(name);
                    return CoreUtil.equals((Object)tk.getName(), (Object)name) ? tk : null;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSupported(IToolChain toolChain, Version version, String instance) {
        ToolkitVersion tcVersion = CudaToolchainSupportDetector.detectToolchainVersion(toolChain);
        return tcVersion != null && CudaToolchainSupportDetector.getToolkitByName(tcVersion.label) != null;
    }
}

