/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.AbstractCudaDMVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.DeviceVMNode;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.CudaObjectLabelImage;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.OccupancyImage;
import com.nvidia.cuda.ide.debug.util.RIRequestMonitor;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.ui.IMemento;

public final class SmVMNode
extends AbstractCudaDMVMNode<StreamingMultiprocessor> {
    public static boolean compareSms(StreamingMultiprocessor object, IMemento memento) {
        return object != null && DeviceVMNode.compareDevices((Device)DMContexts.getAncestorOfType((IDMContext)object, Device.class), memento) && Integer.valueOf(object.getId()).equals(memento.getInteger("sm_id"));
    }

    public static void encodeSM(StreamingMultiprocessor object, IMemento memento) {
        if (object != null) {
            DeviceVMNode.encodeDevice((Device)DMContexts.getAncestorOfType((IDMContext)object, Device.class), memento);
            memento.putInteger("sm_id", (int)object.getId());
        }
    }

    public SmVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, StreamingMultiprocessor.class);
    }

    @Override
    protected boolean compareElement(StreamingMultiprocessor object, IMemento memento) {
        return SmVMNode.compareSms(object, memento);
    }

    private LabelColumnInfo createLabelColumn() {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText("SM {0}", new String[]{"id"}), new CudaObjectLabelImage(CudaDebugImages.SM, CudaDebugImages.SM_INACTIVE), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false)});
    }

    @Override
    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createLabelColumn());
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__HARDWARE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#Block {1}|1<{0} active blocks}", new String[]{"active_kernel_blocks", "block_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#Empty|1#1 warp of {1} is active|1<{0} warps of {1} are active}", new String[]{"active_warps", "total.warps"}), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false), new OccupancyImage("total.warps", "active_warps")}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createLabelColumn());
        return provider;
    }

    @Override
    protected void encodeElement(StreamingMultiprocessor object, IMemento memento) {
        SmVMNode.encodeSM(object, memento);
    }

    @Override
    protected String getInactiveElementRangeLabel(RangeContext rangeContext, boolean singleColumn) {
        return MessageFormat.format((String)"{0,choice,0#SM {1}|0<SMs {1} - {2}}", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart(), rangeContext.getStart(), rangeContext.getEnd()});
    }

    @Override
    protected String getInactiveElementRangeStateLabel(RangeContext rangeContext) {
        return MessageFormat.format((String)"{0,choice,1#{0} Unoccupied SM|1<{0} Unoccupied SMs}", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart() + 1L});
    }

    @Override
    protected boolean isLogicalNode() {
        return false;
    }

    @Override
    protected void updatePropertiesInSessionThread(StreamingMultiprocessor sm, IPropertiesUpdate update) {
        update.setProperty("id", (Object)sm.getId());
        update.setProperty("total.warps", (Object)((Device)DMContexts.getParentOfType((IDMContext)sm, Device.class)).getWarpCount());
        RIRequestMonitor.fill(update, (Executor)this.getSession().getExecutor(), sm);
    }

    @Override
    protected CudaDebugImages getInactiveImageDescriptor() {
        return CudaDebugImages.SM_INACTIVE;
    }
}

