/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.EnabledTopicUtils;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class IndexData
extends ActivitiesData {
    private IIndex index;
    private String imagesDirectory;
    private String plusMinusImage;
    private String expandedCollapsed;
    private boolean usePlusMinus;
    private boolean expandAll;
    private boolean isRTL;
    private Writer out;

    public IndexData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.imagesDirectory = this.preferences.getImagesDirectory();
        this.usePlusMinus = this.preferences.isIndexPlusMinus();
        this.expandAll = this.preferences.isIndexExpandAll();
        this.plusMinusImage = this.expandAll ? "/minus.gif" : "/plus.gif";
        this.expandedCollapsed = this.expandAll ? "expanded" : "collapsed";
        this.isRTL = UrlUtil.isRTL(request, response);
        this.index = HelpPlugin.getIndexManager().getIndex(this.getLocale());
    }

    public void generateIds(Writer out) throws IOException {
        boolean first = true;
        IIndexEntry[] entries = this.index.getEntries();
        int i = 0;
        while (i < entries.length) {
            IIndexEntry entry = entries[i];
            if (entry != null && entry.getKeyword() != null && entry.getKeyword().length() > 0) {
                if (first) {
                    first = false;
                } else {
                    out.write(",\n");
                }
                out.write("\"");
                out.write(UrlUtil.JavaScriptEncode(entry.getKeyword()));
                out.write("\"");
            }
            ++i;
        }
    }

    public void generateIndex(Writer out) throws IOException {
        this.out = out;
        IIndexEntry[] entries = this.index.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (EnabledTopicUtils.isEnabled(entries[i])) {
                this.generateEntry(entries[i], 0);
            }
            ++i;
        }
    }

    private void generateEntry(IIndexEntry entry, int level) throws IOException {
        if (entry.getKeyword() != null && entry.getKeyword().length() > 0) {
            ITopic[] topics = EnabledTopicUtils.getEnabled(entry.getTopics());
            IIndexEntry[] subentries = EnabledTopicUtils.getEnabled(entry.getSubentries());
            boolean multipleTopics = topics.length > 1;
            boolean singleTopic = topics.length == 1;
            this.out.write("<li>");
            if (this.usePlusMinus && this.advancedUI) {
                this.generatePlusImage(multipleTopics);
            }
            this.generateAnchor(singleTopic, entry, level);
            if (multipleTopics || subentries.length > 0) {
                if (!this.advancedUI) {
                    this.out.write("<ul>\n");
                }
                if (multipleTopics) {
                    this.generateTopicList(entry);
                }
                this.generateSubentries(entry, level + 1);
                if (!this.advancedUI) {
                    this.out.write("</ul>\n");
                }
            }
            this.out.write("</li>\n");
        }
    }

    public void generateBasicIndex(Writer out) throws IOException {
        this.out = out;
        IIndexEntry[] entries = this.index.getEntries();
        int i = 0;
        while (i < entries.length) {
            this.generateBasicEntry(entries[i], 0);
            ++i;
        }
    }

    private void generateBasicEntry(IIndexEntry entry, int level) throws IOException {
        ITopic[] topics = entry.getTopics();
        IIndexEntry[] subentries = entry.getSubentries();
        boolean multipleTopics = topics.length > 1;
        boolean singleTopic = topics.length == 1;
        this.out.write("<tr><td align=\"");
        this.out.write(this.isRTL ? "right" : "left");
        this.out.write("\" nowrap>\n");
        this.generateAnchor(singleTopic, entry, level);
        this.out.write("</td></tr>\n");
        if (multipleTopics || subentries.length > 0) {
            this.out.write("<tr><td align=\"");
            this.out.write(this.isRTL ? "right" : "left");
            this.out.write("\" nowrap><ul>\n");
            if (multipleTopics) {
                this.generateTopicList(entry);
            }
            this.generateSubentries(entry, level + 1);
            this.out.write("</ul></td></tr>\n");
        }
    }

    private void generatePlusImage(boolean multipleTopics) throws IOException {
        this.out.write("<img src=\"");
        this.out.write(this.imagesDirectory);
        this.out.write(this.plusMinusImage);
        this.out.write("\" class=\"");
        if (multipleTopics) {
            this.out.write(this.expandedCollapsed);
        } else {
            this.out.write("h");
        }
        this.out.write("\" alt=\"");
        if (multipleTopics) {
            if (this.expandAll) {
                this.out.write(ServletResources.getString("collapseTopicTitles", this.request));
            } else {
                this.out.write(ServletResources.getString("expandTopicTitles", this.request));
            }
        }
        this.out.write("\">");
    }

    private void generateAnchor(boolean singleTopic, IIndexEntry entry, int level) throws IOException {
        this.out.write("<a ");
        if (level == 0 && this.advancedUI) {
            this.out.write("id=\"");
            this.out.write(entry.getKeyword());
            this.out.write("\" ");
        }
        if (singleTopic) {
            this.out.write("href=\"");
            this.out.write(UrlUtil.getHelpURL(entry.getTopics()[0].getHref()));
            this.out.write("\">");
        } else {
            if (this.advancedUI) {
                this.out.write("class=\"nolink\" ");
            }
            this.out.write("href=\"about:blank\">");
        }
        this.out.write(UrlUtil.htmlEncode(entry.getKeyword()));
        this.out.write("</a>\n");
    }

    private void generateTopicList(IIndexEntry entry) throws IOException {
        ITopic[] topics = entry.getTopics();
        if (this.advancedUI) {
            this.out.write("\n<ul class=\"");
            this.out.write(this.expandedCollapsed);
            this.out.write("\">\n");
        }
        int i = 0;
        while (i < topics.length) {
            ITopic topic = topics[i];
            this.out.write("<li>");
            if (this.usePlusMinus && this.advancedUI) {
                this.out.write("<img class=\"h\" src=\"");
                this.out.write(this.imagesDirectory);
                this.out.write(this.plusMinusImage);
                this.out.write("\" alt=\"\">");
            }
            this.out.write("<a href=\"");
            this.out.write(UrlUtil.getHelpURL(topic.getHref()));
            this.out.write("\"><img src=\"");
            this.out.write(this.imagesDirectory);
            this.out.write("/topic.gif\" ");
            if (!this.advancedUI) {
                this.out.write("border=0 ");
            }
            this.out.write("alt=\"\">");
            this.out.write(UrlUtil.htmlEncode(topic.getLabel()));
            this.out.write("</a></li>\n");
            ++i;
        }
        if (this.advancedUI) {
            this.out.write("</ul>\n");
        }
    }

    private void generateSubentries(IIndexEntry entry, int level) throws IOException {
        if (this.advancedUI) {
            this.out.write("<ul class=\"expanded\">\n");
        }
        IIndexEntry[] subentries = entry.getSubentries();
        int i = 0;
        while (i < subentries.length) {
            this.generateEntry(subentries[i], level);
            ++i;
        }
        if (this.advancedUI) {
            this.out.write("</ul>\n");
        }
    }
}

