/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.editor;

import com.nvidia.cuda.ide.editor.CudaCCodeFormatterVisitor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.formatter.AbortFormatting;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.TextEdit;

public class CudaCFormatter
extends CodeFormatter {
    private DefaultCodeFormatterOptions preferences;
    private Map<String, ?> options;

    public CudaCFormatter() {
        this(DefaultCodeFormatterOptions.getDefaultSettings());
    }

    public CudaCFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public CudaCFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, ?> options) {
        this.setOptions(options);
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public CudaCFormatter(Map<String, ?> options) {
        this(null, options);
    }

    public String createIndentationString(int indentationLevel) {
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        int tabs = 0;
        int spaces = 0;
        switch (this.preferences.tab_char) {
            case 2: {
                spaces = indentationLevel * this.preferences.tab_size;
                break;
            }
            case 1: {
                tabs = indentationLevel;
                break;
            }
            case 4: {
                int tabSize = this.preferences.tab_size;
                int spaceEquivalents = indentationLevel * this.preferences.indentation_size;
                tabs = spaceEquivalents / tabSize;
                spaces = spaceEquivalents % tabSize;
                break;
            }
            default: {
                return "";
            }
        }
        if (tabs == 0 && spaces == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public void setOptions(Map<String, ?> options) {
        if (options != null) {
            this.options = options;
            HashMap<String, String> formatterPrefs = new HashMap<String, String>(options.size());
            for (String key : options.keySet()) {
                Object value = options.get(key);
                if (!(value instanceof String)) continue;
                formatterPrefs.put(key, (String)value);
            }
            this.preferences = new DefaultCodeFormatterOptions(formatterPrefs);
        } else {
            this.options = CCorePlugin.getOptions();
            this.preferences = DefaultCodeFormatterOptions.getDefaultSettings();
        }
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        this.preferences.initial_indentation_level = indentationLevel;
        return this.format(kind, source, new IRegion[]{new Region(offset, length)}, lineSeparator)[0];
    }

    public TextEdit[] format(int kind, String source, IRegion[] regions, String lineSeparator) {
        TextEdit[] edits = new TextEdit[regions.length];
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        ITranslationUnit tu = this.getTranslationUnit(source);
        if (tu != null) {
            IIndex index;
            try {
                index = CCorePlugin.getIndexManager().getIndex(tu.getCProject());
                index.acquireReadLock();
            }
            catch (CoreException e) {
                throw new AbortFormatting((Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            try {
                IASTTranslationUnit ast;
                try {
                    ast = tu.getAST(index, 2);
                }
                catch (CoreException e) {
                    throw new AbortFormatting((Throwable)e);
                }
                this.formatRegions(source, regions, edits, ast);
            }
            finally {
                index.releaseReadLock();
            }
        }
        IncludeFileContentProvider contentProvider = IncludeFileContentProvider.getSavedFilesProvider();
        ScannerInfo scanInfo = new ScannerInfo();
        FileContent content = FileContent.create((String)"<text>", (char[])source.toCharArray());
        ILanguage language = (ILanguage)this.options.get("org.eclipse.cdt.core.formatter.language");
        if (language == null) {
            language = GPPLanguage.getDefault();
        }
        try {
            IASTTranslationUnit ast = language.getASTTranslationUnit(content, (IScannerInfo)scanInfo, contentProvider, null, 0, ParserUtil.getParserLogService());
            this.formatRegions(source, regions, edits, ast);
        }
        catch (CoreException e) {
            throw new AbortFormatting((Throwable)e);
        }
        return edits;
    }

    private void formatRegions(String source, IRegion[] regions, TextEdit[] edits, IASTTranslationUnit ast) {
        int i = 0;
        while (i < regions.length) {
            IRegion region = regions[i];
            CudaCCodeFormatterVisitor codeFormatter = new CudaCCodeFormatterVisitor(this.preferences, region.getOffset(), region.getLength());
            edits[i] = codeFormatter.format(source, ast);
            IStatus status = codeFormatter.getStatus();
            if (!status.isOK()) {
                CCorePlugin.log((IStatus)status);
            }
            ++i;
        }
    }

    private ITranslationUnit getTranslationUnit(String source) {
        IFile file;
        ITranslationUnit tu = (ITranslationUnit)this.options.get("org.eclipse.cdt.core.formatter.current_translation_unit");
        if (tu == null && (file = (IFile)this.options.get("org.eclipse.cdt.core.formatter.current_file")) != null) {
            tu = (ITranslationUnit)CoreModel.getDefault().create(file);
        }
        if (tu != null && source != null) {
            try {
                if (tu.isWorkingCopy()) {
                    tu = ((IWorkingCopy)tu).getOriginalElement();
                }
                tu = tu.getWorkingCopy();
                tu.getBuffer().setContents(source);
            }
            catch (CModelException e) {
                throw new AbortFormatting((Throwable)e);
            }
        }
        return tu;
    }
}

