/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.MathUtil;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.jni.CuCacheConfig;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.OccupancyDataTablePainter;
import java.text.DecimalFormat;

public class KernelOccupancyDataGrid {
    static void fillRegistersTable(DataGrid table, TimelineIntervalKernel kernel, OccupancyCalculator calculator, boolean isLimiter) {
        table.clear();
        TimelineDevice deviceTimeline = calculator.getDeviceTimeline();
        int registersPerBlock = calculator.getRegistersPerBlock();
        Integer maxBlocks = calculator.getRegisterLimit();
        KernelOccupancyDataGrid.row(table, "Registers/Thread", null, kernel.getRegistersPerThread(), deviceTimeline.getMaxRegistersPerBlock(), OccupancyDataTablePainter.Datatype.powof2);
        KernelOccupancyDataGrid.row(table, "Registers/Block", null, registersPerBlock, OccupancyCalculator.getMaxRegistersPerMultiprocessor(deviceTimeline), MathUtil.multiply(registersPerBlock, maxBlocks), OccupancyDataTablePainter.Datatype.kilos, false);
        KernelOccupancyDataGrid.row(table, "Block Limit", null, maxBlocks, deviceTimeline.getMaxBlocksPerMultiprocessor(), 0, OccupancyDataTablePainter.Datatype.integer, isLimiter);
    }

    static void fillSharedMemoryTable(DataGrid table, TimelineIntervalKernel kernel, OccupancyCalculator calculator, boolean isLimiter) {
        table.clear();
        TimelineDevice deviceTimeline = calculator.getDeviceTimeline();
        int kernelShMemory = kernel.getDynamicSharedMemory() + kernel.getStaticSharedMemory();
        CuCacheConfig ccExecuted = kernel.getCacheConfigExecuted();
        Long smShMemory = ccExecuted == null ? null : deviceTimeline.getMaxSharedMemory(ccExecuted);
        Integer maxBlocks = kernelShMemory > 0 ? calculator.getSharedMemoryLimit() : 0;
        KernelOccupancyDataGrid.row(table, "Shared Memory/Block", null, kernelShMemory, smShMemory, MathUtil.multiply(maxBlocks, kernelShMemory), OccupancyDataTablePainter.Datatype.kilos, false);
        KernelOccupancyDataGrid.row(table, "Block Limit", null, maxBlocks, deviceTimeline.getMaxBlocksPerMultiprocessor(), 0, OccupancyDataTablePainter.Datatype.integer, isLimiter);
    }

    static void fillSMTable(DataGrid grid, TimelineIntervalKernel kernel, double achievedOccupancy, OccupancyCalculator calculator) {
        grid.clear();
        DecimalFormat percentFormat = new DecimalFormat("######0.#%");
        DecimalFormat decimalFormat = new DecimalFormat("######0.##");
        TimelineDevice deviceTimeline = calculator.getDeviceTimeline();
        int warpsPerSM = deviceTimeline.getMaxWarpsPerMultiprocessor();
        double warps = (double)Math.round(achievedOccupancy * 100.0 * (double)warpsPerSM) / 100.0;
        Double warpsNumber = warps;
        Double occupancy = achievedOccupancy * 100.0;
        String warpsString = decimalFormat.format(warps);
        String occString = percentFormat.format(achievedOccupancy);
        KernelOccupancyDataGrid.row(grid, "Active Blocks", null, calculator.getBlocksPerSM(), deviceTimeline.getMaxBlocksPerMultiprocessor());
        grid.addRow("Active Warps", warpsString, KernelOccupancyDataGrid.toString(calculator.getWarpsPerSM()), KernelOccupancyDataGrid.toString(warpsPerSM), new OccupancyDataTablePainter.BarData(warpsPerSM, calculator.getWarpsPerSM().intValue(), warpsNumber, 0, OccupancyDataTablePainter.Datatype.integer, false));
        KernelOccupancyDataGrid.row(grid, "Active Threads", null, calculator.getWarpsPerSM() * deviceTimeline.getNumThreadsPerWarp(), OccupancyCalculator.getMaxThreadsPerMultiprocessor(deviceTimeline), OccupancyDataTablePainter.Datatype.powof2);
        grid.addRow("Occupancy", occString, percentFormat.format(calculator.getTheoreticOccupancy()), "100%", new OccupancyDataTablePainter.BarData(100, calculator.getTheoreticOccupancy() * 100.0, occupancy, 0, OccupancyDataTablePainter.Datatype.percentage, false));
    }

    static void fillWarpsTable(DataGrid table, TimelineIntervalKernel kernel, OccupancyCalculator calculator, boolean isLimiter) {
        table.clear();
        TimelineDevice deviceTimeline = calculator.getDeviceTimeline();
        int threadsPerBlock = kernel.getThreadsPerBlock();
        int warpsPerBlock = calculator.getWarpsPerBlock();
        Integer maxBlocks = calculator.getBlockLimit();
        KernelOccupancyDataGrid.row(table, "Threads/Block", null, threadsPerBlock, deviceTimeline.getMaxThreadsPerBlock(), OccupancyDataTablePainter.Datatype.powof2);
        KernelOccupancyDataGrid.row(table, "Warps/Block", null, warpsPerBlock, deviceTimeline.getMaxThreadsPerBlock() / deviceTimeline.getNumThreadsPerWarp());
        KernelOccupancyDataGrid.row(table, "Block Limit", null, maxBlocks, deviceTimeline.getMaxBlocksPerMultiprocessor(), 0, OccupancyDataTablePainter.Datatype.integer, isLimiter);
    }

    private static String formatDim(Integer[] dim, long count, String label, String singular, String plural) {
        StringBuilder builder = new StringBuilder(label).append(": [ ");
        boolean first = true;
        Integer[] integerArray = dim;
        int n = dim.length;
        int n2 = 0;
        while (n2 < n) {
            Integer integer = integerArray[n2];
            builder.append(first ? "" : ",").append(integer);
            first = false;
            ++n2;
        }
        builder.append(" ] (").append(count).append(" ");
        builder.append(count == 1L ? singular : plural);
        builder.append(")");
        return builder.toString();
    }

    public static final String kernelInfoString(TimelineIntervalKernel kernel) {
        if (kernel == null) {
            return "";
        }
        String gridLabel = KernelOccupancyDataGrid.formatDim(kernel.getGrid(), kernel.getBlocksPerGrid(), "Grid Size", "block", "blocks");
        String blockLabel = KernelOccupancyDataGrid.formatDim(kernel.getBlock(), kernel.getThreadsPerBlock(), "Block Size", "thread", "threads");
        return String.format("%s\t%s", gridLabel, blockLabel);
    }

    static void row(DataGrid grid, String var, Number achieved, Number theoretical, Number deviceLimit) {
        KernelOccupancyDataGrid.row(grid, var, achieved, theoretical, deviceLimit, 0, OccupancyDataTablePainter.Datatype.integer, false);
    }

    private static void row(DataGrid grid, String var, Number achieved, Number theoretical, Number deviceLimit, Number theoreticalAcrossGrid, OccupancyDataTablePainter.Datatype datatype, boolean isLimiter) {
        OccupancyDataTablePainter.BarData data = theoretical != null && deviceLimit != null ? new OccupancyDataTablePainter.BarData(deviceLimit.intValue(), theoretical.doubleValue(), achieved, theoreticalAcrossGrid, datatype, isLimiter) : null;
        grid.addRow(var, KernelOccupancyDataGrid.toString(achieved), KernelOccupancyDataGrid.toString(theoretical), KernelOccupancyDataGrid.toString(deviceLimit), data);
    }

    private static void row(DataGrid table, String var, Number achieved, Number theoretical, Number deviceLimit, OccupancyDataTablePainter.Datatype datatype) {
        KernelOccupancyDataGrid.row(table, var, achieved, theoretical, deviceLimit, 0, datatype, false);
    }

    private static String toString(Object object) {
        return object != null ? object.toString() : null;
    }
}

