/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import java.util.Arrays;
import org.eclipse.cdt.core.envvar.IEnvironmentContributor;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.runtime.IPath;

public class CDefaultBuildData
extends CBuildData {
    protected IPath fCWD;
    protected String[] fErrorParserIDs;
    protected ICOutputEntry[] fOutputEntries;
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final ICOutputEntry[] EMPTY_OUTPUT_ENTRIES_ARRAY = new ICOutputEntry[0];
    protected String fName;
    protected String fId;
    protected boolean fIsModified;

    public CDefaultBuildData() {
    }

    public CDefaultBuildData(String id, CBuildData base) {
        this.fId = id;
        this.copySettingsFrom(base);
    }

    protected void copySettingsFrom(CBuildData data) {
        if (data != null) {
            this.fName = data.getName();
            this.fCWD = data.getBuilderCWD();
            this.fErrorParserIDs = data.getErrorParserIDs();
            this.fOutputEntries = data.getOutputDirectories();
        }
    }

    @Override
    public IPath getBuilderCWD() {
        return this.fCWD;
    }

    @Override
    public String[] getErrorParserIDs() {
        if (this.fErrorParserIDs != null && this.fErrorParserIDs.length != 0) {
            return (String[])this.fErrorParserIDs.clone();
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public ICOutputEntry[] getOutputDirectories() {
        if (this.fOutputEntries != null && this.fOutputEntries.length != 0) {
            return (ICOutputEntry[])this.fOutputEntries.clone();
        }
        return EMPTY_OUTPUT_ENTRIES_ARRAY;
    }

    @Override
    public void setBuilderCWD(IPath path) {
        if (CDataUtil.objectsEqual(path, this.fCWD)) {
            return;
        }
        this.fCWD = path;
        this.setModified(true);
    }

    @Override
    public void setErrorParserIDs(String[] ids) {
        if (Arrays.equals(ids, this.fErrorParserIDs)) {
            return;
        }
        this.fErrorParserIDs = ids != null && ids.length != 0 ? (String[])ids.clone() : ids;
        this.setModified(true);
    }

    @Override
    public void setOutputDirectories(ICOutputEntry[] entries) {
        if (Arrays.equals(entries, this.fOutputEntries)) {
            return;
        }
        this.fOutputEntries = entries != null && entries.length != 0 ? (ICOutputEntry[])entries.clone() : entries;
        this.setModified(true);
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isValid() {
        return this.getId() != null;
    }

    @Override
    public IEnvironmentContributor getBuildEnvironmentContributor() {
        return null;
    }

    public boolean isModified() {
        return this.fIsModified;
    }

    public void setModified(boolean modified) {
        this.fIsModified = modified;
    }
}

