/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class LookupSourceAction
extends SelectionListenerAction {
    private ISourceLookupDirector director = null;
    private LaunchView fView = null;
    private IStackFrame frame = null;

    public LookupSourceAction(LaunchView view) {
        super(SourceLookupUIMessages.LookupSourceAction_0);
        this.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.lookup_source_context");
        this.fView = view;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object object;
        this.director = null;
        this.frame = null;
        if (selection.size() == 1 && (object = selection.getFirstElement()) instanceof IStackFrame) {
            this.frame = (IStackFrame)object;
            ILaunch launch = this.frame.getLaunch();
            if (launch != null && launch.getLaunchConfiguration() != null && launch.getSourceLocator() instanceof ISourceLookupDirector) {
                this.director = (ISourceLookupDirector)launch.getSourceLocator();
            }
        }
        return this.director != null;
    }

    public void run() {
        IStructuredSelection ss;
        ISelection selection = this.fView.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            IWorkbenchPage page = this.fView.getSite().getPage();
            SourceLookupManager.getDefault().displaySource(ss.getFirstElement(), page, true);
        }
    }
}

