/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contextlaunching.ContextRunner;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.launchConfigurations.OrganizeFavoritesAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.AbstractLaunchHistoryAction;
import org.eclipse.debug.ui.actions.LaunchShortcutsAction;
import org.eclipse.debug.ui.actions.OpenLaunchDialogAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Menu;

public class AbstractLaunchToolbarAction
extends AbstractLaunchHistoryAction {
    public AbstractLaunchToolbarAction(String launchGroupIdentifier) {
        super(launchGroupIdentifier);
    }

    @Override
    protected void fillMenu(Menu menu) {
        super.fillMenu(menu);
        if (menu.getItemCount() > 0) {
            this.addSeparator(menu);
        }
        this.addToMenu(menu, (IAction)new LaunchShortcutsAction(this.getLaunchGroupIdentifier()), -1);
        this.addToMenu(menu, this.getOpenDialogAction(), -1);
        this.addToMenu(menu, (IAction)new OrganizeFavoritesAction(this.getLaunchGroupIdentifier()), -1);
    }

    protected IAction getOpenDialogAction() {
        return new OpenLaunchDialogAction(this.getLaunchGroupIdentifier());
    }

    @Override
    public void run(IAction action) {
        if (LaunchingResourceManager.isContextLaunchEnabled(this.getLaunchGroupIdentifier())) {
            ContextRunner.getDefault().launch(DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.getLaunchGroupIdentifier()));
        } else {
            ILaunchConfiguration configuration = this.getLastLaunch();
            if (configuration == null) {
                DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection(), this.getLaunchGroupIdentifier());
            } else {
                DebugUITools.launch(configuration, this.getMode());
            }
        }
    }
}

